/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.preference;

import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import org.alfresco.model.ContentModel;
import org.alfresco.repo.jscript.ClasspathScriptLocation;
import org.alfresco.repo.model.Repository;
import org.alfresco.repo.security.authentication.AuthenticationUtil;
import org.alfresco.repo.security.permissions.AccessDeniedException;
import org.alfresco.repo.transaction.RetryingTransactionHelper;
import org.alfresco.service.cmr.preference.PreferenceService;
import org.alfresco.service.cmr.repository.ContentReader;
import org.alfresco.service.cmr.repository.ContentService;
import org.alfresco.service.cmr.repository.NodeRef;
import org.alfresco.service.cmr.repository.ScriptLocation;
import org.alfresco.service.cmr.repository.ScriptService;
import org.alfresco.service.cmr.security.PersonService;
import org.alfresco.test_category.BaseSpringTestsCategory;
import org.alfresco.util.test.junitrules.AlfrescoPerson;
import org.alfresco.util.test.junitrules.ApplicationContextInit;
import org.alfresco.util.test.junitrules.RunAsFullyAuthenticatedRule;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.json.JSONException;
import org.json.JSONObject;
import org.json.JSONTokener;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.junit.rules.RuleChain;
import org.junit.rules.TestRule;

@Category(value={BaseSpringTestsCategory.class})
public class PreferenceServiceImplTest {
    private static final Log log = LogFactory.getLog(PreferenceServiceImplTest.class);
    @ClassRule
    public static ApplicationContextInit APP_CONTEXT_INIT = new ApplicationContextInit();
    private static final String USERNAME2 = "username2";
    public AlfrescoPerson testUser1 = new AlfrescoPerson(APP_CONTEXT_INIT);
    public AlfrescoPerson testUser2 = new AlfrescoPerson(APP_CONTEXT_INIT, "username2");
    public RunAsFullyAuthenticatedRule runAsRule = new RunAsFullyAuthenticatedRule(this.testUser1);
    @Rule
    public RuleChain ruleChain = RuleChain.outerRule((TestRule)this.testUser1).around((TestRule)this.testUser2).around((TestRule)this.runAsRule);
    private static ContentService CONTENT_SERVICE;
    private static PersonService PERSON_SERVICE;
    private static PreferenceService PREFERENCE_SERVICE;
    private static RetryingTransactionHelper TRANSACTION_HELPER;
    private static ScriptService SCRIPT_SERVICE;
    private static NodeRef COMPANY_HOME;

    @BeforeClass
    public static void initStaticData() throws Exception {
        CONTENT_SERVICE = (ContentService)APP_CONTEXT_INIT.getApplicationContext().getBean("ContentService", ContentService.class);
        PERSON_SERVICE = (PersonService)APP_CONTEXT_INIT.getApplicationContext().getBean("PersonService", PersonService.class);
        PREFERENCE_SERVICE = (PreferenceService)APP_CONTEXT_INIT.getApplicationContext().getBean("PreferenceService", PreferenceService.class);
        SCRIPT_SERVICE = (ScriptService)APP_CONTEXT_INIT.getApplicationContext().getBean("ScriptService", ScriptService.class);
        TRANSACTION_HELPER = (RetryingTransactionHelper)APP_CONTEXT_INIT.getApplicationContext().getBean("retryingTransactionHelper", RetryingTransactionHelper.class);
        Repository repositoryHelper = (Repository)APP_CONTEXT_INIT.getApplicationContext().getBean("repositoryHelper");
        COMPANY_HOME = repositoryHelper.getCompanyHome();
    }

    @Test
    public void testPreferences() throws Exception {
        TRANSACTION_HELPER.doInTransaction((RetryingTransactionHelper.RetryingTransactionCallback)new RetryingTransactionHelper.RetryingTransactionCallback<Void>(){

            public Void execute() throws Throwable {
                Map prefs = PREFERENCE_SERVICE.getPreferences(PreferenceServiceImplTest.this.testUser1.getUsername());
                Assert.assertNotNull((Object)prefs);
                Assert.assertEquals((long)0L, (long)prefs.size());
                prefs = new HashMap<String, Object>(5);
                prefs.put("alfresco.one.alpha", "string");
                prefs.put("alfresco.one.beta", 100);
                prefs.put("alfresco.two.alpha", 3.142);
                prefs.put("alfresco.two.beta", COMPANY_HOME);
                prefs.put("alfresco.two.gamma", new Date());
                prefs.put("atTheRoot", "thisIsAtTheRoot");
                PREFERENCE_SERVICE.setPreferences(PreferenceServiceImplTest.this.testUser1.getUsername(), prefs);
                NodeRef personNodeRef = PERSON_SERVICE.getPerson(PreferenceServiceImplTest.this.testUser1.getUsername());
                ContentReader reader = CONTENT_SERVICE.getReader(personNodeRef, ContentModel.PROP_PREFERENCE_VALUES);
                log.debug((Object)("JSON: \n" + PreferenceServiceImplTest.this.prettyJson(reader.getContentString())));
                prefs = PREFERENCE_SERVICE.getPreferences(PreferenceServiceImplTest.this.testUser1.getUsername(), null);
                Assert.assertNotNull(prefs);
                Assert.assertEquals((long)6L, (long)prefs.size());
                prefs = PREFERENCE_SERVICE.getPreferences(PreferenceServiceImplTest.this.testUser1.getUsername(), "alfresco.two");
                Assert.assertNotNull(prefs);
                Assert.assertEquals((long)3L, (long)prefs.size());
                PREFERENCE_SERVICE.clearPreferences(PreferenceServiceImplTest.this.testUser1.getUsername(), "alfresco.two");
                prefs = PREFERENCE_SERVICE.getPreferences(PreferenceServiceImplTest.this.testUser1.getUsername(), null);
                Assert.assertNotNull(prefs);
                Assert.assertEquals((long)3L, (long)prefs.size());
                PREFERENCE_SERVICE.clearPreferences(PreferenceServiceImplTest.this.testUser1.getUsername());
                prefs = PREFERENCE_SERVICE.getPreferences(PreferenceServiceImplTest.this.testUser1.getUsername());
                Assert.assertNotNull(prefs);
                Assert.assertEquals((long)0L, (long)prefs.size());
                return null;
            }
        });
    }

    @Test(expected=AccessDeniedException.class)
    @RunAsFullyAuthenticatedRule.RunAsUser(userName="username2")
    public void testBadUser() {
        TRANSACTION_HELPER.doInTransaction((RetryingTransactionHelper.RetryingTransactionCallback)new RetryingTransactionHelper.RetryingTransactionCallback<Void>(){

            public Void execute() throws Throwable {
                HashMap<String, String> prefs = new HashMap<String, String>(5);
                prefs.put("alfresco.one.alpha", "string");
                PREFERENCE_SERVICE.setPreferences(PreferenceServiceImplTest.this.testUser1.getUsername(), prefs);
                return null;
            }
        });
    }

    @Test
    public void testGetOtherUserPreferences() {
        TRANSACTION_HELPER.doInTransaction((RetryingTransactionHelper.RetryingTransactionCallback)new RetryingTransactionHelper.RetryingTransactionCallback<Void>(){

            public Void execute() throws Throwable {
                HashMap<String, Object> prefs = new HashMap<String, Object>(5);
                prefs.put("alfresco.one.alpha", "string");
                prefs.put("alfresco.one.beta", 100);
                PREFERENCE_SERVICE.setPreferences(PreferenceServiceImplTest.this.testUser1.getUsername(), prefs);
                Map userOnePrefs = PREFERENCE_SERVICE.getPreferences(PreferenceServiceImplTest.this.testUser1.getUsername());
                Assert.assertNotNull((Object)userOnePrefs);
                Assert.assertEquals((long)2L, (long)prefs.size());
                return null;
            }
        });
        TRANSACTION_HELPER.doInTransaction((RetryingTransactionHelper.RetryingTransactionCallback)new RetryingTransactionHelper.RetryingTransactionCallback<Void>(){

            public Void execute() throws Throwable {
                AuthenticationUtil.setFullyAuthenticatedUser((String)PreferenceServiceImplTest.USERNAME2);
                try {
                    PREFERENCE_SERVICE.getPreferences(PreferenceServiceImplTest.this.testUser1.getUsername());
                }
                catch (AccessDeniedException accessDeniedException) {
                    return null;
                }
                Assert.fail((String)"Expected exception when trying to access another user's prefs");
                return null;
            }
        });
    }

    @Test
    public void testJSAPI() throws Exception {
        TRANSACTION_HELPER.doInTransaction((RetryingTransactionHelper.RetryingTransactionCallback)new RetryingTransactionHelper.RetryingTransactionCallback<Void>(){

            public Void execute() throws Throwable {
                HashMap<String, String> model = new HashMap<String, String>();
                model.put("username1", PreferenceServiceImplTest.this.testUser1.getUsername());
                model.put(PreferenceServiceImplTest.USERNAME2, PreferenceServiceImplTest.this.testUser2.getUsername());
                ClasspathScriptLocation location = new ClasspathScriptLocation("org/alfresco/repo/preference/script/test_preferenceService.js");
                SCRIPT_SERVICE.executeScript((ScriptLocation)location, model);
                return null;
            }
        });
    }

    private String prettyJson(String jsonString) {
        String result = jsonString;
        try {
            JSONObject json = new JSONObject(new JSONTokener(jsonString));
            result = json.toString(2);
        }
        catch (JSONException jSONException) {}
        return result;
    }
}

