/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.util.schemacomp.model;

import java.util.ArrayList;
import java.util.List;
import org.alfresco.util.schemacomp.DbObjectVisitor;
import org.alfresco.util.schemacomp.DbProperty;
import org.alfresco.util.schemacomp.DiffContext;
import org.alfresco.util.schemacomp.model.AbstractDbObject;
import org.alfresco.util.schemacomp.model.DbObject;
import org.alfresco.util.schemacomp.model.Table;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class Index
extends AbstractDbObject {
    private final List<String> columnNames = new ArrayList<String>();
    private boolean unique;
    private static Log logger = LogFactory.getLog(Index.class);

    public Index(String name) {
        super(null, name);
    }

    public Index(Table table, String name, List<String> columnNames) {
        super(table, name);
        this.columnNames.addAll(columnNames);
    }

    public List<String> getColumnNames() {
        return this.columnNames;
    }

    public void setColumnNames(List<String> columnNames) {
        this.columnNames.clear();
        this.columnNames.addAll(columnNames);
    }

    public boolean isUnique() {
        return this.unique;
    }

    public void setUnique(boolean unique) {
        this.unique = unique;
    }

    @Override
    public int hashCode() {
        int result = super.hashCode();
        result = 31 * result + (this.columnNames == null ? 0 : this.columnNames.hashCode());
        result = 31 * result + (this.unique ? 1231 : 1237);
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Index other = (Index)obj;
        if (this.unique != other.unique) {
            return false;
        }
        return !(this.columnNames == null ? other.columnNames != null : !this.columnNames.equals(other.columnNames));
    }

    @Override
    public boolean sameAs(DbObject o) {
        if (o != null && o instanceof Index) {
            Index other = (Index)o;
            if (!this.getParent().sameAs(other.getParent())) {
                return false;
            }
            if (this.getName() != null && this.getName().equals(other.getName())) {
                return true;
            }
            if (this.unique != other.unique) {
                return false;
            }
            return this.columnNames.equals(other.getColumnNames());
        }
        return false;
    }

    @Override
    protected void doDiff(DbObject right, DiffContext ctx) {
        Index rightIndex = (Index)right;
        this.comparisonUtils.compareSimpleOrderedLists(new DbProperty(this, "columnNames"), new DbProperty(rightIndex, "columnNames"), ctx);
        this.comparisonUtils.compareSimple(new DbProperty(this, "unique"), new DbProperty(rightIndex, "unique"), ctx);
    }

    @Override
    public void accept(DbObjectVisitor visitor) {
        visitor.visit(this);
    }
}

