/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.service.cmr.activities;

import org.alfresco.error.AlfrescoRuntimeException;
import org.alfresco.service.cmr.activities.ActivityPoster;
import org.alfresco.service.cmr.activities.ActivityService;
import org.alfresco.service.cmr.model.FileInfo;
import org.alfresco.service.cmr.repository.NodeRef;
import org.alfresco.sync.repo.Client;
import org.json.JSONException;
import org.json.JSONObject;

public class FileFolderActivityPosterImpl
implements ActivityPoster {
    private ActivityService activityService;

    @Override
    public void postFileFolderActivity(String activityType, String path, String tenantDomain, String siteId, NodeRef parentNodeRef, NodeRef nodeRef, String fileName, String appTool, Client client, FileInfo fileInfo) {
        JSONObject json;
        try {
            json = this.createActivityJSON(tenantDomain, path, parentNodeRef, nodeRef, fileName);
        }
        catch (JSONException jsonError) {
            throw new AlfrescoRuntimeException("Unabled to create activities json", (Throwable)jsonError);
        }
        this.activityService.postActivity(activityType, siteId, appTool, json.toString(), client, fileInfo);
    }

    protected JSONObject createActivityJSON(String tenantDomain, String path, NodeRef parentNodeRef, NodeRef nodeRef, String fileName) throws JSONException {
        JSONObject json = new JSONObject();
        json.put("nodeRef", (Object)nodeRef);
        if (parentNodeRef != null) {
            json.put("parentNodeRef", (Object)parentNodeRef);
        }
        if (path != null) {
            json.put("page", (Object)("documentlibrary?path=" + path));
        } else {
            json.put("page", (Object)("document-details?nodeRef=" + String.valueOf(nodeRef)));
        }
        json.put("title", (Object)fileName);
        if (tenantDomain != null && !tenantDomain.equals("")) {
            json.put("tenantDomain", (Object)tenantDomain);
        }
        return json;
    }

    public void setActivityService(ActivityService activityService) {
        this.activityService = activityService;
    }
}

