/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.action;

import java.io.File;
import java.io.IOException;
import java.io.Serializable;
import java.time.Duration;
import java.util.HashMap;
import java.util.List;
import java.util.Objects;
import org.alfresco.model.ContentModel;
import org.alfresco.repo.content.transform.AbstractContentTransformerTest;
import org.alfresco.repo.security.authentication.AuthenticationUtil;
import org.alfresco.repo.transaction.RetryingTransactionHelper;
import org.alfresco.service.cmr.action.Action;
import org.alfresco.service.cmr.action.ActionService;
import org.alfresco.service.cmr.action.ParameterConstraint;
import org.alfresco.service.cmr.repository.ContentService;
import org.alfresco.service.cmr.repository.ContentWriter;
import org.alfresco.service.cmr.repository.NodeRef;
import org.alfresco.service.cmr.repository.NodeService;
import org.alfresco.service.cmr.site.SiteVisibility;
import org.alfresco.service.namespace.QName;
import org.alfresco.util.test.junitrules.ApplicationContextInit;
import org.alfresco.util.test.junitrules.TemporaryNodes;
import org.alfresco.util.test.junitrules.TemporarySites;
import org.alfresco.util.test.junitrules.WellKnownNodes;
import org.assertj.core.api.Assertions;
import org.awaitility.Awaitility;
import org.junit.Assert;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;

public class ActionServiceImpl2Test {
    private static final int MAX_WAIT_TIMEOUT = 10;
    @ClassRule
    public static ApplicationContextInit APP_CONTEXT_INIT = new ApplicationContextInit();
    @Rule
    public TemporarySites temporarySites = new TemporarySites(APP_CONTEXT_INIT);
    @Rule
    public WellKnownNodes wellKnownNodes = new WellKnownNodes(APP_CONTEXT_INIT);
    @Rule
    public TemporaryNodes tempNodes = new TemporaryNodes(APP_CONTEXT_INIT);
    private static NodeService nodeService;
    private static ActionService actionService;
    private static ContentService contentService;
    private static RetryingTransactionHelper transactionHelper;
    private TemporarySites.TestSiteAndMemberInfo testSiteAndMemberInfo;
    private NodeRef testNode;

    @BeforeClass
    public static void initStaticData() throws Exception {
        nodeService = (NodeService)APP_CONTEXT_INIT.getApplicationContext().getBean("nodeService");
        actionService = (ActionService)APP_CONTEXT_INIT.getApplicationContext().getBean("actionService");
        contentService = (ContentService)APP_CONTEXT_INIT.getApplicationContext().getBean("contentService");
        transactionHelper = (RetryingTransactionHelper)APP_CONTEXT_INIT.getApplicationContext().getBean("retryingTransactionHelper");
    }

    @Before
    public void initTestSiteAndUsersAndSomeContent() {
        String siteShortName = ActionServiceImpl2Test.class.getSimpleName() + "TestSite" + System.currentTimeMillis();
        this.testSiteAndMemberInfo = this.temporarySites.createTestSiteWithUserPerRole(siteShortName, "sitePreset", SiteVisibility.PUBLIC, AuthenticationUtil.getAdminUserName());
        AuthenticationUtil.setFullyAuthenticatedUser((String)AuthenticationUtil.getAdminUserName());
        this.testNode = (NodeRef)transactionHelper.doInTransaction((RetryingTransactionHelper.RetryingTransactionCallback)new RetryingTransactionHelper.RetryingTransactionCallback<NodeRef>(){

            public NodeRef execute() throws Throwable {
                NodeRef docLibNodeRef = ActionServiceImpl2Test.this.testSiteAndMemberInfo.doclib;
                return nodeService.createNode(docLibNodeRef, ContentModel.ASSOC_CONTAINS, ContentModel.ASSOC_CONTAINS, ContentModel.TYPE_CONTENT).getChildRef();
            }
        });
    }

    @Test
    public void testIncrementCounterOnDeletedNode() throws Exception {
        final NodeRef deletedNode = (NodeRef)transactionHelper.doInTransaction((RetryingTransactionHelper.RetryingTransactionCallback)new RetryingTransactionHelper.RetryingTransactionCallback<NodeRef>(){

            public NodeRef execute() throws Throwable {
                NodeRef docLibNodeRef = ActionServiceImpl2Test.this.testSiteAndMemberInfo.doclib;
                NodeRef result = nodeService.createNode(docLibNodeRef, ContentModel.ASSOC_CONTAINS, ContentModel.ASSOC_CONTAINS, ContentModel.TYPE_CONTENT).getChildRef();
                nodeService.deleteNode(result);
                return result;
            }
        });
        transactionHelper.doInTransaction((RetryingTransactionHelper.RetryingTransactionCallback)new RetryingTransactionHelper.RetryingTransactionCallback<Void>(){

            public Void execute() throws Throwable {
                Action incrementAction = actionService.createAction("counter");
                actionService.executeAction(incrementAction, deletedNode);
                return null;
            }
        });
    }

    @Test
    public void testIncrementCounter() throws Exception {
        AuthenticationUtil.setFullyAuthenticatedUser((String)this.testSiteAndMemberInfo.siteManager);
        transactionHelper.doInTransaction((RetryingTransactionHelper.RetryingTransactionCallback)new RetryingTransactionHelper.RetryingTransactionCallback<Void>(){

            public Void execute() throws Throwable {
                HashMap<QName, Integer> props = new HashMap<QName, Integer>(1);
                props.put(ContentModel.PROP_COUNTER, 1);
                nodeService.addAspect(ActionServiceImpl2Test.this.testNode, ContentModel.ASPECT_COUNTABLE, props);
                return null;
            }
        });
        int beforeIncrement = (Integer)nodeService.getProperty(this.testNode, ContentModel.PROP_COUNTER);
        junit.framework.Assert.assertEquals((String)"Counter value incorrect", (int)1, (int)beforeIncrement);
        AuthenticationUtil.setFullyAuthenticatedUser((String)this.testSiteAndMemberInfo.siteConsumer);
        transactionHelper.doInTransaction((RetryingTransactionHelper.RetryingTransactionCallback)new RetryingTransactionHelper.RetryingTransactionCallback<Void>(){

            public Void execute() throws Throwable {
                Action incrementAction = actionService.createAction("counter");
                actionService.executeAction(incrementAction, ActionServiceImpl2Test.this.testNode);
                return null;
            }
        });
        int afterIncrement = (Integer)nodeService.getProperty(this.testNode, ContentModel.PROP_COUNTER);
        junit.framework.Assert.assertEquals((int)2, (int)afterIncrement);
    }

    @Test
    public void testTransform() throws Exception {
        File file = this.loadAndAddQuickFileAsManager(this.testNode, "quick.txt", "text/plain");
        Assert.assertNotNull((String)"Failed to load required test file.", (Object)file);
        AuthenticationUtil.setFullyAuthenticatedUser((String)this.testSiteAndMemberInfo.siteManager);
        transactionHelper.doInTransaction((RetryingTransactionHelper.RetryingTransactionCallback)new RetryingTransactionHelper.RetryingTransactionCallback<Void>(){

            public Void execute() throws Throwable {
                Action action = actionService.createAction("transform");
                HashMap<String, String> map = new HashMap<String, String>();
                map.put("mime-type", "text/html");
                map.put("destination-folder", (String)nodeService.getPrimaryParent(ActionServiceImpl2Test.this.testNode).getParentRef());
                action.setParameterValues(map);
                actionService.executeAction(action, ActionServiceImpl2Test.this.testNode);
                return null;
            }
        });
    }

    @Test
    public void testParameterConstraints() throws Exception {
        List constraints = actionService.getParameterConstraints();
        Assert.assertNotNull((Object)constraints);
        if (constraints.size() > 0) {
            ParameterConstraint parameterConstraint = (ParameterConstraint)constraints.get(0);
            ParameterConstraint pConstraintAgain = actionService.getParameterConstraint(parameterConstraint.getName());
            Assert.assertEquals((Object)parameterConstraint, (Object)pConstraintAgain);
        }
    }

    @Test
    public void testExecuteScript() throws Exception {
        final NodeRef scriptToBeExecuted = this.addTempScript("changeFileNameTest.js", "document.properties.name = \"Changed_\" + document.properties.name;\ndocument.save();");
        Assert.assertNotNull((String)"Failed to add the test script.", (Object)scriptToBeExecuted);
        File file = this.loadAndAddQuickFileAsManager(this.testNode, "quick.pdf", "application/pdf");
        Assert.assertNotNull((String)"Failed to load required test file.", (Object)file);
        AuthenticationUtil.setFullyAuthenticatedUser((String)this.testSiteAndMemberInfo.siteConsumer);
        transactionHelper.doInTransaction((RetryingTransactionHelper.RetryingTransactionCallback)new RetryingTransactionHelper.RetryingTransactionCallback<Void>(){

            public Void execute() throws Throwable {
                Action action = actionService.createAction("script");
                action.setParameterValue("script-ref", (Serializable)scriptToBeExecuted);
                try {
                    actionService.executeAction(action, ActionServiceImpl2Test.this.testNode);
                }
                catch (Throwable throwable) {}
                Assert.assertTrue((String)"The consumer shouldn't be able to change the name of the file.", (boolean)"quick.pdf".equals(nodeService.getProperty(ActionServiceImpl2Test.this.testNode, ContentModel.PROP_NAME)));
                return null;
            }
        });
        AuthenticationUtil.setFullyAuthenticatedUser((String)this.testSiteAndMemberInfo.siteManager);
        transactionHelper.doInTransaction((RetryingTransactionHelper.RetryingTransactionCallback)new RetryingTransactionHelper.RetryingTransactionCallback<Void>(){

            public Void execute() throws Throwable {
                Action action = actionService.createAction("script");
                action.setParameterValue("script-ref", (Serializable)scriptToBeExecuted);
                actionService.executeAction(action, ActionServiceImpl2Test.this.testNode);
                junit.framework.Assert.assertEquals((Object)"Changed_quick.pdf", (Object)nodeService.getProperty(ActionServiceImpl2Test.this.testNode, ContentModel.PROP_NAME));
                return null;
            }
        });
        AuthenticationUtil.setFullyAuthenticatedUser((String)this.testSiteAndMemberInfo.siteManager);
        NodeRef companyHomeRef = this.wellKnownNodes.getCompanyHome();
        NodeRef sharedFolderRef = nodeService.getChildByName(companyHomeRef, ContentModel.ASSOC_CONTAINS, "Shared");
        final NodeRef invalidScriptRef = this.addTempScript("changeFileNameTest.js", "document.properties.name = \"Invalid_Change.pdf\";\ndocument.save();", sharedFolderRef);
        Assert.assertNotNull((String)"Failed to add the test script.", (Object)scriptToBeExecuted);
        transactionHelper.doInTransaction((RetryingTransactionHelper.RetryingTransactionCallback)new RetryingTransactionHelper.RetryingTransactionCallback<Void>(){

            public Void execute() throws Throwable {
                Action action = actionService.createAction("script");
                action.setParameterValue("script-ref", (Serializable)invalidScriptRef);
                try {
                    actionService.executeAction(action, ActionServiceImpl2Test.this.testNode);
                }
                catch (Throwable throwable) {}
                Assert.assertFalse((String)"Scripts outside of Data Dictionary Scripts folder should not be executed", (boolean)"Invalid_Change.pdf".equals(nodeService.getProperty(ActionServiceImpl2Test.this.testNode, ContentModel.PROP_NAME)));
                return null;
            }
        });
    }

    @Test
    public void testActionResult() throws Exception {
        AuthenticationUtil.setFullyAuthenticatedUser((String)AuthenticationUtil.getAdminUserName());
        transactionHelper.doInTransaction((RetryingTransactionHelper.RetryingTransactionCallback)new RetryingTransactionHelper.RetryingTransactionCallback<Void>(){

            public Void execute() throws Throwable {
                try {
                    NodeRef script = ActionServiceImpl2Test.this.addTempScript("test-action-result-script.js", "\"VALUE\";");
                    Action action = actionService.createAction("script");
                    action.setParameterValue("script-ref", (Serializable)script);
                    actionService.executeAction(action, ActionServiceImpl2Test.this.testNode);
                    String result = (String)((Object)action.getParameterValue("result"));
                    Assert.assertNotNull((Object)result);
                    junit.framework.Assert.assertEquals((String)"VALUE", (String)result);
                }
                finally {
                    AuthenticationUtil.clearCurrentSecurityContext();
                }
                return null;
            }
        });
    }

    @Test
    public void testExtractMetedata() throws Exception {
        File file = this.loadAndAddQuickFileAsManager(this.testNode, "quick.pdf", "application/pdf");
        Assert.assertNotNull((String)"Failed to load required test file.", (Object)file);
        AuthenticationUtil.setFullyAuthenticatedUser((String)this.testSiteAndMemberInfo.siteConsumer);
        transactionHelper.doInTransaction((RetryingTransactionHelper.RetryingTransactionCallback)new RetryingTransactionHelper.RetryingTransactionCallback<Void>(){

            public Void execute() throws Throwable {
                Action action = actionService.createAction("extract-metadata");
                try {
                    actionService.executeAction(action, ActionServiceImpl2Test.this.testNode);
                }
                catch (Throwable throwable) {}
                Assert.assertTrue((String)"The consumer shouldn't be able to perform Extract Metadata.", (nodeService.getProperty(ActionServiceImpl2Test.this.testNode, ContentModel.PROP_DESCRIPTION) == null ? 1 : 0) != 0);
                return null;
            }
        });
        AuthenticationUtil.setFullyAuthenticatedUser((String)this.testSiteAndMemberInfo.siteCollaborator);
        transactionHelper.doInTransaction((RetryingTransactionHelper.RetryingTransactionCallback)new RetryingTransactionHelper.RetryingTransactionCallback<Void>(){

            public Void execute() throws Throwable {
                Action action = actionService.createAction("extract-metadata");
                actionService.executeAction(action, ActionServiceImpl2Test.this.testNode);
                return null;
            }
        });
        Awaitility.await().atMost(Duration.ofSeconds(10L)).until(() -> Objects.nonNull(this.getProperty(this.testNode, ContentModel.PROP_DESCRIPTION)));
        Assertions.assertThat((Object)this.getProperty(this.testNode, ContentModel.PROP_DESCRIPTION)).isEqualTo((Object)"Pangram, fox, dog, Gym class featuring a brown fox and lazy dog");
    }

    private Serializable getProperty(NodeRef nodeRef, QName propertyName) {
        return (Serializable)transactionHelper.doInTransaction(() -> nodeService.getProperty(nodeRef, propertyName));
    }

    private NodeRef addTempScript(final String scriptFileName, final String javaScript, final NodeRef parentRef) {
        AuthenticationUtil.setFullyAuthenticatedUser((String)AuthenticationUtil.getAdminUserName());
        return (NodeRef)transactionHelper.doInTransaction((RetryingTransactionHelper.RetryingTransactionCallback)new RetryingTransactionHelper.RetryingTransactionCallback<NodeRef>(){

            public NodeRef execute() throws Throwable {
                NodeRef script = nodeService.createNode(parentRef, ContentModel.ASSOC_CONTAINS, QName.createQName((String)"http://www.alfresco.org/model/content/1.0", (String)scriptFileName), ContentModel.TYPE_CONTENT).getChildRef();
                nodeService.setProperty(script, ContentModel.PROP_NAME, (Serializable)((Object)scriptFileName));
                ContentWriter contentWriter = contentService.getWriter(script, ContentModel.PROP_CONTENT, true);
                contentWriter.setMimetype("application/x-javascript");
                contentWriter.setEncoding("UTF-8");
                contentWriter.putContent(javaScript);
                ActionServiceImpl2Test.this.tempNodes.addNodeRef(script);
                return script;
            }
        });
    }

    private NodeRef addTempScript(final String scriptFileName, final String javaScript) {
        AuthenticationUtil.setFullyAuthenticatedUser((String)AuthenticationUtil.getAdminUserName());
        return (NodeRef)transactionHelper.doInTransaction((RetryingTransactionHelper.RetryingTransactionCallback)new RetryingTransactionHelper.RetryingTransactionCallback<NodeRef>(){

            public NodeRef execute() throws Throwable {
                NodeRef companyHomeRef = ActionServiceImpl2Test.this.wellKnownNodes.getCompanyHome();
                NodeRef dataDictionaryRef = nodeService.getChildByName(companyHomeRef, ContentModel.ASSOC_CONTAINS, "Data Dictionary");
                NodeRef scriptsRef = nodeService.getChildByName(dataDictionaryRef, ContentModel.ASSOC_CONTAINS, "Scripts");
                return ActionServiceImpl2Test.this.addTempScript(scriptFileName, javaScript, scriptsRef);
            }
        });
    }

    private File loadAndAddQuickFileAsManager(final NodeRef nodeRef, final String quickFileName, final String mimeType) throws IOException {
        final File file = AbstractContentTransformerTest.loadNamedQuickTestFile(quickFileName);
        if (file == null) {
            return null;
        }
        AuthenticationUtil.setFullyAuthenticatedUser((String)this.testSiteAndMemberInfo.siteManager);
        transactionHelper.doInTransaction((RetryingTransactionHelper.RetryingTransactionCallback)new RetryingTransactionHelper.RetryingTransactionCallback<Void>(){

            public Void execute() throws Throwable {
                nodeService.setProperty(nodeRef, ContentModel.PROP_NAME, (Serializable)((Object)quickFileName));
                ContentWriter writer = contentService.getWriter(nodeRef, ContentModel.PROP_CONTENT, true);
                writer.setMimetype(mimeType);
                writer.setEncoding("UTF-8");
                writer.putContent(file);
                return null;
            }
        });
        return file;
    }
}

