/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.util.schemacomp;

import org.alfresco.util.schemacomp.DbProperty;
import org.alfresco.util.schemacomp.Difference;
import org.alfresco.util.schemacomp.model.Column;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.mockito.Mockito;
import org.springframework.extensions.surf.util.I18NUtil;

public class DifferenceTest {
    @Before
    public void setUp() {
        I18NUtil.registerResourceBundle((String)"alfresco.messages.system-messages");
    }

    @Test
    public void describe() {
        DbProperty refDbProp = (DbProperty)Mockito.mock(DbProperty.class);
        Mockito.when((Object)refDbProp.getPath()).thenReturn((Object)"alfresco.some_table.some_column.name");
        Mockito.when((Object)refDbProp.getDbObject()).thenReturn((Object)new Column("some_column"));
        Mockito.when((Object)refDbProp.getPropertyValue()).thenReturn((Object)"node_ref");
        DbProperty targetDbProp = (DbProperty)Mockito.mock(DbProperty.class);
        Mockito.when((Object)targetDbProp.getPath()).thenReturn((Object)"alfresco.some_table.some_column.name");
        Mockito.when((Object)targetDbProp.getDbObject()).thenReturn((Object)new Column("some_column"));
        Mockito.when((Object)targetDbProp.getPropertyValue()).thenReturn((Object)"nood_ref");
        Difference diff = new Difference(Difference.Where.IN_BOTH_BUT_DIFFERENCE, refDbProp, targetDbProp);
        Assert.assertEquals((Object)"Difference: expected column alfresco.some_table.some_column.name=\"node_ref\", but was alfresco.some_table.some_column.name=\"nood_ref\"", (Object)diff.describe());
    }

    @Test
    public void describeRefOnly() {
        DbProperty refDbProp = (DbProperty)Mockito.mock(DbProperty.class);
        Mockito.when((Object)refDbProp.getPath()).thenReturn((Object)"alfresco.some_table.some_column");
        Mockito.when((Object)refDbProp.getDbObject()).thenReturn((Object)new Column("some_column"));
        Difference diff = new Difference(Difference.Where.ONLY_IN_REFERENCE, refDbProp, null);
        Assert.assertEquals((Object)"Difference: missing column from database, expected at path: alfresco.some_table.some_column", (Object)diff.describe());
    }

    @Test
    public void describeTargetOnly() {
        DbProperty targetDbProp = (DbProperty)Mockito.mock(DbProperty.class);
        Mockito.when((Object)targetDbProp.getPath()).thenReturn((Object)"alfresco.some_table.some_column");
        Mockito.when((Object)targetDbProp.getDbObject()).thenReturn((Object)new Column("some_column"));
        Difference diff = new Difference(Difference.Where.ONLY_IN_TARGET, null, targetDbProp);
        Assert.assertEquals((Object)"Difference: unexpected column found in database with path: alfresco.some_table.some_column", (Object)diff.describe());
    }
}

