/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.workflow.activiti;

import org.activiti.engine.impl.TaskQueryImpl;
import org.activiti.engine.impl.interceptor.CommandContext;
import org.activiti.engine.impl.jobexecutor.JobHandler;
import org.activiti.engine.impl.persistence.entity.ExecutionEntity;
import org.activiti.engine.impl.persistence.entity.JobEntity;
import org.activiti.engine.impl.pvm.process.ActivityImpl;
import org.activiti.engine.task.Task;
import org.alfresco.model.ContentModel;
import org.alfresco.repo.security.authentication.AuthenticationUtil;
import org.alfresco.repo.tenant.TenantUtil;
import org.alfresco.repo.workflow.activiti.ActivitiScriptNode;
import org.alfresco.service.cmr.repository.NodeRef;
import org.alfresco.service.cmr.repository.NodeService;

public class AuthenticatedTimerJobHandler
implements JobHandler {
    private JobHandler wrappedHandler;
    private NodeService unprotectedNodeService;

    public AuthenticatedTimerJobHandler(JobHandler jobHandler, NodeService nodeService) {
        if (jobHandler == null) {
            throw new IllegalArgumentException("JobHandler to delegate to is required");
        }
        if (nodeService == null) {
            throw new IllegalArgumentException("NodeService is required");
        }
        this.unprotectedNodeService = nodeService;
        this.wrappedHandler = jobHandler;
    }

    public void execute(final JobEntity job, final String configuration, final ExecutionEntity execution, final CommandContext commandContext) {
        Task task;
        String activityType;
        ActivityImpl targetActivity;
        String userName = null;
        String tenantToRunIn = (String)execution.getVariable("_tenant_domain");
        if (tenantToRunIn != null && tenantToRunIn.trim().length() == 0) {
            tenantToRunIn = null;
        }
        final ActivitiScriptNode initiatorNode = (ActivitiScriptNode)execution.getVariable("initiator");
        userName = tenantToRunIn != null ? (String)TenantUtil.runAsTenant((TenantUtil.TenantRunAsWork)new TenantUtil.TenantRunAsWork<String>(){

            public String doWork() throws Exception {
                return AuthenticatedTimerJobHandler.this.getInitiator(initiatorNode);
            }
        }, (String)tenantToRunIn) : (String)AuthenticationUtil.runAs((AuthenticationUtil.RunAsWork)new AuthenticationUtil.RunAsWork<String>(){

            public String doWork() throws Exception {
                return AuthenticatedTimerJobHandler.this.getInitiator(initiatorNode);
            }
        }, (String)AuthenticationUtil.getSystemUserName());
        if (userName == null && (targetActivity = execution.getActivity()) != null && "userTask".equals(activityType = (String)targetActivity.getProperty("type")) && (task = (Task)new TaskQueryImpl(commandContext).executionId(execution.getId()).executeSingleResult(commandContext)) != null && task.getAssignee() != null) {
            userName = task.getAssignee();
        }
        if (userName == null) {
            userName = AuthenticationUtil.getSystemUserName();
            tenantToRunIn = null;
        }
        if (tenantToRunIn != null) {
            TenantUtil.runAsUserTenant((TenantUtil.TenantRunAsWork)new TenantUtil.TenantRunAsWork<Void>(){

                public Void doWork() throws Exception {
                    AuthenticatedTimerJobHandler.this.wrappedHandler.execute(job, configuration, execution, commandContext);
                    return null;
                }
            }, (String)userName, (String)tenantToRunIn);
        } else {
            AuthenticationUtil.runAs((AuthenticationUtil.RunAsWork)new AuthenticationUtil.RunAsWork<Void>(){

                public Void doWork() throws Exception {
                    AuthenticatedTimerJobHandler.this.wrappedHandler.execute(job, configuration, execution, commandContext);
                    return null;
                }
            }, (String)userName);
        }
    }

    protected String getInitiator(ActivitiScriptNode initiatorNode) {
        NodeRef ref;
        if (initiatorNode != null && this.unprotectedNodeService.exists(ref = initiatorNode.getNodeRef())) {
            return (String)((Object)this.unprotectedNodeService.getProperty(ref, ContentModel.PROP_USERNAME));
        }
        return null;
    }

    public String getType() {
        return this.wrappedHandler.getType();
    }
}

