/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.rating;

import java.io.Serializable;
import java.lang.annotation.Annotation;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.alfresco.model.ContentModel;
import org.alfresco.repo.policy.BehaviourFilter;
import org.alfresco.repo.rating.AbstractRatingRollupAlgorithm;
import org.alfresco.repo.rating.RatingNamingConventionsUtil;
import org.alfresco.repo.rating.RatingSchemeRegistry;
import org.alfresco.repo.rating.RatingServiceImpl$AjcClosure1;
import org.alfresco.repo.rating.RatingServiceImpl$AjcClosure11;
import org.alfresco.repo.rating.RatingServiceImpl$AjcClosure13;
import org.alfresco.repo.rating.RatingServiceImpl$AjcClosure15;
import org.alfresco.repo.rating.RatingServiceImpl$AjcClosure17;
import org.alfresco.repo.rating.RatingServiceImpl$AjcClosure19;
import org.alfresco.repo.rating.RatingServiceImpl$AjcClosure3;
import org.alfresco.repo.rating.RatingServiceImpl$AjcClosure5;
import org.alfresco.repo.rating.RatingServiceImpl$AjcClosure7;
import org.alfresco.repo.rating.RatingServiceImpl$AjcClosure9;
import org.alfresco.repo.rating.traitextender.RatingServiceExtension;
import org.alfresco.repo.rating.traitextender.RatingServiceTrait;
import org.alfresco.repo.security.authentication.AuthenticationUtil;
import org.alfresco.service.cmr.dictionary.AspectDefinition;
import org.alfresco.service.cmr.dictionary.DictionaryService;
import org.alfresco.service.cmr.rating.Rating;
import org.alfresco.service.cmr.rating.RatingScheme;
import org.alfresco.service.cmr.rating.RatingService;
import org.alfresco.service.cmr.rating.RatingServiceException;
import org.alfresco.service.cmr.repository.ChildAssociationRef;
import org.alfresco.service.cmr.repository.NodeRef;
import org.alfresco.service.cmr.repository.NodeService;
import org.alfresco.service.namespace.QName;
import org.alfresco.service.namespace.QNamePattern;
import org.alfresco.traitextender.AJProxyTrait;
import org.alfresco.traitextender.Extend;
import org.alfresco.traitextender.ExtendedTrait;
import org.alfresco.traitextender.Extensible;
import org.alfresco.traitextender.RouteExtensions;
import org.alfresco.traitextender.Trait;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.ProceedingJoinPoint;
import org.aspectj.lang.Signature;
import org.aspectj.runtime.internal.Conversions;
import org.aspectj.runtime.reflect.Factory;

public class RatingServiceImpl
implements RatingService,
Extensible {
    private static final Log log;
    private RatingSchemeRegistry schemeRegistry;
    private DictionaryService dictionaryService;
    private NodeService nodeService;
    private BehaviourFilter behaviourFilter;
    public final ExtendedTrait<RatingServiceTrait> ratingServiceTrait = new ExtendedTrait<RatingServiceTrait>(AJProxyTrait.create(this, RatingServiceTrait.class));
    private RatingNamingConventionsUtil ratingNamingConventions;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_0;
    private static /* synthetic */ Annotation ajc$anno$0;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_1;
    private static /* synthetic */ Annotation ajc$anno$1;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_2;
    private static /* synthetic */ Annotation ajc$anno$2;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_3;
    private static /* synthetic */ Annotation ajc$anno$3;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_4;
    private static /* synthetic */ Annotation ajc$anno$4;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_5;
    private static /* synthetic */ Annotation ajc$anno$5;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_6;
    private static /* synthetic */ Annotation ajc$anno$6;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_7;
    private static /* synthetic */ Annotation ajc$anno$7;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_8;
    private static /* synthetic */ Annotation ajc$anno$8;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_9;
    private static /* synthetic */ Annotation ajc$anno$9;

    static {
        RatingServiceImpl.ajc$preClinit();
        log = LogFactory.getLog(RatingServiceImpl.class);
    }

    public void setRatingSchemeRegistry(RatingSchemeRegistry schemeRegistry) {
        this.schemeRegistry = schemeRegistry;
    }

    public void setDictionaryService(DictionaryService dictionaryService) {
        this.dictionaryService = dictionaryService;
    }

    public void setNodeService(NodeService nodeService) {
        this.nodeService = nodeService;
    }

    public void setBehaviourFilter(BehaviourFilter behaviourFilter) {
        this.behaviourFilter = behaviourFilter;
    }

    public void setRollupNamingConventions(RatingNamingConventionsUtil namingConventions) {
        this.ratingNamingConventions = namingConventions;
    }

    @Override
    @Extend(traitAPI=RatingServiceTrait.class, extensionAPI=RatingServiceExtension.class)
    public Map<String, RatingScheme> getRatingSchemes() {
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_0, (Object)this, (Object)this);
        RouteExtensions routeExtensions = RouteExtensions.aspectOf();
        Object[] objectArray = new Object[]{this, joinPoint};
        RatingServiceImpl$AjcClosure1 ratingServiceImpl$AjcClosure1 = new RatingServiceImpl$AjcClosure1(objectArray);
        ProceedingJoinPoint proceedingJoinPoint = ratingServiceImpl$AjcClosure1.linkClosureAndJoinPoint(69648);
        Annotation annotation = ajc$anno$0;
        if (annotation == null) {
            annotation = ajc$anno$0 = RatingServiceImpl.class.getDeclaredMethod("getRatingSchemes", new Class[0]).getAnnotation(Extend.class);
        }
        return (Map)routeExtensions.intercept(proceedingJoinPoint, (Extend)annotation);
    }

    @Override
    @Extend(traitAPI=RatingServiceTrait.class, extensionAPI=RatingServiceExtension.class)
    public RatingScheme getRatingScheme(String ratingSchemeName) {
        String string = ratingSchemeName;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_1, (Object)this, (Object)this, (Object)string);
        RouteExtensions routeExtensions = RouteExtensions.aspectOf();
        Object[] objectArray = new Object[]{this, string, joinPoint};
        RatingServiceImpl$AjcClosure3 ratingServiceImpl$AjcClosure3 = new RatingServiceImpl$AjcClosure3(objectArray);
        ProceedingJoinPoint proceedingJoinPoint = ratingServiceImpl$AjcClosure3.linkClosureAndJoinPoint(69648);
        Annotation annotation = ajc$anno$1;
        if (annotation == null) {
            annotation = ajc$anno$1 = RatingServiceImpl.class.getDeclaredMethod("getRatingScheme", String.class).getAnnotation(Extend.class);
        }
        return (RatingScheme)routeExtensions.intercept(proceedingJoinPoint, (Extend)annotation);
    }

    @Override
    @Extend(traitAPI=RatingServiceTrait.class, extensionAPI=RatingServiceExtension.class)
    public void applyRating(NodeRef targetNode, float rating, String ratingSchemeName) throws RatingServiceException {
        NodeRef nodeRef = targetNode;
        float f = rating;
        String string = ratingSchemeName;
        Object[] objectArray = new Object[]{nodeRef, Conversions.floatObject((float)f), string};
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_2, (Object)this, (Object)this, (Object[])objectArray);
        RouteExtensions routeExtensions = RouteExtensions.aspectOf();
        Object[] objectArray2 = new Object[]{this, nodeRef, Conversions.floatObject((float)f), string, joinPoint};
        RatingServiceImpl$AjcClosure5 ratingServiceImpl$AjcClosure5 = new RatingServiceImpl$AjcClosure5(objectArray2);
        ProceedingJoinPoint proceedingJoinPoint = ratingServiceImpl$AjcClosure5.linkClosureAndJoinPoint(69648);
        Annotation annotation = ajc$anno$2;
        if (annotation == null) {
            annotation = ajc$anno$2 = RatingServiceImpl.class.getDeclaredMethod("applyRating", NodeRef.class, Float.TYPE, String.class).getAnnotation(Extend.class);
        }
        routeExtensions.intercept(proceedingJoinPoint, (Extend)annotation);
    }

    private boolean isCurrentUserNodeCreator(NodeRef targetNode) {
        String currentUser = AuthenticationUtil.getFullyAuthenticatedUser();
        Serializable creator = this.nodeService.getProperty(targetNode, ContentModel.PROP_CREATOR);
        return currentUser.equals(creator);
    }

    private void applyRating(NodeRef targetNode, float rating, String ratingSchemeName, String userName) throws RatingServiceException {
        QName assocQName;
        List myRatingChildren;
        boolean rollupAspectIsDefined;
        RatingScheme ratingScheme;
        if (log.isDebugEnabled()) {
            StringBuilder msg = new StringBuilder();
            msg.append("Applying rating ").append(rating).append(" in scheme ").append(ratingSchemeName).append(" as user ").append(userName).append(" on ").append(targetNode);
            log.debug((Object)msg.toString());
        }
        if ((ratingScheme = this.getRatingScheme(ratingSchemeName)) == null) {
            throw new RatingServiceException("Unrecognised rating scheme: " + ratingSchemeName);
        }
        if (rating < ratingScheme.getMinRating() || rating > ratingScheme.getMaxRating()) {
            throw new RatingServiceException("Rating " + rating + " violates range for " + String.valueOf(ratingScheme));
        }
        QName rollupAspectName = this.ratingNamingConventions.getRollupAspectNameFor(ratingScheme);
        boolean bl = rollupAspectIsDefined = this.dictionaryService.getAspect(rollupAspectName) != null;
        if (!this.nodeService.hasAspect(targetNode, ContentModel.ASPECT_RATEABLE)) {
            this.behaviourFilter.disableBehaviour(targetNode, ContentModel.ASPECT_AUDITABLE);
            try {
                this.nodeService.addAspect(targetNode, ContentModel.ASPECT_RATEABLE, null);
                if (rollupAspectIsDefined) {
                    this.nodeService.addAspect(targetNode, rollupAspectName, null);
                }
            }
            finally {
                this.behaviourFilter.enableBehaviour(targetNode, ContentModel.ASPECT_AUDITABLE);
            }
        }
        if ((myRatingChildren = this.nodeService.getChildAssocs(targetNode, (QNamePattern)ContentModel.ASSOC_RATINGS, (QNamePattern)(assocQName = this.ratingNamingConventions.getRatingAssocNameFor(userName, ratingScheme.getName())))).isEmpty()) {
            HashMap<QName, Object> ratingProps = new HashMap<QName, Object>();
            ratingProps.put(ContentModel.PROP_RATING_SCORE, Float.valueOf(rating));
            ratingProps.put(ContentModel.PROP_RATED_AT, new Date());
            ratingProps.put(ContentModel.PROP_RATING_SCHEME, ratingSchemeName);
            this.behaviourFilter.disableBehaviour(targetNode, ContentModel.ASPECT_AUDITABLE);
            try {
                this.nodeService.createNode(targetNode, ContentModel.ASSOC_RATINGS, assocQName, ContentModel.TYPE_RATING, ratingProps);
            }
            finally {
                this.behaviourFilter.enableBehaviour(targetNode, ContentModel.ASPECT_AUDITABLE);
            }
        } else {
            NodeRef myPreviousRatingsNode = ((ChildAssociationRef)myRatingChildren.get(0)).getChildRef();
            HashMap<QName, Object> ratingProps = new HashMap<QName, Object>();
            ratingProps.put(ContentModel.PROP_RATING_SCHEME, ratingSchemeName);
            ratingProps.put(ContentModel.PROP_RATING_SCORE, Float.valueOf(rating));
            ratingProps.put(ContentModel.PROP_RATED_AT, new Date());
            this.nodeService.setProperties(myPreviousRatingsNode, ratingProps);
        }
        this.recalculateRatingRollups(targetNode, ratingScheme);
    }

    private void recalculateRatingRollups(NodeRef targetNode, RatingScheme ratingScheme) {
        QName rollupAspectName = this.ratingNamingConventions.getRollupAspectNameFor(ratingScheme);
        AspectDefinition rollupAspect = this.dictionaryService.getAspect(rollupAspectName);
        if (rollupAspect != null) {
            this.behaviourFilter.disableBehaviour(targetNode, ContentModel.ASPECT_AUDITABLE);
            try {
                for (AbstractRatingRollupAlgorithm rollupAlgorithm : ratingScheme.getPropertyRollups()) {
                    Serializable s = rollupAlgorithm.recalculate(targetNode);
                    QName rollupPropertyName = this.ratingNamingConventions.getRollupPropertyNameFor(ratingScheme, rollupAlgorithm.getRollupName());
                    this.nodeService.setProperty(targetNode, rollupPropertyName, s);
                    if (rollupAspect.getProperties().containsKey(rollupPropertyName) || !log.isDebugEnabled()) continue;
                    StringBuilder msg = new StringBuilder();
                    msg.append("Rating property rollup property ").append(rollupPropertyName).append(" on aspect ").append(rollupAspectName).append(" is not defined in the content model.");
                    log.debug((Object)msg.toString());
                }
            }
            finally {
                this.behaviourFilter.enableBehaviour(targetNode, ContentModel.ASPECT_AUDITABLE);
            }
        } else if (log.isDebugEnabled()) {
            StringBuilder msg = new StringBuilder();
            msg.append("Rating property rollup aspect ").append(rollupAspectName).append(" is not defined in the content model & therefore the rollup was not persisted.");
            log.debug((Object)msg.toString());
        }
    }

    @Override
    @Extend(traitAPI=RatingServiceTrait.class, extensionAPI=RatingServiceExtension.class)
    public Rating getRatingByCurrentUser(NodeRef targetNode, String ratingSchemeName) {
        NodeRef nodeRef = targetNode;
        String string = ratingSchemeName;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_3, (Object)this, (Object)this, (Object)nodeRef, (Object)string);
        RouteExtensions routeExtensions = RouteExtensions.aspectOf();
        Object[] objectArray = new Object[]{this, nodeRef, string, joinPoint};
        RatingServiceImpl$AjcClosure7 ratingServiceImpl$AjcClosure7 = new RatingServiceImpl$AjcClosure7(objectArray);
        ProceedingJoinPoint proceedingJoinPoint = ratingServiceImpl$AjcClosure7.linkClosureAndJoinPoint(69648);
        Annotation annotation = ajc$anno$3;
        if (annotation == null) {
            annotation = ajc$anno$3 = RatingServiceImpl.class.getDeclaredMethod("getRatingByCurrentUser", NodeRef.class, String.class).getAnnotation(Extend.class);
        }
        return (Rating)routeExtensions.intercept(proceedingJoinPoint, (Extend)annotation);
    }

    @Override
    @Extend(traitAPI=RatingServiceTrait.class, extensionAPI=RatingServiceExtension.class)
    public List<Rating> getRatingsByCurrentUser(NodeRef targetNode) {
        NodeRef nodeRef = targetNode;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_4, (Object)this, (Object)this, (Object)nodeRef);
        RouteExtensions routeExtensions = RouteExtensions.aspectOf();
        Object[] objectArray = new Object[]{this, nodeRef, joinPoint};
        RatingServiceImpl$AjcClosure9 ratingServiceImpl$AjcClosure9 = new RatingServiceImpl$AjcClosure9(objectArray);
        ProceedingJoinPoint proceedingJoinPoint = ratingServiceImpl$AjcClosure9.linkClosureAndJoinPoint(69648);
        Annotation annotation = ajc$anno$4;
        if (annotation == null) {
            annotation = ajc$anno$4 = RatingServiceImpl.class.getDeclaredMethod("getRatingsByCurrentUser", NodeRef.class).getAnnotation(Extend.class);
        }
        return (List)routeExtensions.intercept(proceedingJoinPoint, (Extend)annotation);
    }

    private Rating getRating(NodeRef targetNode, String ratingSchemeName, String user) {
        List<ChildAssociationRef> ratingChildren = this.getRatingNodeChildren(targetNode, ratingSchemeName, user);
        if (ratingChildren.isEmpty()) {
            return null;
        }
        ChildAssociationRef ratingNodeAssoc = ratingChildren.get(0);
        return this.convertNodeRefToRating(user, ratingNodeAssoc.getChildRef());
    }

    private Rating convertNodeRefToRating(String user, NodeRef ratingNode) {
        Map properties = this.nodeService.getProperties(ratingNode);
        String existingRatingScheme = (String)properties.get(ContentModel.PROP_RATING_SCHEME);
        Float existingRatingScore = (Float)properties.get(ContentModel.PROP_RATING_SCORE);
        Date existingRatingDate = (Date)properties.get(ContentModel.PROP_RATED_AT);
        Rating result = new Rating(this.getRatingScheme(existingRatingScheme), existingRatingScore.floatValue(), user, existingRatingDate);
        return result;
    }

    @Override
    @Extend(traitAPI=RatingServiceTrait.class, extensionAPI=RatingServiceExtension.class)
    public Rating removeRatingByCurrentUser(NodeRef targetNode, String ratingScheme) {
        NodeRef nodeRef = targetNode;
        String string = ratingScheme;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_5, (Object)this, (Object)this, (Object)nodeRef, (Object)string);
        RouteExtensions routeExtensions = RouteExtensions.aspectOf();
        Object[] objectArray = new Object[]{this, nodeRef, string, joinPoint};
        RatingServiceImpl$AjcClosure11 ratingServiceImpl$AjcClosure11 = new RatingServiceImpl$AjcClosure11(objectArray);
        ProceedingJoinPoint proceedingJoinPoint = ratingServiceImpl$AjcClosure11.linkClosureAndJoinPoint(69648);
        Annotation annotation = ajc$anno$5;
        if (annotation == null) {
            annotation = ajc$anno$5 = RatingServiceImpl.class.getDeclaredMethod("removeRatingByCurrentUser", NodeRef.class, String.class).getAnnotation(Extend.class);
        }
        return (Rating)routeExtensions.intercept(proceedingJoinPoint, (Extend)annotation);
    }

    private Rating removeRating(NodeRef targetNode, String ratingSchemeName, String user) {
        List<ChildAssociationRef> ratingChildren = this.getRatingNodeChildren(targetNode, ratingSchemeName, user);
        if (ratingChildren.isEmpty()) {
            return null;
        }
        ChildAssociationRef child = ratingChildren.get(0);
        Map properties = this.nodeService.getProperties(child.getChildRef());
        Rating result = null;
        if (ratingSchemeName.equals(properties.get(ContentModel.PROP_RATING_SCHEME))) {
            Float score = (Float)properties.get(ContentModel.PROP_RATING_SCORE);
            Date date = (Date)properties.get(ContentModel.PROP_RATED_AT);
            this.nodeService.deleteNode(child.getChildRef());
            this.recalculateRatingRollups(targetNode, this.getRatingScheme(ratingSchemeName));
            result = new Rating(this.getRatingScheme(ratingSchemeName), score.floatValue(), user, date);
        }
        return result;
    }

    @Override
    @Extend(traitAPI=RatingServiceTrait.class, extensionAPI=RatingServiceExtension.class)
    public float getTotalRating(NodeRef targetNode, String ratingSchemeName) {
        NodeRef nodeRef = targetNode;
        String string = ratingSchemeName;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_6, (Object)this, (Object)this, (Object)nodeRef, (Object)string);
        RouteExtensions routeExtensions = RouteExtensions.aspectOf();
        Object[] objectArray = new Object[]{this, nodeRef, string, joinPoint};
        RatingServiceImpl$AjcClosure13 ratingServiceImpl$AjcClosure13 = new RatingServiceImpl$AjcClosure13(objectArray);
        ProceedingJoinPoint proceedingJoinPoint = ratingServiceImpl$AjcClosure13.linkClosureAndJoinPoint(69648);
        Annotation annotation = ajc$anno$6;
        if (annotation == null) {
            annotation = ajc$anno$6 = RatingServiceImpl.class.getDeclaredMethod("getTotalRating", NodeRef.class, String.class).getAnnotation(Extend.class);
        }
        return Conversions.floatValue((Object)routeExtensions.intercept(proceedingJoinPoint, (Extend)annotation));
    }

    @Override
    @Extend(traitAPI=RatingServiceTrait.class, extensionAPI=RatingServiceExtension.class)
    public float getAverageRating(NodeRef targetNode, String ratingSchemeName) {
        NodeRef nodeRef = targetNode;
        String string = ratingSchemeName;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_7, (Object)this, (Object)this, (Object)nodeRef, (Object)string);
        RouteExtensions routeExtensions = RouteExtensions.aspectOf();
        Object[] objectArray = new Object[]{this, nodeRef, string, joinPoint};
        RatingServiceImpl$AjcClosure15 ratingServiceImpl$AjcClosure15 = new RatingServiceImpl$AjcClosure15(objectArray);
        ProceedingJoinPoint proceedingJoinPoint = ratingServiceImpl$AjcClosure15.linkClosureAndJoinPoint(69648);
        Annotation annotation = ajc$anno$7;
        if (annotation == null) {
            annotation = ajc$anno$7 = RatingServiceImpl.class.getDeclaredMethod("getAverageRating", NodeRef.class, String.class).getAnnotation(Extend.class);
        }
        return Conversions.floatValue((Object)routeExtensions.intercept(proceedingJoinPoint, (Extend)annotation));
    }

    @Override
    @Extend(traitAPI=RatingServiceTrait.class, extensionAPI=RatingServiceExtension.class)
    public int getRatingsCount(NodeRef targetNode, String ratingSchemeName) {
        NodeRef nodeRef = targetNode;
        String string = ratingSchemeName;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_8, (Object)this, (Object)this, (Object)nodeRef, (Object)string);
        RouteExtensions routeExtensions = RouteExtensions.aspectOf();
        Object[] objectArray = new Object[]{this, nodeRef, string, joinPoint};
        RatingServiceImpl$AjcClosure17 ratingServiceImpl$AjcClosure17 = new RatingServiceImpl$AjcClosure17(objectArray);
        ProceedingJoinPoint proceedingJoinPoint = ratingServiceImpl$AjcClosure17.linkClosureAndJoinPoint(69648);
        Annotation annotation = ajc$anno$8;
        if (annotation == null) {
            annotation = ajc$anno$8 = RatingServiceImpl.class.getDeclaredMethod("getRatingsCount", NodeRef.class, String.class).getAnnotation(Extend.class);
        }
        return Conversions.intValue((Object)routeExtensions.intercept(proceedingJoinPoint, (Extend)annotation));
    }

    @Override
    @Extend(traitAPI=RatingServiceTrait.class, extensionAPI=RatingServiceExtension.class)
    public Serializable getRatingRollup(NodeRef targetNode, String ratingSchemeName, String ratingRollupName) {
        NodeRef nodeRef = targetNode;
        String string = ratingSchemeName;
        String string2 = ratingRollupName;
        Object[] objectArray = new Object[]{nodeRef, string, string2};
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_9, (Object)this, (Object)this, (Object[])objectArray);
        RouteExtensions routeExtensions = RouteExtensions.aspectOf();
        Object[] objectArray2 = new Object[]{this, nodeRef, string, string2, joinPoint};
        RatingServiceImpl$AjcClosure19 ratingServiceImpl$AjcClosure19 = new RatingServiceImpl$AjcClosure19(objectArray2);
        ProceedingJoinPoint proceedingJoinPoint = ratingServiceImpl$AjcClosure19.linkClosureAndJoinPoint(69648);
        Annotation annotation = ajc$anno$9;
        if (annotation == null) {
            annotation = ajc$anno$9 = RatingServiceImpl.class.getDeclaredMethod("getRatingRollup", NodeRef.class, String.class, String.class).getAnnotation(Extend.class);
        }
        return (Serializable)routeExtensions.intercept(proceedingJoinPoint, (Extend)annotation);
    }

    List<ChildAssociationRef> getRatingNodeChildren(NodeRef targetNode, String ratingSchemeName, String user) {
        QNamePattern qnamePattern = this.ratingNamingConventions.getRatingAssocPatternForUser(user, ratingSchemeName);
        List results = this.nodeService.getChildAssocs(targetNode, (QNamePattern)ContentModel.ASSOC_RATINGS, qnamePattern);
        return results;
    }

    Rating getRatingFrom(NodeRef ratingNode) {
        ChildAssociationRef parentAssoc = this.nodeService.getPrimaryParent(ratingNode);
        String appliedBy = parentAssoc.getQName().getLocalName();
        Map properties = this.nodeService.getProperties(ratingNode);
        String schemeName = (String)properties.get(ContentModel.PROP_RATING_SCHEME);
        Float score = (Float)properties.get(ContentModel.PROP_RATING_SCORE);
        Date ratedAt = (Date)properties.get(ContentModel.PROP_RATED_AT);
        RatingScheme scheme = this.getRatingScheme(schemeName);
        Rating result = new Rating(scheme, score.floatValue(), appliedBy, ratedAt);
        return result;
    }

    public <M extends Trait> ExtendedTrait<M> getTrait(Class<? extends M> traitAPI) {
        return this.ratingServiceTrait;
    }

    static final /* synthetic */ Map getRatingSchemes_aroundBody0(RatingServiceImpl ajc$this, JoinPoint joinPoint) {
        return ajc$this.schemeRegistry.getRatingSchemes();
    }

    static final /* synthetic */ RatingScheme getRatingScheme_aroundBody2(RatingServiceImpl ajc$this, String ratingSchemeName, JoinPoint joinPoint) {
        return ajc$this.schemeRegistry.getRatingSchemes().get(ratingSchemeName);
    }

    static final /* synthetic */ void applyRating_aroundBody4(RatingServiceImpl ajc$this, final NodeRef targetNode, final float rating, final String ratingSchemeName, JoinPoint joinPoint) {
        final String currentUser = AuthenticationUtil.getFullyAuthenticatedUser();
        boolean isCreator = ajc$this.isCurrentUserNodeCreator(targetNode);
        if (isCreator && !ajc$this.getRatingScheme(ratingSchemeName).isSelfRatingAllowed()) {
            throw new RatingServiceException("Users can't rate their own content for scheme " + ratingSchemeName);
        }
        AuthenticationUtil.runAs((AuthenticationUtil.RunAsWork)new AuthenticationUtil.RunAsWork<Void>(){

            public Void doWork() throws Exception {
                RatingServiceImpl.this.applyRating(targetNode, rating, ratingSchemeName, currentUser);
                return null;
            }
        }, (String)AuthenticationUtil.getSystemUserName());
    }

    static final /* synthetic */ Rating getRatingByCurrentUser_aroundBody6(RatingServiceImpl ajc$this, NodeRef targetNode, String ratingSchemeName, JoinPoint joinPoint) {
        String currentUser = AuthenticationUtil.getFullyAuthenticatedUser();
        return ajc$this.getRating(targetNode, ratingSchemeName, currentUser);
    }

    static final /* synthetic */ List getRatingsByCurrentUser_aroundBody8(RatingServiceImpl ajc$this, NodeRef targetNode, JoinPoint joinPoint) {
        String fullyAuthenticatedUser = AuthenticationUtil.getFullyAuthenticatedUser();
        List<ChildAssociationRef> children = ajc$this.getRatingNodeChildren(targetNode, null, fullyAuthenticatedUser);
        ArrayList<Rating> result = new ArrayList<Rating>(children.size());
        for (ChildAssociationRef child : children) {
            result.add(ajc$this.convertNodeRefToRating(fullyAuthenticatedUser, child.getChildRef()));
        }
        return result;
    }

    static final /* synthetic */ Rating removeRatingByCurrentUser_aroundBody10(RatingServiceImpl ajc$this, NodeRef targetNode, String ratingScheme, JoinPoint joinPoint) {
        String currentUser = AuthenticationUtil.getFullyAuthenticatedUser();
        return ajc$this.removeRating(targetNode, ratingScheme, currentUser);
    }

    static final /* synthetic */ float getTotalRating_aroundBody12(RatingServiceImpl ajc$this, NodeRef targetNode, String ratingSchemeName, JoinPoint joinPoint) {
        Serializable result = ajc$this.getRatingRollup(targetNode, ratingSchemeName, "Total");
        if (result == null) {
            result = Float.valueOf(0.0f);
        }
        return ((Float)result).floatValue();
    }

    static final /* synthetic */ float getAverageRating_aroundBody14(RatingServiceImpl ajc$this, NodeRef targetNode, String ratingSchemeName, JoinPoint joinPoint) {
        float totalRating = ajc$this.getTotalRating(targetNode, ratingSchemeName);
        int ratingCount = ajc$this.getRatingsCount(targetNode, ratingSchemeName);
        return ratingCount == 0 ? -1.0f : Float.valueOf(totalRating / (float)ratingCount).floatValue();
    }

    static final /* synthetic */ int getRatingsCount_aroundBody16(RatingServiceImpl ajc$this, NodeRef targetNode, String ratingSchemeName, JoinPoint joinPoint) {
        Serializable result = ajc$this.getRatingRollup(targetNode, ratingSchemeName, "Count");
        if (result == null) {
            result = Integer.valueOf(0);
        }
        return (Integer)result;
    }

    static final /* synthetic */ Serializable getRatingRollup_aroundBody18(RatingServiceImpl ajc$this, NodeRef targetNode, String ratingSchemeName, String ratingRollupName, JoinPoint joinPoint) {
        RatingScheme scheme = ajc$this.schemeRegistry.getRatingSchemes().get(ratingSchemeName);
        if (scheme == null) {
            throw new RatingServiceException("Cannot retrieve rollup. Unrecognized rating scheme " + ratingSchemeName);
        }
        QName rollupAspectName = ajc$this.ratingNamingConventions.getRollupAspectNameFor(scheme);
        Serializable result = null;
        if (ajc$this.nodeService.hasAspect(targetNode, rollupAspectName)) {
            QName rollupPropertyName = ajc$this.ratingNamingConventions.getRollupPropertyNameFor(scheme, ratingRollupName);
            result = ajc$this.nodeService.getProperty(targetNode, rollupPropertyName);
        }
        return result;
    }

    private static /* synthetic */ void ajc$preClinit() {
        Factory factory = new Factory("RatingServiceImpl.java", RatingServiceImpl.class);
        ajc$tjp_0 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "getRatingSchemes", "org.alfresco.repo.rating.RatingServiceImpl", "", "", "", "java.util.Map"), 110);
        ajc$tjp_1 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "getRatingScheme", "org.alfresco.repo.rating.RatingServiceImpl", "java.lang.String", "ratingSchemeName", "", "org.alfresco.service.cmr.rating.RatingScheme"), 117);
        ajc$tjp_2 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "applyRating", "org.alfresco.repo.rating.RatingServiceImpl", "org.alfresco.service.cmr.repository.NodeRef:float:java.lang.String", "targetNode:rating:ratingSchemeName", "org.alfresco.service.cmr.rating.RatingServiceException", "void"), 126);
        ajc$tjp_3 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "getRatingByCurrentUser", "org.alfresco.repo.rating.RatingServiceImpl", "org.alfresco.service.cmr.repository.NodeRef:java.lang.String", "targetNode:ratingSchemeName", "", "org.alfresco.service.cmr.rating.Rating"), 298);
        ajc$tjp_4 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "getRatingsByCurrentUser", "org.alfresco.repo.rating.RatingServiceImpl", "org.alfresco.service.cmr.repository.NodeRef", "targetNode", "", "java.util.List"), 308);
        ajc$tjp_5 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "removeRatingByCurrentUser", "org.alfresco.repo.rating.RatingServiceImpl", "org.alfresco.service.cmr.repository.NodeRef:java.lang.String", "targetNode:ratingScheme", "", "org.alfresco.service.cmr.rating.Rating"), 378);
        ajc$tjp_6 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "getTotalRating", "org.alfresco.repo.rating.RatingServiceImpl", "org.alfresco.service.cmr.repository.NodeRef:java.lang.String", "targetNode:ratingSchemeName", "", "float"), 417);
        ajc$tjp_7 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "getAverageRating", "org.alfresco.repo.rating.RatingServiceImpl", "org.alfresco.service.cmr.repository.NodeRef:java.lang.String", "targetNode:ratingSchemeName", "", "float"), 429);
        ajc$tjp_8 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "getRatingsCount", "org.alfresco.repo.rating.RatingServiceImpl", "org.alfresco.service.cmr.repository.NodeRef:java.lang.String", "targetNode:ratingSchemeName", "", "int"), 438);
        ajc$tjp_9 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "getRatingRollup", "org.alfresco.repo.rating.RatingServiceImpl", "org.alfresco.service.cmr.repository.NodeRef:java.lang.String:java.lang.String", "targetNode:ratingSchemeName:ratingRollupName", "", "java.io.Serializable"), 453);
    }
}

