/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.transfer.requisite;

import java.io.Writer;
import org.alfresco.repo.transfer.requisite.TransferRequsiteWriter;
import org.alfresco.service.cmr.repository.NodeRef;
import org.alfresco.service.namespace.QName;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.dom4j.io.OutputFormat;
import org.dom4j.io.XMLWriter;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.AttributesImpl;

public class XMLTransferRequsiteWriter
implements TransferRequsiteWriter {
    private static final Log log = LogFactory.getLog(XMLTransferRequsiteWriter.class);
    private XMLWriter writer;
    final AttributesImpl EMPTY_ATTRIBUTES = new AttributesImpl();
    final String PREFIX = "xferr";

    public XMLTransferRequsiteWriter(Writer out) {
        OutputFormat format = OutputFormat.createPrettyPrint();
        format.setNewLineAfterDeclaration(false);
        format.setIndentSize(3);
        format.setEncoding("UTF-8");
        this.writer = new XMLWriter(out, format);
    }

    @Override
    public void startTransferRequsite() {
        try {
            this.writer.startDocument();
            this.writer.startPrefixMapping("xferr", "http://www.alfresco.org/model/transfer/1.0");
            this.writer.startPrefixMapping("cm", "http://www.alfresco.org/model/content/1.0");
            this.writer.startElement("http://www.alfresco.org/model/transfer/1.0", "transferRequsite", "xferr:transferRequsite", (Attributes)this.EMPTY_ATTRIBUTES);
        }
        catch (SAXException se) {
            log.debug((Object)"error", (Throwable)se);
        }
    }

    @Override
    public void endTransferRequsite() {
        try {
            this.writer.endElement("http://www.alfresco.org/model/transfer/1.0", "transferRequsite", "xferr:transferRequsite");
            this.writer.endPrefixMapping("xferr");
            this.writer.endDocument();
        }
        catch (SAXException se) {
            log.debug((Object)"error", (Throwable)se);
        }
    }

    @Override
    public void missingContent(NodeRef node, QName qname, String name) {
        log.debug((Object)"write missing content");
        try {
            AttributesImpl attributes = new AttributesImpl();
            attributes.addAttribute("uri", "nodeRef", "nodeRef", "String", node.toString());
            attributes.addAttribute("uri", "qname", "qname", "String", qname.toString());
            attributes.addAttribute("uri", "name", "name", "String", name.toString());
            this.writer.startElement("http://www.alfresco.org/model/transfer/1.0", "requiredContent", "xferr:requiredContent", (Attributes)attributes);
            this.writer.endElement("http://www.alfresco.org/model/transfer/1.0", "requiredContent", "xferr:requiredContent");
        }
        catch (SAXException se) {
            log.debug((Object)"error", (Throwable)se);
        }
    }
}

