/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.heartbeat.jobs;

import java.util.List;
import org.alfresco.heartbeat.HBBaseDataCollector;
import org.alfresco.heartbeat.datasender.HBData;
import org.alfresco.heartbeat.datasender.HBDataSenderService;
import org.alfresco.util.ParameterCheck;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.quartz.Job;
import org.quartz.JobDataMap;
import org.quartz.JobExecutionContext;
import org.quartz.JobExecutionException;

public class NonLockingJob
implements Job {
    private static final Log logger = LogFactory.getLog(NonLockingJob.class);
    public static final String COLLECTOR_KEY = "collector";
    public static final String DATA_SENDER_SERVICE_KEY = "hbDataSenderService";

    public void execute(JobExecutionContext jobExecutionContext) throws JobExecutionException {
        JobDataMap dataMap = jobExecutionContext.getJobDetail().getJobDataMap();
        HBBaseDataCollector collector = (HBBaseDataCollector)dataMap.get((Object)COLLECTOR_KEY);
        HBDataSenderService hbDataSenderService = (HBDataSenderService)dataMap.get((Object)DATA_SENDER_SERVICE_KEY);
        ParameterCheck.mandatory((String)COLLECTOR_KEY, (Object)collector);
        ParameterCheck.mandatory((String)DATA_SENDER_SERVICE_KEY, (Object)hbDataSenderService);
        try {
            List<HBData> data = collector.collectData();
            hbDataSenderService.sendData(data);
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("Finished collector job. ID:" + collector.getCollectorId()));
            }
        }
        catch (Exception e) {
            logger.error((Object)("Heartbeat failed to collect data for collector ID: " + collector.getCollectorId()), (Throwable)e);
        }
    }
}

