/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.content.filestore;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import org.alfresco.model.ContentModel;
import org.alfresco.repo.content.ContentStore;
import org.alfresco.repo.content.cleanup.ContentStoreCleaner;
import org.alfresco.repo.content.cleanup.ContentStoreCleanerListener;
import org.alfresco.repo.content.cleanup.EagerContentStoreCleaner;
import org.alfresco.repo.content.filestore.FileContentStore;
import org.alfresco.repo.domain.contentdata.ContentDataDAO;
import org.alfresco.repo.lock.JobLockService;
import org.alfresco.repo.security.authentication.AuthenticationUtil;
import org.alfresco.repo.transaction.RetryingTransactionHelper;
import org.alfresco.service.ServiceRegistry;
import org.alfresco.service.cmr.dictionary.DictionaryService;
import org.alfresco.service.cmr.repository.ContentData;
import org.alfresco.service.cmr.repository.ContentIOException;
import org.alfresco.service.cmr.repository.ContentService;
import org.alfresco.service.cmr.repository.ContentWriter;
import org.alfresco.service.cmr.repository.NodeRef;
import org.alfresco.service.cmr.repository.NodeService;
import org.alfresco.service.cmr.repository.StoreRef;
import org.alfresco.service.namespace.QName;
import org.alfresco.service.transaction.TransactionService;
import org.alfresco.util.ApplicationContextHelper;
import org.alfresco.util.GUID;
import org.springframework.context.ApplicationContext;

public class DeletionMetricsRunner {
    private ApplicationContext ctx = ApplicationContextHelper.getApplicationContext();
    private ContentService contentService;
    private NodeService nodeService;
    private TransactionService transactionService;
    private JobLockService jobLockService;
    private ContentStoreCleaner cleaner;
    private EagerContentStoreCleaner eagerCleaner;
    private FileContentStore store;
    private ContentStoreCleanerListener listener;
    private int deletedUrls;
    private final int numOrphans = 1000;

    public DeletionMetricsRunner() {
        ServiceRegistry serviceRegistry = (ServiceRegistry)this.ctx.getBean("ServiceRegistry");
        this.contentService = serviceRegistry.getContentService();
        this.nodeService = serviceRegistry.getNodeService();
        this.transactionService = serviceRegistry.getTransactionService();
        this.jobLockService = serviceRegistry.getJobLockService();
        TransactionService transactionService = serviceRegistry.getTransactionService();
        DictionaryService dictionaryService = serviceRegistry.getDictionaryService();
        ContentDataDAO contentDataDAO = (ContentDataDAO)this.ctx.getBean("contentDataDAO");
        this.store = (FileContentStore)this.ctx.getBean("fileContentStore");
        ArrayList<ContentStoreCleanerListener> listeners = new ArrayList<ContentStoreCleanerListener>(2);
        this.listener = new CleanerListener();
        listeners.add(this.listener);
        this.eagerCleaner = (EagerContentStoreCleaner)this.ctx.getBean("eagerContentStoreCleaner");
        this.eagerCleaner.setEagerOrphanCleanup(false);
        this.eagerCleaner.setStores(Collections.singletonList(this.store));
        this.eagerCleaner.setListeners(listeners);
        this.cleaner = new ContentStoreCleaner();
        this.cleaner.setEagerContentStoreCleaner(this.eagerCleaner);
        this.cleaner.setJobLockService(this.jobLockService);
        this.cleaner.setContentDataDAO(contentDataDAO);
        this.cleaner.setTransactionService(transactionService);
        this.cleaner.setDictionaryService(dictionaryService);
        this.cleaner.setContentService(this.contentService);
    }

    public static void main(String[] args) {
        DeletionMetricsRunner metrics = new DeletionMetricsRunner();
        metrics.run();
    }

    public void run() {
        this.setUp(true);
        this.time("Deleting empty parent dirs");
        this.tearDown();
        this.setUp(false);
        this.time("Ignoring empty parent dirs");
        this.tearDown();
    }

    private void setUp(boolean deleteEmptyDirs) {
        AuthenticationUtil.setRunAsUserSystem();
        this.store.setDeleteEmptyDirs(deleteEmptyDirs);
        this.deletedUrls = 0;
    }

    private void tearDown() {
        AuthenticationUtil.clearCurrentSecurityContext();
        System.out.println("Deleted " + this.deletedUrls + " URLs.");
    }

    private void time(String description) {
        long beforeClean = System.currentTimeMillis();
        this.createContent();
        this.cleanContent();
        long afterClean = System.currentTimeMillis();
        double timeTaken = afterClean - beforeClean;
        System.out.println();
        System.out.println(String.format("%s took %6.0fms", description, timeTaken));
    }

    private void createContent() {
        final StoreRef storeRef = this.nodeService.createStore("test", "timings-" + GUID.generate());
        RetryingTransactionHelper.RetryingTransactionCallback<ContentData> testCallback = new RetryingTransactionHelper.RetryingTransactionCallback<ContentData>(){

            @Override
            public ContentData execute() throws Throwable {
                ContentData contentData = null;
                int i = 0;
                while (i < 1000) {
                    NodeRef rootNodeRef = DeletionMetricsRunner.this.nodeService.getRootNode(storeRef);
                    HashMap<QName, String> properties = new HashMap<QName, String>(13);
                    properties.put(ContentModel.PROP_NAME, "test.txt");
                    NodeRef contentNodeRef = DeletionMetricsRunner.this.nodeService.createNode(rootNodeRef, ContentModel.ASSOC_CHILDREN, ContentModel.ASSOC_CHILDREN, ContentModel.TYPE_CONTENT, properties).getChildRef();
                    ContentWriter writer = DeletionMetricsRunner.this.contentService.getWriter(contentNodeRef, ContentModel.PROP_CONTENT, true);
                    writer.setMimetype("text/plain");
                    writer.putContent("INITIAL CONTENT");
                    contentData = writer.getContentData();
                    DeletionMetricsRunner.this.nodeService.addAspect(contentNodeRef, ContentModel.ASPECT_TEMPORARY, null);
                    DeletionMetricsRunner.this.nodeService.deleteNode(contentNodeRef);
                    ++i;
                }
                return contentData;
            }
        };
        this.transactionService.getRetryingTransactionHelper().doInTransaction(testCallback);
    }

    private void cleanContent() {
        this.cleaner.setProtectDays(0);
        this.cleaner.execute();
        if (this.deletedUrls < 1000) {
            throw new IllegalStateException("Not all the orphans were cleaned.");
        }
    }

    private class CleanerListener
    implements ContentStoreCleanerListener {
        private CleanerListener() {
        }

        @Override
        public void beforeDelete(ContentStore store, String contentUrl) throws ContentIOException {
            ++DeletionMetricsRunner.this.deletedUrls;
        }
    }
}

