/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.virtual.bundle;

import org.alfresco.model.ContentModel;
import org.alfresco.repo.lock.mem.Lifetime;
import org.alfresco.repo.virtual.VirtualizationIntegrationTest;
import org.alfresco.service.cmr.lock.LockService;
import org.alfresco.service.cmr.lock.LockType;
import org.alfresco.service.cmr.repository.NodeRef;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class VirtualLockableAspectInterceptorExtensionTest
extends VirtualizationIntegrationTest {
    private LockService lockService;
    private NodeRef originalContentNodeRef;

    @Override
    @Before
    public void setUp() throws Exception {
        super.setUp();
        this.lockService = (LockService)this.ctx.getBean("lockService", LockService.class);
        NodeRef node = this.nodeService.getChildByName(this.virtualFolder1NodeRef, ContentModel.ASSOC_CONTAINS, "Node1");
        this.originalContentNodeRef = this.createContent(node, "originalContentName", "0", "text/plain", "UTF-8").getChildRef();
    }

    @Test
    public void testHasLockableAspect() throws Exception {
        Assert.assertFalse((String)"Node should not be reported as lockable", (boolean)this.nodeService.hasAspect(this.originalContentNodeRef, ContentModel.ASPECT_LOCKABLE));
        this.lockService.lock(this.originalContentNodeRef, LockType.WRITE_LOCK, 10, Lifetime.EPHEMERAL, null);
        Assert.assertTrue((String)"Node should be reported as lockable", (boolean)this.nodeService.hasAspect(this.originalContentNodeRef, ContentModel.ASPECT_LOCKABLE));
    }

    @Test
    public void testGetAspectsHasLockableAspect() throws Exception {
        Assert.assertFalse((String)"Node should not contain lockable aspect", (boolean)this.nodeService.getAspects(this.originalContentNodeRef).contains(ContentModel.ASPECT_LOCKABLE));
        this.lockService.lock(this.originalContentNodeRef, LockType.WRITE_LOCK, 10, Lifetime.EPHEMERAL, null);
        Assert.assertTrue((String)"Node should contain lockable aspect", (boolean)this.nodeService.getAspects(this.originalContentNodeRef).contains(ContentModel.ASPECT_LOCKABLE));
    }
}

