/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.util;

import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.alfresco.repo.tenant.TenantUtil;
import org.alfresco.service.cmr.dictionary.DictionaryService;
import org.alfresco.service.cmr.repository.NodeRef;
import org.alfresco.service.cmr.repository.NodeService;
import org.alfresco.service.namespace.QName;

public class TypeConstraint {
    public static final String WILDCARD = "*";
    private Set<String> expectedModels;
    private Set<QName> expectedQNames;
    private List<String> expectedTypes;
    private Set<QName> excludedQNames;
    private Set<String> excludedModels;
    private List<String> excludedTypes;
    private NodeService nodeService;
    private DictionaryService dictionaryService;

    public void setExpectedTypes(List<String> expectedTypes) {
        this.expectedTypes = expectedTypes;
    }

    public void setNodeService(NodeService nodeService) {
        this.nodeService = nodeService;
    }

    public void setDictionaryService(DictionaryService dictionaryService) {
        this.dictionaryService = dictionaryService;
    }

    public void setExcludedTypes(List<String> excludedTypes) {
        this.excludedTypes = excludedTypes;
    }

    public void init() {
        if (this.expectedTypes != null && !this.expectedTypes.isEmpty()) {
            this.preprocessExpectedTypes(this.expectedTypes);
        }
        if (this.excludedTypes != null && !this.excludedTypes.isEmpty()) {
            this.preprocessExcludedTypes(this.excludedTypes);
        }
    }

    protected void preprocessExcludedTypes(List<String> typeNames) {
        HashSet<QName> qNamesToExclude = new HashSet<QName>(typeNames.size());
        HashSet<String> modelsToExclude = new HashSet<String>();
        for (String typeDefinition : typeNames) {
            QName typeDef = QName.createQName((String)typeDefinition);
            if (WILDCARD.equals(typeDef.getLocalName())) {
                modelsToExclude.add(typeDef.getNamespaceURI());
                continue;
            }
            qNamesToExclude.add(typeDef);
        }
        this.excludedModels = modelsToExclude;
        this.excludedQNames = qNamesToExclude;
    }

    protected void preprocessExpectedTypes(List<String> typeNames) {
        HashSet<QName> qNames = new HashSet<QName>(typeNames.size());
        HashSet<String> models = new HashSet<String>();
        for (String typeDefinition : typeNames) {
            QName typeDef = QName.createQName((String)typeDefinition);
            if (WILDCARD.equals(typeDef.getLocalName())) {
                models.add(typeDef.getNamespaceURI());
                continue;
            }
            qNames.add(typeDef);
        }
        this.expectedModels = models;
        this.expectedQNames = qNames;
    }

    private boolean isExcluded(QName typeQName) {
        return this.excludedQNames != null && this.excludedQNames.contains(typeQName) || this.excludedModels != null && this.excludedModels.contains(typeQName.getNamespaceURI());
    }

    private boolean matchesExpected(QName typeQName) {
        if (this.expectedQNames == null || this.expectedQNames.contains(typeQName) || this.expectedModels == null || this.expectedModels.contains(typeQName.getNamespaceURI())) {
            return true;
        }
        for (QName expectedQName : this.expectedQNames) {
            if (!this.dictionaryService.isSubClass(typeQName, expectedQName)) continue;
            return true;
        }
        return false;
    }

    public boolean matches(final NodeRef nodeRef) {
        boolean matches = (Boolean)TenantUtil.runAsSystemTenant((TenantUtil.TenantRunAsWork)new TenantUtil.TenantRunAsWork<Boolean>(){

            public Boolean doWork() throws Exception {
                boolean matches = true;
                QName nodeType = TypeConstraint.this.nodeService.getType(nodeRef);
                boolean typeExcluded = TypeConstraint.this.isExcluded(nodeType);
                if (typeExcluded) {
                    matches = false;
                } else {
                    boolean isExpected = TypeConstraint.this.matchesExpected(nodeType);
                    if (isExpected) {
                        Set aspects = TypeConstraint.this.nodeService.getAspects(nodeRef);
                        for (QName aspect : aspects) {
                            if (!TypeConstraint.this.isExcluded(aspect)) continue;
                            matches = false;
                            break;
                        }
                    } else {
                        Set aspects = TypeConstraint.this.nodeService.getAspects(nodeRef);
                        for (QName aspect : aspects) {
                            if (TypeConstraint.this.isExcluded(aspect)) {
                                matches = false;
                                break;
                            }
                            if (!TypeConstraint.this.matchesExpected(aspect)) continue;
                            isExpected = true;
                        }
                        if (!isExpected) {
                            matches = false;
                        }
                    }
                }
                return matches;
            }
        }, (String)TenantUtil.getCurrentDomain());
        return matches;
    }
}

