/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.security.authentication;

import java.io.IOException;
import java.net.InetAddress;
import java.net.Socket;
import java.net.UnknownHostException;
import java.security.KeyManagementException;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import javax.net.SocketFactory;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLSocketFactory;
import javax.net.ssl.TrustManagerFactory;
import org.alfresco.error.AlfrescoRuntimeException;

public class AlfrescoSSLSocketFactory
extends SSLSocketFactory {
    private static SSLContext context;

    public static synchronized void initTrustedSSLSocketFactory(KeyStore trustStore) {
        try {
            TrustManagerFactory trustManagerFactory = TrustManagerFactory.getInstance("SunX509");
            trustManagerFactory.init(trustStore);
            context = SSLContext.getInstance("SSL");
            context.init(null, trustManagerFactory.getTrustManagers(), SecureRandom.getInstance("SHA1PRNG"));
        }
        catch (NoSuchAlgorithmException nsae) {
            throw new AlfrescoRuntimeException("The SSL socket factory cannot be initialized.", (Throwable)nsae);
        }
        catch (KeyStoreException kse) {
            throw new AlfrescoRuntimeException("The SSL socket factory cannot be initialized.", (Throwable)kse);
        }
        catch (KeyManagementException kme) {
            throw new AlfrescoRuntimeException("The SSL socket factory cannot be initialized.", (Throwable)kme);
        }
    }

    public static synchronized SocketFactory getDefault() {
        if (context == null) {
            throw new AlfrescoRuntimeException("The factory was not initialized.");
        }
        return new AlfrescoSSLSocketFactory();
    }

    @Override
    public String[] getDefaultCipherSuites() {
        return context.getSocketFactory().getDefaultCipherSuites();
    }

    @Override
    public String[] getSupportedCipherSuites() {
        return context.getSocketFactory().getSupportedCipherSuites();
    }

    @Override
    public Socket createSocket(Socket socket, String s, int i, boolean b) throws IOException {
        return context.getSocketFactory().createSocket(socket, s, i, b);
    }

    @Override
    public Socket createSocket(String s, int i) throws IOException, UnknownHostException {
        return context.getSocketFactory().createSocket(s, i);
    }

    @Override
    public Socket createSocket(String s, int i, InetAddress inetAddress, int i2) throws IOException, UnknownHostException {
        return context.getSocketFactory().createSocket(s, i, inetAddress, i2);
    }

    @Override
    public Socket createSocket(InetAddress inetAddress, int i) throws IOException {
        return context.getSocketFactory().createSocket(inetAddress, i);
    }

    @Override
    public Socket createSocket(InetAddress inetAddress, int i, InetAddress inetAddress2, int i2) throws IOException {
        return context.getSocketFactory().createSocket(inetAddress, i, inetAddress2, i2);
    }
}

