/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.tenant;

import java.sql.SQLException;
import java.util.HashMap;
import java.util.Map;
import javax.sql.DataSource;
import org.alfresco.repo.security.authentication.AuthenticationUtil;
import org.alfresco.repo.tenant.TenantBasicDataSource;
import org.alfresco.repo.tenant.TenantService;
import org.apache.commons.dbcp2.BasicDataSource;
import org.springframework.extensions.surf.util.ParameterCheck;
import org.springframework.jdbc.datasource.lookup.AbstractRoutingDataSource;

public class TenantRoutingDataSource
extends AbstractRoutingDataSource {
    Map<String, DataSource> tenantDataSources = new HashMap<String, DataSource>();
    private BasicDataSource baseDataSource;
    private TenantService tenantService;

    public void setTenantService(TenantService tenantService) {
        this.tenantService = tenantService;
    }

    public void setBaseDataSource(BasicDataSource baseDataSource) {
        this.baseDataSource = baseDataSource;
    }

    protected Object determineCurrentLookupKey() {
        String[] parts;
        String runAsUser = AuthenticationUtil.getRunAsUser();
        String tenantDomain = "";
        if (runAsUser != null && (parts = runAsUser.split("@")).length == 2) {
            tenantDomain = parts[1];
        }
        return tenantDomain;
    }

    public void afterPropertiesSet() {
        ParameterCheck.mandatory((String)"baseDataSource", (Object)this.baseDataSource);
        ParameterCheck.mandatory((String)"tenantDataSources", this.tenantDataSources);
        String dbUrl = this.baseDataSource.getUrl();
        this.setTargetDataSources(this.tenantDataSources);
        try {
            TenantBasicDataSource defaultTargetDataSource = new TenantBasicDataSource(this.baseDataSource, dbUrl, -1);
            this.tenantDataSources.put("", (DataSource)((Object)defaultTargetDataSource));
            this.setDefaultTargetDataSource((Object)defaultTargetDataSource);
        }
        catch (SQLException se) {
            throw new RuntimeException(se);
        }
        super.afterPropertiesSet();
    }

    public synchronized void addTenantDataSource(String tenantDomain, String dbUrl) throws SQLException {
        String currentTenantDomain = this.tenantService.getCurrentUserDomain();
        if (!"".equals(currentTenantDomain)) {
            throw new RuntimeException("Unexpected - should not be in context of a tenant [" + currentTenantDomain + "]");
        }
        this.tenantDataSources.put(tenantDomain, (DataSource)((Object)new TenantBasicDataSource(this.baseDataSource, dbUrl, -1)));
        super.afterPropertiesSet();
    }

    public synchronized void removeTenantDataSource(String tenantDomain) throws SQLException {
        String currentTenantDomain = this.tenantService.getCurrentUserDomain();
        if (!"".equals(currentTenantDomain)) {
            throw new RuntimeException("Unexpected - should not be in context of a tenant [" + currentTenantDomain + "]");
        }
        this.tenantDataSources.remove(tenantDomain);
        super.afterPropertiesSet();
    }
}

