/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.content.transform;

import java.util.ArrayDeque;
import java.util.Collection;
import java.util.Deque;
import java.util.Iterator;
import java.util.Map;
import java.util.StringJoiner;
import java.util.concurrent.atomic.AtomicInteger;
import org.alfresco.model.ContentModel;
import org.alfresco.repo.content.transform.TransformerLog;
import org.alfresco.service.cmr.repository.MimetypeService;
import org.alfresco.service.cmr.repository.NodeRef;
import org.alfresco.service.cmr.repository.NodeService;
import org.alfresco.util.LogTee;
import org.alfresco.util.PropertyCheck;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class TransformerDebug {
    public static final String TIMEOUT = "timeout";
    public static final String SOURCE_ENCODING = "sourceEncoding";
    public static final String SOURCE_NODE_REF = "sourceNodeRef";
    public static final String TARGET_ENCODING = "targetEncoding";
    public static final String TRANSFORM_NAMESPACE = "transform:";
    public static final String MIMETYPE_METADATA_EXTRACT = "alfresco-metadata-extract";
    public static final String MIMETYPE_METADATA_EMBED = "alfresco-metadata-embed";
    protected static final String FINISHED_IN = "Finished in ";
    protected static final String NO_TRANSFORMERS = "No transformers";
    protected static final String TRANSFORM_SERVICE_NAME = "TransformService";
    private static final int REFERENCE_SIZE = 15;
    protected ExtensionLookup extensionLookup;
    private Log singleLineLog;
    protected Log multiLineLog;
    protected NodeService nodeService;
    protected MimetypeService mimetypeService;
    private final ThreadLocal<Integer> previousTransformId = ThreadLocal.withInitial(() -> -1);

    public void setExtensionLookup(ExtensionLookup extensionLookup) {
        this.extensionLookup = extensionLookup;
    }

    public void setTransformerLog(Log transformerLog) {
        this.singleLineLog = new LogTee(LogFactory.getLog(TransformerLog.class), transformerLog);
    }

    public void setTransformerDebugLog(Log transformerDebugLog) {
        this.multiLineLog = new LogTee(LogFactory.getLog(TransformerDebug.class), transformerDebugLog);
    }

    public void setNodeService(NodeService nodeService) {
        this.nodeService = nodeService;
    }

    public void setMimetypeService(MimetypeService mimetypeService) {
        this.mimetypeService = mimetypeService;
        this.setExtensionLookup(mimetype -> mimetypeService.getExtension(mimetype));
    }

    public void setPreviousTransformId(int id) {
        this.previousTransformId.set(id);
    }

    private int getPreviousTransformId() {
        return this.previousTransformId.get();
    }

    public void afterPropertiesSet() throws Exception {
        PropertyCheck.mandatory((Object)this, (String)"nodeService", (Object)this.nodeService);
        PropertyCheck.mandatory((Object)this, (String)"mimetypeService", (Object)this.mimetypeService);
        PropertyCheck.mandatory((Object)this, (String)"transformerLog", (Object)this.singleLineLog);
        PropertyCheck.mandatory((Object)this, (String)"transformerDebugLog", (Object)this.multiLineLog);
    }

    public void pushTransform(String transformerName, String fromUrl, String sourceMimetype, String targetMimetype, long sourceSize, Map<String, String> options, String renditionName, NodeRef sourceNodeRef) {
        if (this.isEnabled()) {
            this.push(transformerName, fromUrl, sourceMimetype, targetMimetype, sourceSize, options, renditionName, sourceNodeRef, Call.TRANSFORM);
        }
    }

    public void pushMisc() {
        if (this.isEnabled()) {
            this.push(null, null, null, null, -1L, null, null, null, Call.AVAILABLE);
        }
    }

    void push(String transformerName, String fromUrl, String sourceMimetype, String targetMimetype, long sourceSize, Map<String, String> options, String renditionName, NodeRef sourceNodeRef, Call callType) {
        Deque<Frame> ourStack = ThreadInfo.getStack();
        Frame frame = ourStack.peek();
        if (callType == Call.TRANSFORM && frame != null && frame.callType == Call.AVAILABLE) {
            frame.setTransformerName(transformerName);
            frame.setSourceSize(sourceSize);
            frame.callType = Call.AVAILABLE_AND_TRANSFORM;
        }
        boolean origDebugOutput = ThreadInfo.setDebugOutput(ThreadInfo.getDebugOutput() && sourceSize != 0L);
        frame = new Frame(frame, transformerName, fromUrl, sourceMimetype, targetMimetype, sourceSize, renditionName, sourceNodeRef, callType, origDebugOutput);
        ourStack.push(frame);
        if (callType == Call.TRANSFORM) {
            this.logBasicDetails(frame, sourceSize, options, renditionName, transformerName, ourStack.size() == 1);
        }
    }

    protected void logBasicDetails(Frame frame, long sourceSize, Map<String, String> options, String renditionName, String message, boolean firstLevel) {
        if (frame.fromUrl != null && (firstLevel || frame.id != 1)) {
            this.log(frame.fromUrl, false);
        }
        this.log(frame.sourceMimetype + " " + frame.targetMimetype, false);
        String filename = this.getFilename(frame.sourceNodeRef, firstLevel);
        this.log(this.getSourceAndTargetExt(frame.sourceMimetype, frame.targetMimetype) + (String)(filename != null ? filename + " " : "") + (String)(sourceSize >= 0L ? this.fileSize(sourceSize) + " " : "") + (firstLevel ? this.getRenditionName(renditionName) : "") + message);
        if (firstLevel) {
            this.log(options);
            String nodeRef = this.getNodeRef(frame.sourceNodeRef);
            if (!nodeRef.isEmpty()) {
                this.log(nodeRef);
            }
        }
    }

    private void log(Map<String, String> options) {
        if (options != null) {
            for (Map.Entry<String, String> option : options.entrySet()) {
                String key = option.getKey();
                if (TIMEOUT.equals(key)) continue;
                Object value = option.getValue();
                value = value != null ? "=\"" + ((String)value).replaceAll("\"", "\\\"") + "\"" : "=null" + (SOURCE_NODE_REF.equals(key) || SOURCE_ENCODING.equals(key) || TARGET_ENCODING.equals(key) ? " - set automatically" : "");
                this.log("  " + key + (String)value);
            }
        }
    }

    public void popTransform() {
        if (this.isEnabled()) {
            this.pop(Call.TRANSFORM, false, false);
        }
    }

    public void popMisc() {
        if (this.isEnabled()) {
            this.pop(Call.AVAILABLE, ThreadInfo.getStack().size() > 1, false);
        }
    }

    protected int pop(Call callType, boolean suppressFinish, boolean suppressChecking) {
        int id = -1;
        Deque<Frame> ourStack = ThreadInfo.getStack();
        if (!ourStack.isEmpty()) {
            Frame frame = ourStack.peek();
            id = frame.getId();
            if (frame.callType == callType || frame.callType == Call.AVAILABLE_AND_TRANSFORM && callType == Call.AVAILABLE) {
                boolean firstLevel;
                int size = ourStack.size();
                String ms = this.ms(System.currentTimeMillis() - frame.start);
                this.logInfo(frame, size, ms);
                boolean bl = firstLevel = size == 1;
                if (!suppressFinish && (firstLevel || this.multiLineLog.isTraceEnabled())) {
                    this.log(FINISHED_IN + ms + (frame.callType == Call.AVAILABLE && !suppressChecking ? " Just checking if a transformer is available" : "") + (firstLevel ? "\n" : ""), firstLevel);
                }
                TransformerDebug.setDebugOutput(frame.origDebugOutput);
                ourStack.pop();
            }
        }
        this.setPreviousTransformId(id);
        return id;
    }

    private void logInfo(Frame frame, int size, String ms) {
        if (this.singleLineLog.isDebugEnabled()) {
            String failureReason = frame.getFailureReason();
            boolean firstLevel = size == 1;
            String sourceAndTargetExt = this.getSourceAndTargetExt(frame.sourceMimetype, frame.targetMimetype);
            String filename = this.getFilename(frame.sourceNodeRef, firstLevel);
            long sourceSize = frame.getSourceSize();
            String transformerName = frame.getTransformerName();
            String renditionName = frame.getRenditionName();
            String level = null;
            boolean debug = false;
            if (NO_TRANSFORMERS.equals(failureReason)) {
                debug = firstLevel;
                level = "INFO";
                failureReason = NO_TRANSFORMERS;
            } else if (frame.callType == Call.TRANSFORM) {
                level = failureReason == null || failureReason.length() == 0 ? "INFO" : "ERROR";
                boolean bl = debug = size == 1 || size == 2 && ThreadInfo.getStack().peekLast().callType != Call.TRANSFORM;
            }
            if (level != null) {
                this.infoLog(this.getReference(firstLevel, false, false), sourceAndTargetExt, level, filename, sourceSize, transformerName, renditionName, failureReason, ms, debug);
            }
        }
    }

    private void infoLog(String reference, String sourceAndTargetExt, String level, String filename, long sourceSize, String transformerName, String renditionName, String failureReason, String ms, boolean debug) {
        String message = reference + sourceAndTargetExt + (String)(level == null ? "" : level + " ") + (filename == null ? "" : filename) + (String)(sourceSize >= 0L ? " " + this.fileSize(sourceSize) : "") + (String)(ms == null || ms.isEmpty() ? "" : " " + ms) + (String)(transformerName == null ? "" : " " + transformerName) + (String)(renditionName == null ? "" : " " + this.getRenditionName(renditionName)) + (String)(failureReason == null ? "" : " " + failureReason.trim());
        if (debug) {
            this.singleLineLog.debug((Object)message);
        } else {
            this.singleLineLog.trace((Object)message);
        }
    }

    public boolean isEnabled() {
        return this.multiLineLog.isDebugEnabled() || this.singleLineLog.isDebugEnabled() || ThreadInfo.getStringBuilder() != null;
    }

    public static boolean setDebugOutput(boolean debugOutput) {
        return ThreadInfo.setDebugOutput(debugOutput);
    }

    public void debug(String message) {
        if (this.isEnabled() && message != null) {
            this.log(message);
        }
    }

    public void debugUsingPreviousReference(String message) {
        if (this.isEnabled() && message != null) {
            this.log(message, null, true, true);
        }
    }

    public void debug(String message, Throwable t) {
        if (this.isEnabled()) {
            String msg = t.getMessage();
            if (msg != null) {
                int i = msg.indexOf(": \n");
                if (i != -1) {
                    msg = msg.substring(0, i);
                }
                this.log(message + " " + msg);
            } else {
                this.log(message);
            }
            Deque<Frame> ourStack = ThreadInfo.getStack();
            if (!ourStack.isEmpty()) {
                Frame frame = ourStack.peek();
                frame.setFailureReason(message + " " + this.getRootCauseMessage(t));
            }
        }
    }

    private String getRootCauseMessage(Throwable t) {
        Throwable cause = t;
        while (cause != null) {
            t = cause;
            cause = t.getCause();
        }
        String message = t.getMessage();
        if (message == null || message.length() == 0) {
            message = t.getClass().getSimpleName();
        }
        return message;
    }

    protected void log(String message) {
        this.log(message, true);
    }

    protected void log(String message, boolean debug) {
        this.log(message, null, debug);
    }

    private void log(String message, Throwable t, boolean debug) {
        this.log(message, t, debug, false);
    }

    private void log(String message, Throwable t, boolean debug, boolean usePreviousRef) {
        StringBuilder sb;
        if (debug && ThreadInfo.getDebugOutput() && this.multiLineLog.isDebugEnabled()) {
            this.multiLineLog.debug((Object)(this.getReference(false, false, usePreviousRef) + message), t);
        } else if (this.multiLineLog.isTraceEnabled()) {
            this.multiLineLog.trace((Object)(this.getReference(false, false, usePreviousRef) + message), t);
        }
        if (debug && (sb = ThreadInfo.getStringBuilder()) != null) {
            sb.append(this.getReference(false, true, usePreviousRef));
            sb.append(message);
            if (t != null) {
                sb.append(t.getMessage());
            }
            sb.append('\n');
        }
    }

    public <T extends Throwable> T setCause(T t) {
        return t;
    }

    public StringBuilder getStringBuilder() {
        return ThreadInfo.getStringBuilder();
    }

    public void setStringBuilder(StringBuilder sb) {
        ThreadInfo.setStringBuilder(sb);
    }

    private String getReference(boolean firstLevelOnly, boolean overrideFirstLevel, boolean usePreviousRef) {
        if (usePreviousRef) {
            int id = this.getPreviousTransformId();
            Object ref = "";
            if (id >= 0) {
                ref = Integer.toString(id) + this.spaces(15);
            }
            return ref;
        }
        StringBuilder sb = new StringBuilder("");
        Frame frame = null;
        Iterator<Frame> iterator = ThreadInfo.getStack().descendingIterator();
        int lengthOfFirstId = 0;
        boolean firstLevel = true;
        while (iterator.hasNext()) {
            frame = iterator.next();
            if (firstLevel) {
                if (!overrideFirstLevel) {
                    sb.append(frame.getId());
                } else {
                    sb.append("1");
                }
                lengthOfFirstId = sb.length();
                if (firstLevelOnly) {
                    break;
                }
            } else {
                if (sb.length() != 0) {
                    sb.append('.');
                }
                sb.append(frame.getId());
            }
            firstLevel = false;
        }
        if (frame != null) {
            if (firstLevelOnly) {
                sb.append(' ');
            } else {
                sb.append(this.spaces(15 - sb.length() + lengthOfFirstId));
            }
        }
        return sb.toString();
    }

    public String getFilename(NodeRef sourceNodeRef, boolean firstLevel) {
        String result = null;
        if (sourceNodeRef != null) {
            try {
                result = (String)((Object)this.nodeService.getProperty(sourceNodeRef, ContentModel.PROP_NAME));
            }
            catch (RuntimeException runtimeException) {}
        }
        if (result == null && !firstLevel) {
            result = "<<TemporaryFile>>";
        }
        return result;
    }

    private String getNodeRef(NodeRef sourceNodeRef) {
        return sourceNodeRef == null ? "" : sourceNodeRef.toString();
    }

    protected String getSourceAndTargetExt(String sourceMimetype, String targetMimetype) {
        String sourceExt = this.getMimetypeExt(sourceMimetype);
        String targetExt = this.getMimetypeExt(targetMimetype);
        targetExt = TransformerDebug.replaceWithMetadataExtensionIfEmbedOrExtract(targetMimetype, sourceExt, targetExt);
        return sourceExt + targetExt + this.spaces(5 - targetExt.length());
    }

    public static String replaceWithMetadataExtensionIfEmbedOrExtract(String targetMimetype, String sourceExtension, String targetExtension) {
        return TransformerDebug.isMetadataExtractMimetype(targetMimetype) ? "json" : (TransformerDebug.isMetadataEmbedMimetype(targetMimetype) ? sourceExtension : targetExtension);
    }

    protected String getMimetypeExt(String mimetype) {
        StringBuilder sb = new StringBuilder("");
        if (this.extensionLookup == null) {
            sb.append(mimetype);
        } else {
            String mimetypeExt = this.extensionLookup.getExtension(mimetype);
            if (mimetypeExt == null) {
                sb.append(mimetype);
            } else {
                sb.append(mimetypeExt);
                sb.append(this.spaces(4 - mimetypeExt.length()));
            }
        }
        sb.append(' ');
        return sb.toString();
    }

    protected String spaces(int i) {
        StringBuilder sb = new StringBuilder("");
        while (--i >= 0) {
            sb.append(' ');
        }
        return sb.toString();
    }

    public String ms(long time) {
        return String.format("%,d ms", time);
    }

    public String fileSize(long size) {
        if (size < 0L) {
            return "unlimited";
        }
        if (size == 1L) {
            return "1 byte";
        }
        String[] units = new String[]{"bytes", "KB", "MB", "GB", "TB"};
        long divider = 1L;
        int i = 0;
        while (i < units.length - 1) {
            long nextDivider = divider * 1024L;
            if (size < nextDivider) {
                return this.fileSizeFormat(size, divider, units[i]);
            }
            divider = nextDivider;
            ++i;
        }
        return this.fileSizeFormat(size, divider, units[units.length - 1]);
    }

    private String fileSizeFormat(long size, long divider, String unit) {
        size = size * 10L / divider;
        int decimalPoint = (int)size % 10;
        StringBuilder sb = new StringBuilder();
        sb.append(size / 10L);
        if (decimalPoint != 0) {
            sb.append(".");
            sb.append(decimalPoint);
        }
        sb.append(' ');
        sb.append(unit);
        return sb.toString();
    }

    public int debugTransformServiceRequest(String sourceMimetype, long sourceSize, NodeRef sourceNodeRef, int contentHashcode, String filename, String targetMimetype, Map<String, String> options, String renditionName) {
        if (this.isEnabled()) {
            this.pushMisc();
            String sourceAndTargetExt = this.getSourceAndTargetExt(sourceMimetype, targetMimetype);
            this.debug(sourceAndTargetExt + (String)(filename != null ? filename + " " : "") + (String)(sourceSize >= 0L ? this.fileSize(sourceSize) + " " : "") + this.getRenditionName(renditionName) + " TransformService");
            this.log(sourceNodeRef.toString() + " " + contentHashcode);
            String reference = this.getReference(true, false, false);
            this.infoLog(reference, sourceAndTargetExt, null, filename, sourceSize, TRANSFORM_SERVICE_NAME, renditionName, null, "", true);
        }
        return this.pop(Call.AVAILABLE, true, false);
    }

    public String getRenditionName(String renditionName) {
        return renditionName != null ? "-- " + TransformerDebug.replaceWithMetadataRenditionNameIfEmbedOrExtract(renditionName) + " -- " : "";
    }

    static String replaceWithMetadataRenditionNameIfEmbedOrExtract(String renditionName) {
        String transformName = TransformerDebug.getTransformName(renditionName);
        return transformName != null && transformName.startsWith(MIMETYPE_METADATA_EXTRACT) ? "metadataExtract" : (transformName != null && transformName.startsWith(MIMETYPE_METADATA_EMBED) ? "metadataEmbed" : renditionName);
    }

    static String getTransformName(String renditionName) {
        return renditionName == null || !renditionName.startsWith(TRANSFORM_NAMESPACE) ? null : renditionName.substring(TRANSFORM_NAMESPACE.length());
    }

    public static boolean isMetadataExtractMimetype(String targetMimetype) {
        return MIMETYPE_METADATA_EXTRACT.equals(targetMimetype);
    }

    public static boolean isMetadataEmbedMimetype(String targetMimetype) {
        return MIMETYPE_METADATA_EMBED.equals(targetMimetype);
    }

    public void debugTransformServiceResponse(long requested, int id, String msg, Collection<String> debugLines) {
        boolean suppressFinish = this.debugTransformServiceResponsePreConsume(requested, id, msg, debugLines);
        this.debugTransformServiceResponsePostConsume(suppressFinish);
    }

    public boolean debugTransformServiceResponsePreConsume(long requested, int id, String msg, Collection<String> debugLines) {
        boolean suppressFinish;
        boolean bl = suppressFinish = id == -1 || requested == -1L;
        if (this.isEnabled()) {
            this.pushMisc();
            Frame frame = ThreadInfo.getStack().getLast();
            frame.id = id;
            if (!suppressFinish) {
                frame.start = requested;
            }
            this.debug(msg);
            debugLines.forEach(line -> this.multiLineLog.debug(line));
        }
        return suppressFinish;
    }

    public void debugTransformServiceResponsePostConsume(boolean suppressFinish) {
        if (this.isEnabled()) {
            this.pop(Call.AVAILABLE, suppressFinish, true);
        }
    }

    public static String toString(Map<String, String> options) {
        StringJoiner sj = new StringJoiner(", ");
        options.entrySet().forEach(option -> {
            StringJoiner stringJoiner2 = sj.add((String)option.getKey() + "=\"" + ((String)option.getValue()).replaceAll("\"", "\\\"") + "\"");
        });
        return sj.toString();
    }

    protected static enum Call {
        AVAILABLE,
        TRANSFORM,
        AVAILABLE_AND_TRANSFORM;

    }

    public static interface ExtensionLookup {
        public String getExtension(String var1);
    }

    protected static class Frame {
        private static final AtomicInteger uniqueId = new AtomicInteger(1);
        private int id = -1;
        private final String fromUrl;
        protected final String sourceMimetype;
        protected final String targetMimetype;
        protected final NodeRef sourceNodeRef;
        protected final String renditionName;
        private final boolean origDebugOutput;
        private long start;
        private Call callType;
        private Frame parent;
        private int childId;
        private String failureReason;
        private long sourceSize;
        private String transformerName;

        private Frame(Frame parent, String transformerName, String fromUrl, String sourceMimetype, String targetMimetype, long sourceSize, String renditionName, NodeRef sourceNodeRef, Call pushCall, boolean origDebugOutput) {
            this.parent = parent;
            this.fromUrl = fromUrl;
            this.transformerName = transformerName;
            this.sourceMimetype = sourceMimetype;
            this.targetMimetype = targetMimetype;
            this.sourceSize = sourceSize;
            this.renditionName = renditionName;
            this.sourceNodeRef = sourceNodeRef;
            this.callType = pushCall;
            this.origDebugOutput = origDebugOutput;
            this.start = System.currentTimeMillis();
        }

        static void reset() {
            uniqueId.set(0);
        }

        private int getId() {
            if (this.id == -1) {
                this.id = this.parent == null ? uniqueId.getAndIncrement() : (this.parent.childId = this.parent.childId + 1);
            }
            return this.id;
        }

        protected void setFailureReason(String failureReason) {
            this.failureReason = failureReason;
        }

        protected String getFailureReason() {
            return this.failureReason;
        }

        protected void setSourceSize(long sourceSize) {
            this.sourceSize = sourceSize;
        }

        public long getSourceSize() {
            return this.sourceSize;
        }

        private void setTransformerName(String transformerName) {
            this.transformerName = transformerName;
        }

        public String getTransformerName() {
            return this.transformerName;
        }

        public String getRenditionName() {
            return this.renditionName;
        }
    }

    protected static class ThreadInfo {
        private static final ThreadLocal<ThreadInfo> threadInfo = new ThreadLocal<ThreadInfo>(){

            @Override
            protected ThreadInfo initialValue() {
                return new ThreadInfo();
            }
        };
        private final Deque<Frame> stack = new ArrayDeque<Frame>();
        private final Deque<String> isTransformableStack = new ArrayDeque<String>();
        private boolean debugOutput = true;
        private StringBuilder sb;

        protected ThreadInfo() {
        }

        public static Deque<Frame> getStack() {
            return ThreadInfo.threadInfo.get().stack;
        }

        public static boolean getDebugOutput() {
            return ThreadInfo.threadInfo.get().debugOutput;
        }

        public static Deque<String> getIsTransformableStack() {
            return ThreadInfo.threadInfo.get().isTransformableStack;
        }

        public static boolean setDebugOutput(boolean debugOutput) {
            ThreadInfo thisThreadInfo = threadInfo.get();
            boolean orig = thisThreadInfo.debugOutput;
            thisThreadInfo.debugOutput = debugOutput;
            return orig;
        }

        public static StringBuilder getStringBuilder() {
            return ThreadInfo.threadInfo.get().sb;
        }

        public static void setStringBuilder(StringBuilder sb) {
            ThreadInfo.threadInfo.get().sb = sb;
        }
    }
}

