/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.workflow.activiti;

import java.io.IOException;
import junit.framework.TestCase;
import org.activiti.engine.ProcessEngine;
import org.activiti.engine.ProcessEngineConfiguration;
import org.activiti.engine.RepositoryService;
import org.activiti.engine.RuntimeService;
import org.activiti.engine.repository.Deployment;
import org.activiti.engine.runtime.ProcessInstance;
import org.alfresco.util.testing.category.NeverRunsTests;
import org.junit.experimental.categories.Category;
import org.springframework.core.io.ClassPathResource;

@Category(value={NeverRunsTests.class})
public class ActivitiSmokeTest
extends TestCase {
    public void testDeploy() throws Exception {
        ProcessEngine engine = this.buildProcessEngine();
        RepositoryService repoService = engine.getRepositoryService();
        Deployment deployment = this.deployDefinition(repoService);
        ActivitiSmokeTest.assertNotNull((Object)deployment);
        RuntimeService runtimeService = engine.getRuntimeService();
        try {
            ProcessInstance instance = runtimeService.startProcessInstanceByKey("testTask");
            ActivitiSmokeTest.assertNotNull((Object)instance);
            String instanceId = instance.getId();
            ProcessInstance instanceInDb = this.findProcessInstance(runtimeService, instanceId);
            ActivitiSmokeTest.assertNotNull((Object)instanceInDb);
            runtimeService.deleteProcessInstance(instanceId, "");
        }
        finally {
            repoService.deleteDeployment(deployment.getId());
        }
    }

    private Deployment deployDefinition(RepositoryService repoService) throws IOException {
        ClassPathResource resource = new ClassPathResource("org/alfresco/repo/workflow/activiti/testTransaction.bpmn20.xml");
        Deployment deployment = repoService.createDeployment().addInputStream(resource.getFilename(), resource.getInputStream()).deploy();
        return deployment;
    }

    private ProcessEngine buildProcessEngine() {
        String properties = "activiti/activiti.cfg.xml";
        ProcessEngine engine = ProcessEngineConfiguration.createProcessEngineConfigurationFromResource((String)properties).buildProcessEngine();
        return engine;
    }

    private ProcessInstance findProcessInstance(RuntimeService runtimeService, String instanceId) {
        ProcessInstance instanceInDb = (ProcessInstance)runtimeService.createProcessInstanceQuery().processInstanceId(instanceId).singleResult();
        return instanceInDb;
    }
}

