/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.rendition2;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.alfresco.model.ContentModel;
import org.alfresco.model.RenditionModel;
import org.alfresco.repo.rendition2.AbstractRenditionIntegrationTest;
import org.alfresco.repo.rendition2.RenditionDefinition2;
import org.alfresco.repo.rendition2.TransformDefinition;
import org.alfresco.repo.security.authentication.AuthenticationUtil;
import org.alfresco.repo.security.permissions.AccessDeniedException;
import org.alfresco.service.cmr.repository.ChildAssociationRef;
import org.alfresco.service.cmr.repository.ContentData;
import org.alfresco.service.cmr.repository.NodeRef;
import org.alfresco.service.cmr.repository.datatype.DefaultTypeConverter;
import org.alfresco.service.namespace.QName;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;

public class RenditionService2IntegrationTest
extends AbstractRenditionIntegrationTest {
    @BeforeClass
    public static void before() {
        AbstractRenditionIntegrationTest.before();
        RenditionService2IntegrationTest.local();
    }

    @Test
    public void testLocalRenderPdfToJpegMedium() {
        this.checkRendition("quick.pdf", "medium", true);
    }

    @Test
    public void testLocalRenderPdfToDoclib() {
        this.checkRendition("quick.pdf", "doclib", true);
    }

    @Test
    public void testLocalRenderPdfJpegImgpreview() {
        this.checkRendition("quick.pdf", "imgpreview", true);
    }

    @Test
    public void testLocalRenderPdfPngAvatar() {
        this.checkRendition("quick.pdf", "avatar", true);
    }

    @Test
    public void testLocalRenderPdfPngAvatar32() {
        this.checkRendition("quick.pdf", "avatar32", true);
    }

    @Test
    public void testLocalRenderPdfFlashWebpreview() {
        this.checkRendition("quick.pdf", "webpreview", false);
    }

    @Test
    public void testLocalRenderDocxJpegMedium() {
        this.checkRendition("quick.docx", "medium", true);
    }

    @Test
    public void testLocalRenderDocxDoclib() {
        this.checkRendition("quick.docx", "doclib", true);
    }

    @Test
    public void testLocalRenderDocxJpegImgpreview() {
        this.checkRendition("quick.docx", "imgpreview", true);
    }

    @Test
    public void testLocalRenderDocxPngAvatar() {
        this.checkRendition("quick.docx", "avatar", true);
    }

    @Test
    public void testLocalRenderDocxPngAvatar32() {
        this.checkRendition("quick.docx", "avatar32", true);
    }

    @Test
    public void testLocalRenderDocxFlashWebpreview() {
        this.checkRendition("quick.docx", "webpreview", false);
    }

    @Test
    public void testLocalRenderDocxPdf() {
        this.checkRendition("quick.docx", "pdf", true);
    }

    @Test
    public void basicRendition() {
        NodeRef sourceNodeRef = this.createSource("admin", "quick.jpg");
        this.render("admin", sourceNodeRef, "doclib");
        this.waitForRendition("admin", sourceNodeRef, "doclib", true);
    }

    @Test
    public void changedSourceToNullContent() {
        NodeRef sourceNodeRef = this.createSource("admin", "quick.jpg");
        this.render("admin", sourceNodeRef, "doclib");
        this.waitForRendition("admin", sourceNodeRef, "doclib", true);
        this.clearContent("admin", sourceNodeRef);
        this.render("admin", sourceNodeRef, "doclib");
        ChildAssociationRef assoc = (ChildAssociationRef)AuthenticationUtil.runAs(() -> this.renditionService2.getRenditionByName(sourceNodeRef, "doclib"), (String)"admin");
        this.waitForRendition("admin", sourceNodeRef, "doclib", false);
        RenditionService2IntegrationTest.assertNull((String)"There should be no rendition as there was no content", (Object)assoc);
    }

    @Test
    public void changedSourceToNonNull() {
        NodeRef sourceNodeRef = this.createSource("admin", "quick.jpg");
        this.render("admin", sourceNodeRef, "doclib");
        NodeRef rendition1 = this.waitForRendition("admin", sourceNodeRef, "doclib", true);
        ContentData contentData1 = (ContentData)DefaultTypeConverter.INSTANCE.convert(ContentData.class, (Object)this.nodeService.getProperty(rendition1, ContentModel.PROP_CONTENT));
        this.updateContent("admin", sourceNodeRef, "quick.png");
        this.render("admin", sourceNodeRef, "doclib");
        NodeRef rendition2 = this.waitForRendition("admin", sourceNodeRef, "doclib", true);
        ContentData contentData2 = (ContentData)DefaultTypeConverter.INSTANCE.convert(ContentData.class, (Object)this.nodeService.getProperty(rendition2, ContentModel.PROP_CONTENT));
        RenditionService2IntegrationTest.assertEquals((String)"The rendition node should not change", (Object)rendition1, (Object)rendition2);
        Assert.assertNotEquals((String)"The content should have change", (Object)contentData1.toString(), (Object)contentData2.toString());
    }

    @Test
    public void changedSourceFromNull() {
        NodeRef sourceNodeRef = this.createSource("admin", "quick.jpg");
        this.render("admin", sourceNodeRef, "doclib");
        this.waitForRendition("admin", sourceNodeRef, "doclib", true);
        this.clearContent("admin", sourceNodeRef);
        this.render("admin", sourceNodeRef, "doclib");
        ChildAssociationRef assoc = (ChildAssociationRef)AuthenticationUtil.runAs(() -> this.renditionService2.getRenditionByName(sourceNodeRef, "doclib"), (String)"admin");
        this.waitForRendition("admin", sourceNodeRef, "doclib", false);
        RenditionService2IntegrationTest.assertNull((String)"There should be no rendition as there was no content", (Object)assoc);
        this.updateContent("admin", sourceNodeRef, "quick.png");
        this.render("admin", sourceNodeRef, "doclib");
        this.waitForRendition("admin", sourceNodeRef, "doclib", true);
    }

    @Test
    public void testCreateRenditionByUser() {
        String userName = this.createRandomUser();
        NodeRef sourceNodeRef = this.createSource(userName, "quick.jpg");
        this.render(userName, sourceNodeRef, "doclib");
        NodeRef renditionNodeRef = this.waitForRendition(userName, sourceNodeRef, "doclib", true);
        RenditionService2IntegrationTest.assertNotNull((String)"The rendition was not generated for non-admin user", (Object)renditionNodeRef);
    }

    @Test
    public void testReadRenditionByOtherUser() {
        String ownerUserName = this.createRandomUser();
        NodeRef sourceNodeRef = this.createSource(ownerUserName, "quick.jpg");
        String otherUserName = this.createRandomUser();
        this.transactionService.getRetryingTransactionHelper().doInTransaction(() -> {
            this.permissionService.setPermission(sourceNodeRef, otherUserName, "Read", true);
            return null;
        });
        this.render(ownerUserName, sourceNodeRef, "doclib");
        NodeRef renditionNodeRef = this.waitForRendition(ownerUserName, sourceNodeRef, "doclib", true);
        RenditionService2IntegrationTest.assertNotNull((String)"The rendition is not visible for owner of source node", (Object)renditionNodeRef);
        renditionNodeRef = this.waitForRendition(otherUserName, sourceNodeRef, "doclib", true);
        RenditionService2IntegrationTest.assertNotNull((String)"The rendition is not visible for non-owner user with read permissions", (Object)renditionNodeRef);
        RenditionService2IntegrationTest.assertEquals((String)"The creator of the rendition is not correct", (Object)ownerUserName, (Object)this.nodeService.getProperty(sourceNodeRef, ContentModel.PROP_CREATOR));
    }

    @Test
    public void testRenderByReader() {
        String ownerUserName = this.createRandomUser();
        NodeRef sourceNodeRef = this.createSource(ownerUserName, "quick.jpg");
        String otherUserName = this.createRandomUser();
        this.transactionService.getRetryingTransactionHelper().doInTransaction(() -> {
            this.permissionService.setPermission(sourceNodeRef, otherUserName, "Read", true);
            return null;
        });
        this.render(otherUserName, sourceNodeRef, "doclib");
        NodeRef renditionNodeRef = this.waitForRendition(ownerUserName, sourceNodeRef, "doclib", true);
        RenditionService2IntegrationTest.assertNotNull((String)"The rendition is not visible for owner of source node", (Object)renditionNodeRef);
        renditionNodeRef = this.waitForRendition(otherUserName, sourceNodeRef, "doclib", true);
        RenditionService2IntegrationTest.assertNotNull((String)"The rendition is not visible for owner of rendition node", (Object)renditionNodeRef);
        RenditionService2IntegrationTest.assertEquals((String)"The creator of the rendition is not correct", (Object)ownerUserName, (Object)this.nodeService.getProperty(sourceNodeRef, ContentModel.PROP_CREATOR));
    }

    @Test
    public void testAccessWithNoPermissions() {
        String ownerUserName = this.createRandomUser();
        NodeRef sourceNodeRef = this.createSource(ownerUserName, "quick.jpg");
        this.render(ownerUserName, sourceNodeRef, "doclib");
        String noPermissionsUser = this.createRandomUser();
        this.transactionService.getRetryingTransactionHelper().doInTransaction(() -> {
            this.permissionService.setPermission(sourceNodeRef, noPermissionsUser, "All", false);
            return null;
        });
        try {
            this.waitForRendition(noPermissionsUser, sourceNodeRef, "doclib", true);
            RenditionService2IntegrationTest.fail((String)"The rendition should not be visible for user with no permissions");
        }
        catch (AccessDeniedException accessDeniedException) {}
    }

    @Test
    public void testUpgradeRenditionService() throws InterruptedException {
        String ownerUserName = this.createRandomUser();
        NodeRef sourceNodeRef = this.createSource(ownerUserName, "quick.jpg");
        QName doclibRendDefQName = QName.createQName((String)"http://www.alfresco.org/model/content/1.0", (String)"doclib");
        this.transactionService.getRetryingTransactionHelper().doInTransaction(() -> (ChildAssociationRef)AuthenticationUtil.runAs(() -> this.renditionService.render(sourceNodeRef, doclibRendDefQName), (String)ownerUserName));
        NodeRef oldRendition = (NodeRef)AuthenticationUtil.runAs(() -> this.renditionService.getRenditionByName(sourceNodeRef, doclibRendDefQName).getChildRef(), (String)ownerUserName);
        RenditionService2IntegrationTest.assertFalse((String)"The rendition should be generated by old Rendition Service", (boolean)((Boolean)AuthenticationUtil.runAs(() -> this.nodeService.hasAspect(oldRendition, RenditionModel.ASPECT_RENDITION2), (String)ownerUserName)));
        this.updateContent(ownerUserName, sourceNodeRef, "quick.png");
        NodeRef newRendition = this.waitForRendition(ownerUserName, sourceNodeRef, "doclib", true);
        RenditionService2IntegrationTest.assertNotNull((String)"The rendition should be reported via RenditionService2", (Object)newRendition);
        Thread.sleep(200L);
        boolean hasRenditionedAspect = false;
        int i = 0;
        while (i < 5) {
            hasRenditionedAspect = (Boolean)AuthenticationUtil.runAs(() -> this.nodeService.hasAspect(newRendition, RenditionModel.ASPECT_RENDITION2), (String)ownerUserName);
            if (hasRenditionedAspect) break;
            Thread.sleep(500L);
            ++i;
        }
        RenditionService2IntegrationTest.assertTrue((String)"The rendition should be generated by new Rendition Service", (boolean)hasRenditionedAspect);
    }

    @Test
    public void testClearRenditionContentData() {
        NodeRef sourceNodeRef = this.createSource("admin", "quick.jpg");
        this.render("admin", sourceNodeRef, "doclib");
        NodeRef renditionNodeRef = this.waitForRendition("admin", sourceNodeRef, "doclib", true);
        RenditionService2IntegrationTest.assertNotNull((String)"Rendition was not generated", (Object)renditionNodeRef);
        RenditionService2IntegrationTest.assertNotNull((String)"Rendition was not generated", (Object)this.nodeService.getProperty(renditionNodeRef, ContentModel.PROP_CONTENT));
        int contentHashCode = this.getRenditionContentHashCode(renditionNodeRef);
        RenditionService2IntegrationTest.assertTrue((String)"Rendition content hash code was not generated", (boolean)this.isValidRenditionContentHashCode(contentHashCode));
        this.renditionService2.setEnabled(false);
        AuthenticationUtil.runAs(() -> (Void)this.transactionService.getRetryingTransactionHelper().doInTransaction(() -> {
            this.renditionService2.clearRenditionContentData(sourceNodeRef, "doclib");
            return null;
        }), (String)"admin");
        RenditionService2IntegrationTest.assertNull((String)"Rendition has content", (Object)this.nodeService.getProperty(renditionNodeRef, ContentModel.PROP_CONTENT));
        contentHashCode = this.getRenditionContentHashCode(renditionNodeRef);
        RenditionService2IntegrationTest.assertFalse((String)"Rendition has content hash code", (boolean)this.isValidRenditionContentHashCode(contentHashCode));
        this.renditionService2.setEnabled(true);
    }

    @Test
    public void testRenditionWithNullContentButWithContentHashCode() {
        this.testRenditionWithoutContentButWithContentHashCode(null);
    }

    @Test
    public void testRenditionWithZeroContentButWithContentHashCode() {
        this.testRenditionWithoutContentButWithContentHashCode(new ByteArrayInputStream(new byte[0]));
    }

    private void testRenditionWithoutContentButWithContentHashCode(InputStream transformInputStream) {
        NodeRef sourceNodeRef = this.createSource("admin", "quick.jpg");
        this.render("admin", sourceNodeRef, "doclib");
        NodeRef renditionNodeRef = this.waitForRendition("admin", sourceNodeRef, "doclib", true);
        RenditionService2IntegrationTest.assertNotNull((String)"Rendition was not generated", (Object)renditionNodeRef);
        RenditionService2IntegrationTest.assertNotNull((String)"Rendition was not generated", (Object)this.nodeService.getProperty(renditionNodeRef, ContentModel.PROP_CONTENT));
        this.clearContent("admin", renditionNodeRef);
        RenditionService2IntegrationTest.assertNull((String)"Rendition has content", (Object)this.nodeService.getProperty(renditionNodeRef, ContentModel.PROP_CONTENT));
        int contentHashCode = this.getRenditionContentHashCode(renditionNodeRef);
        RenditionService2IntegrationTest.assertTrue((String)"Rendition content hash code was not generated", (boolean)this.isValidRenditionContentHashCode(contentHashCode));
        RenditionDefinition2 renditionDefinition = this.renditionDefinitionRegistry2.getRenditionDefinition("doclib");
        AuthenticationUtil.runAs(() -> {
            this.renditionService2.consume(sourceNodeRef, transformInputStream, renditionDefinition, contentHashCode);
            return null;
        }, (String)"admin");
        this.waitForRendition("admin", sourceNodeRef, "doclib", false);
        int contentHashCode2 = this.getRenditionContentHashCode(renditionNodeRef);
        RenditionService2IntegrationTest.assertFalse((String)"Rendition content hash code was not cleaned", (boolean)this.isValidRenditionContentHashCode(contentHashCode2));
        this.render("admin", sourceNodeRef, "doclib");
        NodeRef renditionNodeRef2 = this.waitForRendition("admin", sourceNodeRef, "doclib", true);
        RenditionService2IntegrationTest.assertEquals((String)"New rendition nodeRef is different", (String)renditionNodeRef.toString(), (String)renditionNodeRef2.toString());
        RenditionService2IntegrationTest.assertNotNull((String)"New rendition content was not generated", (Object)this.nodeService.getProperty(renditionNodeRef2, ContentModel.PROP_CONTENT));
        int contentHashCode3 = this.getRenditionContentHashCode(renditionNodeRef2);
        RenditionService2IntegrationTest.assertTrue((String)"New rendition content hash code was not generated", (boolean)this.isValidRenditionContentHashCode(contentHashCode3));
    }

    @Test
    public void testModifierAfterMultipleRenditionRequests() throws InterruptedException {
        String user1 = this.createRandomUser();
        String user2 = this.createRandomUser();
        ArrayList<NodeRef> nodes = new ArrayList<NodeRef>();
        int i = 0;
        while (i < 10) {
            NodeRef n = this.createSource(user1, "quick.jpg");
            this.render(user1, n, "doclib");
            nodes.add(n);
            ++i;
        }
        int j = 0;
        while (j < 10) {
            int i2 = 0;
            while (i2 < 10) {
                this.render(user2, (NodeRef)nodes.get(i2), "doclib");
                ++i2;
            }
            ++j;
        }
        i = 0;
        while (i < 10) {
            this.waitForRendition(user1, (NodeRef)nodes.get(i), "doclib", true);
            ++i;
        }
        RenditionService2IntegrationTest.assertEquals((int)10, (int)this.countModifier(nodes, user1));
    }

    @Test
    public void testForceRenditionsContentHashCode() {
        NodeRef sourceNodeRef = this.createSource("admin", "quick.docx");
        RenditionService2IntegrationTest.assertNotNull((String)"Node not generated", (Object)sourceNodeRef);
        int sourceNodeContentHashCode = this.getSourceContentHashCode(sourceNodeRef);
        this.render("admin", sourceNodeRef, "pdf");
        NodeRef pdfRenditionNodeRef = this.waitForRendition("admin", sourceNodeRef, "pdf", true);
        RenditionService2IntegrationTest.assertNotNull((String)"pdf rendition was not generated", (Object)pdfRenditionNodeRef);
        RenditionService2IntegrationTest.assertNotNull((String)"pdf rendition was not generated", (Object)this.nodeService.getProperty(pdfRenditionNodeRef, ContentModel.PROP_CONTENT));
        int pdfRenditionContentHashCode = this.getRenditionContentHashCode(pdfRenditionNodeRef);
        RenditionService2IntegrationTest.assertEquals((String)"pdf rendition content hash code is different from source node content hash code", (int)sourceNodeContentHashCode, (int)pdfRenditionContentHashCode);
        this.render("admin", sourceNodeRef, "doclib");
        NodeRef docLibRenditionNodeRef = this.waitForRendition("admin", sourceNodeRef, "doclib", true);
        RenditionService2IntegrationTest.assertNotNull((String)"doc lib rendition was not generated", (Object)docLibRenditionNodeRef);
        RenditionService2IntegrationTest.assertNotNull((String)"doc lib rendition was not generated", (Object)this.nodeService.getProperty(docLibRenditionNodeRef, ContentModel.PROP_CONTENT));
        int docLibenditionContentHashCode = this.getRenditionContentHashCode(docLibRenditionNodeRef);
        RenditionService2IntegrationTest.assertEquals((String)"doc lib rendition content hash code is different from source node content hash code", (int)sourceNodeContentHashCode, (int)docLibenditionContentHashCode);
        this.updateContent("admin", sourceNodeRef, "quick.docx");
        int sourceNodeContentHashCode2 = this.getSourceContentHashCode(sourceNodeRef);
        Assert.assertNotEquals((String)"Source node content hash code is the same after content update", (long)sourceNodeContentHashCode, (long)sourceNodeContentHashCode2);
        Assert.assertNotEquals((String)"pdf rendition content hash code is the same after content update", (long)sourceNodeContentHashCode2, (long)pdfRenditionContentHashCode);
        Assert.assertNotEquals((String)"doc lib rendition content hash code is the same after content update", (long)sourceNodeContentHashCode2, (long)docLibenditionContentHashCode);
        AuthenticationUtil.runAs(() -> {
            this.renditionService2.forceRenditionsContentHashCode(sourceNodeRef);
            return null;
        }, (String)"admin");
        int pdfRenditionContentHashCode2 = this.getRenditionContentHashCode(pdfRenditionNodeRef);
        int docLibenditionContentHashCode2 = this.getRenditionContentHashCode(docLibRenditionNodeRef);
        RenditionService2IntegrationTest.assertEquals((String)"pdf rendition content hash code is different from latest source node content hash code", (int)sourceNodeContentHashCode2, (int)pdfRenditionContentHashCode2);
        RenditionService2IntegrationTest.assertEquals((String)"doc lib rendition content hash code is different from latest source node content hash code", (int)sourceNodeContentHashCode2, (int)docLibenditionContentHashCode2);
    }

    private int countModifier(List<NodeRef> nodes, String user) {
        int count = 0;
        int i = 0;
        while (i < nodes.size()) {
            count += this.compareModifier(nodes.get(i), user);
            ++i;
        }
        return count;
    }

    private int compareModifier(NodeRef nodeRef, String user) {
        String modifier;
        int res = 0;
        if (nodeRef != null && user != null && user.equals(modifier = this.nodeService.getProperty(nodeRef, ContentModel.PROP_MODIFIER).toString())) {
            res = 1;
        }
        return res;
    }

    @Deprecated
    @Test
    public void testUseOldService() throws InterruptedException {
        this.renditionService2.setEnabled(false);
        try {
            NodeRef sourceNodeRef = this.createSource("admin", "quick.jpg");
            QName doclibRendDefQName = QName.createQName((String)"http://www.alfresco.org/model/content/1.0", (String)"doclib");
            this.transactionService.getRetryingTransactionHelper().doInTransaction(() -> (ChildAssociationRef)AuthenticationUtil.runAs(() -> this.renditionService.render(sourceNodeRef, doclibRendDefQName), (String)"admin"));
            RenditionService2IntegrationTest.assertNotNull((String)"The old renditions service did not render", (Object)this.waitForRendition("admin", sourceNodeRef, "doclib", true));
            List lastThumbnailModification = (List)this.transactionService.getRetryingTransactionHelper().doInTransaction(() -> (List)AuthenticationUtil.runAs(() -> (List)((Object)this.nodeService.getProperty(sourceNodeRef, ContentModel.PROP_LAST_THUMBNAIL_MODIFICATION_DATA)), (String)"admin"));
            this.updateContent("admin", sourceNodeRef, "quick.png");
            List newThumbnailModification = null;
            int i = 0;
            while (i < 5) {
                newThumbnailModification = (List)this.transactionService.getRetryingTransactionHelper().doInTransaction(() -> (List)AuthenticationUtil.runAs(() -> (List)((Object)this.nodeService.getProperty(sourceNodeRef, ContentModel.PROP_LAST_THUMBNAIL_MODIFICATION_DATA)), (String)"admin"));
                if (!newThumbnailModification.equals(lastThumbnailModification)) break;
                Thread.sleep(500L);
                ++i;
            }
            RenditionService2IntegrationTest.assertFalse((String)"The old rendition service did not update the rendition.", (boolean)newThumbnailModification.equals(lastThumbnailModification));
            NodeRef renditionNodeRef = (NodeRef)AuthenticationUtil.runAs(() -> this.renditionService.getRenditionByName(sourceNodeRef, doclibRendDefQName).getChildRef(), (String)"admin");
            RenditionService2IntegrationTest.assertFalse((String)"The rendition should be rendered by the old rendition service", (boolean)((Boolean)AuthenticationUtil.runAs(() -> this.nodeService.hasAspect(renditionNodeRef, RenditionModel.ASPECT_RENDITION2), (String)"admin")));
        }
        finally {
            this.renditionService2.setEnabled(true);
        }
    }

    @Deprecated
    @Test
    public void testSwitchBackToOldService() throws InterruptedException {
        NodeRef sourceNodeRef = this.createSource("admin", "quick.jpg");
        this.render("admin", sourceNodeRef, "doclib");
        this.waitForRendition("admin", sourceNodeRef, "doclib", true);
        this.renditionService2.setEnabled(false);
        try {
            this.updateContent("admin", sourceNodeRef, "quick.png");
            Thread.sleep(200L);
            NodeRef renditionNodeRef = this.waitForRendition("admin", sourceNodeRef, "doclib", true);
            boolean hasRendition2Aspect = true;
            int i = 0;
            while (i < 5) {
                hasRendition2Aspect = (Boolean)AuthenticationUtil.runAs(() -> this.nodeService.hasAspect(renditionNodeRef, RenditionModel.ASPECT_RENDITION2), (String)"admin");
                if (!hasRendition2Aspect) break;
                Thread.sleep(500L);
                ++i;
            }
            RenditionService2IntegrationTest.assertFalse((String)"Should have switched to the old rendition service", (boolean)hasRendition2Aspect);
        }
        finally {
            this.renditionService2.setEnabled(true);
        }
    }

    @Deprecated
    @Test
    public void testSwitchToNewServiceViaContentUpdate() {
        this.renditionService2.setEnabled(false);
        try {
            NodeRef sourceNodeRef = this.createSource("admin", "quick.jpg");
            QName doclibRendDefQName = QName.createQName((String)"http://www.alfresco.org/model/content/1.0", (String)"doclib");
            this.transactionService.getRetryingTransactionHelper().doInTransaction(() -> (ChildAssociationRef)AuthenticationUtil.runAs(() -> this.renditionService.render(sourceNodeRef, doclibRendDefQName), (String)"admin"));
            this.waitForRendition("admin", sourceNodeRef, "doclib", true);
            this.renditionService2.setEnabled(true);
            this.updateContent("admin", sourceNodeRef, "quick.png");
            NodeRef renditionNodeRef = this.waitForRendition("admin", sourceNodeRef, "doclib", true);
            boolean hasAspect = this.nodeService.hasAspect(renditionNodeRef, RenditionModel.ASPECT_RENDITION2);
            RenditionService2IntegrationTest.assertFalse((String)"Should have switched to the old rendition service", (boolean)hasAspect);
        }
        finally {
            this.renditionService2.setEnabled(true);
        }
    }

    @Deprecated
    @Test
    public void testDowngradeRenditionService() throws InterruptedException {
        String ownerUserName = this.createRandomUser();
        NodeRef sourceNodeRef = this.createSource(ownerUserName, "quick.jpg");
        this.render(ownerUserName, sourceNodeRef, "doclib");
        NodeRef newRendition = this.waitForRendition(ownerUserName, sourceNodeRef, "doclib", true);
        boolean hasRendition2Aspect = (Boolean)AuthenticationUtil.runAs(() -> this.nodeService.hasAspect(newRendition, RenditionModel.ASPECT_RENDITION2), (String)ownerUserName);
        RenditionService2IntegrationTest.assertTrue((String)"The source should have the old renditioned aspect", (boolean)((Boolean)AuthenticationUtil.runAs(() -> this.nodeService.hasAspect(sourceNodeRef, RenditionModel.ASPECT_RENDITIONED), (String)ownerUserName)));
        RenditionService2IntegrationTest.assertTrue((String)"The rendition2 aspect should be present", (boolean)hasRendition2Aspect);
        try {
            this.renditionService2.setEnabled(false);
            this.updateContent(ownerUserName, sourceNodeRef, "quick.png");
            NodeRef oldRendition = this.waitForRendition(ownerUserName, sourceNodeRef, "doclib", true);
            Thread.sleep(200L);
            hasRendition2Aspect = false;
            int i = 0;
            while (i < 5) {
                hasRendition2Aspect = (Boolean)AuthenticationUtil.runAs(() -> this.nodeService.hasAspect(oldRendition, RenditionModel.ASPECT_RENDITION2), (String)ownerUserName);
                if (!hasRendition2Aspect) break;
                Thread.sleep(500L);
                ++i;
            }
            RenditionService2IntegrationTest.assertFalse((String)"The rendition should be generated by old Rendition Service", (boolean)hasRendition2Aspect);
        }
        finally {
            this.renditionService2.setEnabled(true);
        }
    }

    @Deprecated
    @Test
    public void testUpgradeRenditionViaRender() throws InterruptedException {
        this.renditionService2.setEnabled(false);
        try {
            NodeRef sourceNodeRef = this.createSource("admin", "quick.jpg");
            QName doclibRendDefQName = QName.createQName((String)"http://www.alfresco.org/model/content/1.0", (String)"doclib");
            this.transactionService.getRetryingTransactionHelper().doInTransaction(() -> (ChildAssociationRef)AuthenticationUtil.runAs(() -> this.renditionService.render(sourceNodeRef, doclibRendDefQName), (String)"admin"));
            this.waitForRendition("admin", sourceNodeRef, "doclib", true);
            this.renditionService2.setEnabled(true);
            this.render("admin", sourceNodeRef, "doclib");
            Thread.sleep(200L);
            NodeRef renditionNodeRef = this.waitForRendition("admin", sourceNodeRef, "doclib", true);
            boolean hasRendition2Aspect = false;
            int i = 0;
            while (i < 5) {
                hasRendition2Aspect = (Boolean)AuthenticationUtil.runAs(() -> this.nodeService.hasAspect(renditionNodeRef, RenditionModel.ASPECT_RENDITION2), (String)"admin");
                if (hasRendition2Aspect) break;
                Thread.sleep(500L);
                ++i;
            }
            RenditionService2IntegrationTest.assertTrue((String)"Should have switched to the new rendition service", (boolean)hasRendition2Aspect);
        }
        finally {
            this.renditionService2.setEnabled(true);
        }
    }

    @Test
    public void testRecreationOfRendition2() {
        this.renditionService2.setEnabled(true);
        try {
            NodeRef sourceNodeRef = this.createSource("admin", "quick.docx");
            RenditionService2IntegrationTest.assertNotNull((String)"Node not generated", (Object)sourceNodeRef);
            int sourceNodeContentHashCode = this.getSourceContentHashCode(sourceNodeRef);
            this.render("admin", sourceNodeRef, "pdf");
            NodeRef pdfRenditionNodeRef = this.waitForRendition("admin", sourceNodeRef, "pdf", true);
            RenditionService2IntegrationTest.assertNotNull((String)"pdf rendition was not generated", (Object)pdfRenditionNodeRef);
            RenditionService2IntegrationTest.assertNotNull((String)"pdf rendition was not generated", (Object)this.nodeService.getProperty(pdfRenditionNodeRef, ContentModel.PROP_CONTENT));
            int pdfRenditionContentHashCode = this.getRenditionContentHashCode(pdfRenditionNodeRef);
            RenditionService2IntegrationTest.assertEquals((String)"pdf rendition content hash code is different from source node content hash code", (int)sourceNodeContentHashCode, (int)pdfRenditionContentHashCode);
            AuthenticationUtil.runAs(() -> (Void)this.transactionService.getRetryingTransactionHelper().doInTransaction(() -> {
                this.renditionService2.clearRenditionContentData(sourceNodeRef, "pdf");
                return null;
            }), (String)"admin");
            RenditionService2IntegrationTest.assertNull((String)"Rendition has content", (Object)this.nodeService.getProperty(pdfRenditionNodeRef, ContentModel.PROP_CONTENT));
            pdfRenditionContentHashCode = this.getRenditionContentHashCode(pdfRenditionNodeRef);
            RenditionService2IntegrationTest.assertFalse((String)"Rendition has content hash code", (boolean)this.isValidRenditionContentHashCode(pdfRenditionContentHashCode));
            this.renditionService2.setEnabled(false);
            QName pdfRendDefQName = QName.createQName((String)"http://www.alfresco.org/model/content/1.0", (String)"pdf");
            this.transactionService.getRetryingTransactionHelper().doInTransaction(() -> (ChildAssociationRef)AuthenticationUtil.runAs(() -> this.renditionService.render(sourceNodeRef, pdfRendDefQName), (String)"admin"));
            this.renditionService2.setEnabled(true);
            NodeRef pdfRecreatedRenditionNodeRef = this.waitForRendition("admin", sourceNodeRef, "pdf", true);
            Assert.assertNotEquals((String)" Rendition before deletion and after previewing are identical", (Object)pdfRenditionNodeRef.getId(), (Object)pdfRecreatedRenditionNodeRef.getId());
        }
        finally {
            this.renditionService2.setEnabled(true);
        }
    }

    @Test
    public void testTextExtractTransformAllowedWhenThumbnailDisabled() {
        NodeRef sourceNodeRef = this.createSource("admin", "quick.pdf");
        RenditionService2IntegrationTest.assertNotNull((String)"Node not generated", (Object)sourceNodeRef);
        String replyQueue = "org.test.queue";
        String targetMimetype = "text/plain";
        TransformDefinition textExtractTransform = new TransformDefinition(targetMimetype, Collections.emptyMap(), "clientData", replyQueue, "requestId");
        this.renditionService2.setThumbnailsEnabled(false);
        try {
            AuthenticationUtil.runAs(() -> {
                this.transactionService.getRetryingTransactionHelper().doInTransaction(() -> {
                    this.renditionService2.transform(sourceNodeRef, textExtractTransform);
                    return null;
                });
                return null;
            }, (String)"admin");
        }
        finally {
            this.renditionService2.setThumbnailsEnabled(true);
        }
    }

    @Test
    public void testMetadataExtractTransformAllowedWhenThumbnailDisabled() {
        NodeRef sourceNodeRef = this.createSource("admin", "quick.pdf");
        RenditionService2IntegrationTest.assertNotNull((String)"Node not generated", (Object)sourceNodeRef);
        this.renditionService2.setThumbnailsEnabled(false);
        try {
            this.extract("admin", sourceNodeRef);
            this.waitForExtract("admin", sourceNodeRef, true);
        }
        finally {
            this.renditionService2.setThumbnailsEnabled(true);
        }
    }
}

