/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.dictionary;

import java.io.InputStream;
import java.util.ArrayList;
import java.util.concurrent.ThreadPoolExecutor;
import org.alfresco.model.ContentModel;
import org.alfresco.repo.dictionary.CompiledModelsCache;
import org.alfresco.repo.dictionary.DictionaryBootstrap;
import org.alfresco.repo.dictionary.DictionaryComponent;
import org.alfresco.repo.dictionary.DictionaryDAO;
import org.alfresco.repo.dictionary.DictionaryDAOImpl;
import org.alfresco.repo.dictionary.M2Model;
import org.alfresco.repo.i18n.StaticMessageLookup;
import org.alfresco.repo.security.authentication.AuthenticationUtil;
import org.alfresco.repo.tenant.MultiTServiceImpl;
import org.alfresco.repo.tenant.SingleTServiceImpl;
import org.alfresco.repo.tenant.TenantService;
import org.alfresco.repo.tenant.TenantUtil;
import org.alfresco.service.cmr.dictionary.DictionaryService;
import org.alfresco.service.cmr.dictionary.TypeDefinition;
import org.alfresco.service.cmr.i18n.MessageLookup;
import org.alfresco.service.namespace.QName;
import org.alfresco.util.ThreadPoolExecutorFactoryBean;
import org.alfresco.util.cache.AsynchronouslyRefreshedCacheRegistry;
import org.alfresco.util.cache.DefaultAsynchronouslyRefreshedCacheRegistry;
import org.alfresco.util.testing.category.NeverRunsTests;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.springframework.extensions.surf.util.I18NUtil;

@Category(value={NeverRunsTests.class})
public class DictionaryDAOTest {
    public static final String TEST_RESOURCE_MESSAGES = "alfresco/messages/dictionary-messages";
    private DictionaryService service;
    private DictionaryDAOImpl dictionaryDAO;

    @Before
    public void setUp() throws Exception {
        I18NUtil.registerResourceBundle((String)TEST_RESOURCE_MESSAGES);
        MultiTServiceImpl tenantService = new MultiTServiceImpl();
        this.dictionaryDAO = new DictionaryDAOImpl();
        this.dictionaryDAO.setTenantService((TenantService)tenantService);
        this.initDictionaryCaches(this.dictionaryDAO, (TenantService)tenantService);
        new AuthenticationUtil().afterPropertiesSet();
        DictionaryBootstrap bootstrap = new DictionaryBootstrap();
        ArrayList<String> bootstrapModels = new ArrayList<String>();
        bootstrapModels.add("alfresco/model/dictionaryModel.xml");
        bootstrapModels.add("alfresco/model/systemModel.xml");
        bootstrapModels.add("alfresco/model/contentModel.xml");
        ArrayList labels = new ArrayList();
        bootstrap.setModels(bootstrapModels);
        bootstrap.setLabels(labels);
        bootstrap.setDictionaryDAO((DictionaryDAO)this.dictionaryDAO);
        bootstrap.setTenantService((TenantService)tenantService);
        bootstrap.bootstrap();
        DictionaryComponent component = new DictionaryComponent();
        component.setDictionaryDAO((DictionaryDAO)this.dictionaryDAO);
        component.setMessageLookup((MessageLookup)new StaticMessageLookup());
        this.service = component;
    }

    private void initDictionaryCaches(DictionaryDAOImpl dictionaryDAO, TenantService tenantService) throws Exception {
        CompiledModelsCache compiledModelsCache = new CompiledModelsCache();
        compiledModelsCache.setDictionaryDAO(dictionaryDAO);
        compiledModelsCache.setTenantService(tenantService);
        compiledModelsCache.setRegistry((AsynchronouslyRefreshedCacheRegistry)new DefaultAsynchronouslyRefreshedCacheRegistry());
        ThreadPoolExecutorFactoryBean threadPoolfactory = new ThreadPoolExecutorFactoryBean();
        threadPoolfactory.afterPropertiesSet();
        compiledModelsCache.setThreadPoolExecutor((ThreadPoolExecutor)threadPoolfactory.getObject());
        dictionaryDAO.setDictionaryRegistryCache(compiledModelsCache);
        dictionaryDAO.init();
    }

    @Test
    public void testBootstrap() throws Exception {
        SingleTServiceImpl tenantService = new SingleTServiceImpl();
        DictionaryDAOImpl dictionaryDAO = new DictionaryDAOImpl();
        dictionaryDAO.setTenantService((TenantService)tenantService);
        this.initDictionaryCaches(dictionaryDAO, (TenantService)tenantService);
        DictionaryBootstrap bootstrap = new DictionaryBootstrap();
        ArrayList<String> bootstrapModels = new ArrayList<String>();
        bootstrapModels.add("alfresco/model/dictionaryModel.xml");
        bootstrap.setModels(bootstrapModels);
        bootstrap.setDictionaryDAO((DictionaryDAO)dictionaryDAO);
        bootstrap.setTenantService((TenantService)tenantService);
        bootstrap.bootstrap();
    }

    @Test
    public void test1() {
        TenantUtil.runAsUserTenant((TenantUtil.TenantRunAsWork)new TenantUtil.TenantRunAsWork<Void>(){

            public Void doWork() throws Exception {
                M2Model customModel = M2Model.createModel((InputStream)Thread.currentThread().getContextClassLoader().getResourceAsStream("dictionary/dictionarydaotest_model1.xml"));
                DictionaryDAOTest.this.dictionaryDAO.putModel(customModel);
                Assert.assertNotNull((Object)DictionaryDAOTest.this.service.getType(ContentModel.TYPE_CONTENT));
                QName qname = QName.createQName((String)"{http://www.alfresco.org/test/dictionarydaotest1/1.0}type1");
                TypeDefinition td = DictionaryDAOTest.this.service.getType(qname);
                Assert.assertNotNull((Object)td);
                return null;
            }
        }, (String)"user1", (String)"tenant1");
        TenantUtil.runAsUserTenant((TenantUtil.TenantRunAsWork)new TenantUtil.TenantRunAsWork<Void>(){

            public Void doWork() throws Exception {
                Assert.assertNotNull((Object)DictionaryDAOTest.this.service.getType(ContentModel.TYPE_CONTENT));
                QName qname = QName.createQName((String)"{http://www.alfresco.org/test/dictionarydaotest1/1.0}type1");
                TypeDefinition td = DictionaryDAOTest.this.service.getType(qname);
                Assert.assertNull((Object)td);
                return null;
            }
        }, (String)"user2", (String)"tenant2");
    }
}

