/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.rule.ruletrigger;

import java.util.Set;
import org.alfresco.model.ContentModel;
import org.alfresco.repo.node.NodeServicePolicies;
import org.alfresco.repo.policy.Behaviour;
import org.alfresco.repo.policy.JavaBehaviour;
import org.alfresco.repo.rule.RuntimeRuleService;
import org.alfresco.repo.rule.ruletrigger.RuleTriggerAbstractBase;
import org.alfresco.repo.transaction.TransactionalResourceHelper;
import org.alfresco.service.cmr.repository.ChildAssociationRef;
import org.alfresco.service.cmr.repository.NodeRef;
import org.alfresco.service.namespace.QName;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class CreateNodeRuleTrigger
extends RuleTriggerAbstractBase
implements NodeServicePolicies.OnCreateNodePolicy {
    private static Log logger = LogFactory.getLog(CreateNodeRuleTrigger.class);
    private static final String POLICY = "onCreateNode";
    private boolean isClassBehaviour = false;
    RuntimeRuleService runtimeRuleService;

    public void setIsClassBehaviour(boolean isClassBehaviour) {
        this.isClassBehaviour = isClassBehaviour;
    }

    public void setRuntimeRuleService(RuntimeRuleService runtimeRuleService) {
        this.runtimeRuleService = runtimeRuleService;
    }

    @Override
    public void registerRuleTrigger() {
        if (this.isClassBehaviour) {
            this.policyComponent.bindClassBehaviour(QName.createQName((String)"http://www.alfresco.org", (String)POLICY), this, (Behaviour)new JavaBehaviour(this, POLICY));
        } else {
            this.policyComponent.bindAssociationBehaviour(QName.createQName((String)"http://www.alfresco.org", (String)POLICY), this, (Behaviour)new JavaBehaviour(this, POLICY));
        }
        for (QName ignoreAspect : this.getIgnoredAspects()) {
            this.policyComponent.bindClassBehaviour(NodeServicePolicies.OnAddAspectPolicy.QNAME, ignoreAspect, (Behaviour)new JavaBehaviour(this, "onAddAspect", Behaviour.NotificationFrequency.EVERY_EVENT));
            this.policyComponent.bindClassBehaviour(NodeServicePolicies.OnRemoveAspectPolicy.QNAME, ignoreAspect, (Behaviour)new JavaBehaviour(this, "onRemoveAspect", Behaviour.NotificationFrequency.EVERY_EVENT));
        }
    }

    @Override
    public void onCreateNode(ChildAssociationRef childAssocRef) {
        if (!this.areRulesEnabled()) {
            return;
        }
        NodeRef nodeRef = childAssocRef.getChildRef();
        Set newNodeRefSet = TransactionalResourceHelper.getSet("RuleTrigger.NewNodes");
        newNodeRefSet.add(nodeRef);
        if (nodeRef != null && this.nodeService.exists(nodeRef) && !this.nodeService.hasAspect(nodeRef, ContentModel.ASPECT_NO_CONTENT)) {
            NodeRef parentNodeRef = childAssocRef.getParentRef();
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("Create node rule trigger fired for parent node " + this.nodeService.getType(parentNodeRef).toString() + " " + String.valueOf(parentNodeRef) + " and child node " + this.nodeService.getType(nodeRef).toString() + " " + String.valueOf(nodeRef)));
            }
            this.triggerRules(parentNodeRef, nodeRef);
        }
    }

    public void onAddAspect(NodeRef nodeRef, QName aspectTypeQName) {
        if (!this.nodeService.exists(nodeRef)) {
            return;
        }
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("Removing the pending rules for the node " + nodeRef.toString() + " since the noContent aspect has been applied."));
        }
        this.runtimeRuleService.removeRulePendingExecution(nodeRef);
    }

    public void onRemoveAspect(NodeRef nodeRef, QName aspectTypeQName) {
        if (!this.nodeService.exists(nodeRef)) {
            return;
        }
        NodeRef parentNodeRef = this.nodeService.getPrimaryParent(nodeRef).getParentRef();
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("Create node rule trigger fired for parent node " + this.nodeService.getType(parentNodeRef).toString() + " " + String.valueOf(parentNodeRef) + " and child node " + this.nodeService.getType(nodeRef).toString() + " " + String.valueOf(nodeRef) + " (this was triggered on removal of the noContent aspect)"));
        }
        if (!this.ignoreTrigger(nodeRef)) {
            this.triggerRules(parentNodeRef, nodeRef);
        }
    }
}

