/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.action.access;

import java.util.Objects;
import java.util.Optional;
import java.util.Properties;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.alfresco.repo.action.ActionModel;
import org.alfresco.repo.action.access.ActionAccessRestriction;
import org.alfresco.repo.rule.RuleModel;
import org.alfresco.service.cmr.action.Action;
import org.alfresco.service.cmr.repository.NodeRef;
import org.alfresco.service.cmr.repository.NodeService;

public abstract class ActionAccessRestrictionAbstractBase
implements ActionAccessRestriction {
    private static final Set<String> CONTROLLED_ACTION_ACCESS_CONTEXT = Set.of("rule", "formProcessor", "v0", "v1");
    protected NodeService nodeService;
    private Properties configProperties;

    public void setNodeService(NodeService nodeService) {
        this.nodeService = nodeService;
    }

    public void setConfigProperties(Properties configProperties) {
        this.configProperties = configProperties;
    }

    @Override
    public void verifyAccessRestriction(Action action) {
        if (this.blockAccessRestriction(action)) {
            return;
        }
        this.innerVerifyAccessRestriction(action);
    }

    protected boolean blockAccessRestriction(Action action) {
        return this.isActionExposed(action) || this.isActionCausedByRule(action);
    }

    protected boolean isActionExposed(Action action) {
        return !this.isActionFromControlledContext(action) || this.isExposedInConfig(action).orElse(Boolean.FALSE) != false;
    }

    private boolean isActionFromControlledContext(Action action) {
        String actionContext = ActionAccessRestriction.getActionContext(action);
        return actionContext != null && CONTROLLED_ACTION_ACCESS_CONTEXT.contains(actionContext);
    }

    private Optional<Boolean> isExposedInConfig(Action action) {
        return this.getConfigKeys(action).map(this.configProperties::getProperty).filter(Objects::nonNull).map(Boolean::parseBoolean).findFirst();
    }

    private Stream<String> getConfigKeys(Action action) {
        String context = ActionAccessRestriction.getActionContext(action);
        String actionName = action.getActionDefinitionName();
        if (context != null) {
            return Stream.of(this.getConfigKey(actionName, context), this.getConfigKey(actionName));
        }
        return Stream.of(this.getConfigKey(actionName));
    }

    private String getConfigKey(String ... parts) {
        return Stream.of(parts).collect(Collectors.joining(".", "org.alfresco.repo.action.", ".exposed"));
    }

    protected boolean isActionCausedByRule(Action action) {
        if (action.getNodeRef() == null) {
            return false;
        }
        NodeRef ruleParent = this.getPotentialRuleParent(action.getNodeRef());
        return this.isRule(ruleParent);
    }

    private NodeRef getPotentialRuleParent(NodeRef nodeRef) {
        NodeRef parentNode = this.nodeService.getPrimaryParent(nodeRef).getParentRef();
        while (this.isCompositeAction(parentNode)) {
            parentNode = this.nodeService.getPrimaryParent(parentNode).getParentRef();
        }
        return parentNode;
    }

    private boolean isCompositeAction(NodeRef nodeRef) {
        return ActionModel.TYPE_COMPOSITE_ACTION.equals((Object)this.nodeService.getType(nodeRef));
    }

    private boolean isRule(NodeRef nodeRef) {
        return RuleModel.TYPE_RULE.equals((Object)this.nodeService.getType(nodeRef));
    }

    protected abstract void innerVerifyAccessRestriction(Action var1);
}

