/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.opencmis;

import org.alfresco.repo.transaction.AlfrescoTransactionSupport;
import org.alfresco.util.transaction.TransactionListener;
import org.alfresco.util.transaction.TransactionListenerAdapter;
import org.apache.chemistry.opencmis.commons.spi.Holder;
import org.springframework.transaction.support.TransactionSynchronizationManager;

public class TransactionAwareHolder<T>
extends Holder<T> {
    private Holder<T> internalHolder;
    private T value;
    private TxAwareHolderListener txListener;

    TransactionAwareHolder(Holder<T> internalHolder) {
        this.internalHolder = internalHolder;
        this.value = internalHolder.getValue();
    }

    public T getValue() {
        this.registerTxListenerIfNeeded();
        return this.value;
    }

    public void setValue(T value) {
        this.registerTxListenerIfNeeded();
        this.value = value;
    }

    public String toString() {
        return "TransactionAwareHolder{internalHolder=" + String.valueOf(this.internalHolder) + ", value=" + String.valueOf(this.value) + "}";
    }

    private void registerTxListenerIfNeeded() {
        if (this.txListener == null && TransactionSynchronizationManager.isSynchronizationActive()) {
            TxAwareHolderListener listener = new TxAwareHolderListener();
            AlfrescoTransactionSupport.bindListener((TransactionListener)listener);
            this.txListener = listener;
        }
    }

    private class TxAwareHolderListener
    extends TransactionListenerAdapter {
        private TxAwareHolderListener() {
        }

        public void afterCommit() {
            TransactionAwareHolder.this.internalHolder.setValue(TransactionAwareHolder.this.getValue());
        }

        public void afterRollback() {
            TransactionAwareHolder.this.setValue(TransactionAwareHolder.this.internalHolder.getValue());
        }
    }
}

