/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.virtual.ref;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.alfresco.repo.virtual.ref.ClasspathResource;
import org.alfresco.repo.virtual.ref.Encoding;
import org.alfresco.repo.virtual.ref.Parameter;
import org.alfresco.repo.virtual.ref.ProtocolMethod;
import org.alfresco.repo.virtual.ref.ProtocolMethodException;
import org.alfresco.repo.virtual.ref.Reference;
import org.alfresco.repo.virtual.ref.RepositoryNodeRef;
import org.alfresco.repo.virtual.ref.RepositoryResource;
import org.alfresco.repo.virtual.ref.Resource;
import org.alfresco.repo.virtual.ref.ResourceParameter;
import org.alfresco.repo.virtual.ref.VirtualProtocol;
import org.alfresco.service.cmr.repository.NodeRef;

public class VanillaProtocol
extends VirtualProtocol {
    private static final long serialVersionUID = -7192024582935232081L;
    public static final int VANILLA_TEMPLATE_PARAM_INDEX = 2;

    public VanillaProtocol() {
        super("vanilla");
    }

    @Override
    public <R> R dispatch(ProtocolMethod<R> method, Reference reference) throws ProtocolMethodException {
        return method.execute(this, reference);
    }

    public Reference newReference(String vanillaProcessorClasspath, String templatePath, NodeRef actualNodeRef, NodeRef templateRef) {
        return this.newReference(new ClasspathResource(vanillaProcessorClasspath), templatePath, actualNodeRef, Arrays.asList(new ResourceParameter(new RepositoryResource(new RepositoryNodeRef(templateRef)))));
    }

    public Reference newReference(Encoding encoding, Resource virtualTemplateResource, String templatePath, Resource actualResource, Resource vanillTemplateResource, List<Parameter> extraParameters) {
        ArrayList<Parameter> parameters = new ArrayList<Parameter>(2);
        parameters.add(new ResourceParameter(vanillTemplateResource));
        parameters.addAll(extraParameters);
        return this.newReference(encoding, virtualTemplateResource, templatePath, actualResource, parameters);
    }

    public Resource getVanillaTemplateResource(Reference reference) {
        ResourceParameter vanillaTemplateParamter = (ResourceParameter)reference.getParameters().get(2);
        Resource resource = (Resource)vanillaTemplateParamter.getValue();
        return resource;
    }

    public Reference newReference(String vanillaProcessorClasspath, String templatePath, NodeRef actualNodeRef, String templateSysPath) throws ProtocolMethodException {
        Resource templateResource = this.createSystemPathResource(templateSysPath);
        if (templateResource != null) {
            return this.newReference(new ClasspathResource(vanillaProcessorClasspath), templatePath, actualNodeRef, Arrays.asList(new ResourceParameter(templateResource)));
        }
        throw new ProtocolMethodException("Invalid template system path : " + templatePath);
    }
}

