/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.forms.processor.workflow;

import java.io.Serializable;
import java.util.List;
import org.alfresco.repo.forms.FormData;
import org.alfresco.repo.forms.processor.node.ContentModelItemData;
import org.alfresco.repo.forms.processor.workflow.DataKeyInfo;
import org.alfresco.repo.forms.processor.workflow.DataKeyMatcher;
import org.alfresco.repo.forms.processor.workflow.FieldType;
import org.alfresco.repo.forms.processor.workflow.FormPersister;
import org.alfresco.repo.forms.processor.workflow.TypedPropertyValueGetter;
import org.alfresco.service.cmr.dictionary.DictionaryService;
import org.alfresco.service.cmr.dictionary.PropertyDefinition;
import org.alfresco.service.cmr.repository.NodeRef;
import org.alfresco.service.namespace.NamespaceService;
import org.alfresco.service.namespace.QName;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public abstract class ContentModelFormPersister<T>
implements FormPersister<T> {
    private static final Log LOGGER = LogFactory.getLog(ContentModelFormPersister.class);
    protected static final TypedPropertyValueGetter valueGetter = new TypedPropertyValueGetter();
    protected final DataKeyMatcher keyMatcher;
    protected final DictionaryService dictionaryService;
    protected final Log logger;
    protected final ContentModelItemData<?> itemData;

    public ContentModelFormPersister(ContentModelItemData<?> itemData, NamespaceService namespaceService, DictionaryService dictionaryService, Log logger) {
        this.dictionaryService = dictionaryService;
        this.logger = logger == null ? LOGGER : logger;
        this.keyMatcher = new DataKeyMatcher(namespaceService);
        this.itemData = itemData;
    }

    @Override
    public void addField(FormData.FieldData fieldData) {
        String dataKeyName = fieldData.getName();
        DataKeyInfo keyInfo = this.keyMatcher.match(dataKeyName);
        if (keyInfo == null) {
            this.logIgnore(fieldData);
        } else {
            boolean wasApplied = this.persistField(fieldData, keyInfo);
            if (!wasApplied) {
                this.logIgnore(fieldData);
            }
        }
    }

    private boolean persistField(FormData.FieldData fieldData, DataKeyInfo keyInfo) {
        switch (keyInfo.getFieldType()) {
            case PROPERTY: {
                return this.addProperty(keyInfo.getQName(), fieldData);
            }
            case TRANSIENT_PROPERTY: {
                return this.updateTransientProperty(keyInfo.getFieldName(), fieldData);
            }
        }
        return this.changeAssociation(keyInfo, fieldData);
    }

    protected boolean updateTransientProperty(String fieldName, FormData.FieldData fieldData) {
        return false;
    }

    protected boolean changeTransientAssociation(String fieldName, List<NodeRef> values, boolean add) {
        if (add) {
            return this.addTransientAssociation(fieldName, values);
        }
        return this.removeTransientAssociation(fieldName, values);
    }

    protected boolean removeTransientAssociation(String fieldName, List<NodeRef> values) {
        return false;
    }

    protected boolean addTransientAssociation(String fieldName, List<NodeRef> values) {
        return false;
    }

    protected boolean addProperty(QName qName, FormData.FieldData fieldData) {
        Object rawValue = fieldData.getValue();
        Serializable value = this.getPropertyValueToPersist(qName, rawValue);
        return this.updateProperty(qName, value);
    }

    protected Serializable getPropertyValueToPersist(QName qName, Object value) {
        PropertyDefinition propDef = this.itemData.getPropertyDefinition(qName);
        if (propDef == null) {
            propDef = this.dictionaryService.getProperty(qName);
        }
        if (propDef != null) {
            return valueGetter.getValue(value, propDef);
        }
        return (Serializable)value;
    }

    protected boolean changeAssociation(DataKeyInfo info, FormData.FieldData fieldData) {
        List values;
        Object rawValue = fieldData.getValue();
        if (rawValue instanceof String && !(values = NodeRef.getNodeRefs((String)((String)rawValue), (Log)LOGGER)).isEmpty()) {
            boolean add = info.isAdd();
            if (info.getFieldType() == FieldType.ASSOCIATION) {
                return this.changeAssociation(info.getQName(), values, add);
            }
            return this.changeTransientAssociation(info.getFieldName(), values, add);
        }
        return false;
    }

    private boolean changeAssociation(QName qName, List<NodeRef> values, boolean add) {
        if (add) {
            return this.addAssociation(qName, values);
        }
        return this.removeAssociation(qName, values);
    }

    protected void logIgnore(FormData.FieldData fieldData) {
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)("Ignoring unrecognized field: " + fieldData.getName()));
        }
    }

    @Override
    public abstract T persist();

    protected abstract boolean removeAssociation(QName var1, List<NodeRef> var2);

    protected abstract boolean addAssociation(QName var1, List<NodeRef> var2);

    protected abstract boolean updateProperty(QName var1, Serializable var2);
}

