/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.filesys.repo;

import jakarta.transaction.UserTransaction;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.Serializable;
import java.net.InetAddress;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import java.util.concurrent.Callable;
import java.util.regex.Pattern;
import org.alfresco.error.AlfrescoRuntimeException;
import org.alfresco.filesys.alfresco.AlfrescoTxDiskDriver;
import org.alfresco.filesys.repo.CacheLookupSearchContext;
import org.alfresco.filesys.repo.CifsHelper;
import org.alfresco.filesys.repo.ContentContext;
import org.alfresco.filesys.repo.ContentFileInfo;
import org.alfresco.filesys.repo.ContentNetworkFile;
import org.alfresco.filesys.repo.ContentSearchContext;
import org.alfresco.filesys.repo.LinkMemoryNetworkFile;
import org.alfresco.filesys.repo.NodeMonitor;
import org.alfresco.filesys.repo.NodeMonitorFactory;
import org.alfresco.filesys.repo.NodeRefNetworkFile;
import org.alfresco.filesys.repo.OpenOfficeContentNetworkFile;
import org.alfresco.jlan.server.SrvSession;
import org.alfresco.jlan.server.core.DeviceContext;
import org.alfresco.jlan.server.core.DeviceContextException;
import org.alfresco.jlan.server.filesys.AccessDeniedException;
import org.alfresco.jlan.server.filesys.DirectoryNotEmptyException;
import org.alfresco.jlan.server.filesys.DiskDeviceContext;
import org.alfresco.jlan.server.filesys.DiskFullException;
import org.alfresco.jlan.server.filesys.DiskInterface;
import org.alfresco.jlan.server.filesys.DiskSizeInterface;
import org.alfresco.jlan.server.filesys.FileExistsException;
import org.alfresco.jlan.server.filesys.FileName;
import org.alfresco.jlan.server.filesys.FileOpenParams;
import org.alfresco.jlan.server.filesys.FileSharingException;
import org.alfresco.jlan.server.filesys.NetworkFile;
import org.alfresco.jlan.server.filesys.SearchContext;
import org.alfresco.jlan.server.filesys.SrvDiskInfo;
import org.alfresco.jlan.server.filesys.TreeConnection;
import org.alfresco.jlan.server.filesys.cache.FileState;
import org.alfresco.jlan.server.filesys.quota.QuotaManager;
import org.alfresco.jlan.server.filesys.quota.QuotaManagerException;
import org.alfresco.jlan.server.locking.FileLockingInterface;
import org.alfresco.jlan.server.locking.LockManager;
import org.alfresco.jlan.server.locking.OpLockInterface;
import org.alfresco.jlan.server.locking.OpLockManager;
import org.alfresco.jlan.smb.server.SMBServer;
import org.alfresco.jlan.smb.server.SMBSrvSession;
import org.alfresco.model.ContentModel;
import org.alfresco.repo.admin.SysAdminParams;
import org.alfresco.repo.node.archive.NodeArchiveService;
import org.alfresco.repo.policy.BehaviourFilter;
import org.alfresco.repo.security.authentication.AuthenticationContext;
import org.alfresco.repo.security.authentication.AuthenticationUtil;
import org.alfresco.repo.transaction.RetryingTransactionHelper;
import org.alfresco.service.cmr.action.Action;
import org.alfresco.service.cmr.action.ActionService;
import org.alfresco.service.cmr.coci.CheckOutCheckInService;
import org.alfresco.service.cmr.dictionary.DictionaryService;
import org.alfresco.service.cmr.lock.LockService;
import org.alfresco.service.cmr.lock.LockType;
import org.alfresco.service.cmr.lock.NodeLockedException;
import org.alfresco.service.cmr.model.FileFolderService;
import org.alfresco.service.cmr.model.FileInfo;
import org.alfresco.service.cmr.repository.AssociationRef;
import org.alfresco.service.cmr.repository.ContentData;
import org.alfresco.service.cmr.repository.ContentIOException;
import org.alfresco.service.cmr.repository.ContentService;
import org.alfresco.service.cmr.repository.InvalidNodeRefException;
import org.alfresco.service.cmr.repository.MimetypeService;
import org.alfresco.service.cmr.repository.NodeRef;
import org.alfresco.service.cmr.repository.NodeService;
import org.alfresco.service.cmr.repository.StoreRef;
import org.alfresco.service.cmr.repository.datatype.DefaultTypeConverter;
import org.alfresco.service.cmr.search.SearchService;
import org.alfresco.service.cmr.security.AccessPermission;
import org.alfresco.service.cmr.security.AccessStatus;
import org.alfresco.service.cmr.security.AuthenticationService;
import org.alfresco.service.cmr.security.OwnableService;
import org.alfresco.service.cmr.security.PermissionService;
import org.alfresco.service.namespace.NamespacePrefixResolver;
import org.alfresco.service.namespace.NamespaceService;
import org.alfresco.service.namespace.QName;
import org.alfresco.service.namespace.QNamePattern;
import org.alfresco.util.Pair;
import org.alfresco.util.PropertyCheck;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.extensions.config.ConfigElement;

public class ContentDiskDriver
extends AlfrescoTxDiskDriver
implements DiskInterface,
FileLockingInterface,
OpLockInterface,
DiskSizeInterface {
    private static final Log logger = LogFactory.getLog(ContentDiskDriver.class);
    private static final String KEY_STORE = "store";
    private static final String KEY_ROOT_PATH = "rootPath";
    private static final String KEY_RELATIVE_PATH = "relativePath";
    public static final int FileUnknown = -1;
    public static final int FileNotExist = 0;
    public static final int FileExists = 1;
    public static final int DirectoryExists = 2;
    public static final int CustomFileStatus = 3;
    public static final int FileRenamed = 3;
    public static final int DeleteOnClose = 4;
    public static final String AttrLinkNode = "ContentLinkNode";
    public static final String CanDeleteWithoutPerms = "CanDeleteWithoutPerms";
    private static QName[] _copyProperties = new QName[]{ContentModel.PROP_AUTHOR, ContentModel.PROP_TITLE, ContentModel.PROP_DESCRIPTION};
    private static Set<String> _excludedNamespaces = new TreeSet<String>(Arrays.asList("http://www.alfresco.org/model/content/1.0", "http://www.alfresco.org/model/system/1.0"));
    private static final int DiskBlockSize = 512;
    private static final long DiskAllocationUnit = 32768L;
    private static final long DiskBlocksPerUnit = 64L;
    protected static final long DiskSizeDefault = 0x10000000000L;
    protected static final long DiskFreeDefault = 0x8000000000L;
    private boolean isReadOnly;
    private boolean isLockedFilesAsOffline;
    private Pattern renameCSVShufflePattern = Pattern.compile(".*[a-f0-9]{8}+$");
    private CifsHelper cifsHelper;
    private NamespaceService namespaceService;
    private NodeService nodeService;
    private CheckOutCheckInService checkOutCheckInService;
    private SearchService searchService;
    private ContentService contentService;
    private MimetypeService mimetypeService;
    private PermissionService permissionService;
    private FileFolderService fileFolderService;
    private NodeArchiveService nodeArchiveService;
    private LockService lockService;
    private DictionaryService dictionaryService;
    private OwnableService ownableService;
    private ActionService actionService;
    private AuthenticationContext authContext;
    private AuthenticationService authService;
    private SysAdminParams sysAdminParams;
    private BehaviourFilter policyBehaviourFilter;
    private NodeMonitorFactory m_nodeMonitorFactory;

    public ContentDiskDriver(CifsHelper cifsHelper) {
        this.cifsHelper = cifsHelper;
    }

    public void init() {
        PropertyCheck.mandatory((Object)this, (String)"nodeService", (Object)this.nodeService);
    }

    public final CifsHelper getCifsHelper() {
        return this.cifsHelper;
    }

    public final AuthenticationService getAuthenticationService() {
        return this.authService;
    }

    public final AuthenticationContext getAuthenticationContext() {
        return this.authContext;
    }

    public final NodeService getNodeService() {
        return this.nodeService;
    }

    public CheckOutCheckInService getCheckOutCheckInService() {
        return this.checkOutCheckInService;
    }

    public final ContentService getContentService() {
        return this.contentService;
    }

    public final NamespaceService getNamespaceService() {
        return this.namespaceService;
    }

    public final SearchService getSearchService() {
        return this.searchService;
    }

    public final FileFolderService getFileFolderService() {
        return this.fileFolderService;
    }

    public final PermissionService getPermissionService() {
        return this.permissionService;
    }

    public final NodeArchiveService getNodeArchiveService() {
        return this.nodeArchiveService;
    }

    public final LockService getLockService() {
        return this.lockService;
    }

    public BehaviourFilter getPolicyFilter() {
        return this.policyBehaviourFilter;
    }

    public final DictionaryService getDictionaryService() {
        return this.dictionaryService;
    }

    public final OwnableService getOwnableService() {
        return this.ownableService;
    }

    public void setContentService(ContentService contentService) {
        this.contentService = contentService;
    }

    public void setNamespaceService(NamespaceService namespaceService) {
        this.namespaceService = namespaceService;
    }

    public void setNodeService(NodeService nodeService) {
        this.nodeService = nodeService;
    }

    public void setCheckOutCheckInService(CheckOutCheckInService checkOutCheckInService) {
        this.checkOutCheckInService = checkOutCheckInService;
    }

    public void setSearchService(SearchService searchService) {
        this.searchService = searchService;
    }

    public void setPermissionService(PermissionService permissionService) {
        this.permissionService = permissionService;
    }

    public void setAuthenticationContext(AuthenticationContext authContext) {
        this.authContext = authContext;
    }

    public void setAuthenticationService(AuthenticationService authService) {
        this.authService = authService;
    }

    public void setSysAdminParams(SysAdminParams sysAdminParams) {
        this.sysAdminParams = sysAdminParams;
    }

    public void setFileFolderService(FileFolderService fileService) {
        this.fileFolderService = fileService;
    }

    public void setMimetypeService(MimetypeService mimetypeService) {
        this.mimetypeService = mimetypeService;
    }

    public void setNodeMonitorFactory(NodeMonitorFactory nodeMonitorFactory) {
        this.m_nodeMonitorFactory = nodeMonitorFactory;
    }

    public void setNodeArchiveService(NodeArchiveService nodeArchiveService) {
        this.nodeArchiveService = nodeArchiveService;
    }

    public void setLockService(LockService lockService) {
        this.lockService = lockService;
    }

    public void setPolicyFilter(BehaviourFilter policyFilter) {
        this.policyBehaviourFilter = policyFilter;
    }

    public void setDictionaryService(DictionaryService dictionaryService) {
        this.dictionaryService = dictionaryService;
    }

    public void setOwnableService(OwnableService ownableService) {
        this.ownableService = ownableService;
    }

    public void setRenameCSVShufflePattern(Pattern renameCSVShufflePattern) {
        this.renameCSVShufflePattern = renameCSVShufflePattern;
    }

    public DeviceContext createContext(String deviceName, ConfigElement cfg) throws DeviceContextException {
        ConfigElement offlineFiles;
        ConfigElement pseudoName;
        ContentContext context = null;
        try {
            ConfigElement storeElement = cfg.getChild(KEY_STORE);
            if (storeElement == null || storeElement.getValue() == null || storeElement.getValue().length() == 0) {
                throw new DeviceContextException("Device missing init value: store");
            }
            String storeValue = storeElement.getValue();
            ConfigElement rootPathElement = cfg.getChild(KEY_ROOT_PATH);
            if (rootPathElement == null || rootPathElement.getValue() == null || rootPathElement.getValue().length() == 0) {
                throw new DeviceContextException("Device missing init value: rootPath");
            }
            String rootPath = rootPathElement.getValue();
            context = new ContentContext();
            context.setDeviceName(deviceName);
            context.setStoreName(storeValue);
            context.setRootPath(rootPath);
            context.setSysAdminParams(this.sysAdminParams);
            ConfigElement relativePathElement = cfg.getChild(KEY_RELATIVE_PATH);
            if (relativePathElement != null) {
                String relPath = relativePathElement.getValue().replace('/', '\\');
                context.setRelativePath(relPath);
            }
        }
        catch (DeviceContextException ex) {
            logger.error((Object)"Error during create context", (Throwable)ex);
            throw ex;
        }
        ConfigElement urlFileElem = cfg.getChild("urlFile");
        if (urlFileElem != null && (pseudoName = urlFileElem.getChild("filename")) != null) {
            context.setURLFileName(pseudoName.getValue());
        }
        if ((offlineFiles = cfg.getChild("offlineFiles")) != null) {
            context.setOfflineFiles(true);
        }
        if (cfg.getChild("disableNodeMonitor") == null) {
            context.setDisableNodeMonitor(true);
        }
        if (cfg.getChild("disableOplocks") != null) {
            context.setDisableOplocks(true);
        }
        this.registerContext((DeviceContext)context);
        return context;
    }

    @Override
    public void registerContext(DeviceContext ctx) throws DeviceContextException {
        super.registerContext(ctx);
        ContentContext context = (ContentContext)ctx;
        UserTransaction tx = this.getTransactionService().getUserTransaction(true);
        try {
            try {
                String storeValue;
                StoreRef storeRef;
                AuthenticationUtil.pushAuthentication();
                AuthenticationUtil.setFullyAuthenticatedUser((String)AuthenticationUtil.getSystemUserName());
                if (tx != null) {
                    tx.begin();
                }
                if (!this.nodeService.exists(storeRef = new StoreRef(storeValue = context.getStoreName()))) {
                    throw new DeviceContextException("Store not created prior to application startup: " + String.valueOf(storeRef));
                }
                NodeRef storeRootNodeRef = this.nodeService.getRootNode(storeRef);
                String rootPath = context.getRootPath();
                List nodeRefs = this.searchService.selectNodes(storeRootNodeRef, rootPath, null, (NamespacePrefixResolver)this.namespaceService, false);
                NodeRef rootNodeRef = null;
                if (nodeRefs.size() > 1) {
                    throw new DeviceContextException("Multiple possible roots for device: \n   root path: " + rootPath + "\n   results: " + String.valueOf(nodeRefs));
                }
                if (nodeRefs.size() == 0) {
                    throw new DeviceContextException("No root found for device: \n   root path: " + rootPath);
                }
                rootNodeRef = (NodeRef)nodeRefs.get(0);
                String relPath = context.getRelativePath();
                if (relPath != null && relPath.length() > 0) {
                    NodeRef relPathNode = this.cifsHelper.getNodeRef(rootNodeRef, relPath);
                    if (!this.cifsHelper.isDirectory(relPathNode)) {
                        throw new DeviceContextException("Relative path is not a folder, " + relPath);
                    }
                    rootNodeRef = relPathNode;
                } else if (!this.cifsHelper.isDirectory(rootNodeRef)) {
                    throw new DeviceContextException("Root node is not a folder type node");
                }
                tx.commit();
                tx = null;
                context.setRootNodeRef(rootNodeRef);
            }
            catch (Exception ex) {
                logger.error((Object)"Error during create context", (Throwable)ex);
                throw new DeviceContextException("unable to register context", (Throwable)ex);
            }
        }
        finally {
            AuthenticationUtil.popAuthentication();
            if (tx != null) {
                try {
                    tx.rollback();
                }
                catch (Exception ex) {
                    logger.warn((Object)"Failed to rollback transaction", (Throwable)ex);
                }
            }
        }
        if (context.getOfflineFiles()) {
            this.isLockedFilesAsOffline = true;
            logger.info((Object)"Locked files will be marked as offline");
        }
        if (!context.getDisableNodeMonitor() && this.m_nodeMonitorFactory != null) {
            NodeMonitor nodeMonitor = this.m_nodeMonitorFactory.createNodeMonitor(context);
            context.setNodeMonitor(nodeMonitor);
        }
        if (context.getDisableOplocks()) {
            logger.warn((Object)("Oplock support disabled for filesystem " + ctx.getDeviceName()));
        }
        if (context.hasQuotaManager()) {
            try {
                context.getQuotaManager().startManager((DiskInterface)this, (DiskDeviceContext)context);
                logger.info((Object)"Quota manager enabled for filesystem");
            }
            catch (QuotaManagerException ex) {
                logger.error((Object)"Failed to start quota manager", (Throwable)ex);
            }
        }
    }

    public boolean isReadOnly(SrvSession sess, DeviceContext ctx) throws IOException {
        return this.isReadOnly;
    }

    public org.alfresco.jlan.server.filesys.FileInfo getFileInformation(SrvSession session, TreeConnection tree, String path) throws IOException {
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("getFileInformation:" + path));
        }
        this.beginReadTransaction(session);
        ContentContext ctx = (ContentContext)tree.getContext();
        NodeRef infoParentNodeRef = ctx.getRootNode();
        if (path == null || path.length() == 0) {
            path = "\\";
        }
        String infoPath = path;
        try {
            ContentFileInfo finfo = null;
            NodeRef nodeRef = this.getNodeForPath(tree, infoPath);
            if (nodeRef != null) {
                finfo = this.cifsHelper.getFileInformation(nodeRef, this.isReadOnly, this.isLockedFilesAsOffline);
                if (logger.isDebugEnabled() && ctx.hasDebug(8)) {
                    logger.debug((Object)("getInfo using cached noderef for path " + path));
                }
            }
            if (finfo == null) {
                String[] paths = FileName.splitPath((String)path);
                if (paths[0] != null && paths[0].length() > 1 && (nodeRef = this.getNodeForPath(tree, paths[0])) != null) {
                    infoParentNodeRef = nodeRef;
                    infoPath = paths[1];
                    if (logger.isDebugEnabled() && ctx.hasDebug(8)) {
                        logger.debug((Object)("getInfo using cached noderef for parent " + path));
                    }
                }
                finfo = this.cifsHelper.getFileInformation(infoParentNodeRef, infoPath, this.isReadOnly, this.isLockedFilesAsOffline);
                if (logger.isDebugEnabled() && ctx.hasDebug(8)) {
                    logger.debug((Object)("Getting file information: path=" + path + " file info: " + String.valueOf((Object)finfo)));
                }
            }
            if (finfo != null) {
                long id = (Long)DefaultTypeConverter.INSTANCE.convert(Long.class, (Object)this.nodeService.getProperty(nodeRef, ContentModel.PROP_NODE_DBID));
                finfo.setFileId((int)(id & 0xFFFFFFFFL));
                FileState fstate = this.getStateForPath(tree, infoPath);
                if (fstate != null) {
                    if (fstate.hasChangeDateTime()) {
                        finfo.setChangeDateTime(fstate.getChangeDateTime());
                    }
                    if (fstate.hasModifyDateTime()) {
                        finfo.setModifyDateTime(fstate.getModifyDateTime());
                    }
                    if (fstate.hasAllocationSize() && fstate.getAllocationSize() > finfo.getSize()) {
                        finfo.setAllocationSize(fstate.getAllocationSize());
                    }
                } else {
                    fstate = ctx.getStateCache().findFileState(path, true);
                    if (finfo.isDirectory()) {
                        fstate.setFileStatus(2);
                    } else {
                        fstate.setFileStatus(1);
                    }
                    fstate.setFilesystemObject((Object)nodeRef);
                }
            }
            return finfo;
        }
        catch (FileNotFoundException e) {
            if (logger.isDebugEnabled() && ctx.hasDebug(8)) {
                logger.debug((Object)("Get file info - file not found, " + path));
            }
            throw e;
        }
        catch (org.alfresco.repo.security.permissions.AccessDeniedException accessDeniedException) {
            if (logger.isDebugEnabled() && ctx.hasDebug(8)) {
                logger.debug((Object)("Get file info - access denied, " + path));
            }
            throw new AccessDeniedException("Get file information " + path);
        }
        catch (RuntimeException ex) {
            if (logger.isDebugEnabled() && ctx.hasDebug(8)) {
                logger.debug((Object)"Get file info error", (Throwable)ex);
            }
            throw new IOException("Get file information " + path);
        }
    }

    public SearchContext startSearch(SrvSession sess, TreeConnection tree, String searchPath, int attributes) throws FileNotFoundException {
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("startSearch: " + searchPath));
        }
        ContentContext ctx = (ContentContext)tree.getContext();
        try {
            long endTime;
            String searchFileSpec = searchPath;
            NodeRef searchRootNodeRef = ctx.getRootNode();
            FileState searchFolderState = null;
            this.beginReadTransaction(sess);
            String[] paths = FileName.splitPath((String)searchPath);
            if (ctx.hasStateCache() && paths[0] != null && paths[0].length() >= 1) {
                NodeRef nodeRef = this.getNodeForPath(tree, paths[0]);
                searchFolderState = this.getStateForPath(tree, paths[0]);
                if (searchFolderState == null) {
                    searchFolderState = ctx.getStateCache().findFileState(paths[0], true);
                }
                if (!searchFolderState.hasFilesystemObject()) {
                    searchFolderState.setFilesystemObject((Object)nodeRef);
                }
                if (nodeRef != null) {
                    searchRootNodeRef = nodeRef;
                    searchFileSpec = paths[1];
                    if (logger.isDebugEnabled() && ctx.hasDebug(4)) {
                        logger.debug((Object)("Search using cached noderef for path " + searchPath));
                    }
                }
            }
            if (searchFileSpec.equals("*.*")) {
                searchFileSpec = "*";
            }
            long startTime = 0L;
            if (logger.isDebugEnabled() && ctx.hasDebug(4)) {
                startTime = System.currentTimeMillis();
            }
            List<NodeRef> results = this.cifsHelper.getNodeRefs(searchRootNodeRef, searchFileSpec);
            if (logger.isDebugEnabled() && ctx.hasDebug(4) && (endTime = System.currentTimeMillis()) - startTime > 500L) {
                logger.debug((Object)("Search for searchPath=" + searchPath + ", searchSpec=" + searchFileSpec + ", searchRootNode=" + String.valueOf(searchRootNodeRef) + " took " + (endTime - startTime) + "ms results=" + results.size()));
            }
            ContentSearchContext searchCtx = null;
            if (searchFileSpec.equals("*")) {
                CacheLookupSearchContext cacheContext = new CacheLookupSearchContext(this.cifsHelper, results, searchFileSpec, paths[0], ctx.getStateCache(), this.isLockedFilesAsOffline);
                searchCtx = cacheContext;
                if (searchFolderState != null && searchFolderState.hasFilesystemObject()) {
                    ContentFileInfo finfo = this.cifsHelper.getFileInformation((NodeRef)searchFolderState.getFilesystemObject(), this.isReadOnly, this.isLockedFilesAsOffline);
                    if (searchFolderState != null) {
                        if (searchFolderState.hasAccessDateTime()) {
                            finfo.setAccessDateTime(searchFolderState.getAccessDateTime());
                        }
                        if (searchFolderState.hasChangeDateTime()) {
                            finfo.setChangeDateTime(searchFolderState.getChangeDateTime());
                        }
                        if (searchFolderState.hasModifyDateTime()) {
                            finfo.setModifyDateTime(searchFolderState.getModifyDateTime());
                        }
                    }
                    cacheContext.setDotInfo(finfo);
                    if (searchFolderState.getPath().equals("\\")) {
                        org.alfresco.jlan.server.filesys.FileInfo dotDotInfo = new org.alfresco.jlan.server.filesys.FileInfo();
                        dotDotInfo.copyFrom((org.alfresco.jlan.server.filesys.FileInfo)finfo);
                        cacheContext.setDotDotInfo(dotDotInfo);
                    } else {
                        int pos;
                        String parentPath = searchFolderState.getPath();
                        if (parentPath.endsWith("\\") && parentPath.length() > 1) {
                            parentPath = parentPath.substring(0, parentPath.length() - 1);
                        }
                        if ((pos = parentPath.lastIndexOf("\\")) != -1) {
                            parentPath = parentPath.substring(0, pos + 1);
                        }
                        FileState parentState = ctx.getStateCache().findFileState(parentPath);
                        NodeRef parentNode = null;
                        if (parentState != null) {
                            parentNode = (NodeRef)parentState.getFilesystemObject();
                        }
                        if (parentState == null || parentNode == null) {
                            parentNode = this.getNodeForPath(tree, parentPath);
                        }
                        finfo = this.cifsHelper.getFileInformation(parentNode, this.isReadOnly, this.isLockedFilesAsOffline);
                        if (parentState != null) {
                            if (parentState.hasAccessDateTime()) {
                                finfo.setAccessDateTime(parentState.getAccessDateTime());
                            }
                            if (parentState.hasChangeDateTime()) {
                                finfo.setChangeDateTime(parentState.getChangeDateTime());
                            }
                            if (parentState.hasModifyDateTime()) {
                                finfo.setModifyDateTime(parentState.getModifyDateTime());
                            }
                        }
                        cacheContext.setDotDotInfo(finfo);
                    }
                }
            } else {
                searchCtx = ctx.hasStateCache() ? new CacheLookupSearchContext(this.cifsHelper, results, searchFileSpec, paths[0], ctx.getStateCache(), this.isLockedFilesAsOffline) : new ContentSearchContext(this.cifsHelper, results, searchFileSpec, paths[0], this.isLockedFilesAsOffline);
            }
            if (logger.isDebugEnabled() && ctx.hasDebug(4)) {
                logger.debug((Object)("Started search: search path=" + searchPath + " attributes=" + attributes + ", ctx=" + String.valueOf(searchCtx)));
            }
            return searchCtx;
        }
        catch (org.alfresco.repo.security.permissions.AccessDeniedException accessDeniedException) {
            if (logger.isDebugEnabled() && ctx.hasDebug(4)) {
                logger.debug((Object)("Start search - access denied, " + searchPath));
            }
            throw new FileNotFoundException("Start search " + searchPath);
        }
        catch (RuntimeException ex) {
            if (logger.isDebugEnabled() && ctx.hasDebug(4)) {
                logger.debug((Object)"Start search", (Throwable)ex);
            }
            throw new FileNotFoundException("Start search " + searchPath);
        }
    }

    public int fileExists(SrvSession sess, TreeConnection tree, String name) {
        ContentContext ctx = (ContentContext)tree.getContext();
        int status = -1;
        FileState fstate = null;
        try {
            if (ctx.hasStateCache()) {
                fstate = ctx.getStateCache().findFileState(name, true);
            }
            if (fstate != null && fstate.getFileStatus() != -1) {
                status = fstate.getFileStatus();
                if (status >= 3) {
                    status = 0;
                }
                if (logger.isDebugEnabled() && ctx.hasDebug(8)) {
                    logger.debug((Object)("Cache hit - fileExists() " + name + ", sts=" + status));
                }
            } else if (status == -1) {
                this.beginReadTransaction(sess);
                org.alfresco.jlan.server.filesys.FileInfo info = this.getFileInformation(sess, tree, name);
                NodeRef nodeRef = this.getNodeOrNull(name, ctx, fstate);
                NodeRef nodeRef2 = nodeRef = nodeRef == null && info instanceof ContentFileInfo ? ((ContentFileInfo)info).getNodeRef() : nodeRef;
                status = nodeRef == null || !this.fileFolderService.exists(nodeRef) ? 0 : (info.isDirectory() ? 2 : 1);
                if (fstate != null) {
                    fstate.setFileStatus(status);
                }
            }
        }
        catch (FileNotFoundException fileNotFoundException) {
            status = 0;
            if (fstate != null) {
                fstate.setFileStatus(status);
            }
        }
        catch (IOException e) {
            if (logger.isDebugEnabled() && ctx.hasDebug(8)) {
                logger.debug((Object)("File exists error, " + name), (Throwable)e);
            }
            status = 0;
        }
        if (logger.isDebugEnabled() && ctx.hasDebug(8)) {
            logger.debug((Object)("File status determined: name=" + name + " status=" + this.fileStatusString(fstate.getFileStatus())));
        }
        return status;
    }

    public NetworkFile openFile(SrvSession sess, TreeConnection tree, FileOpenParams params) throws IOException {
        this.beginReadTransaction(sess);
        ContentContext ctx = (ContentContext)tree.getContext();
        try {
            NodeRef nodeRef = this.getNodeForPath(tree, params.getPath());
            if (params.hasAccessMode(1) && this.permissionService.hasPermission(nodeRef, "Read") == AccessStatus.DENIED) {
                throw new AccessDeniedException("No read access to " + params.getFullPath());
            }
            if (params.hasAccessMode(2) && this.permissionService.hasPermission(nodeRef, "Write") == AccessStatus.DENIED) {
                throw new AccessDeniedException("No write access to " + params.getFullPath());
            }
            String lockTypeStr = (String)((Object)this.nodeService.getProperty(nodeRef, ContentModel.PROP_LOCK_TYPE));
            if (params.hasAccessMode(2) && lockTypeStr != null) {
                throw new AccessDeniedException("File is locked, no write access to " + params.getFullPath());
            }
            FileState fstate = null;
            if (ctx.hasStateCache()) {
                fstate = ctx.getStateCache().findFileState(params.getPath());
                if (fstate != null) {
                    if (!fstate.exists()) {
                        throw new FileNotFoundException();
                    }
                } else {
                    fstate = ctx.getStateCache().findFileState(params.getPath(), true);
                }
                boolean nosharing = false;
                String noshrReason = null;
                if (params.getAccessMode() == 1180063 && !params.getPath().toLowerCase().endsWith(".exe")) {
                    if (logger.isDebugEnabled() && ctx.hasDebug(1)) {
                        logger.debug((Object)("Execute access mode, path" + params.getPath()));
                        logger.debug((Object)("  Fstate=" + String.valueOf(fstate)));
                    }
                    throw new AccessDeniedException("Invalid access mode");
                }
                if (fstate.getOpenCount() > 0 && !params.isAttributesOnlyAccess()) {
                    if (params.getSecurityLevel() == 2 && params.getProcessId() == fstate.getProcessId()) {
                        nosharing = false;
                    } else if (params.isReadOnlyAccess() && (fstate.getSharedAccess() & 1) != 0) {
                        nosharing = false;
                    } else if ((params.isReadWriteAccess() || params.isWriteOnlyAccess()) && (fstate.getSharedAccess() & 2) == 0) {
                        nosharing = true;
                        noshrReason = "Sharing mode disallows write";
                        if (logger.isDebugEnabled() && ctx.hasDebug(1)) {
                            logger.debug((Object)("Sharing mode disallows write access path=" + params.getPath()));
                        }
                    } else if (fstate.getSharedAccess() == 0) {
                        nosharing = true;
                        noshrReason = "Sharing mode exclusive";
                    } else if ((fstate.getSharedAccess() & params.getSharedAccess()) != params.getSharedAccess()) {
                        nosharing = true;
                        noshrReason = "Sharing mode mismatch";
                        if (logger.isDebugEnabled() && ctx.hasDebug(1)) {
                            logger.debug((Object)("Local share mode=0x" + Integer.toHexString(fstate.getSharedAccess()) + ", params share mode=0x" + Integer.toHexString(params.getSharedAccess())));
                        }
                    } else if (params.getSharedAccess() == 0) {
                        nosharing = true;
                        noshrReason = "Requestor wants exclusive mode";
                    }
                }
                if (nosharing && !params.getPath().equals("\\")) {
                    if (logger.isDebugEnabled() && ctx.hasDebug(1)) {
                        logger.debug((Object)("Sharing violation path=" + params.getPath() + ", sharing=0x" + Integer.toHexString(fstate.getSharedAccess()) + ",reason=" + noshrReason));
                    }
                    throw new FileSharingException("File already open, " + params.getPath());
                }
                fstate.setSharedAccess(params.getSharedAccess());
                fstate.setProcessId(params.getProcessId());
                if (logger.isDebugEnabled() && fstate.getOpenCount() == 0 && ctx.hasDebug(1)) {
                    logger.debug((Object)("Path " + params.getPath() + ", sharing=0x" + Integer.toHexString(params.getSharedAccess()) + ", PID=" + params.getProcessId()));
                }
            }
            NodeRef linkRef = (NodeRef)this.nodeService.getProperty(nodeRef, ContentModel.PROP_LINK_DESTINATION);
            NodeRefNetworkFile netFile = null;
            if (linkRef == null) {
                if (tree.openFileCount() > 0 && !params.isAttributesOnlyAccess()) {
                    int idx = 0;
                    while (idx < tree.getFileTableLength() && netFile == null) {
                        ContentNetworkFile contentFile;
                        NetworkFile curFile = tree.findFile(idx);
                        if (curFile != null && curFile instanceof ContentNetworkFile && (contentFile = (ContentNetworkFile)curFile).getProcessId() == params.getProcessId() && contentFile.getFullName().equalsIgnoreCase(params.getFullPath())) {
                            if (params.isReadWriteAccess() && contentFile.getGrantedAccess() == 3 || params.isReadOnlyAccess() && contentFile.getGrantedAccess() == 1) {
                                netFile = contentFile;
                                contentFile.incrementOpenCount();
                                if (logger.isDebugEnabled() && ctx.hasDebug(1)) {
                                    logger.debug((Object)("Re-use existing file open Path " + params.getPath() + ", PID=" + params.getProcessId() + ", params=" + (params.isReadOnlyAccess() ? "ReadOnly" : "Write") + ", file=" + (contentFile.getGrantedAccess() <= 1 ? "ReadOnly" : "Write")));
                                }
                            } else if (logger.isDebugEnabled() && ctx.hasDebug(1)) {
                                logger.debug((Object)("Not re-using file path=" + params.getPath() + ", readWrite=" + (params.isReadWriteAccess() ? "true" : "false") + ", readOnly=" + (params.isReadOnlyAccess() ? "true" : "false") + ", grantedAccess=" + contentFile.getGrantedAccessAsString()));
                            }
                        }
                        ++idx;
                    }
                }
                if (netFile == null) {
                    netFile = ContentNetworkFile.createFile(this.nodeService, this.contentService, this.mimetypeService, this.cifsHelper, nodeRef, params.getPath(), params.isReadOnlyAccess(), params.isAttributesOnlyAccess(), sess);
                }
            } else {
                String srvName = null;
                SMBServer cifsServer = (SMBServer)sess.getServer().getConfiguration().findServer("CIFS");
                if (sess instanceof SMBSrvSession) {
                    SMBSrvSession smbSess = (SMBSrvSession)sess;
                    srvName = smbSess.getShareHostName();
                } else {
                    srvName = cifsServer != null ? cifsServer.getServerName() : InetAddress.getLocalHost().getHostName();
                }
                String path = this.getPathForNode(tree, linkRef);
                path = path.replace('\\', '/');
                StringBuilder urlStr = new StringBuilder();
                urlStr.append("[InternetShortcut]\r\n");
                urlStr.append("URL=file://");
                urlStr.append(srvName);
                urlStr.append("/");
                urlStr.append(tree.getSharedDevice().getName());
                urlStr.append(path);
                urlStr.append("\r\n");
                byte[] urlData = urlStr.toString().getBytes();
                ContentFileInfo fInfo = this.cifsHelper.getFileInformation(nodeRef, this.isReadOnly, this.isLockedFilesAsOffline);
                fInfo.setFileSize(urlData.length);
                netFile = new LinkMemoryNetworkFile(fInfo.getFileName(), urlData, fInfo, nodeRef);
                netFile.setFullName(params.getPath());
            }
            if (netFile != null) {
                long id = (Long)DefaultTypeConverter.INSTANCE.convert(Long.class, (Object)this.nodeService.getProperty(nodeRef, ContentModel.PROP_NODE_DBID));
                netFile.setFileId((int)(id & 0xFFFFFFFFL));
                netFile.setClosed(false);
            }
            if (params.isOverwrite() && netFile != null) {
                netFile.truncateFile(0L);
            }
            if (ctx.hasStateCache()) {
                if (fstate == null) {
                    fstate = ctx.getStateCache().findFileState(params.getPath(), true);
                }
                if (netFile.getGrantedAccess() > 0) {
                    fstate.incrementOpenCount();
                }
                fstate.setFilesystemObject((Object)nodeRef);
                netFile.setFileState(fstate);
                if (fstate.hasFileSize()) {
                    netFile.setFileSize(fstate.getFileSize());
                }
            }
            if (logger.isDebugEnabled() && ctx.hasDebug(1)) {
                logger.debug((Object)("Opened network file: path=" + params.getPath() + " file open parameters=" + String.valueOf(params) + " network file=" + String.valueOf(netFile)));
            }
            return netFile;
        }
        catch (org.alfresco.repo.security.permissions.AccessDeniedException accessDeniedException) {
            if (logger.isDebugEnabled() && ctx.hasDebug(1)) {
                logger.debug((Object)("Open file - access denied, " + params.getFullPath()));
            }
            throw new AccessDeniedException("Open file " + params.getFullPath());
        }
        catch (RuntimeException ex) {
            if (logger.isDebugEnabled() && ctx.hasDebug(1)) {
                logger.debug((Object)"Open file error", (Throwable)ex);
            }
            throw new IOException("Open file " + params.getFullPath());
        }
    }

    public NetworkFile createFile(SrvSession sess, final TreeConnection tree, final FileOpenParams params) throws IOException {
        final ContentContext ctx = (ContentContext)tree.getContext();
        try {
            NodeRef nodeRef;
            Pair<String, NodeRef> result = this.doInWriteTransaction(sess, new AlfrescoTxDiskDriver.CallableIO<Pair<String, NodeRef>>(){

                @Override
                public Pair<String, NodeRef> call() throws IOException {
                    NodeRef nodeRef;
                    String parentPath;
                    block6: {
                        String[] paths;
                        NodeRef deviceRootNodeRef = ctx.getRootNode();
                        String path = params.getPath();
                        parentPath = null;
                        if (ctx.hasStateCache() && (paths = FileName.splitPath((String)path))[0] != null && paths[0].length() > 1) {
                            NodeRef nodeRef2 = ContentDiskDriver.this.getNodeForPath(tree, paths[0]);
                            if (nodeRef2 != null) {
                                deviceRootNodeRef = nodeRef2;
                                path = paths[1];
                                if (logger.isDebugEnabled() && ctx.hasDebug(1)) {
                                    logger.debug((Object)("Create file using cached noderef for path " + paths[0]));
                                }
                            }
                            parentPath = paths[0];
                        }
                        if (logger.isDebugEnabled()) {
                            logger.debug((Object)("create new file" + path));
                        }
                        nodeRef = null;
                        try {
                            nodeRef = ContentDiskDriver.this.cifsHelper.createNode(deviceRootNodeRef, path, ContentModel.TYPE_CONTENT);
                            ContentDiskDriver.this.nodeService.addAspect(nodeRef, ContentModel.ASPECT_NO_CONTENT, null);
                        }
                        catch (FileExistsException ex) {
                            nodeRef = ContentDiskDriver.this.cifsHelper.getNodeRef(deviceRootNodeRef, path);
                            if (ContentDiskDriver.this.nodeService.hasAspect(nodeRef, ContentModel.ASPECT_SOFT_DELETE)) break block6;
                            throw ex;
                        }
                    }
                    return new Pair(parentPath, (Object)nodeRef);
                }
            });
            FileState parentState = null;
            String parentPath = (String)result.getFirst();
            if (parentPath != null && (parentState = this.getStateForPath(tree, parentPath)) == null && ctx.hasStateCache()) {
                parentState = ctx.getStateCache().findFileState(parentPath, true);
            }
            if ((nodeRef = (NodeRef)result.getSecond()) != null && this.nodeService.hasAspect(nodeRef, ContentModel.ASPECT_SOFT_DELETE)) {
                this.nodeService.removeAspect(nodeRef, ContentModel.ASPECT_SOFT_DELETE);
            }
            ContentNetworkFile netFile = ContentNetworkFile.createFile(this.nodeService, this.contentService, this.mimetypeService, this.cifsHelper, (NodeRef)result.getSecond(), params.getPath(), params.isReadOnlyAccess(), params.isAttributesOnlyAccess(), sess);
            netFile.setGrantedAccess(3);
            netFile.setProcessId(params.getProcessId());
            netFile.truncateFile(0L);
            netFile.setClosed(false);
            if (netFile != null) {
                long id = (Long)DefaultTypeConverter.INSTANCE.convert(Long.class, (Object)this.nodeService.getProperty(netFile.getNodeRef(), ContentModel.PROP_NODE_DBID));
                netFile.setFileId((int)(id & 0xFFFFFFFFL));
            }
            if (ctx.hasStateCache()) {
                FileState fstate = ctx.getStateCache().findFileState(params.getPath(), true);
                if (fstate != null) {
                    fstate.setSharedAccess(params.getSharedAccess());
                    fstate.setProcessId(params.getProcessId());
                    fstate.setFileStatus(1);
                    fstate.incrementOpenCount();
                    fstate.setFilesystemObject(result.getSecond());
                    fstate.setAllocationSize(params.getAllocationSize());
                    netFile.setFileState(fstate);
                    if (logger.isDebugEnabled() && ctx.hasDebug(1)) {
                        logger.debug((Object)("Create file, state=" + String.valueOf(fstate)));
                    }
                }
                if (parentState != null) {
                    parentState.updateModifyDateTime();
                }
            }
            if (logger.isDebugEnabled() && ctx.hasDebug(1)) {
                logger.debug((Object)("Created file: path=" + params.getPath() + " file open parameters=" + String.valueOf(params) + " node=" + String.valueOf(result.getSecond()) + " network file=" + String.valueOf(netFile)));
            }
            return netFile;
        }
        catch (org.alfresco.repo.security.permissions.AccessDeniedException accessDeniedException) {
            if (logger.isDebugEnabled() && ctx.hasDebug(1)) {
                logger.debug((Object)("Create file - access denied, " + params.getFullPath()));
            }
            throw new AccessDeniedException("Create file " + params.getFullPath());
        }
        catch (ContentIOException contentIOException) {
            if (logger.isDebugEnabled() && ctx.hasDebug(1)) {
                logger.debug((Object)("Create file - content I/O error, " + params.getFullPath()));
            }
            throw new DiskFullException("Create file " + params.getFullPath());
        }
        catch (RuntimeException ex) {
            if (logger.isDebugEnabled() && ctx.hasDebug(1)) {
                logger.debug((Object)"Create file error", (Throwable)ex);
            }
            throw new IOException("Create file " + params.getFullPath(), ex);
        }
    }

    public void createDirectory(SrvSession sess, final TreeConnection tree, final FileOpenParams params) throws IOException {
        final ContentContext ctx = (ContentContext)tree.getContext();
        try {
            Pair<String, NodeRef> result = this.doInWriteTransaction(sess, new AlfrescoTxDiskDriver.CallableIO<Pair<String, NodeRef>>(){

                @Override
                public Pair<String, NodeRef> call() throws IOException {
                    String[] paths;
                    NodeRef deviceRootNodeRef = ctx.getRootNode();
                    String path = params.getPath();
                    String parentPath = null;
                    if (ctx.hasStateCache() && (paths = FileName.splitPath((String)path))[0] != null && paths[0].length() > 1) {
                        NodeRef nodeRef = ContentDiskDriver.this.getNodeForPath(tree, paths[0]);
                        if (nodeRef != null) {
                            deviceRootNodeRef = nodeRef;
                            path = paths[1];
                            if (logger.isDebugEnabled() && ctx.hasDebug(1)) {
                                logger.debug((Object)("Create file using cached noderef for path " + paths[0]));
                            }
                        }
                        parentPath = paths[0];
                    }
                    NodeRef nodeRef = ContentDiskDriver.this.cifsHelper.createNode(deviceRootNodeRef, path, ContentModel.TYPE_FOLDER);
                    return new Pair(parentPath, (Object)nodeRef);
                }
            });
            FileState parentState = null;
            String parentPath = (String)result.getFirst();
            if (parentPath != null && (parentState = this.getStateForPath(tree, parentPath)) == null && ctx.hasStateCache()) {
                parentState = ctx.getStateCache().findFileState(parentPath, true);
            }
            if (ctx.hasStateCache()) {
                FileState fstate = ctx.getStateCache().findFileState(params.getPath(), true);
                if (fstate != null) {
                    fstate.setFileStatus(2);
                    fstate.setFilesystemObject(result.getSecond());
                    if (logger.isDebugEnabled() && ctx.hasDebug(1)) {
                        logger.debug((Object)("Create folder, state=" + String.valueOf(fstate)));
                    }
                }
                if (parentState != null) {
                    parentState.updateModifyDateTime();
                }
            }
            if (logger.isDebugEnabled() && ctx.hasDebug(1)) {
                logger.debug((Object)("Created directory: path=" + params.getPath() + " file open params=" + String.valueOf(params) + " node=" + String.valueOf(result.getSecond())));
            }
        }
        catch (org.alfresco.repo.security.permissions.AccessDeniedException accessDeniedException) {
            if (logger.isDebugEnabled() && ctx.hasDebug(1)) {
                logger.debug((Object)("Create directory - access denied, " + params.getFullPath()));
            }
            throw new AccessDeniedException("Create directory " + params.getFullPath());
        }
        catch (RuntimeException ex) {
            if (logger.isDebugEnabled() && ctx.hasDebug(1)) {
                logger.debug((Object)"Create directory error", (Throwable)ex);
            }
            throw new IOException("Create directory " + params.getFullPath(), ex);
        }
    }

    public void deleteDirectory(SrvSession sess, TreeConnection tree, final String dir) throws IOException {
        ContentContext ctx = (ContentContext)tree.getContext();
        final NodeRef deviceRootNodeRef = ctx.getRootNode();
        try {
            NodeRef nodeRef = this.doInWriteTransaction(sess, new AlfrescoTxDiskDriver.CallableIO<NodeRef>(){

                @Override
                public NodeRef call() throws IOException {
                    NodeRef nodeRef = ContentDiskDriver.this.cifsHelper.getNodeRef(deviceRootNodeRef, dir);
                    if (ContentDiskDriver.this.fileFolderService.exists(nodeRef)) {
                        if (ContentDiskDriver.this.cifsHelper.isFolderEmpty(nodeRef)) {
                            ContentDiskDriver.this.fileFolderService.delete(nodeRef);
                            return nodeRef;
                        }
                        throw new DirectoryNotEmptyException(dir);
                    }
                    return null;
                }
            });
            if (nodeRef != null && ctx.hasStateCache()) {
                ctx.getStateCache().removeFileState(dir);
                String[] paths = FileName.splitPath((String)dir);
                if (paths[0] != null && paths[0].length() > 1) {
                    FileState parentState = this.getStateForPath(tree, paths[0]);
                    if (parentState == null && ctx.hasStateCache()) {
                        parentState = ctx.getStateCache().findFileState(paths[0], true);
                    }
                    parentState.updateModifyDateTime();
                }
            }
            if (logger.isDebugEnabled() && ctx.hasDebug(1)) {
                logger.debug((Object)("Deleted directory: directory=" + dir + " node=" + String.valueOf(nodeRef)));
            }
        }
        catch (FileNotFoundException fileNotFoundException) {
            if (logger.isDebugEnabled() && ctx.hasDebug(1)) {
                logger.debug((Object)("Delete directory - file not found, " + dir));
            }
        }
        catch (org.alfresco.repo.security.permissions.AccessDeniedException accessDeniedException) {
            if (logger.isDebugEnabled() && ctx.hasDebug(1)) {
                logger.debug((Object)("Delete directory - access denied, " + dir));
            }
            throw new AccessDeniedException("Delete directory " + dir);
        }
        catch (RuntimeException ex) {
            if (logger.isDebugEnabled() && ctx.hasDebug(1)) {
                logger.debug((Object)"Delete directory", (Throwable)ex);
            }
            throw new IOException("Delete directory " + dir);
        }
    }

    public void flushFile(SrvSession sess, TreeConnection tree, NetworkFile file) throws IOException {
        ContentContext ctx = (ContentContext)tree.getContext();
        if (logger.isDebugEnabled() && ctx.hasDebug(2)) {
            logger.debug((Object)("Flush file=" + file.getFullName()));
        }
        file.flushFile();
    }

    public void closeFile(SrvSession sess, TreeConnection tree, final NetworkFile file) throws IOException {
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("Close file: file" + String.valueOf(file)));
        }
        final ContentContext ctx = (ContentContext)tree.getContext();
        FileState toUpdate = null;
        if (file instanceof ContentNetworkFile) {
            ContentNetworkFile contentFile;
            FileState fstate;
            if (ctx.hasStateCache() && (fstate = ctx.getStateCache().findFileState(file.getFullName())) != null) {
                if (file.getGrantedAccess() > 0 && fstate.decrementOpenCount() == 0) {
                    fstate.setSharedAccess(7);
                }
                if (file.hasOpLock()) {
                    ContentDiskDriver flIface = this;
                    OpLockManager oplockMgr = flIface.getOpLockManager(sess, tree);
                    oplockMgr.releaseOpLock(file.getOpLock().getPath());
                    if (logger.isDebugEnabled()) {
                        logger.debug((Object)("Released oplock for closed file, file=" + file.getFullName()));
                    }
                }
                if (!file.hasDeleteOnClose() && fstate.hasModifyDateTime() && fstate.hasFilesystemObject() && !fstate.isDirectory()) {
                    toUpdate = fstate;
                }
            }
            if ((contentFile = (ContentNetworkFile)file).decrementOpenCount() > 0) {
                if (logger.isDebugEnabled() && ctx.hasDebug(1)) {
                    logger.debug((Object)("Deferred file close, path=" + file.getFullName() + ", openCount=" + contentFile.getOpenCount()));
                }
                return;
            }
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("Last reference to file, closing, path=" + file.getFullName() + ", access=" + file.getGrantedAccessAsString() + ", fid=" + file.getProtocolId() + ", modified=" + contentFile.isModified()));
            }
        }
        long fileSize = 0L;
        if (ctx.hasQuotaManager() && file.hasDeleteOnClose() && file instanceof ContentNetworkFile) {
            ContentNetworkFile contentFile = (ContentNetworkFile)file;
            if (!contentFile.hasContent()) {
                contentFile.openContent(false, false);
            }
            fileSize = contentFile.getFileSize();
        }
        AlfrescoTxDiskDriver.CallableIO<Void> errorHandler = new AlfrescoTxDiskDriver.CallableIO<Void>(){

            @Override
            public Void call() throws IOException {
                NodeRef nodeRef;
                if (file instanceof NodeRefNetworkFile && ContentDiskDriver.this.nodeService.exists(nodeRef = ((NodeRefNetworkFile)file).getNodeRef()) && ContentDiskDriver.this.nodeService.hasAspect(nodeRef, ContentModel.ASPECT_NO_CONTENT)) {
                    logger.debug((Object)"No content - delete");
                    ContentDiskDriver.this.fileFolderService.delete(nodeRef);
                }
                return null;
            }
        };
        try {
            final FileState finalFileState = toUpdate;
            Pair<NodeRef, Boolean> result = this.doInWriteTransaction(sess, new AlfrescoTxDiskDriver.CallableIO<Pair<NodeRef, Boolean>>(){

                @Override
                public Pair<NodeRef, Boolean> call() throws IOException {
                    OpenOfficeContentNetworkFile ooFile;
                    if (file instanceof OpenOfficeContentNetworkFile && (ooFile = (OpenOfficeContentNetworkFile)file).truncatedToZeroLength()) {
                        ContentDiskDriver.this.getPolicyFilter().disableBehaviour(ContentModel.ASPECT_VERSIONABLE);
                        if (logger.isDebugEnabled() && ctx.hasDebug(1)) {
                            logger.debug((Object)("OpenOffice file truncation update only, inhibit versioning, " + file.getFullName()));
                        }
                    }
                    if (finalFileState != null && file instanceof ContentNetworkFile) {
                        NodeRef nodeRef = (NodeRef)finalFileState.getFilesystemObject();
                        ContentNetworkFile contentFile = (ContentNetworkFile)file;
                        if (!contentFile.isModified() && ContentDiskDriver.this.nodeService.hasAspect(nodeRef, ContentModel.ASPECT_VERSIONABLE)) {
                            ContentDiskDriver.this.getPolicyFilter().disableBehaviour(ContentModel.ASPECT_VERSIONABLE);
                            if (logger.isDebugEnabled() && ctx.hasDebug(1)) {
                                logger.debug((Object)("Timestamp update only, inhibit versioning, " + file.getFullName()));
                            }
                        }
                        ContentDiskDriver.this.getPolicyFilter().disableBehaviour(nodeRef, ContentModel.ASPECT_AUDITABLE);
                        if (ContentDiskDriver.this.permissionService.hasPermission((NodeRef)finalFileState.getFilesystemObject(), "WriteProperties") == AccessStatus.ALLOWED) {
                            ContentDiskDriver.this.nodeService.setProperty(nodeRef, ContentModel.PROP_MODIFIER, (Serializable)((Object)ContentDiskDriver.this.authService.getCurrentUserName()));
                            Date modifyDate = new Date(finalFileState.getModifyDateTime());
                            ContentDiskDriver.this.nodeService.setProperty(nodeRef, ContentModel.PROP_MODIFIED, (Serializable)modifyDate);
                            if (logger.isDebugEnabled() && ctx.hasDebug(1)) {
                                logger.debug((Object)("Updated modification timestamp, " + file.getFullName() + ", modTime=" + String.valueOf(modifyDate)));
                            }
                        }
                    }
                    file.close();
                    if (file.hasDeleteOnClose()) {
                        NodeRefNetworkFile nodeNetFile;
                        NodeRef nodeRef;
                        logger.debug((Object)"File has delete on close");
                        if (file instanceof NodeRefNetworkFile && ContentDiskDriver.this.fileFolderService.exists(nodeRef = (nodeNetFile = (NodeRefNetworkFile)file).getNodeRef())) {
                            try {
                                boolean isVersionable;
                                block18: {
                                    isVersionable = ContentDiskDriver.this.nodeService.hasAspect(nodeRef, ContentModel.ASPECT_VERSIONABLE);
                                    try {
                                        FileState fileState = ctx.getStateCache().findFileState(file.getFullName());
                                        if (fileState != null && fileState.findAttribute(ContentDiskDriver.CanDeleteWithoutPerms) != null) {
                                            AuthenticationUtil.runAs((AuthenticationUtil.RunAsWork)new AuthenticationUtil.RunAsWork<Object>(){

                                                public Object doWork() throws Exception {
                                                    logger.debug((Object)("delete as system" + String.valueOf(nodeRef)));
                                                    (this).ContentDiskDriver.this.fileFolderService.delete(nodeRef);
                                                    return null;
                                                }
                                            }, (String)AuthenticationUtil.getSystemUserName());
                                        } else {
                                            logger.debug((Object)("delete nodeRef:" + String.valueOf(nodeRef)));
                                            ContentDiskDriver.this.fileFolderService.delete(nodeRef);
                                        }
                                    }
                                    catch (Exception ex) {
                                        logger.debug((Object)"on delete on close", (Throwable)ex);
                                        if (RetryingTransactionHelper.extractRetryCause(ex) != null) {
                                            if (ex instanceof RuntimeException) {
                                                throw (RuntimeException)ex;
                                            }
                                            throw new AlfrescoRuntimeException("Error during delete on close, " + file.getFullName(), (Throwable)ex);
                                        }
                                        if (!logger.isWarnEnabled() || !ctx.hasDebug(1)) break block18;
                                        logger.warn((Object)("Error during delete on close, " + file.getFullName()), (Throwable)ex);
                                    }
                                }
                                return new Pair((Object)nodeRef, (Object)isVersionable);
                            }
                            catch (org.alfresco.repo.security.permissions.AccessDeniedException accessDeniedException) {
                                if (logger.isDebugEnabled() && ctx.hasDebug(1)) {
                                    logger.debug((Object)("Delete on close - access denied, " + file.getFullName()));
                                }
                                throw new AccessDeniedException("Delete on close " + file.getFullName());
                            }
                        }
                    }
                    return null;
                }
            });
            if (result != null) {
                if (ctx.hasQuotaManager()) {
                    ctx.getQuotaManager().releaseSpace(sess, tree, file.getFileId(), file.getFullName(), fileSize);
                }
                if (ctx.hasStateCache()) {
                    if (((Boolean)result.getSecond()).booleanValue()) {
                        FileState fState = ctx.getStateCache().findFileState(file.getFullName(), true);
                        fState.setFileStatus(4);
                        fState.setExpiryTime(System.currentTimeMillis() + 60000L);
                        fState.setFilesystemObject(result.getFirst());
                    } else {
                        ctx.getStateCache().removeFileState(file.getFullName());
                    }
                }
            }
            if (logger.isDebugEnabled() && (ctx.hasDebug(1) || ctx.hasDebug(64))) {
                logger.debug((Object)("Closed file: network file=" + String.valueOf(file) + " delete on close=" + file.hasDeleteOnClose()));
                if (!file.hasDeleteOnClose() && file instanceof ContentNetworkFile) {
                    ContentNetworkFile cFile = (ContentNetworkFile)file;
                    logger.debug((Object)("  File " + file.getFullName() + ", version=" + String.valueOf(this.nodeService.getProperty(cFile.getNodeRef(), ContentModel.PROP_VERSION_LABEL))));
                }
            }
        }
        catch (IOException e) {
            try {
                this.doInWriteTransaction(sess, errorHandler);
            }
            catch (Throwable t) {
                logger.error((Object)t.getMessage(), t);
            }
            throw e;
        }
        catch (RuntimeException e) {
            try {
                this.doInWriteTransaction(sess, errorHandler);
            }
            catch (Throwable t) {
                logger.error((Object)t.getMessage(), t);
            }
            throw e;
        }
        catch (Error e) {
            try {
                this.doInWriteTransaction(sess, errorHandler);
            }
            catch (Throwable t) {
                logger.error((Object)t.getMessage(), t);
            }
            throw e;
        }
    }

    public void deleteFile(final SrvSession sess, final TreeConnection tree, final String name) throws IOException {
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("Delete file - " + name));
        }
        final ContentContext ctx = (ContentContext)tree.getContext();
        try {
            final QuotaManager quotaMgr = ctx.getQuotaManager();
            Callable<Void> postTxn = this.doInWriteTransaction(sess, new AlfrescoTxDiskDriver.CallableIO<Callable<Void>>(){

                @Override
                public Callable<Void> call() throws IOException {
                    final NodeRef nodeRef = ContentDiskDriver.this.getNodeForPath(tree, name);
                    Callable<Void> result = null;
                    if (ContentDiskDriver.this.fileFolderService.exists(nodeRef)) {
                        final org.alfresco.jlan.server.filesys.FileInfo fInfo = quotaMgr == null ? null : ContentDiskDriver.this.getFileInformation(sess, tree, name);
                        final boolean isVersionable = ContentDiskDriver.this.nodeService.hasAspect(nodeRef, ContentModel.ASPECT_VERSIONABLE);
                        if (logger.isDebugEnabled()) {
                            logger.debug((Object)("deleted file" + name));
                        }
                        ContentDiskDriver.this.fileFolderService.delete(nodeRef);
                        result = new Callable<Void>(){

                            @Override
                            public Void call() throws Exception {
                                if (ctx.hasStateCache()) {
                                    if (isVersionable) {
                                        FileState delState = ctx.getStateCache().findFileState(name, true);
                                        if (logger.isDebugEnabled()) {
                                            logger.debug((Object)("set delete on close" + name));
                                        }
                                        delState.setExpiryTime(System.currentTimeMillis() + 15000L);
                                        delState.setFileStatus(4);
                                        delState.setFilesystemObject((Object)nodeRef);
                                    } else {
                                        ctx.getStateCache().removeFileState(name);
                                    }
                                    String[] paths = FileName.splitPath((String)name);
                                    if (paths[0] != null && paths[0].length() > 1) {
                                        FileState parentState = ContentDiskDriver.this.getStateForPath(tree, paths[0]);
                                        if (parentState == null && ctx.hasStateCache()) {
                                            parentState = ctx.getStateCache().findFileState(paths[0], true);
                                        }
                                        parentState.updateModifyDateTime();
                                    }
                                }
                                if (quotaMgr != null) {
                                    quotaMgr.releaseSpace(sess, tree, fInfo.getFileId(), name, fInfo.getSize());
                                }
                                return null;
                            }
                        };
                    }
                    if (logger.isDebugEnabled() && (ctx.hasDebug(1) || ctx.hasDebug(64))) {
                        logger.debug((Object)("Deleted file: " + name + ", node=" + String.valueOf(nodeRef)));
                    }
                    return result;
                }
            });
            postTxn.call();
        }
        catch (NodeLockedException nodeLockedException) {
            if (logger.isDebugEnabled() && ctx.hasDebug(1)) {
                logger.debug((Object)"Delete file - access denied (locked)");
            }
            throw new AccessDeniedException("Delete " + name);
        }
        catch (org.alfresco.repo.security.permissions.AccessDeniedException accessDeniedException) {
            if (logger.isDebugEnabled() && ctx.hasDebug(1)) {
                logger.debug((Object)"Delete file - access denied");
            }
            throw new AccessDeniedException("Delete " + name);
        }
        catch (IOException ex) {
            throw ex;
        }
        catch (Exception ex) {
            if (logger.isDebugEnabled() && ctx.hasDebug(1)) {
                logger.debug((Object)"Delete file error", (Throwable)ex);
            }
            IOException ioe = new IOException("Delete file " + name);
            ioe.initCause(ex);
            throw ioe;
        }
    }

    public void renameFile(final SrvSession sess, final TreeConnection tree, final String oldName, final String newName) throws IOException {
        this.beginReadTransaction(sess);
        final ContentContext ctx = (ContentContext)tree.getContext();
        if (logger.isDebugEnabled() && ctx.hasDebug(64)) {
            logger.debug((Object)("Rename oldName=" + oldName + ", newName=" + newName));
        }
        try {
            final NodeRef nodeToMoveRef = this.getNodeForPath(tree, oldName);
            if (nodeToMoveRef != null && this.nodeService.getProperty(nodeToMoveRef, ContentModel.PROP_LINK_DESTINATION) != null) {
                throw new AccessDeniedException("Cannot rename link nodes");
            }
            String[] splitPaths = FileName.splitPath((String)newName);
            String[] oldPaths = FileName.splitPath((String)oldName);
            final NodeRef targetFolderRef = this.getNodeForPath(tree, splitPaths[0]);
            final NodeRef sourceFolderRef = this.getNodeForPath(tree, oldPaths[0]);
            final String name = splitPaths[1];
            final boolean sameFolder = splitPaths[0].equalsIgnoreCase(oldPaths[0]);
            final FileState oldState = ctx.getStateCache().findFileState(oldName, true);
            boolean isFolder = this.cifsHelper.isDirectory(nodeToMoveRef);
            if (isFolder || !sameFolder) {
                this.doInWriteTransaction(sess, new AlfrescoTxDiskDriver.CallableIO<Void>(){

                    @Override
                    public Void call() throws IOException {
                        if (sameFolder) {
                            ContentDiskDriver.this.cifsHelper.rename(nodeToMoveRef, name);
                        } else {
                            ContentDiskDriver.this.cifsHelper.move(nodeToMoveRef, sourceFolderRef, targetFolderRef, name);
                        }
                        return null;
                    }
                });
                if (oldState != null) {
                    ctx.getStateCache().renameFileState(newName, oldState, isFolder);
                }
                if (logger.isDebugEnabled() && ctx.hasDebug(64)) {
                    logger.debug((Object)("  Renamed " + (isFolder ? "folder" : "file") + " using " + (sameFolder ? "rename" : "move")));
                }
            } else {
                final int newExists = this.fileExists(sess, tree, newName);
                final FileState newState = ctx.getStateCache().findFileState(newName, true);
                List<Runnable> postTxn = this.doInWriteTransaction(sess, new AlfrescoTxDiskDriver.CallableIO<List<Runnable>>(){

                    @Override
                    public List<Runnable> call() throws IOException {
                        LinkedList<Runnable> postTxn = new LinkedList<Runnable>();
                        NodeRef targetNodeRef = null;
                        boolean isFromVersionable = ContentDiskDriver.this.nodeService.hasAspect(nodeToMoveRef, ContentModel.ASPECT_VERSIONABLE);
                        boolean typesCompatible = true;
                        Pattern renameShufflePattern = ctx.getRenameShufflePattern();
                        boolean renameShuffle = ContentDiskDriver.this.isRenameShuffle(oldName, newName, renameShufflePattern);
                        if (logger.isDebugEnabled()) {
                            logger.debug((Object)("Rename file: \n   Old name:      " + oldName + "\n   New name:      " + newName + "\n   Pattern:       " + renameShufflePattern.pattern() + "\n   Is shuffle:    " + renameShuffle + "\n   Source folder: " + String.valueOf(sourceFolderRef) + "\n   Target folder: " + String.valueOf(targetFolderRef) + "\n   Node:          " + String.valueOf(nodeToMoveRef) + "\n   Aspects:       " + String.valueOf(ContentDiskDriver.this.nodeService.getAspects(nodeToMoveRef))));
                        }
                        if (newExists == 1) {
                            targetNodeRef = ContentDiskDriver.this.getNodeForPath(tree, newName);
                        } else if (renameShuffle) {
                            logger.debug((Object)"is rename shuffle");
                            if (newState.getFileStatus() == 3) {
                                QName newType;
                                logger.debug((Object)"file status == FileRenamed");
                                if (logger.isDebugEnabled() && ctx.hasDebug(64)) {
                                    logger.debug((Object)("  Using renamed node, " + String.valueOf(newState)));
                                }
                                NodeRef newStateNode = (NodeRef)newState.getFilesystemObject();
                                QName oldType = ContentDiskDriver.this.nodeService.getType(nodeToMoveRef);
                                if (oldType.equals((Object)(newType = ContentDiskDriver.this.nodeService.getType(newStateNode)))) {
                                    ContentDiskDriver.this.cloneNode(name, newStateNode, nodeToMoveRef, ctx);
                                } else {
                                    logger.debug((Object)"not renamed, must create new node");
                                    targetNodeRef = ContentDiskDriver.this.cifsHelper.createNode(ctx.getRootNode(), newName, newType);
                                    typesCompatible = false;
                                    if (logger.isDebugEnabled() && ctx.hasDebug(64)) {
                                        logger.debug((Object)("  Created new node for " + newName + " type " + String.valueOf(newType) + ", isFromVersionable=false"));
                                    }
                                    ContentDiskDriver.this.cloneNode(name, newStateNode, targetNodeRef, ctx);
                                }
                                String newStateNodeName = (String)((Object)ContentDiskDriver.this.nodeService.getProperty(newStateNode, ContentModel.PROP_NAME));
                                FileState stateForTmp = ctx.getStateCache().findFileState(newName.substring(0, newName.lastIndexOf("\\")) + "\\" + newStateNodeName, true);
                                stateForTmp.addAttribute(ContentDiskDriver.CanDeleteWithoutPerms, (Object)true);
                                stateForTmp.setFileStatus(1);
                                stateForTmp.setExpiryTime(System.currentTimeMillis() + 15000L);
                                if (logger.isDebugEnabled() && ctx.hasDebug(64)) {
                                    logger.debug((Object)("  Set CanDeleteWithoutPerms=true for " + String.valueOf(stateForTmp)));
                                }
                            } else if (newState.getFileStatus() == 4) {
                                logger.debug((Object)"file state is delete on close");
                                if (logger.isDebugEnabled() && ctx.hasDebug(64)) {
                                    logger.debug((Object)("  Restoring delete-on-close node, " + String.valueOf(newState)));
                                }
                                NodeRef archivedNode = ContentDiskDriver.this.getNodeArchiveService().getArchivedNode((NodeRef)newState.getFilesystemObject());
                                if (logger.isDebugEnabled() && ctx.hasDebug(64)) {
                                    logger.debug((Object)("  Found archived node " + String.valueOf(archivedNode)));
                                }
                                if (archivedNode != null && ContentDiskDriver.this.getNodeService().exists(archivedNode)) {
                                    NodeRef linkNode;
                                    targetNodeRef = ContentDiskDriver.this.getNodeService().restoreNode(archivedNode, null, null, null);
                                    if (logger.isDebugEnabled() && ctx.hasDebug(64)) {
                                        logger.debug((Object)("  Restored node " + String.valueOf(targetNodeRef) + ", version=" + String.valueOf(ContentDiskDriver.this.nodeService.getProperty(targetNodeRef, ContentModel.PROP_VERSION_LABEL))));
                                    }
                                    if ((linkNode = (NodeRef)newState.findAttribute(ContentDiskDriver.AttrLinkNode)) != null && ContentDiskDriver.this.nodeService.exists(linkNode)) {
                                        ContentDiskDriver.this.cloneNode(name, linkNode, targetNodeRef, ctx);
                                        if (logger.isDebugEnabled() && ctx.hasDebug(64)) {
                                            logger.debug((Object)("  Moved aspects from linked node " + String.valueOf(linkNode)));
                                            NodeRef mainNodeRef = ContentDiskDriver.this.checkOutCheckInService.getCheckedOut(targetNodeRef);
                                            if (mainNodeRef != null) {
                                                LockType lockTyp = ContentDiskDriver.this.lockService.getLockType(mainNodeRef);
                                                logger.debug((Object)("  Main node ref lock type = " + String.valueOf((Object)lockTyp)));
                                            }
                                        }
                                    }
                                }
                            } else if (isFromVersionable) {
                                logger.debug((Object)"from node is versionable");
                                targetNodeRef = ContentDiskDriver.this.cifsHelper.createNode(ctx.getRootNode(), newName, ContentDiskDriver.this.nodeService.getType(nodeToMoveRef));
                                if (logger.isDebugEnabled() && ctx.hasDebug(64)) {
                                    logger.debug((Object)("  Created new node for " + newName + ", isFromVersionable=true"));
                                }
                                ContentDiskDriver.this.cloneNode(name, nodeToMoveRef, targetNodeRef, ctx);
                                FileState stateForTmp = ctx.getStateCache().findFileState(newName, true);
                                stateForTmp.addAttribute(ContentDiskDriver.CanDeleteWithoutPerms, (Object)true);
                                stateForTmp.setFileStatus(1);
                                stateForTmp.setExpiryTime(System.currentTimeMillis() + 15000L);
                                if (logger.isDebugEnabled() && ctx.hasDebug(64)) {
                                    logger.debug((Object)("  Set CanDeleteWithoutPerms=true for " + String.valueOf(stateForTmp)));
                                }
                            }
                        }
                        if (!renameShuffle || !isFromVersionable && typesCompatible && (targetNodeRef == null || !ContentDiskDriver.this.nodeService.hasAspect(targetNodeRef, ContentModel.ASPECT_VERSIONABLE))) {
                            logger.debug((Object)"do simple rename");
                            ContentDiskDriver.this.cifsHelper.rename(nodeToMoveRef, name);
                            postTxn.add(new Runnable(){

                                @Override
                                public void run() {
                                    newState.setFileStatus(1);
                                    newState.setFilesystemObject((Object)nodeToMoveRef);
                                    newState.setFileSize(oldState.getFileSize());
                                    newState.updateModifyDateTime(oldState.getModifyDateTime());
                                    oldState.setExpiryTime(System.currentTimeMillis() + 15000L);
                                    oldState.setFileStatus(3);
                                    oldState.setFilesystemObject((Object)nodeToMoveRef);
                                }
                            });
                            if (logger.isDebugEnabled() && ctx.hasDebug(64)) {
                                logger.debug((Object)("  Use standard rename for " + name + "(versionable=" + isFromVersionable + ", targetNodeRef=" + String.valueOf(targetNodeRef) + ")"));
                            }
                        } else {
                            if (targetNodeRef == null) {
                                if (logger.isDebugEnabled() && ctx.hasDebug(64)) {
                                    logger.debug((Object)"  No target node for rename");
                                }
                                throw new AccessDeniedException("No target node for file rename");
                            }
                            ContentDiskDriver.this.copyContentData(sess, tree, nodeToMoveRef, targetNodeRef, newName);
                            final NodeRef finalTargetNodeRef = targetNodeRef;
                            postTxn.add(new Runnable(){

                                @Override
                                public void run() {
                                    newState.setFileStatus(1);
                                    newState.setFilesystemObject((Object)finalTargetNodeRef);
                                    newState.setFileSize(oldState.getFileSize());
                                    newState.updateModifyDateTime(oldState.getModifyDateTime());
                                    oldState.setExpiryTime(System.currentTimeMillis() + 15000L);
                                    oldState.setFileStatus(4);
                                    oldState.setFilesystemObject((Object)nodeToMoveRef);
                                    oldState.addAttribute(ContentDiskDriver.AttrLinkNode, (Object)finalTargetNodeRef);
                                    if (logger.isDebugEnabled() && ctx.hasDebug(64)) {
                                        logger.debug((Object)("  Cached delete state for " + oldName));
                                    }
                                }
                            });
                            logger.debug((Object)"delete the old file");
                            if (renameShuffle && isFromVersionable && ContentDiskDriver.this.permissionService.hasPermission(nodeToMoveRef, "Editor") == AccessStatus.ALLOWED) {
                                AuthenticationUtil.runAs((AuthenticationUtil.RunAsWork)new AuthenticationUtil.RunAsWork<Object>(){

                                    public Object doWork() throws Exception {
                                        if (logger.isDebugEnabled()) {
                                            logger.debug((Object)("Rename shuffle for versioning content is assumed. Deleting " + String.valueOf(nodeToMoveRef) + " as system user"));
                                        }
                                        if ((this).ContentDiskDriver.this.renameCSVShufflePattern.matcher(newName.toLowerCase()).matches()) {
                                            Map props = Collections.emptyMap();
                                            (this).ContentDiskDriver.this.nodeService.addAspect(nodeToMoveRef, ContentModel.ASPECT_SOFT_DELETE, props);
                                        } else {
                                            (this).ContentDiskDriver.this.nodeService.deleteNode(nodeToMoveRef);
                                        }
                                        return null;
                                    }
                                }, (String)AuthenticationUtil.getSystemUserName());
                            } else {
                                if (logger.isDebugEnabled()) {
                                    logger.debug((Object)("Deleting " + String.valueOf(nodeToMoveRef) + " as user: " + AuthenticationUtil.getFullyAuthenticatedUser()));
                                }
                                ContentDiskDriver.this.nodeService.deleteNode(nodeToMoveRef);
                            }
                        }
                        return postTxn;
                    }
                });
                logger.debug((Object)"running post txns");
                for (Runnable runnable : postTxn) {
                    runnable.run();
                }
            }
        }
        catch (org.alfresco.repo.security.permissions.AccessDeniedException accessDeniedException) {
            if (logger.isDebugEnabled() && ctx.hasDebug(64)) {
                logger.debug((Object)("Rename file - access denied, " + oldName));
            }
            throw new AccessDeniedException("Rename file " + oldName);
        }
        catch (NodeLockedException ex) {
            if (logger.isDebugEnabled() && ctx.hasDebug(64)) {
                logger.debug((Object)"Rename file", (Throwable)((Object)ex));
            }
            throw new AccessDeniedException("Node locked " + oldName);
        }
        catch (InvalidNodeRefException ex) {
            if (logger.isDebugEnabled() && ctx.hasDebug(64)) {
                logger.debug((Object)("Rename file - file doesn't exist, " + oldName), (Throwable)ex);
            }
            throw new FileNotFoundException("File doesn't exist " + oldName);
        }
        catch (RuntimeException ex) {
            logger.error((Object)("Unable to rename file" + oldName), (Throwable)ex);
            throw new AccessDeniedException("Rename file " + oldName);
        }
    }

    public void setFileInformation(SrvSession sess, final TreeConnection tree, final String name, final org.alfresco.jlan.server.filesys.FileInfo info) throws IOException {
        final ContentContext ctx = (ContentContext)tree.getContext();
        try {
            final FileState fstate = this.getStateForPath(tree, name);
            this.doInWriteTransaction(sess, new AlfrescoTxDiskDriver.CallableIO<Pair<Boolean, Boolean>>(){

                @Override
                public Pair<Boolean, Boolean> call() throws IOException {
                    NodeRef nodeRef = ContentDiskDriver.this.getNodeForPath(tree, name);
                    if (ContentDiskDriver.this.permissionService.hasPermission(nodeRef, "Write") == AccessStatus.DENIED) {
                        throw new AccessDeniedException("No write access to " + name);
                    }
                    ContentDiskDriver.this.getPolicyFilter().disableBehaviour(ContentModel.ASPECT_VERSIONABLE);
                    if (info.hasSetFlag(1024) && info.hasDeleteOnClose()) {
                        String lockTypeStr;
                        if (AccessStatus.DENIED == ContentDiskDriver.this.permissionService.hasPermission(nodeRef, "Delete") && (fstate == null || fstate.findAttribute(ContentDiskDriver.CanDeleteWithoutPerms) == null)) {
                            throw new org.alfresco.repo.security.permissions.AccessDeniedException("No delete access to " + name);
                        }
                        if (ContentDiskDriver.this.nodeService.hasAspect(nodeRef, ContentModel.ASPECT_LOCKABLE) && (lockTypeStr = (String)((Object)ContentDiskDriver.this.nodeService.getProperty(nodeRef, ContentModel.PROP_LOCK_TYPE))) != null) {
                            throw new org.alfresco.repo.security.permissions.AccessDeniedException("Node locked, cannot mark for delete");
                        }
                        if (ContentDiskDriver.this.fileFolderService.exists(nodeRef)) {
                            boolean isFolder = true;
                            if (fstate != null) {
                                isFolder = fstate.isDirectory();
                            } else {
                                ContentFileInfo cInfo = ContentDiskDriver.this.cifsHelper.getFileInformation(nodeRef, ContentDiskDriver.this.isReadOnly, ContentDiskDriver.this.isLockedFilesAsOffline);
                                if (cInfo != null && !cInfo.isDirectory()) {
                                    isFolder = false;
                                }
                            }
                            if (isFolder && !ContentDiskDriver.this.cifsHelper.isFolderEmpty(nodeRef)) {
                                throw new DirectoryNotEmptyException(name);
                            }
                        }
                        if (logger.isDebugEnabled() && ctx.hasDebug(8)) {
                            logger.debug((Object)("Set deleteOnClose=true file=" + name));
                        }
                    }
                    HashMap<QName, Date> auditableProps = new HashMap<QName, Date>(5);
                    if (info.hasSetFlag(16)) {
                        Date createDate = new Date(info.getCreationDateTime());
                        auditableProps.put(ContentModel.PROP_CREATED, createDate);
                    }
                    if (info.hasSetFlag(8)) {
                        Date modifyDate = new Date(info.getModifyDateTime());
                        auditableProps.put(ContentModel.PROP_MODIFIED, modifyDate);
                    }
                    if (auditableProps.size() > 0) {
                        ContentDiskDriver.this.getPolicyFilter().disableBehaviour(nodeRef, ContentModel.ASPECT_AUDITABLE);
                        ContentDiskDriver.this.nodeService.addProperties(nodeRef, auditableProps);
                        if (logger.isDebugEnabled() && ctx.hasDebug(8)) {
                            logger.debug((Object)("Set auditable props: " + String.valueOf(auditableProps) + " file=" + name));
                        }
                    }
                    return null;
                }
            });
            if (fstate != null) {
                if (info.hasSetFlag(1024) && info.hasDeleteOnClose() || info.hasSetFlag(16)) {
                    fstate.updateChangeDateTime();
                }
                if (info.hasSetFlag(8)) {
                    fstate.updateChangeDateTime();
                    Date modifyDate = new Date(info.getModifyDateTime());
                    fstate.updateModifyDateTime(modifyDate.getTime());
                }
            }
        }
        catch (org.alfresco.repo.security.permissions.AccessDeniedException ex) {
            if (logger.isDebugEnabled() && ctx.hasDebug(8)) {
                logger.debug((Object)("Set file information - access denied, " + name), (Throwable)((Object)ex));
            }
            throw new AccessDeniedException("Set file information " + name);
        }
        catch (RuntimeException ex) {
            if (logger.isDebugEnabled() && ctx.hasDebug(8)) {
                logger.debug((Object)"Open file error", (Throwable)ex);
            }
            throw new IOException("Set file information " + name);
        }
    }

    public void truncateFile(SrvSession sess, TreeConnection tree, NetworkFile file, long size) throws IOException {
        FileState fstate;
        ContentNetworkFile contentFile;
        ContentContext ctx = (ContentContext)tree.getContext();
        long allocSize = 0L;
        long releaseSize = 0L;
        QuotaManager quotaMgr = ctx.getQuotaManager();
        if (ctx.hasQuotaManager()) {
            if (file instanceof ContentNetworkFile) {
                contentFile = (ContentNetworkFile)file;
                if (!contentFile.hasContent()) {
                    contentFile.openContent(false, false);
                }
            } else {
                throw new IOException("Invalid file class type, " + file.getClass().getName());
            }
            if (size > file.getFileSize()) {
                allocSize = size - file.getFileSize();
                quotaMgr.allocateSpace(sess, tree, file, allocSize);
            } else {
                releaseSize = file.getFileSize() - size;
            }
        }
        if (file instanceof ContentNetworkFile && (fstate = (contentFile = (ContentNetworkFile)file).getFileState()) != null && size > fstate.getAllocationSize()) {
            fstate.setAllocationSize(size);
        }
        try {
            file.truncateFile(size);
        }
        catch (IOException ex) {
            if (allocSize > 0L && quotaMgr != null) {
                quotaMgr.releaseSpace(sess, tree, file.getFileId(), null, allocSize);
            }
            throw ex;
        }
        if (releaseSize > 0L && quotaMgr != null) {
            quotaMgr.releaseSpace(sess, tree, file.getFileId(), null, releaseSize);
        }
        if (logger.isDebugEnabled() && ctx.hasDebug(2)) {
            logger.debug((Object)("Truncated file: network file=" + String.valueOf(file) + " size=" + size));
        }
    }

    public int readFile(SrvSession sess, TreeConnection tree, NetworkFile file, byte[] buffer, int bufferPosition, int size, long fileOffset) throws IOException {
        int count;
        ContentNetworkFile contentFile;
        if (file.isDirectory()) {
            throw new AccessDeniedException();
        }
        if (file instanceof ContentNetworkFile && !(contentFile = (ContentNetworkFile)file).hasContent()) {
            this.beginReadTransaction(sess);
        }
        if ((count = file.readFile(buffer, size, bufferPosition, fileOffset)) == -1) {
            count = 0;
        }
        ContentContext ctx = (ContentContext)tree.getContext();
        if (logger.isDebugEnabled() && ctx.hasDebug(2)) {
            logger.debug((Object)("Read bytes from file: network file=" + String.valueOf(file) + " buffer size=" + buffer.length + " buffer pos=" + bufferPosition + " size=" + size + " file offset=" + fileOffset + " bytes read=" + count));
        }
        return count;
    }

    public long seekFile(SrvSession sess, TreeConnection tree, NetworkFile file, long pos, int typ) throws IOException {
        if (file.isDirectory()) {
            throw new AccessDeniedException();
        }
        ContentNetworkFile contentFile = (ContentNetworkFile)file;
        if (!contentFile.hasContent()) {
            this.beginReadTransaction(sess);
        }
        return file.seekFile(pos, typ);
    }

    public int writeFile(SrvSession sess, TreeConnection tree, NetworkFile file, byte[] buffer, int bufferOffset, int size, long fileOffset) throws IOException {
        ContentNetworkFile contentFile;
        if (file instanceof ContentNetworkFile && !(contentFile = (ContentNetworkFile)file).hasContent()) {
            this.beginReadTransaction(sess);
        }
        ContentContext ctx = (ContentContext)tree.getContext();
        QuotaManager quotaMgr = ctx.getQuotaManager();
        long curSize = file.getFileSize();
        if (quotaMgr != null) {
            long extendSize = 0L;
            long endOfWrite = fileOffset + (long)size;
            if (endOfWrite > curSize) {
                extendSize = endOfWrite - file.getFileSize();
                quotaMgr.allocateSpace(sess, tree, file, extendSize);
            }
        }
        file.writeFile(buffer, size, bufferOffset, fileOffset);
        if (quotaMgr != null && file.getFileSize() < curSize) {
            quotaMgr.releaseSpace(sess, tree, file.getFileId(), file.getFullName(), curSize - file.getFileSize());
        }
        if (logger.isDebugEnabled() && ctx.hasDebug(2)) {
            logger.debug((Object)("Wrote bytes to file: network file=" + String.valueOf(file) + " buffer size=" + buffer.length + " size=" + size + " file offset=" + fileOffset));
        }
        return size;
    }

    public NodeRef getNodeForPath(TreeConnection tree, String path) throws FileNotFoundException {
        FileState fstate;
        ContentContext ctx = (ContentContext)tree.getContext();
        NodeRef result = null;
        if (ctx.hasStateCache() && (result = this.getNodeOrNull(path, ctx, fstate = ctx.getStateCache().findFileState(path))) != null) {
            return result;
        }
        return this.cifsHelper.getNodeRef(ctx.getRootNode(), path);
    }

    private NodeRef getNodeOrNull(String path, ContentContext ctx, FileState fstate) {
        if (fstate != null && fstate.hasFilesystemObject() && fstate.exists()) {
            if (this.fileFolderService.exists((NodeRef)fstate.getFilesystemObject())) {
                fstate.setExpiryTime(System.currentTimeMillis() + 120000L);
                return (NodeRef)fstate.getFilesystemObject();
            }
            ctx.getStateCache().removeFileState(path);
        }
        return null;
    }

    public String getPathForNode(TreeConnection tree, NodeRef nodeRef) throws FileNotFoundException {
        ContentContext ctx = (ContentContext)tree.getContext();
        List<FileInfo> linkPaths = null;
        try {
            linkPaths = this.fileFolderService.getNamePath(ctx.getRootNode(), nodeRef);
        }
        catch (org.alfresco.service.cmr.model.FileNotFoundException fileNotFoundException) {
            throw new FileNotFoundException();
        }
        StringBuilder pathStr = new StringBuilder();
        for (FileInfo fInfo : linkPaths) {
            pathStr.append('\\');
            pathStr.append(fInfo.getName());
        }
        return pathStr.toString();
    }

    public FileState getStateForPath(TreeConnection tree, String path) throws FileNotFoundException {
        ContentContext ctx = (ContentContext)tree.getContext();
        FileState fstate = null;
        if (ctx.hasStateCache()) {
            fstate = ctx.getStateCache().findFileState(path);
        }
        return fstate;
    }

    public void treeClosed(SrvSession sess, TreeConnection tree) {
    }

    public void treeOpened(SrvSession sess, TreeConnection tree) {
    }

    public LockManager getLockManager(SrvSession sess, TreeConnection tree) {
        ContentContext ctx = (ContentContext)tree.getContext();
        return ctx.getLockManager();
    }

    public OpLockManager getOpLockManager(SrvSession sess, TreeConnection tree) {
        ContentContext ctx = (ContentContext)tree.getContext();
        return ctx.getLockManager();
    }

    public boolean isOpLocksEnabled(SrvSession sess, TreeConnection tree) {
        ContentContext ctx = (ContentContext)tree.getContext();
        return !ctx.getDisableOplocks();
    }

    private void copyContentData(SrvSession sess, TreeConnection tree, NodeRef fromNode, NodeRef toNode, String newName) {
        ContentData content = (ContentData)this.nodeService.getProperty(fromNode, ContentModel.PROP_CONTENT);
        if (newName != null) {
            content = ContentData.setMimetype((ContentData)content, (String)this.mimetypeService.guessMimetype(newName));
        }
        this.nodeService.setProperty(toNode, ContentModel.PROP_CONTENT, (Serializable)content);
    }

    private void cloneNodeAspects(String newName, NodeRef fromNode, NodeRef toNode, ContentContext ctx) {
        if (this.nodeService.hasAspect(fromNode, ContentModel.ASPECT_LOCKABLE)) {
            this.nodeService.removeAspect(fromNode, ContentModel.ASPECT_LOCKABLE);
            this.nodeService.addAspect(toNode, ContentModel.ASPECT_LOCKABLE, null);
            if (logger.isDebugEnabled() && ctx.hasDebug(64)) {
                logger.debug((Object)("  Moved aspect " + String.valueOf(ContentModel.ASPECT_LOCKABLE) + " to new document"));
            }
        }
        if (this.nodeService.hasAspect(fromNode, ContentModel.ASPECT_WORKING_COPY)) {
            HashMap<QName, Serializable> workingCopyProperties = new HashMap<QName, Serializable>(1);
            workingCopyProperties.put(ContentModel.PROP_WORKING_COPY_OWNER, this.nodeService.getProperty(fromNode, ContentModel.PROP_WORKING_COPY_OWNER));
            this.nodeService.addAspect(toNode, ContentModel.ASPECT_WORKING_COPY, workingCopyProperties);
            this.nodeService.removeAspect(fromNode, ContentModel.ASPECT_WORKING_COPY);
            if (logger.isDebugEnabled() && ctx.hasDebug(64)) {
                logger.debug((Object)("  Moved aspect " + String.valueOf(ContentModel.ASPECT_WORKING_COPY) + " to new document"));
            }
        }
        if (this.nodeService.hasAspect(fromNode, ContentModel.ASPECT_COPIEDFROM)) {
            List assocs = this.nodeService.getSourceAssocs(fromNode, (QNamePattern)ContentModel.ASSOC_ORIGINAL);
            if (assocs.size() > 0) {
                AssociationRef associationRef = (AssociationRef)assocs.get(0);
                NodeRef originalNodeRef = associationRef.getTargetRef();
                this.nodeService.createAssociation(toNode, originalNodeRef, ContentModel.ASSOC_ORIGINAL);
            }
            this.nodeService.removeAspect(fromNode, ContentModel.ASPECT_COPIEDFROM);
            if (logger.isDebugEnabled() && ctx.hasDebug(64)) {
                logger.debug((Object)("  Moved aspect " + String.valueOf(ContentModel.ASPECT_COPIEDFROM) + " to new document"));
            }
        }
        for (QName aspectName : this.nodeService.getAspects(fromNode)) {
            if (_excludedNamespaces.contains(aspectName.getNamespaceURI())) continue;
            this.nodeService.addAspect(toNode, aspectName, null);
        }
        Map fromProps = this.nodeService.getProperties(fromNode);
        for (Map.Entry entry : fromProps.entrySet()) {
            QName propName = (QName)entry.getKey();
            if (_excludedNamespaces.contains(propName.getNamespaceURI())) continue;
            this.nodeService.setProperty(toNode, propName, (Serializable)entry.getValue());
        }
        String string = newName.toLowerCase();
        if (string.endsWith(".tmp") || string.endsWith(".temp")) {
            if (this.nodeService.hasAspect(toNode, ContentModel.ASPECT_VERSIONABLE)) {
                this.nodeService.removeAspect(toNode, ContentModel.ASPECT_VERSIONABLE);
            }
            this.nodeService.addAspect(toNode, ContentModel.ASPECT_TEMPORARY, null);
            if (logger.isDebugEnabled() && ctx.hasDebug(64)) {
                logger.debug((Object)"  Removed versionable aspect from temp file");
            }
        }
        QName[] qNameArray = _copyProperties;
        int n = _copyProperties.length;
        int n2 = 0;
        while (n2 < n) {
            QName propName = qNameArray[n2];
            Serializable nodeProp = this.nodeService.getProperty(fromNode, propName);
            if (nodeProp != null) {
                this.nodeService.setProperty(toNode, propName, nodeProp);
            }
            ++n2;
        }
    }

    private void cloneNode(String newName, NodeRef fromNode, NodeRef toNode, ContentContext ctx) {
        Action action;
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("clone node from fromNode:" + String.valueOf(fromNode) + "toNode:" + String.valueOf(toNode)));
        }
        this.cloneNodeAspects(newName, fromNode, toNode, ctx);
        this.policyBehaviourFilter.disableBehaviour(ContentModel.ASPECT_AUDITABLE);
        try {
            this.nodeService.setProperty(toNode, ContentModel.PROP_CREATOR, this.nodeService.getProperty(fromNode, ContentModel.PROP_CREATOR));
            this.ownableService.setOwner(toNode, this.ownableService.getOwner(fromNode));
        }
        finally {
            this.policyBehaviourFilter.enableBehaviour(ContentModel.ASPECT_AUDITABLE);
        }
        Set permissions = this.permissionService.getAllSetPermissions(fromNode);
        boolean inheritParentPermissions = this.permissionService.getInheritParentPermissions(fromNode);
        this.permissionService.deletePermissions(fromNode);
        this.permissionService.setInheritParentPermissions(toNode, inheritParentPermissions);
        for (AccessPermission permission : permissions) {
            this.permissionService.setPermission(toNode, permission.getAuthority(), permission.getPermission(), permission.getAccessStatus() == AccessStatus.ALLOWED);
        }
        ContentData content = (ContentData)this.nodeService.getProperty(toNode, ContentModel.PROP_CONTENT);
        if (content != null && (content.getMimetype() == null || content.getMimetype().equals("application/octet-stream"))) {
            String mimetype = this.mimetypeService.guessMimetype(newName);
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("set new mimetype to:" + mimetype));
            }
            ContentData replacement = ContentData.setMimetype((ContentData)content, (String)mimetype);
            this.nodeService.setProperty(toNode, ContentModel.PROP_CONTENT, (Serializable)replacement);
        }
        if ((action = this.getActionService().createAction("extract-metadata")) != null) {
            this.getActionService().executeAction(action, toNode);
        }
    }

    private final String fileStatusString(int sts) {
        String fstatus = "Unknown";
        switch (sts) {
            case -1: {
                fstatus = "Unknown";
                break;
            }
            case 0: {
                fstatus = "NotExist";
                break;
            }
            case 1: {
                fstatus = "FileExists";
                break;
            }
            case 2: {
                fstatus = "DirectoryExists";
                break;
            }
            case 3: {
                fstatus = "FileRenamed";
                break;
            }
            case 4: {
                fstatus = "DeleteOnClose";
            }
        }
        return fstatus;
    }

    private boolean isRenameShuffle(String oldFilename, String newFilename, Pattern renameShufflePattern) {
        boolean renameShuffle = false;
        String oldNameLower = oldFilename.toLowerCase();
        String newNameLower = newFilename.toLowerCase();
        renameShuffle = renameShuffle || renameShufflePattern.matcher(oldNameLower).matches();
        renameShuffle = renameShuffle || renameShufflePattern.matcher(newNameLower).matches();
        return renameShuffle;
    }

    public void getDiskInformation(DiskDeviceContext ctx, SrvDiskInfo diskDev) throws IOException {
        diskDev.setBlockSize(512);
        diskDev.setBlocksPerAllocationUnit(64L);
        long freeSpace = this.contentService.getStoreFreeSpace();
        long totalSpace = this.contentService.getStoreTotalSpace();
        if (totalSpace == -1L) {
            totalSpace = 0x10000000000L;
            freeSpace = 0x8000000000L;
        }
        diskDev.setTotalUnits(totalSpace / 32768L);
        diskDev.setFreeUnits(freeSpace / 32768L);
    }

    public void setActionService(ActionService actionService) {
        this.actionService = actionService;
    }

    public ActionService getActionService() {
        return this.actionService;
    }
}

