/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.security.authentication.identityservice.webscript;

import com.nimbusds.oauth2.sdk.Scope;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.time.Instant;
import java.util.Arrays;
import java.util.Map;
import java.util.Set;
import org.alfresco.repo.security.authentication.external.RemoteUserMapper;
import org.alfresco.repo.security.authentication.identityservice.IdentityServiceConfig;
import org.alfresco.repo.security.authentication.identityservice.IdentityServiceFacade;
import org.alfresco.repo.security.authentication.identityservice.authentication.AdditionalHeadersHttpServletRequestWrapper;
import org.alfresco.repo.security.authentication.identityservice.authentication.AdminAuthenticationCookiesService;
import org.alfresco.repo.security.authentication.identityservice.authentication.webscripts.IdentityServiceWebScriptsHomeAuthenticator;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.mockito.ArgumentCaptor;
import org.mockito.ArgumentMatchers;
import org.mockito.Captor;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.MockitoAnnotations;
import org.springframework.security.oauth2.client.registration.ClientRegistration;

public class IdentityServiceWebScriptsHomeAuthenticatorUnitTest {
    private static final String ALFRESCO_ACCESS_TOKEN = "ALFRESCO_ACCESS_TOKEN";
    private static final String ALFRESCO_REFRESH_TOKEN = "ALFRESCO_REFRESH_TOKEN";
    private static final String ALFRESCO_TOKEN_EXPIRATION = "ALFRESCO_TOKEN_EXPIRATION";
    @Mock
    HttpServletRequest request;
    @Mock
    HttpServletResponse response;
    @Mock
    IdentityServiceFacade identityServiceFacade;
    @Mock
    IdentityServiceConfig identityServiceConfig;
    @Mock
    AdminAuthenticationCookiesService cookiesService;
    @Mock
    RemoteUserMapper remoteUserMapper;
    @Mock
    IdentityServiceFacade.AccessTokenAuthorization accessTokenAuthorization;
    @Mock
    IdentityServiceFacade.AccessToken accessToken;
    @Captor
    ArgumentCaptor<AdditionalHeadersHttpServletRequestWrapper> requestCaptor;
    IdentityServiceWebScriptsHomeAuthenticator authenticator;
    StringBuffer webScriptHomeURL = new StringBuffer("http://localhost:8080/alfresco/s/index");

    @Before
    public void setup() {
        MockitoAnnotations.initMocks((Object)this);
        ClientRegistration clientRegistration = (ClientRegistration)Mockito.mock(ClientRegistration.class);
        ClientRegistration.ProviderDetails providerDetails = (ClientRegistration.ProviderDetails)Mockito.mock(ClientRegistration.ProviderDetails.class);
        Scope scope = Scope.parse(Arrays.asList("openid", "profile", "email", "offline_access"));
        Mockito.when((Object)clientRegistration.getProviderDetails()).thenReturn((Object)providerDetails);
        Mockito.when((Object)clientRegistration.getClientId()).thenReturn((Object)"alfresco");
        Mockito.when((Object)providerDetails.getAuthorizationUri()).thenReturn((Object)"http://localhost:8999/auth");
        Mockito.when((Object)providerDetails.getConfigurationMetadata()).thenReturn(Map.of("scopes_supported", scope));
        Mockito.when((Object)this.identityServiceFacade.getClientRegistration()).thenReturn((Object)clientRegistration);
        Mockito.when((Object)this.request.getRequestURL()).thenReturn((Object)this.webScriptHomeURL);
        Mockito.when((Object)this.remoteUserMapper.getRemoteUser(this.request)).thenReturn(null);
        this.authenticator = new IdentityServiceWebScriptsHomeAuthenticator();
        this.authenticator.setActive(true);
        this.authenticator.setIdentityServiceFacade(this.identityServiceFacade);
        this.authenticator.setCookiesService(this.cookiesService);
        this.authenticator.setRemoteUserMapper(this.remoteUserMapper);
        this.authenticator.setIdentityServiceConfig(this.identityServiceConfig);
    }

    @Test
    public void shouldCallRemoteMapperIfTokenIsInCookies() {
        Mockito.when((Object)this.cookiesService.getCookie(ALFRESCO_ACCESS_TOKEN, this.request)).thenReturn((Object)"JWT_TOKEN");
        Mockito.when((Object)this.cookiesService.getCookie(ALFRESCO_TOKEN_EXPIRATION, this.request)).thenReturn((Object)String.valueOf(Instant.now().plusSeconds(60L).toEpochMilli()));
        Mockito.when((Object)this.remoteUserMapper.getRemoteUser((HttpServletRequest)this.requestCaptor.capture())).thenReturn((Object)"admin");
        String username = this.authenticator.getUserId(this.request, this.response);
        Assert.assertEquals((Object)"Bearer JWT_TOKEN", (Object)((AdditionalHeadersHttpServletRequestWrapper)this.requestCaptor.getValue()).getHeader("Authorization"));
        Assert.assertEquals((Object)"admin", (Object)username);
        Assert.assertTrue((boolean)this.authenticator.isActive());
    }

    @Test
    public void shouldRefreshExpiredTokenAndCallRemoteMapper() {
        Mockito.when((Object)this.cookiesService.getCookie(ALFRESCO_ACCESS_TOKEN, this.request)).thenReturn((Object)"EXPIRED_JWT_TOKEN");
        Mockito.when((Object)this.cookiesService.getCookie(ALFRESCO_REFRESH_TOKEN, this.request)).thenReturn((Object)"REFRESH_TOKEN");
        Mockito.when((Object)this.cookiesService.getCookie(ALFRESCO_TOKEN_EXPIRATION, this.request)).thenReturn((Object)String.valueOf(Instant.now().minusSeconds(60L).toEpochMilli()));
        Mockito.when((Object)this.accessToken.getTokenValue()).thenReturn((Object)"REFRESHED_JWT_TOKEN");
        Mockito.when((Object)this.accessToken.getExpiresAt()).thenReturn((Object)Instant.now().plusSeconds(60L));
        Mockito.when((Object)this.accessTokenAuthorization.getAccessToken()).thenReturn((Object)this.accessToken);
        Mockito.when((Object)this.accessTokenAuthorization.getRefreshTokenValue()).thenReturn((Object)"REFRESH_TOKEN");
        Mockito.when((Object)this.identityServiceFacade.authorize((IdentityServiceFacade.AuthorizationGrant)ArgumentMatchers.any(IdentityServiceFacade.AuthorizationGrant.class))).thenReturn((Object)this.accessTokenAuthorization);
        Mockito.when((Object)this.remoteUserMapper.getRemoteUser((HttpServletRequest)this.requestCaptor.capture())).thenReturn((Object)"admin");
        String username = this.authenticator.getUserId(this.request, this.response);
        ((AdminAuthenticationCookiesService)Mockito.verify((Object)this.cookiesService)).addCookie(ALFRESCO_ACCESS_TOKEN, "REFRESHED_JWT_TOKEN", this.response);
        ((AdminAuthenticationCookiesService)Mockito.verify((Object)this.cookiesService)).addCookie(ALFRESCO_REFRESH_TOKEN, "REFRESH_TOKEN", this.response);
        Assert.assertEquals((Object)"Bearer REFRESHED_JWT_TOKEN", (Object)((AdditionalHeadersHttpServletRequestWrapper)this.requestCaptor.getValue()).getHeader("Authorization"));
        Assert.assertEquals((Object)"admin", (Object)username);
    }

    @Test
    public void shouldCallAuthChallengeWebScriptHome() throws IOException {
        String redirectPath = "/alfresco/s/index";
        Mockito.when((Object)this.request.getRequestURL()).thenReturn((Object)this.webScriptHomeURL);
        Mockito.when((Object)this.identityServiceConfig.getWebScriptsHomeScopes()).thenReturn(Set.of("openid", "email", "profile", "offline_access"));
        Mockito.when((Object)this.identityServiceConfig.getWebScriptsHomeRedirectPath()).thenReturn((Object)redirectPath);
        ArgumentCaptor authenticationRequest = ArgumentCaptor.forClass(String.class);
        String expectedUri = "http://localhost:8999/auth?client_id=alfresco&redirect_uri=%s%s&response_type=code&scope=".formatted("http://localhost:8080", redirectPath);
        this.authenticator.requestAuthentication(this.request, this.response);
        ((HttpServletResponse)Mockito.verify((Object)this.response)).sendRedirect((String)authenticationRequest.capture());
        Assert.assertTrue((boolean)((String)authenticationRequest.getValue()).contains(expectedUri));
        Assert.assertTrue((boolean)((String)authenticationRequest.getValue()).contains("openid"));
        Assert.assertTrue((boolean)((String)authenticationRequest.getValue()).contains("profile"));
        Assert.assertTrue((boolean)((String)authenticationRequest.getValue()).contains("email"));
        Assert.assertTrue((boolean)((String)authenticationRequest.getValue()).contains("offline_access"));
        Assert.assertTrue((boolean)((String)authenticationRequest.getValue()).contains("state"));
    }

    @Test
    public void shouldCallAuthChallengeWebScriptHomeWithAudience() throws IOException {
        String audience = "http://localhost:8082";
        String redirectPath = "/alfresco/s/index";
        Mockito.when((Object)this.request.getRequestURL()).thenReturn((Object)this.webScriptHomeURL);
        Mockito.when((Object)this.identityServiceConfig.getAudience()).thenReturn((Object)audience);
        Mockito.when((Object)this.identityServiceConfig.getWebScriptsHomeRedirectPath()).thenReturn((Object)redirectPath);
        Mockito.when((Object)this.identityServiceConfig.getWebScriptsHomeScopes()).thenReturn(Set.of("openid", "email", "profile", "offline_access"));
        ArgumentCaptor authenticationRequest = ArgumentCaptor.forClass(String.class);
        String expectedUri = "http://localhost:8999/auth?client_id=alfresco&redirect_uri=%s%s&response_type=code&scope=".formatted("http://localhost:8080", redirectPath);
        this.authenticator.requestAuthentication(this.request, this.response);
        ((HttpServletResponse)Mockito.verify((Object)this.response)).sendRedirect((String)authenticationRequest.capture());
        Assert.assertTrue((boolean)((String)authenticationRequest.getValue()).contains(expectedUri));
        Assert.assertTrue((boolean)((String)authenticationRequest.getValue()).contains("openid"));
        Assert.assertTrue((boolean)((String)authenticationRequest.getValue()).contains("profile"));
        Assert.assertTrue((boolean)((String)authenticationRequest.getValue()).contains("email"));
        Assert.assertTrue((boolean)((String)authenticationRequest.getValue()).contains("offline_access"));
        Assert.assertTrue((boolean)((String)authenticationRequest.getValue()).contains("audience=%s".formatted(audience)));
        Assert.assertTrue((boolean)((String)authenticationRequest.getValue()).contains("state"));
    }

    @Test
    public void shouldResetCookiesAndCallAuthChallenge() throws IOException {
        Mockito.when((Object)this.cookiesService.getCookie(ALFRESCO_ACCESS_TOKEN, this.request)).thenReturn((Object)"EXPIRED_JWT_TOKEN");
        Mockito.when((Object)this.cookiesService.getCookie(ALFRESCO_REFRESH_TOKEN, this.request)).thenReturn((Object)"REFRESH_TOKEN");
        Mockito.when((Object)this.cookiesService.getCookie(ALFRESCO_TOKEN_EXPIRATION, this.request)).thenReturn((Object)String.valueOf(Instant.now().minusSeconds(60L).toEpochMilli()));
        Mockito.when((Object)this.identityServiceFacade.authorize((IdentityServiceFacade.AuthorizationGrant)ArgumentMatchers.any(IdentityServiceFacade.AuthorizationGrant.class))).thenThrow(IdentityServiceFacade.AuthorizationException.class);
        String username = this.authenticator.getUserId(this.request, this.response);
        ((AdminAuthenticationCookiesService)Mockito.verify((Object)this.cookiesService)).resetCookie(ALFRESCO_ACCESS_TOKEN, this.response);
        ((AdminAuthenticationCookiesService)Mockito.verify((Object)this.cookiesService)).resetCookie(ALFRESCO_REFRESH_TOKEN, this.response);
        ((AdminAuthenticationCookiesService)Mockito.verify((Object)this.cookiesService)).resetCookie(ALFRESCO_TOKEN_EXPIRATION, this.response);
        Assert.assertNull((Object)username);
    }

    @Test
    public void shouldAuthorizeCodeAndSetCookies() {
        Mockito.when((Object)this.request.getParameter("code")).thenReturn((Object)"auth_code");
        Mockito.when((Object)this.accessToken.getTokenValue()).thenReturn((Object)"JWT_TOKEN");
        Mockito.when((Object)this.accessToken.getExpiresAt()).thenReturn((Object)Instant.now().plusSeconds(60L));
        Mockito.when((Object)this.accessTokenAuthorization.getAccessToken()).thenReturn((Object)this.accessToken);
        Mockito.when((Object)this.accessTokenAuthorization.getRefreshTokenValue()).thenReturn((Object)"REFRESH_TOKEN");
        Mockito.when((Object)this.identityServiceFacade.authorize(IdentityServiceFacade.AuthorizationGrant.authorizationCode((String)"auth_code", (String)this.webScriptHomeURL.toString()))).thenReturn((Object)this.accessTokenAuthorization);
        Mockito.when((Object)this.remoteUserMapper.getRemoteUser((HttpServletRequest)this.requestCaptor.capture())).thenReturn((Object)"admin");
        String username = this.authenticator.getUserId(this.request, this.response);
        ((AdminAuthenticationCookiesService)Mockito.verify((Object)this.cookiesService)).addCookie(ALFRESCO_ACCESS_TOKEN, "JWT_TOKEN", this.response);
        ((AdminAuthenticationCookiesService)Mockito.verify((Object)this.cookiesService)).addCookie(ALFRESCO_REFRESH_TOKEN, "REFRESH_TOKEN", this.response);
        Assert.assertEquals((Object)"Bearer JWT_TOKEN", (Object)((AdditionalHeadersHttpServletRequestWrapper)this.requestCaptor.getValue()).getHeader("Authorization"));
        Assert.assertEquals((Object)"admin", (Object)username);
    }

    @Test
    public void shouldExtractUsernameFromAuthorizationHeader() {
        Mockito.when((Object)this.remoteUserMapper.getRemoteUser(this.request)).thenReturn((Object)"admin");
        String username = this.authenticator.getUserId(this.request, this.response);
        Assert.assertEquals((Object)"admin", (Object)username);
    }
}

