/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.i18n;

import jakarta.transaction.UserTransaction;
import java.io.InputStream;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Locale;
import java.util.Set;
import junit.framework.TestCase;
import org.alfresco.model.ContentModel;
import org.alfresco.repo.dictionary.DictionaryDAO;
import org.alfresco.repo.i18n.MessageDeployer;
import org.alfresco.repo.i18n.MessageService;
import org.alfresco.repo.i18n.MessageServiceImpl;
import org.alfresco.repo.security.authentication.AuthenticationComponent;
import org.alfresco.repo.security.authentication.AuthenticationUtil;
import org.alfresco.repo.transaction.AlfrescoTransactionSupport;
import org.alfresco.repo.transaction.RetryingTransactionHelper;
import org.alfresco.service.cmr.repository.ChildAssociationRef;
import org.alfresco.service.cmr.repository.ContentService;
import org.alfresco.service.cmr.repository.ContentWriter;
import org.alfresco.service.cmr.repository.NodeRef;
import org.alfresco.service.cmr.repository.NodeService;
import org.alfresco.service.cmr.repository.StoreRef;
import org.alfresco.service.cmr.security.MutableAuthenticationService;
import org.alfresco.service.namespace.QName;
import org.alfresco.service.transaction.TransactionService;
import org.alfresco.test_category.OwnJVMTestsCategory;
import org.alfresco.util.ApplicationContextHelper;
import org.junit.FixMethodOrder;
import org.junit.experimental.categories.Category;
import org.junit.runners.MethodSorters;
import org.springframework.context.ApplicationContext;
import org.springframework.core.io.Resource;
import org.springframework.core.io.support.PathMatchingResourcePatternResolver;

@FixMethodOrder(value=MethodSorters.NAME_ASCENDING)
@Category(value={OwnJVMTestsCategory.class})
public class MessageServiceImplTest
extends TestCase
implements MessageDeployer {
    private ApplicationContext applicationContext;
    private static final String BASE_BUNDLE_NAME = "testMessages";
    private static final String BASE_RESOURCE_CLASSPATH = "org/alfresco/repo/i18n/";
    private static final String PARAM_VALUE = "television";
    private static final String MSG_YES = "msg_yes";
    private static final String MSG_NO = "msg_no";
    private static final String MSG_PARAMS = "msg_params";
    private static final String VALUE_YES = "Yes";
    private static final String VALUE_NO = "No";
    private static final String VALUE_PARAMS = "What no television?";
    private static final String VALUE_FR_YES = "Oui";
    private static final String VALUE_FR_NO = "Non";
    private static final String VALUE_FR_PARAMS = "Que non television?";
    private MessageService messageService;
    private NodeService nodeService;
    private MutableAuthenticationService authenticationService;
    private ContentService contentService;
    private DictionaryDAO dictionaryDAO;
    private TransactionService transactionService;
    private AuthenticationComponent authenticationComponent;
    private static final String PWD = "admin";
    private StoreRef testStoreRef;
    private UserTransaction testTX;

    protected void setUp() throws Exception {
        this.applicationContext = ApplicationContextHelper.getApplicationContext();
        if (AlfrescoTransactionSupport.getTransactionReadState() != AlfrescoTransactionSupport.TxnReadState.TXN_NONE) {
            MessageServiceImplTest.fail((String)"Detected a leaked transaction from a previous test.");
        }
        this.messageService = (MessageService)this.applicationContext.getBean("messageService");
        this.nodeService = (NodeService)this.applicationContext.getBean("NodeService");
        this.authenticationService = (MutableAuthenticationService)this.applicationContext.getBean("AuthenticationService");
        this.contentService = (ContentService)this.applicationContext.getBean("ContentService");
        this.transactionService = (TransactionService)this.applicationContext.getBean("transactionComponent");
        this.authenticationComponent = (AuthenticationComponent)this.applicationContext.getBean("authenticationComponent");
        this.dictionaryDAO = (DictionaryDAO)this.applicationContext.getBean("dictionaryDAO");
        Locale.setDefault(Locale.ENGLISH);
        this.messageService.setLocale(Locale.getDefault());
        this.testTX = this.transactionService.getUserTransaction();
        this.testTX.begin();
        this.authenticationComponent.setSystemUserAsCurrentUser();
    }

    protected void tearDown() throws Exception {
        if (this.testTX != null) {
            try {
                this.testTX.rollback();
            }
            catch (Throwable throwable) {}
        }
        AuthenticationUtil.clearCurrentSecurityContext();
        super.tearDown();
    }

    private void setupRepo() throws Exception {
        AuthenticationUtil.clearCurrentSecurityContext();
        AuthenticationUtil.setFullyAuthenticatedUser((String)AuthenticationUtil.getSystemUserName());
        this.testStoreRef = this.nodeService.createStore("workspace", "Test_" + System.currentTimeMillis());
        NodeRef rootNodeRef = this.nodeService.getRootNode(this.testStoreRef);
        if (!this.authenticationService.authenticationExists(AuthenticationUtil.getAdminUserName())) {
            this.authenticationService.createAuthentication(AuthenticationUtil.getAdminUserName(), PWD.toCharArray());
        }
        this.authenticationService.authenticate(AuthenticationUtil.getAdminUserName(), PWD.toCharArray());
        String pattern = "classpath*:org/alfresco/repo/i18n/testMessages*";
        PathMatchingResourcePatternResolver resolver = new PathMatchingResourcePatternResolver();
        Resource[] resources = resolver.getResources(pattern);
        if (resources != null) {
            int i = 0;
            while (i < resources.length) {
                String filename = resources[i].getFilename();
                this.addMessageResource(rootNodeRef, filename, resources[i].getInputStream());
                ++i;
            }
        }
    }

    private void addMessageResource(NodeRef rootNodeRef, String name, InputStream resourceStream) throws Exception {
        HashMap<QName, String> contentProps = new HashMap<QName, String>();
        contentProps.put(ContentModel.PROP_NAME, name);
        ChildAssociationRef association = this.nodeService.createNode(rootNodeRef, ContentModel.ASSOC_CHILDREN, QName.createQName((String)"http://www.alfresco.org/model/content/1.0", (String)name), ContentModel.TYPE_CONTENT, contentProps);
        NodeRef content = association.getChildRef();
        ContentWriter writer = this.contentService.getWriter(content, ContentModel.PROP_CONTENT, true);
        writer.setMimetype("text/plain");
        writer.setEncoding("UTF-8");
        writer.putContent(resourceStream);
        resourceStream.close();
    }

    public void test1SetAndGet() {
        MessageServiceImplTest.assertEquals((Object)Locale.getDefault(), (Object)this.messageService.getLocale());
        this.messageService.setLocale(Locale.CANADA_FRENCH);
        MessageServiceImplTest.assertEquals((Object)Locale.CANADA_FRENCH, (Object)this.messageService.getLocale());
        this.messageService.setLocale(null);
        MessageServiceImplTest.assertEquals((Object)Locale.getDefault(), (Object)this.messageService.getLocale());
    }

    public void test2GetMessagesLoadedFromRepo() throws Exception {
        this.setupRepo();
        MessageServiceImplTest.assertNull((Object)this.messageService.getMessage(MSG_NO));
        this.messageService.registerResourceBundle(String.valueOf(this.testStoreRef) + "/cm:testMessages");
        this.getMessages();
        this.messageService.unregisterResourceBundle(String.valueOf(this.testStoreRef) + "/cm:testMessages");
    }

    public void test3GetMessagesWithParamsLoadedFromRepo() throws Exception {
        this.setupRepo();
        MessageServiceImplTest.assertNull((Object)this.messageService.getMessage(MSG_PARAMS, new Object[]{PARAM_VALUE}));
        this.messageService.registerResourceBundle(String.valueOf(this.testStoreRef) + "/cm:testMessages");
        this.getMessagesWithParams();
        this.messageService.unregisterResourceBundle(String.valueOf(this.testStoreRef) + "/cm:testMessages");
    }

    public void test4GetMessagesLoadedFromClasspath() throws Exception {
        MessageServiceImplTest.assertNull((Object)this.messageService.getMessage(MSG_NO));
        this.messageService.registerResourceBundle("org/alfresco/repo/i18n/testMessages");
        this.getMessages();
        this.messageService.unregisterResourceBundle("org/alfresco/repo/i18n/testMessages");
    }

    public void test5GetMessagesWithParamsLoadedFromClasspath() throws Exception {
        MessageServiceImplTest.assertNull((Object)this.messageService.getMessage(MSG_PARAMS, new Object[]{PARAM_VALUE}));
        this.messageService.registerResourceBundle("org/alfresco/repo/i18n/testMessages");
        this.getMessagesWithParams();
        this.messageService.unregisterResourceBundle("org/alfresco/repo/i18n/testMessages");
    }

    public void test6RegisterBundleFromRepo() throws Exception {
        this.setupRepo();
        this.messageService.registerResourceBundle(String.valueOf(this.testStoreRef) + "/cm:testMessages");
        MessageServiceImplTest.assertEquals((String)VALUE_YES, (String)this.messageService.getMessage(MSG_YES));
        this.messageService.unregisterResourceBundle(String.valueOf(this.testStoreRef) + "/cm:testMessages");
    }

    public void test7RegisterBundleFromClasspath() throws Exception {
        this.messageService.registerResourceBundle("org/alfresco/repo/i18n/testMessages");
        MessageServiceImplTest.assertEquals((String)VALUE_YES, (String)this.messageService.getMessage(MSG_YES));
        this.messageService.unregisterResourceBundle("org/alfresco/repo/i18n/testMessages");
    }

    public void test8Reset() throws Exception {
        MessageServiceImplTest.assertNull((Object)this.messageService.getMessage(MSG_YES));
        this.messageService.register((MessageDeployer)this);
        this.initMessages();
        MessageServiceImplTest.assertEquals((String)VALUE_YES, (String)this.messageService.getMessage(MSG_YES));
        ((MessageServiceImpl)this.messageService).reset();
        MessageServiceImplTest.assertEquals((String)VALUE_YES, (String)this.messageService.getMessage(MSG_YES));
    }

    public void initMessages() {
        this.messageService.registerResourceBundle("org/alfresco/repo/i18n/testMessages");
    }

    public void test9LocaleMatching() {
        HashSet<Locale> options = new HashSet<Locale>(13);
        options.add(Locale.FRENCH);
        options.add(Locale.FRANCE);
        options.add(Locale.CANADA);
        options.add(Locale.CANADA_FRENCH);
        options.add(Locale.CHINESE);
        options.add(Locale.TRADITIONAL_CHINESE);
        options.add(Locale.SIMPLIFIED_CHINESE);
        options.add(Locale.GERMAN);
        Locale fr_FR_1 = new Locale("fr", "FR", "1");
        Locale zh_CN_1 = new Locale("zh", "CN", "1");
        Locale zh_CN_2 = new Locale("zh", "CN", "2");
        Locale zh_CN_3 = new Locale("zh", "CN", "3");
        options.add(zh_CN_1);
        options.add(zh_CN_2);
        HashSet<Locale> chineseMatches = new HashSet<Locale>(3);
        chineseMatches.add(Locale.SIMPLIFIED_CHINESE);
        chineseMatches.add(zh_CN_1);
        chineseMatches.add(zh_CN_2);
        HashSet<Locale> frenchMatches = new HashSet<Locale>(3);
        frenchMatches.add(Locale.FRANCE);
        MessageServiceImplTest.assertEquals((Object)Locale.CHINA, (Object)this.messageService.getNearestLocale(Locale.CHINA, options));
        MessageServiceImplTest.assertEquals((Object)Locale.CHINESE, (Object)this.messageService.getNearestLocale(Locale.CHINESE, options));
        MessageServiceImplTest.assertEquals((Object)zh_CN_1, (Object)this.messageService.getNearestLocale(zh_CN_1, options));
        MessageServiceImplTest.assertEquals((Object)zh_CN_2, (Object)this.messageService.getNearestLocale(zh_CN_2, options));
        MessageServiceImplTest.assertTrue((boolean)chineseMatches.contains(this.messageService.getNearestLocale(zh_CN_3, options)));
        MessageServiceImplTest.assertEquals((Object)Locale.FRANCE, (Object)this.messageService.getNearestLocale(fr_FR_1, options));
        MessageServiceImplTest.assertFalse((boolean)options.contains(Locale.GERMANY));
        MessageServiceImplTest.assertEquals((Object)Locale.GERMAN, (Object)this.messageService.getNearestLocale(Locale.GERMANY, options));
        Locale na_na_na = new Locale("", "", "");
        Locale check = this.messageService.getNearestLocale(na_na_na, options);
        MessageServiceImplTest.assertNotNull((String)"Expected some kind of value back", (Object)check);
    }

    public void testLocaleParsing() {
        MessageServiceImplTest.assertEquals((Object)Locale.FRANCE, (Object)this.messageService.parseLocale("fr_FR"));
        MessageServiceImplTest.assertEquals((Object)new Locale("en", "GB", "cockney"), (Object)this.messageService.parseLocale("en_GB_cockney"));
        MessageServiceImplTest.assertEquals((Object)new Locale("en", "GB", ""), (Object)this.messageService.parseLocale("en_GB"));
        MessageServiceImplTest.assertEquals((Object)new Locale("en", "", ""), (Object)this.messageService.parseLocale("en"));
        MessageServiceImplTest.assertEquals((Object)Locale.getDefault(), (Object)this.messageService.parseLocale(""));
    }

    public void testRegisteredBundlesSetDirectModification() {
        String bad_key = "BAD_KEY" + System.currentTimeMillis();
        Set bundles = this.messageService.getRegisteredBundles();
        MessageServiceImplTest.assertNotNull((Object)bundles);
        MessageServiceImplTest.assertTrue((!bundles.contains(bad_key) ? 1 : 0) != 0);
        try {
            bundles.add(bad_key);
            MessageServiceImplTest.fail((String)"Shouldn't be modified");
        }
        catch (UnsupportedOperationException unsupportedOperationException) {}
        Set anotherTryBundles = this.messageService.getRegisteredBundles();
        MessageServiceImplTest.assertNotNull((Object)anotherTryBundles);
        MessageServiceImplTest.assertTrue((!bundles.contains(bad_key) ? 1 : 0) != 0);
    }

    private void getMessages() {
        MessageServiceImplTest.assertEquals((String)VALUE_YES, (String)this.messageService.getMessage(MSG_YES));
        MessageServiceImplTest.assertEquals((String)VALUE_NO, (String)this.messageService.getMessage(MSG_NO));
        MessageServiceImplTest.assertNull((Object)this.messageService.getMessage("bad_key"));
        this.messageService.setLocale(new Locale("fr", "FR"));
        MessageServiceImplTest.assertEquals((String)VALUE_FR_YES, (String)this.messageService.getMessage(MSG_YES));
        MessageServiceImplTest.assertEquals((String)VALUE_FR_NO, (String)this.messageService.getMessage(MSG_NO));
        MessageServiceImplTest.assertEquals((String)VALUE_YES, (String)this.messageService.getMessage(MSG_YES, Locale.getDefault()));
        MessageServiceImplTest.assertEquals((String)VALUE_NO, (String)this.messageService.getMessage(MSG_NO, Locale.getDefault()));
    }

    private void getMessagesWithParams() {
        MessageServiceImplTest.assertEquals((String)VALUE_PARAMS, (String)this.messageService.getMessage(MSG_PARAMS, new Object[]{PARAM_VALUE}));
        this.messageService.setLocale(new Locale("fr", "FR"));
        MessageServiceImplTest.assertEquals((String)VALUE_FR_PARAMS, (String)this.messageService.getMessage(MSG_PARAMS, new Object[]{PARAM_VALUE}));
        MessageServiceImplTest.assertEquals((String)VALUE_PARAMS, (String)this.messageService.getMessage(MSG_PARAMS, Locale.getDefault(), new Object[]{PARAM_VALUE}));
    }

    public void testDictionaryDAOLock() {
        class DictionaryDAOThread
        extends Thread {
            private volatile boolean success = false;

            DictionaryDAOThread() {
            }

            @Override
            public void run() {
                this.success = (Boolean)MessageServiceImplTest.this.transactionService.getRetryingTransactionHelper().doInTransaction((RetryingTransactionHelper.RetryingTransactionCallback)new RetryingTransactionHelper.RetryingTransactionCallback<Boolean>(){

                    public Boolean execute() throws Throwable {
                        ((DictionaryDAOThread)this).MessageServiceImplTest.this.dictionaryDAO.destroy();
                        ((DictionaryDAOThread)this).MessageServiceImplTest.this.dictionaryDAO.init();
                        return Boolean.TRUE;
                    }
                });
            }
        }
        DictionaryDAOThread ddt = new DictionaryDAOThread();
        ddt.setDaemon(true);
        class MessageServiceThread
        extends Thread {
            private volatile boolean success = false;

            MessageServiceThread() {
            }

            @Override
            public void run() {
                this.success = (Boolean)MessageServiceImplTest.this.transactionService.getRetryingTransactionHelper().doInTransaction((RetryingTransactionHelper.RetryingTransactionCallback)new RetryingTransactionHelper.RetryingTransactionCallback<Boolean>(){

                    public Boolean execute() {
                        ((MessageServiceThread)this).MessageServiceImplTest.this.messageService.destroy();
                        ((MessageServiceThread)this).MessageServiceImplTest.this.messageService.getMessage(MessageServiceImplTest.MSG_YES);
                        return Boolean.TRUE;
                    }
                });
            }
        }
        MessageServiceThread mst = new MessageServiceThread();
        mst.setDaemon(true);
        ddt.start();
        mst.start();
        try {
            ddt.join(60000L);
            mst.join(60000L);
        }
        catch (InterruptedException interruptedException) {
            ddt.interrupt();
            mst.interrupt();
            MessageServiceImplTest.fail((String)"Unexpected interrupt while joining to deadlocking threads.");
        }
        try {
            if (ddt.isAlive() && mst.isAlive()) {
                MessageServiceImplTest.fail((String)"Deadlock: DictionaryDAOThread and MessageServiceThread are both still alive.");
            } else if (ddt.isAlive()) {
                MessageServiceImplTest.fail((String)"Possible deadlock with a background process: DictionaryDAOThread is still alive.");
            } else if (mst.isAlive()) {
                MessageServiceImplTest.fail((String)"Possible deadlock with a background process: MessageServiceThread is still alive.");
            } else if (!ddt.success) {
                MessageServiceImplTest.fail((String)"DictionaryDAOThread failed to execute successfully.");
            } else if (!mst.success) {
                MessageServiceImplTest.fail((String)"MessageServiceThread failed to execute successfully.");
            }
        }
        finally {
            ddt.interrupt();
            mst.interrupt();
        }
    }

    public void testMNT13575() {
        Locale de = new Locale("de");
        MessageServiceImplTest.assertTrue((boolean)this.messageService.getLocale().equals(new Locale("en")));
        MessageServiceImplTest.assertFalse((boolean)this.messageService.getLocale().equals(de));
        String key = "cm_contentmodel.property.cm_description.title";
        String value_en = "Description";
        String value_de = "Beschreibung";
        MessageServiceImplTest.assertEquals((String)value_en, (String)this.messageService.getMessage(key));
        MessageServiceImplTest.assertEquals((String)value_de, (String)this.messageService.getMessage(key, de));
    }
}

