/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.tenant;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.alfresco.query.PageDetails;
import org.alfresco.query.PagingRequest;
import org.alfresco.query.PagingResults;
import org.alfresco.repo.security.authentication.AuthenticationUtil;
import org.alfresco.repo.security.permissions.AccessDeniedException;
import org.alfresco.repo.tenant.Network;
import org.alfresco.repo.tenant.NetworksService;
import org.alfresco.repo.tenant.Tenant;
import org.alfresco.repo.tenant.TenantAdminService;
import org.alfresco.util.Pair;

public class NetworksServiceImpl
implements NetworksService {
    public static final Network DEFAULT_NETWORK = new Network("-default-", true, null, null);
    private TenantAdminService tenantAdminService;

    public void setTenantAdminService(TenantAdminService tenantAdminService) {
        this.tenantAdminService = tenantAdminService;
    }

    private boolean hasAccess(String networkId) {
        String currentUser = AuthenticationUtil.getFullyAuthenticatedUser();
        String authNetworkId = this.tenantAdminService.getUserDomain(currentUser);
        return authNetworkId.equalsIgnoreCase(networkId);
    }

    @Override
    public Network getNetwork(String networkId) {
        Network network = null;
        if (networkId.equals("-system-") || networkId.equals("-default-")) {
            return DEFAULT_NETWORK;
        }
        if (this.tenantAdminService.existsTenant(networkId)) {
            Tenant tenant = this.tenantAdminService.getTenant(networkId);
            if (this.hasAccess(networkId)) {
                network = new Network(tenant, true, null, null, null, null);
            } else {
                throw new AccessDeniedException("Cannot get network, no permission");
            }
        }
        return network;
    }

    @Override
    public PagingResults<Network> getNetworks(PagingRequest pagingRequest) {
        String username = AuthenticationUtil.getFullyAuthenticatedUser();
        String admin = this.tenantAdminService.getBaseNameUser(AuthenticationUtil.getAdminUserName());
        String user = this.tenantAdminService.getBaseNameUser(username);
        ArrayList<Network> networks = null;
        if (user.equalsIgnoreCase(admin)) {
            networks = new ArrayList<Network>(1);
            String tenantId = this.tenantAdminService.getUserDomain(username);
            if (tenantId != null && tenantId.equals("")) {
                network = DEFAULT_NETWORK;
                networks.add(network);
            } else {
                tenant = this.tenantAdminService.getTenant(tenantId);
                network = new Network(tenant, false, null, null, null, null);
                networks.add(network);
            }
        } else {
            String userDomain = this.tenantAdminService.getUserDomain(username);
            networks = new ArrayList(1);
            if (userDomain != null && userDomain.equals("")) {
                network = DEFAULT_NETWORK;
                networks.add(network);
            } else {
                tenant = this.tenantAdminService.getTenant(userDomain);
                network = new Network(tenant, true, null, null, null, null);
                networks.add(network);
            }
        }
        final int totalSize = networks.size();
        final PageDetails pageDetails = PageDetails.getPageDetails((PagingRequest)pagingRequest, (int)totalSize);
        final ArrayList<Network> page = new ArrayList<Network>(pageDetails.getPageSize());
        Iterator it = networks.iterator();
        int counter = 0;
        while (counter < pageDetails.getEnd() && it.hasNext()) {
            Network network = (Network)it.next();
            if (counter >= pageDetails.getSkipCount()) {
                if (counter > pageDetails.getEnd() - 1) break;
                page.add(network);
            }
            ++counter;
        }
        return new PagingResults<Network>(){

            public List<Network> getPage() {
                return page;
            }

            public boolean hasMoreItems() {
                return pageDetails.hasMoreItems();
            }

            public Pair<Integer, Integer> getTotalResultCount() {
                Integer total = totalSize;
                return new Pair((Object)total, (Object)total);
            }

            public String getQueryExecutionId() {
                return null;
            }
        };
    }

    @Override
    public String getUserDefaultNetwork(String user) {
        Pair pair = AuthenticationUtil.getUserTenant((String)user);
        return (String)pair.getSecond();
    }
}

