/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.audit;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.alfresco.model.ContentModel;
import org.alfresco.repo.policy.BehaviourFilter;
import org.alfresco.service.cmr.repository.NodeRef;
import org.alfresco.service.namespace.QName;
import org.aopalliance.intercept.MethodInterceptor;
import org.aopalliance.intercept.MethodInvocation;

public class DisableAuditableBehaviourInterceptor
implements MethodInterceptor {
    private BehaviourFilter behaviourFilter;
    private Set<String> methodNames = new HashSet<String>(0);
    private Set<QName> argumentQNameValues = new HashSet<QName>(0);

    /*
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Object invoke(MethodInvocation methodInvocation) throws Throwable {
        methodName = methodInvocation.getMethod().getName();
        args = methodInvocation.getArguments();
        nodes = new ArrayList<NodeRef>();
        if (args.length > 0) {
            if (args[0] instanceof NodeRef) {
                nodes.add((NodeRef)args[0]);
            } else if (args[0] instanceof Collection) {
                nodes.addAll((Collection)args[0]);
            }
        }
        arg1 = null;
        if (args.length > 1 && args[1] instanceof QName) {
            arg1 = (QName)args[1];
        }
        if (this.behaviourFilter == null) return methodInvocation.proceed();
        if (this.methodNames.contains(methodName) == false) return methodInvocation.proceed();
        if (arg1 != null) {
            if (this.argumentQNameValues.contains(arg1) == false) return methodInvocation.proceed();
        }
        disabledNodeRefs = new HashSet<NodeRef>();
        var8_7 = nodes.iterator();
        while (var8_7.hasNext()) {
            nodeRef = (NodeRef)var8_7.next();
            if (disabledNodeRefs.contains(nodeRef) || !this.behaviourFilter.isEnabled(nodeRef, ContentModel.ASPECT_AUDITABLE)) continue;
            this.behaviourFilter.disableBehaviour(nodeRef, ContentModel.ASPECT_AUDITABLE);
            disabledNodeRefs.add(nodeRef);
        }
        try {
            var8_7 = methodInvocation.proceed();
            return var8_7;
        }
        finally {
            ** for (nodeRef : nodes)
        }
lbl-1000:
        // 1 sources

        {
            if (!disabledNodeRefs.contains(nodeRef)) continue;
            this.behaviourFilter.enableBehaviour(nodeRef, ContentModel.ASPECT_AUDITABLE);
            continue;
        }
lbl36:
        // 1 sources

        return var8_7;
    }

    public void setBehaviourFilter(BehaviourFilter behaviourFilter) {
        this.behaviourFilter = behaviourFilter;
    }

    public void setMethodNames(List<String> methodNames) {
        this.methodNames = new HashSet<String>(methodNames);
    }

    public void setArgumentValues(List<String> argumentValues) {
        this.argumentQNameValues = new HashSet<QName>(argumentValues.size() * 2 + 1);
        for (String argumentValue : argumentValues) {
            QName argumentQNameValue = QName.createQName((String)argumentValue);
            this.argumentQNameValues.add(argumentQNameValue);
        }
    }
}

