/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.security.authentication.external;

import java.lang.invoke.CallSite;
import java.util.HashMap;
import junit.framework.TestCase;
import org.alfresco.model.ContentModel;
import org.alfresco.repo.management.subsystems.ChildApplicationContextFactory;
import org.alfresco.repo.management.subsystems.DefaultChildApplicationContextManager;
import org.alfresco.repo.security.authentication.AuthenticationServiceImpl;
import org.alfresco.repo.security.authentication.AuthenticationUtil;
import org.alfresco.service.cmr.security.AuthenticationService;
import org.alfresco.service.cmr.security.PersonService;
import org.alfresco.service.namespace.QName;
import org.alfresco.util.ApplicationContextHelper;
import org.alfresco.util.GUID;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.springframework.context.ApplicationContext;

public class LocalAuthenticationServiceTest {
    private ApplicationContext ctx = ApplicationContextHelper.getApplicationContext();
    private DefaultChildApplicationContextManager childApplicationContextManager;
    private PersonService personService;
    private AuthenticationService localAuthenticationService;

    @Before
    public void before() {
        this.childApplicationContextManager = (DefaultChildApplicationContextManager)this.ctx.getBean("Authentication");
        this.personService = (PersonService)this.ctx.getBean("PersonService");
        this.childApplicationContextManager.stop();
        this.childApplicationContextManager.setProperty("chain", "external1:external");
        ChildApplicationContextFactory childApplicationContextFactory = this.childApplicationContextManager.getChildApplicationContextFactory("external1");
        childApplicationContextFactory.stop();
        childApplicationContextFactory.setProperty("external.authentication.proxyUserName", "");
        this.localAuthenticationService = (AuthenticationService)childApplicationContextFactory.getApplicationContext().getBean("localAuthenticationService");
        AuthenticationUtil.setAdminUserAsFullyAuthenticatedUser();
    }

    @After
    public void after() {
        AuthenticationUtil.clearCurrentSecurityContext();
        this.childApplicationContextManager.destroy();
        this.childApplicationContextManager = null;
    }

    private String createPerson() {
        HashMap<QName, CallSite> properties = new HashMap<QName, CallSite>();
        String username = "user" + GUID.generate();
        properties.put(ContentModel.PROP_USERNAME, (CallSite)((Object)username));
        properties.put(ContentModel.PROP_FIRSTNAME, (CallSite)((Object)username));
        properties.put(ContentModel.PROP_LASTNAME, (CallSite)((Object)username));
        this.personService.createPerson(properties);
        return username;
    }

    @Test
    public void testIsEnabledFlag() {
        String username = this.createPerson();
        TestCase.assertTrue((String)"The isEnabed flag should be set to true for the enabled user", (boolean)this.localAuthenticationService.getAuthenticationEnabled(username));
        HashMap<QName, Boolean> properties = new HashMap<QName, Boolean>();
        properties.put(ContentModel.PROP_ENABLED, false);
        this.personService.setPersonProperties(username, properties);
        Assert.assertFalse((String)"The isEnabed flag should be set to false for the disabled user", (boolean)this.localAuthenticationService.getAuthenticationEnabled(username));
        Assert.assertFalse((String)"External authentication should not protect against brute force attacks", (boolean)((AuthenticationServiceImpl)this.localAuthenticationService).isProtectionEnabled());
    }
}

