/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.policy;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.alfresco.api.AlfrescoPublicApi;
import org.alfresco.repo.policy.Behaviour;
import org.alfresco.repo.policy.BehaviourBinding;
import org.alfresco.repo.policy.BehaviourChangeObserver;
import org.alfresco.repo.policy.BehaviourFilter;
import org.alfresco.repo.policy.BehaviourIndex;
import org.alfresco.repo.policy.Policy;
import org.alfresco.repo.policy.PolicyComponentImpl;
import org.alfresco.repo.policy.PolicyFactory;
import org.alfresco.util.LockHelper;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

@AlfrescoPublicApi
public class CachedPolicyFactory<B extends BehaviourBinding, P extends Policy>
extends PolicyFactory<B, P> {
    private static final Log logger = LogFactory.getLog(PolicyComponentImpl.class);
    private BehaviourFilter behaviourFilter = null;
    private ReentrantReadWriteLock lock = new ReentrantReadWriteLock();
    private Map<B, P> singleCache = new HashMap<B, P>();
    private Map<B, Collection<P>> listCache = new HashMap<B, Collection<P>>();
    private long tryLockTimeout;

    public void setTryLockTimeout(long tryLockTimeout) {
        this.tryLockTimeout = tryLockTimeout;
    }

    CachedPolicyFactory(Class<P> policyClass, BehaviourIndex<B> index) {
        super(policyClass, index);
        this.behaviourFilter = index.getFilter();
        index.addChangeObserver(new BehaviourChangeObserver<B>(){

            @Override
            public void addition(B binding, Behaviour behaviour) {
                CachedPolicyFactory.this.clearCache("aggregate delegate", CachedPolicyFactory.this.singleCache, binding);
                CachedPolicyFactory.this.clearCache("delegate collection", CachedPolicyFactory.this.listCache, binding);
            }

            @Override
            public void removal(B binding, Behaviour behaviour) {
                CachedPolicyFactory.this.clearCache("aggregate delegate", CachedPolicyFactory.this.singleCache, binding);
                CachedPolicyFactory.this.clearCache("delegate collection", CachedPolicyFactory.this.listCache, binding);
            }
        });
    }

    @Override
    public P create(B binding) {
        Policy policyInterface;
        if (this.behaviourFilter != null && this.behaviourFilter.isActivated()) {
            return super.create(binding);
        }
        LockHelper.tryLock((Lock)this.lock.readLock(), (long)this.tryLockTimeout, (String)"getting policy from cache in 'CachedPolicyFactory.create()'");
        try {
            policyInterface = (Policy)this.singleCache.get(binding);
            if (policyInterface != null) {
                Policy policy = policyInterface;
                return (P)policy;
            }
        }
        finally {
            this.lock.readLock().unlock();
        }
        LockHelper.tryLock((Lock)this.lock.writeLock(), (long)this.tryLockTimeout, (String)"putting new policy to cache in 'CachedPolicyFactory.create()'");
        try {
            policyInterface = (Policy)this.singleCache.get(binding);
            if (policyInterface != null) {
                Policy policy = policyInterface;
                return (P)policy;
            }
            policyInterface = super.create(binding);
            this.singleCache.put(binding, policyInterface);
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("Cached delegate interface " + String.valueOf(policyInterface) + " for " + String.valueOf(binding) + " and policy " + String.valueOf(this.getPolicyClass())));
            }
            Policy policy = policyInterface;
            return (P)policy;
        }
        finally {
            this.lock.writeLock().unlock();
        }
    }

    @Override
    public Collection<P> createList(B binding) {
        Collection<P> policyInterfaces;
        if (this.behaviourFilter != null && this.behaviourFilter.isActivated()) {
            return super.createList(binding);
        }
        LockHelper.tryLock((Lock)this.lock.readLock(), (long)this.tryLockTimeout, (String)"getting policy list from cache in 'CachedPolicyFactory.createList()'");
        try {
            policyInterfaces = this.listCache.get(binding);
            if (policyInterfaces != null) {
                Collection<P> collection = policyInterfaces;
                return collection;
            }
        }
        finally {
            this.lock.readLock().unlock();
        }
        LockHelper.tryLock((Lock)this.lock.writeLock(), (long)this.tryLockTimeout, (String)"putting policy list to cache in 'CachedPolicyFactory.createList()'");
        try {
            policyInterfaces = this.listCache.get(binding);
            if (policyInterfaces != null) {
                Collection<P> collection = policyInterfaces;
                return collection;
            }
            policyInterfaces = super.createList(binding);
            this.listCache.put(binding, policyInterfaces);
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("Cached delegate interface collection " + String.valueOf(policyInterfaces) + " for " + String.valueOf(binding) + " and policy " + String.valueOf(this.getPolicyClass())));
            }
            Collection<P> collection = policyInterfaces;
            return collection;
        }
        finally {
            this.lock.writeLock().unlock();
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void clearCache(String cacheDescription, Map<B, ?> cache, B binding) {
        if (binding == null) {
            LockHelper.tryLock((Lock)this.lock.writeLock(), (long)this.tryLockTimeout, (String)"clearing policy cache in 'CachedPolicyFactory.clearCache()'");
            try {
                cache.clear();
                if (!logger.isDebugEnabled() || cache.isEmpty()) return;
                logger.debug((Object)("Cleared " + cacheDescription + " cache (all class bindings) for policy " + String.valueOf(this.getPolicyClass())));
                return;
            }
            finally {
                this.lock.writeLock().unlock();
            }
        }
        ArrayList<BehaviourBinding> invalidBindings = new ArrayList<BehaviourBinding>();
        Iterator<Object> iterator = cache.keySet().iterator();
        block6: while (iterator.hasNext()) {
            BehaviourBinding cachedBinding;
            BehaviourBinding generalisedBinding = cachedBinding = (BehaviourBinding)iterator.next();
            while (generalisedBinding != null) {
                if (generalisedBinding.equals(binding)) {
                    invalidBindings.add(cachedBinding);
                    continue block6;
                }
                generalisedBinding = generalisedBinding.generaliseBinding();
            }
        }
        if (invalidBindings.size() <= 0) return;
        LockHelper.tryLock((Lock)this.lock.writeLock(), (long)this.tryLockTimeout, (String)"removing invalid policy bindings from cache in 'CachedPolicyFactory.clearCache()'");
        try {
            for (BehaviourBinding invalidBinding : invalidBindings) {
                cache.remove(invalidBinding);
                if (!logger.isDebugEnabled()) continue;
                logger.debug((Object)("Cleared " + cacheDescription + " cache for " + String.valueOf(invalidBinding) + " and policy " + String.valueOf(this.getPolicyClass())));
            }
            return;
        }
        finally {
            this.lock.writeLock().unlock();
        }
    }
}

