/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.bulkimport;

import java.io.File;
import java.io.FileFilter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import org.alfresco.util.GUID;
import org.apache.commons.io.FileUtils;

public class CreateInPlaceTestData {
    private List<File> sourceFiles = new ArrayList<File>(50);
    private File targetFolder;
    private Random rand = new Random();
    private int startYear;
    private int maxYears;
    private int maxMonths;
    private int maxDays;
    private int maxHours;
    private int maxMinutes;
    private int maxFilesPerMinute;

    public CreateInPlaceTestData(int startYear, int maxYears, int maxMonths, int maxDays, int maxHours, int maxMinutes, int maxFilesPerMinute, String sourceFolderPath, String contentStore) {
        this.startYear = startYear;
        this.maxYears = maxYears;
        this.maxMonths = maxMonths;
        this.maxDays = maxDays;
        this.maxHours = maxHours;
        this.maxMinutes = maxMinutes;
        this.maxFilesPerMinute = maxFilesPerMinute;
        File sourceFolder = new File(sourceFolderPath);
        this.targetFolder = new File(contentStore);
        if (!sourceFolder.isDirectory()) {
            throw new IllegalArgumentException("source is not a folder");
        }
        if (!this.targetFolder.isDirectory()) {
            throw new IllegalArgumentException("target is not a folder");
        }
        this.initSourceFiles(sourceFolder);
    }

    private File getSourceFile() {
        int idx = this.rand.nextInt(this.sourceFiles.size());
        File f = this.sourceFiles.get(idx);
        return f;
    }

    private void createFile(File targetFolder) throws IOException {
        File f = new File(targetFolder, GUID.generate() + ".bin");
        FileUtils.copyFile((File)this.getSourceFile(), (File)f);
    }

    private void createFiles(File targetFolder) throws IOException {
        int i = 0;
        while (i < this.maxFilesPerMinute) {
            this.createFile(targetFolder);
            ++i;
        }
    }

    private void createDirectoryTree(File contentStore) throws IOException {
        int y = this.startYear;
        while (y < this.startYear + this.rand.nextInt(this.maxYears) + 1) {
            File year = new File(contentStore, String.valueOf(y));
            if (year.exists() || year.mkdir()) {
                int m = 1;
                while (m <= this.rand.nextInt(this.maxMonths) + 1) {
                    File month = new File(year, String.valueOf(m));
                    if (month.exists() || month.mkdir()) {
                        int d = 1;
                        while (d <= this.rand.nextInt(this.maxDays) + 1) {
                            File day = new File(month, String.valueOf(d));
                            if (day.exists() || day.mkdir()) {
                                int h = 1;
                                while (h <= this.rand.nextInt(this.maxHours) + 1) {
                                    File hour = new File(day, String.valueOf(h));
                                    if (hour.exists() || hour.mkdir()) {
                                        int mi = 1;
                                        while (mi <= this.rand.nextInt(this.maxMinutes) + 1) {
                                            File minute = new File(hour, String.valueOf(mi));
                                            if (minute.exists() || minute.mkdir()) {
                                                this.createFiles(minute);
                                            } else {
                                                System.err.println("Unable to create directory " + minute.getAbsolutePath());
                                            }
                                            ++mi;
                                        }
                                    } else {
                                        System.err.println("Unable to create directory " + hour.getAbsolutePath());
                                    }
                                    ++h;
                                }
                            } else {
                                System.err.println("Unable to create directory " + day.getAbsolutePath());
                            }
                            ++d;
                        }
                    } else {
                        System.err.println("Unable to create directory " + month.getAbsolutePath());
                    }
                    ++m;
                }
            } else {
                System.err.println("Unable to create directory " + year.getAbsolutePath());
            }
            ++y;
        }
    }

    private void initSourceFiles(File sourceFolder) {
        File[] fileArray = sourceFolder.listFiles(new FileFilter(){

            @Override
            public boolean accept(File file) {
                return !file.getName().startsWith(".");
            }
        });
        int n = fileArray.length;
        int n2 = 0;
        while (n2 < n) {
            File f = fileArray[n2];
            this.sourceFiles.add(f);
            ++n2;
        }
    }

    public void execute() throws IOException {
        this.createDirectoryTree(this.targetFolder);
    }

    public static void main(String[] args) {
        try {
            new CreateInPlaceTestData(Integer.parseInt(args[0]), Integer.parseInt(args[1]), Integer.parseInt(args[2]), Integer.parseInt(args[3]), Integer.parseInt(args[4]), Integer.parseInt(args[5]), Integer.parseInt(args[6]), args[7], args[8]).execute();
        }
        catch (Throwable e) {
            e.printStackTrace();
        }
    }
}

