/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.jscript;

import java.io.Serializable;
import java.util.Map;
import org.alfresco.repo.jscript.Scopeable;
import org.alfresco.repo.jscript.ScriptNode;
import org.alfresco.repo.jscript.ScriptableHashMap;
import org.alfresco.repo.jscript.ValueConverter;
import org.alfresco.repo.transaction.RetryingTransactionHelper;
import org.alfresco.service.ServiceRegistry;
import org.alfresco.service.cmr.action.Action;
import org.alfresco.service.cmr.action.ActionDefinition;
import org.alfresco.service.cmr.action.ActionService;
import org.alfresco.service.cmr.action.ParameterDefinition;
import org.alfresco.service.cmr.dictionary.DataTypeDefinition;
import org.alfresco.service.cmr.repository.NodeRef;
import org.alfresco.service.namespace.NamespacePrefixResolver;
import org.alfresco.service.namespace.NamespaceService;
import org.alfresco.service.namespace.QName;
import org.alfresco.service.transaction.TransactionService;
import org.mozilla.javascript.Scriptable;
import org.mozilla.javascript.Wrapper;

public class ScriptAction
implements Serializable,
Scopeable {
    private static final long serialVersionUID = 5794161358406531996L;
    private Scriptable scope;
    private ActionValueConverter converter;
    protected Action action;
    protected ActionDefinition actionDef;
    protected ServiceRegistry services;
    private ActionService actionService;
    private NamespaceService namespaceService;
    private TransactionService transactionService;
    private ScriptableParameterMap<String, Serializable> parameters = null;

    public ScriptAction(ServiceRegistry services, Action action, ActionDefinition actionDef) {
        this.services = services;
        this.actionService = services.getActionService();
        this.namespaceService = services.getNamespaceService();
        this.transactionService = services.getTransactionService();
        this.action = action;
        this.actionDef = actionDef;
        this.converter = new ActionValueConverter();
    }

    @Override
    public void setScope(Scriptable scope) {
        this.scope = scope;
    }

    public String getName() {
        return this.actionDef.getName();
    }

    public Map<String, Serializable> getParameters() {
        if (this.parameters == null) {
            this.parameters = new ScriptableParameterMap();
            Map<String, Serializable> actionParams = this.action.getParameterValues();
            for (Map.Entry<String, Serializable> entry : actionParams.entrySet()) {
                String name = entry.getKey();
                this.parameters.put(name, this.converter.convertActionParamForScript(name, entry.getValue()));
            }
            this.parameters.setModified(false);
        }
        return this.parameters;
    }

    public void execute(ScriptNode node) {
        this.performParamConversionForRepo();
        this.executeImpl(node);
        this.parameters = null;
        node.reset();
    }

    public void executeAsynchronously(ScriptNode node) {
        this.performParamConversionForRepo();
        this.executeAsynchronouslyImpl(node);
        this.parameters = null;
        node.reset();
    }

    protected void executeImpl(ScriptNode node) {
        this.actionService.executeAction(this.action, node.getNodeRef());
    }

    protected void executeAsynchronouslyImpl(ScriptNode node) {
        this.actionService.executeAction(this.action, node.getNodeRef(), true, true);
    }

    public void execute(final ScriptNode node, boolean readOnly, boolean newTxn) {
        this.performParamConversionForRepo();
        RetryingTransactionHelper.RetryingTransactionCallback<Object> executionActionCallback = new RetryingTransactionHelper.RetryingTransactionCallback<Object>(){

            @Override
            public Object execute() throws Throwable {
                ScriptAction.this.executeImpl(node);
                return null;
            }
        };
        this.transactionService.getRetryingTransactionHelper().doInTransaction(executionActionCallback, readOnly, newTxn);
        this.parameters = null;
        node.reset();
    }

    public void execute(NodeRef nodeRef) {
        this.performParamConversionForRepo();
        this.actionService.executeAction(this.action, nodeRef);
        this.parameters = null;
    }

    public void execute(final NodeRef nodeRef, boolean readOnly, boolean newTxn) {
        this.performParamConversionForRepo();
        RetryingTransactionHelper.RetryingTransactionCallback<Object> executionActionCallback = new RetryingTransactionHelper.RetryingTransactionCallback<Object>(){

            @Override
            public Object execute() throws Throwable {
                ScriptAction.this.actionService.executeAction(ScriptAction.this.action, nodeRef);
                return null;
            }
        };
        this.transactionService.getRetryingTransactionHelper().doInTransaction(executionActionCallback, readOnly, newTxn);
        this.parameters = null;
    }

    protected void performParamConversionForRepo() {
        if (this.parameters != null && this.parameters.isModified()) {
            Map<String, Serializable> actionParams = this.action.getParameterValues();
            actionParams.clear();
            for (Map.Entry entry : this.parameters.entrySet()) {
                String name = (String)entry.getKey();
                Serializable value = this.converter.convertActionParamForRepo(name, (Serializable)entry.getValue());
                actionParams.put(name, value);
            }
        }
    }

    private class ActionValueConverter
    extends ValueConverter {
        private ActionValueConverter() {
        }

        public Serializable convertActionParamForScript(String paramName, Serializable value) {
            ParameterDefinition paramDef = ScriptAction.this.actionDef.getParameterDefintion(paramName);
            if (paramDef != null && paramDef.getType().equals((Object)DataTypeDefinition.QNAME)) {
                return ((QName)value).toPrefixString((NamespacePrefixResolver)ScriptAction.this.namespaceService);
            }
            return this.convertValueForScript(ScriptAction.this.services, ScriptAction.this.scope, null, value);
        }

        public Serializable convertActionParamForRepo(String paramName, Serializable value) {
            ParameterDefinition paramDef = ScriptAction.this.actionDef.getParameterDefintion(paramName);
            if (paramDef != null && paramDef.getType().equals((Object)DataTypeDefinition.QNAME)) {
                if (value instanceof Wrapper) {
                    return this.convertActionParamForRepo(paramName, (Serializable)((Wrapper)value).unwrap());
                }
                if (value instanceof String) {
                    String stringQName = (String)((Object)value);
                    if (stringQName.startsWith("{")) {
                        return QName.createQName((String)stringQName);
                    }
                    return QName.createQName((String)stringQName, (NamespacePrefixResolver)ScriptAction.this.namespaceService);
                }
                return value;
            }
            return this.convertValueForRepo(value);
        }
    }

    public static final class ScriptableParameterMap<K, V>
    extends ScriptableHashMap<K, V> {
        private static final long serialVersionUID = 574661815973241554L;
        private boolean modified = false;

        boolean isModified() {
            return this.modified;
        }

        void setModified(boolean modified) {
            this.modified = modified;
        }

        @Override
        public String getClassName() {
            return "ScriptableParameterMap";
        }

        @Override
        public void delete(String name) {
            super.delete(name);
            this.setModified(true);
        }

        @Override
        public void put(String name, Scriptable start, Object value) {
            super.put(name, start, value);
            this.setModified(true);
        }
    }
}

