/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.virtual.ref;

import java.util.Collections;
import junit.framework.TestCase;
import org.alfresco.repo.virtual.ref.ClasspathResource;
import org.alfresco.repo.virtual.ref.Encoding;
import org.alfresco.repo.virtual.ref.Encodings;
import org.alfresco.repo.virtual.ref.HashReferenceParser;
import org.alfresco.repo.virtual.ref.HashStore;
import org.alfresco.repo.virtual.ref.HashStoreConfiguration;
import org.alfresco.repo.virtual.ref.HashStringifier;
import org.alfresco.repo.virtual.ref.NodeProtocol;
import org.alfresco.repo.virtual.ref.Protocols;
import org.alfresco.repo.virtual.ref.Reference;
import org.alfresco.repo.virtual.ref.RepositoryLocation;
import org.alfresco.repo.virtual.ref.RepositoryNodeRef;
import org.alfresco.repo.virtual.ref.RepositoryPath;
import org.alfresco.repo.virtual.ref.RepositoryResource;
import org.alfresco.repo.virtual.ref.Resource;
import org.alfresco.repo.virtual.ref.VanillaProtocol;
import org.alfresco.repo.virtual.ref.VirtualProtocol;
import org.alfresco.service.cmr.repository.NodeRef;
import org.junit.Test;

public class HashStringifierTest
extends TestCase {
    private HashStore cpHashStore;

    public void setUp() {
        this.cpHashStore = HashStoreConfiguration.getInstance().getClasspathHashStore();
        this.cpHashStore.put("/com/alfresco", "1");
    }

    private Reference stringifyParse(Reference reference) {
        String encodedReferenceString = new HashStringifier().stringify(reference);
        Reference paresedReference = new HashReferenceParser().parse(encodedReferenceString);
        return paresedReference;
    }

    @Test
    public void testStringifyVirtualReference_nodeRef() {
        NodeRef templateNodeRef = new NodeRef("workspace://SpacesStore/0d3b26ff-c4c1-4680-8622-8608ea7ab4b2");
        NodeRef actualNode = new NodeRef("workspace://SpacesStore/67c8f11d-0936-4295-88a0-12b85764c76f");
        Reference virtualReference = ((VirtualProtocol)Protocols.VIRTUAL.protocol).newReference(templateNodeRef, "/1/2/3", actualNode);
        Reference spReference = this.stringifyParse(virtualReference);
        HashStringifierTest.assertEquals((Object)virtualReference, (Object)spReference);
    }

    @Test
    public void testStringifyVirtualReference_classpath() {
        ClasspathResource classpathTemplate = new ClasspathResource("/com/alfresco/template.js");
        NodeRef actualNode = new NodeRef("workspace://SpacesStore/67c8f11d-0936-4295-88a0-12b85764c76f");
        RepositoryResource actualNodeResource = new RepositoryResource((RepositoryLocation)new RepositoryNodeRef(actualNode));
        Reference virtualReference = ((VirtualProtocol)Protocols.VIRTUAL.protocol).newReference(Encodings.PLAIN.encoding, (Resource)classpathTemplate, "/1/2/3", (Resource)actualNodeResource, Collections.emptyList());
        Reference spReference = this.stringifyParse(virtualReference);
        HashStringifierTest.assertEquals((Object)virtualReference, (Object)spReference);
    }

    @Test
    public void testStringifyVirtualReference_actualRepositoryPath() {
        ClasspathResource classpathTemplate = new ClasspathResource("/com/alfresco/template.js");
        RepositoryResource actualNodeResource = new RepositoryResource((RepositoryLocation)new RepositoryPath("/app:company_home/cm:aVirtualFolder"));
        Reference virtualReference = ((VirtualProtocol)Protocols.VIRTUAL.protocol).newReference(Encodings.PLAIN.encoding, (Resource)classpathTemplate, "/1/2/3", (Resource)actualNodeResource, Collections.emptyList());
        Reference spReference = this.stringifyParse(virtualReference);
        HashStringifierTest.assertEquals((Object)virtualReference, (Object)spReference);
    }

    @Test
    public void testStringifyVirtualReference_root() {
        NodeRef templateNodeRef = new NodeRef("workspace://SpacesStore/0d3b26ff-c4c1-4680-8622-8608ea7ab4b2");
        NodeRef actualNode = new NodeRef("workspace://SpacesStore/67c8f11d-0936-4295-88a0-12b85764c76f");
        Reference virtualReference = ((VirtualProtocol)Protocols.VIRTUAL.protocol).newReference(templateNodeRef, "/", actualNode);
        Reference spReference = this.stringifyParse(virtualReference);
        HashStringifierTest.assertEquals((Object)virtualReference, (Object)spReference);
    }

    @Test
    public void testStringifyNodeReference_actualRepositoryPath() {
        NodeRef templateNodeRef = new NodeRef("workspace://SpacesStore/0d3b26ff-c4c1-4680-8622-8608ea7ab4b2");
        NodeRef actualTemplateNode = new NodeRef("workspace://SpacesStore/67c8f11d-0936-4295-88a0-12b85764c76f");
        Reference virtualReference = ((VirtualProtocol)Protocols.VIRTUAL.protocol).newReference(templateNodeRef, "/1/2/3", actualTemplateNode);
        RepositoryResource actualNodeResource = new RepositoryResource((RepositoryLocation)new RepositoryPath("/app:company_home/cm:aVirtualFolder"));
        Reference nodeReference = NodeProtocol.newReference((Encoding)Encodings.PLAIN.encoding, (Resource)actualNodeResource, (Reference)virtualReference);
        Reference spReference = this.stringifyParse(nodeReference);
        HashStringifierTest.assertEquals((Object)nodeReference, (Object)spReference);
    }

    @Test
    public void testStringifyNodeReference_actualNodeRef() {
        NodeRef templateNodeRef = new NodeRef("workspace://SpacesStore/0d3b26ff-c4c1-4680-8622-8608ea7ab4b2");
        NodeRef actualTemplateNode = new NodeRef("workspace://SpacesStore/67c8f11d-0936-4295-88a0-12b85764c76f");
        Reference virtualReference = ((VirtualProtocol)Protocols.VIRTUAL.protocol).newReference(templateNodeRef, "/1/2/3", actualTemplateNode);
        NodeRef actualNode = new NodeRef("workspace://SpacesStore/00c8f11d-0936-4295-88a0-12b85764c76f");
        Reference nodeReference = NodeProtocol.newReference((NodeRef)actualNode, (Reference)virtualReference);
        Reference spReference = this.stringifyParse(nodeReference);
        HashStringifierTest.assertEquals((Object)nodeReference, (Object)spReference);
    }

    @Test
    public void testStringifyVanillaReference_classpath() {
        ClasspathResource virtualClasspathTemplate = new ClasspathResource("/com/alfresco/template.js");
        NodeRef actualNode = new NodeRef("workspace://SpacesStore/67c8f11d-0936-4295-88a0-12b85764c76f");
        RepositoryResource actualNodeResource = new RepositoryResource((RepositoryLocation)new RepositoryNodeRef(actualNode));
        ClasspathResource vanillaClasspathTemplate = new ClasspathResource("/com/alfresco/vanilla-template.js");
        Reference vanillaReference = ((VanillaProtocol)Protocols.VANILLA.protocol).newReference(Encodings.PLAIN.encoding, (Resource)virtualClasspathTemplate, "/1/2/3", (Resource)actualNodeResource, (Resource)vanillaClasspathTemplate, Collections.emptyList());
        Reference spReference = this.stringifyParse(vanillaReference);
        HashStringifierTest.assertEquals((Object)vanillaReference, (Object)spReference);
    }
}

