/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.node;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.alfresco.repo.node.BaseNodeServiceTest;
import org.alfresco.repo.node.MLPropertyInterceptor;
import org.alfresco.service.cmr.dictionary.DictionaryException;
import org.alfresco.service.cmr.repository.MLText;
import org.alfresco.service.cmr.repository.NodeRef;
import org.alfresco.service.cmr.repository.NodeService;
import org.alfresco.service.cmr.repository.datatype.DefaultTypeConverter;
import org.alfresco.service.namespace.QName;
import org.alfresco.test_category.OwnJVMTestsCategory;
import org.junit.After;
import org.junit.Before;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.springframework.extensions.surf.util.I18NUtil;
import org.springframework.test.context.transaction.TestTransaction;
import org.springframework.transaction.annotation.Transactional;

@Transactional
@Category(value={OwnJVMTestsCategory.class})
public class FullNodeServiceTest
extends BaseNodeServiceTest {
    private static Locale contentLocaleToRestore;
    private static Locale localeToRestore;

    @Override
    protected NodeService getNodeService() {
        return (NodeService)this.applicationContext.getBean("NodeService");
    }

    @Override
    @Before
    public void before() {
        super.before();
        contentLocaleToRestore = I18NUtil.getContentLocale();
        localeToRestore = I18NUtil.getLocale();
        Locale.setDefault(Locale.ENGLISH);
        MLPropertyInterceptor.setMLAware((boolean)false);
    }

    @Override
    @After
    public void after() {
        super.after();
        I18NUtil.setContentLocale((Locale)contentLocaleToRestore);
        I18NUtil.setLocale((Locale)localeToRestore);
    }

    @Test
    public void testMLTextValues() throws Exception {
        Locale.setDefault(Locale.ENGLISH);
        MLText mlTextProperty = new MLText();
        mlTextProperty.addValue(Locale.ENGLISH, "Very good!");
        mlTextProperty.addValue(Locale.FRENCH, "Tr\u00e8s bon!");
        mlTextProperty.addValue(Locale.GERMAN, "Sehr gut!");
        this.nodeService.setProperty(this.rootNodeRef, BaseNodeServiceTest.PROP_QNAME_ML_TEXT_VALUE, (Serializable)mlTextProperty);
        Serializable textValueFiltered = this.nodeService.getProperty(this.rootNodeRef, BaseNodeServiceTest.PROP_QNAME_ML_TEXT_VALUE);
        FullNodeServiceTest.assertEquals((String)"Default locale value not taken for ML text", (Object)mlTextProperty.getValue(Locale.ENGLISH), (Object)textValueFiltered);
        Map propertiesFiltered = this.nodeService.getProperties(this.rootNodeRef);
        FullNodeServiceTest.assertEquals((String)"Default locale value not taken for ML text in Map", (Object)mlTextProperty.getValue(Locale.ENGLISH), propertiesFiltered.get(BaseNodeServiceTest.PROP_QNAME_ML_TEXT_VALUE));
    }

    @Test
    public void testMLTextUpdatedForCorrectLanguage() throws Exception {
        Locale.setDefault(Locale.UK);
        MLPropertyInterceptor.setMLAware((boolean)true);
        MLText mlTextProperty = new MLText();
        mlTextProperty.addValue(Locale.UK, "en_GB String");
        mlTextProperty.addValue(Locale.FRANCE, "fr_FR String");
        this.nodeService.setProperty(this.rootNodeRef, BaseNodeServiceTest.PROP_QNAME_ML_TEXT_VALUE, (Serializable)mlTextProperty);
        Serializable textValue = this.nodeService.getProperty(this.rootNodeRef, BaseNodeServiceTest.PROP_QNAME_ML_TEXT_VALUE);
        FullNodeServiceTest.assertEquals((int)2, (int)((MLText)textValue).size());
        FullNodeServiceTest.assertEquals((String)"en_GB String", (String)((MLText)textValue).getValue(Locale.UK));
        FullNodeServiceTest.assertEquals((String)"fr_FR String", (String)((MLText)textValue).getValue(Locale.FRANCE));
        MLPropertyInterceptor.setMLAware((boolean)false);
        textValue = this.nodeService.getProperty(this.rootNodeRef, BaseNodeServiceTest.PROP_QNAME_ML_TEXT_VALUE);
        FullNodeServiceTest.assertEquals((String)"en_GB String", (String)((String)((Object)textValue)));
        Locale.setDefault(Locale.US);
        this.nodeService.setProperty(this.rootNodeRef, BaseNodeServiceTest.PROP_QNAME_ML_TEXT_VALUE, (Serializable)((Object)"Not using MLText for this part."));
        MLPropertyInterceptor.setMLAware((boolean)true);
        textValue = this.nodeService.getProperty(this.rootNodeRef, BaseNodeServiceTest.PROP_QNAME_ML_TEXT_VALUE);
        FullNodeServiceTest.assertEquals((int)2, (int)((MLText)textValue).size());
        FullNodeServiceTest.assertEquals((String)"Text wasn't updated correctly", (String)"Not using MLText for this part.", (String)((MLText)textValue).getValue(Locale.ENGLISH));
        FullNodeServiceTest.assertEquals((String)"Failed to get text using locale it was added with", (String)"Not using MLText for this part.", (String)((MLText)textValue).getClosestValue(Locale.US));
        FullNodeServiceTest.assertEquals((String)"Failed to get text using original locale", (String)"Not using MLText for this part.", (String)((MLText)textValue).getClosestValue(Locale.UK));
        FullNodeServiceTest.assertEquals((String)"fr_FR String", (String)((MLText)textValue).getValue(Locale.FRANCE));
    }

    @Test
    public void testMLTextCollectionUpdatedForCorrectLanguage() {
        Locale.setDefault(Locale.UK);
        I18NUtil.setContentLocale((Locale)Locale.UK);
        I18NUtil.setLocale((Locale)Locale.UK);
        MLPropertyInterceptor.setMLAware((boolean)true);
        ArrayList<Object> values = new ArrayList<Object>();
        values.add(new MLText(Locale.UK, "en_GB text"));
        values.add(new MLText(Locale.US, "en_US text"));
        values.add(new MLText(Locale.FRANCE, "fr_FR text"));
        this.nodeService.setProperty(this.rootNodeRef, BaseNodeServiceTest.PROP_QNAME_MULTI_ML_VALUE, values);
        List checkValues = (List)((Object)this.nodeService.getProperty(this.rootNodeRef, BaseNodeServiceTest.PROP_QNAME_MULTI_ML_VALUE));
        FullNodeServiceTest.assertEquals((String)"Expected 3 MLText values back", (int)3, (int)checkValues.size());
        FullNodeServiceTest.assertEquals((String)"en_GB text", (String)((MLText)checkValues.get(0)).getValue(Locale.UK));
        FullNodeServiceTest.assertEquals((String)"en_US text", (String)((MLText)checkValues.get(1)).getValue(Locale.US));
        FullNodeServiceTest.assertEquals((String)"fr_FR text", (String)((MLText)checkValues.get(2)).getValue(Locale.FRANCE));
        MLPropertyInterceptor.setMLAware((boolean)false);
        checkValues = (List)((Object)this.nodeService.getProperty(this.rootNodeRef, BaseNodeServiceTest.PROP_QNAME_MULTI_ML_VALUE));
        FullNodeServiceTest.assertEquals((String)"Expected 1 MLText values back", (int)1, (int)checkValues.size());
        FullNodeServiceTest.assertEquals((String)"en_GB text", (String)((String)checkValues.get(0)));
        Locale.setDefault(Locale.US);
        values.clear();
        values.add("text 1 added using en_US");
        values.add("text 2 added using en_US");
        values.add("text 3 added using en_US");
        values.add("text 4 added using en_US");
        this.nodeService.setProperty(this.rootNodeRef, BaseNodeServiceTest.PROP_QNAME_MULTI_ML_VALUE, values);
        MLPropertyInterceptor.setMLAware((boolean)true);
        checkValues = (List)((Object)this.nodeService.getProperty(this.rootNodeRef, BaseNodeServiceTest.PROP_QNAME_MULTI_ML_VALUE));
        FullNodeServiceTest.assertEquals((String)"Expected 3 MLText values back", (int)4, (int)checkValues.size());
        MLText mlText = (MLText)checkValues.get(0);
        FullNodeServiceTest.assertEquals((String)"en_GB should be replaced with new, not added to", (int)1, (int)mlText.size());
        FullNodeServiceTest.assertEquals((String)"text 1 added using en_US", (String)mlText.getValue(Locale.ENGLISH));
        mlText = (MLText)checkValues.get(1);
        FullNodeServiceTest.assertEquals((String)"en_US should be replaced with new, not added to", (int)1, (int)mlText.size());
        FullNodeServiceTest.assertEquals((String)"text 2 added using en_US", (String)mlText.getValue(Locale.ENGLISH));
        mlText = (MLText)checkValues.get(2);
        FullNodeServiceTest.assertEquals((String)"en_US should be added to fr_FR", (int)2, (int)mlText.size());
        FullNodeServiceTest.assertEquals((String)"fr_FR text", (String)mlText.getValue(Locale.FRANCE));
        FullNodeServiceTest.assertEquals((String)"text 3 added using en_US", (String)mlText.getValue(Locale.ENGLISH));
        mlText = (MLText)checkValues.get(3);
        FullNodeServiceTest.assertEquals((String)"entirely new text value should be added", (int)1, (int)mlText.size());
        FullNodeServiceTest.assertEquals((String)"text 4 added using en_US", (String)mlText.getValue(Locale.ENGLISH));
    }

    @Test
    public void testLongMLTextValues() throws Exception {
        StringBuilder sb = new StringBuilder();
        int i = 0;
        while (i < 4096) {
            sb.append(" ").append(i);
            ++i;
        }
        String longString = sb.toString();
        Locale.setDefault(Locale.ENGLISH);
        this.nodeService.setProperty(this.rootNodeRef, BaseNodeServiceTest.PROP_QNAME_ML_TEXT_VALUE, (Serializable)((Object)longString));
        MLText mlTextProperty = new MLText();
        mlTextProperty.addValue(Locale.ENGLISH, longString);
        mlTextProperty.addValue(Locale.FRENCH, longString);
        mlTextProperty.addValue(Locale.GERMAN, longString);
        this.nodeService.setProperty(this.rootNodeRef, BaseNodeServiceTest.PROP_QNAME_ML_TEXT_VALUE, (Serializable)mlTextProperty);
    }

    @Test
    public void testNullMLText() throws Exception {
        this.nodeService.setProperty(this.rootNodeRef, BaseNodeServiceTest.PROP_QNAME_ML_TEXT_VALUE, null);
        Serializable mlTextSer = this.nodeService.getProperty(this.rootNodeRef, BaseNodeServiceTest.PROP_QNAME_ML_TEXT_VALUE);
        MLText mlText = (MLText)DefaultTypeConverter.INSTANCE.convert(MLText.class, (Object)mlTextSer);
        FullNodeServiceTest.assertNull((String)"Value returned is not null", (Object)mlText);
        mlText = new MLText(null);
        this.nodeService.setProperty(this.rootNodeRef, BaseNodeServiceTest.PROP_QNAME_ML_TEXT_VALUE, (Serializable)mlText);
        MLText mlTextCheck = (MLText)this.nodeService.getProperty(this.rootNodeRef, BaseNodeServiceTest.PROP_QNAME_ML_TEXT_VALUE);
        FullNodeServiceTest.assertNull((String)"MLText value should have been converted to a null String", (Object)mlTextCheck);
        this.nodeService.setProperty(this.rootNodeRef, BaseNodeServiceTest.PROP_QNAME_ML_TEXT_VALUE, null);
        MLPropertyInterceptor.setMLAware((boolean)true);
        try {
            mlText = new MLText(null);
            this.nodeService.setProperty(this.rootNodeRef, BaseNodeServiceTest.PROP_QNAME_ML_TEXT_VALUE, (Serializable)mlText);
            mlTextCheck = (MLText)this.nodeService.getProperty(this.rootNodeRef, BaseNodeServiceTest.PROP_QNAME_ML_TEXT_VALUE);
            FullNodeServiceTest.assertEquals((String)"MLText value was not pulled out the same as it went in", (Object)mlText, (Object)mlTextCheck);
            this.nodeService.setProperty(this.rootNodeRef, BaseNodeServiceTest.PROP_QNAME_ML_TEXT_VALUE, null);
        }
        finally {
            MLPropertyInterceptor.setMLAware((boolean)false);
        }
    }

    @Test
    public void testMLValuesOnCreate() throws Exception {
        HashMap<QName, Serializable> properties = new HashMap<QName, Serializable>();
        this.fillProperties(BaseNodeServiceTest.TYPE_QNAME_TEST_MANY_PROPERTIES, properties);
        properties.put(BaseNodeServiceTest.PROP_QNAME_ML_TEXT_VALUE, (Serializable)((Object)"Bonjour"));
        I18NUtil.setContentLocale((Locale)Locale.FRENCH);
        NodeRef nodeRef = this.nodeService.createNode(this.rootNodeRef, BaseNodeServiceTest.ASSOC_TYPE_QNAME_TEST_CHILDREN, QName.createQName((String)"http://www.alfresco.org/test/BaseNodeServiceTest", (String)((Object)((Object)this)).getClass().getName()), BaseNodeServiceTest.TYPE_QNAME_TEST_MANY_PROPERTIES, properties).getChildRef();
        I18NUtil.setContentLocale((Locale)Locale.ENGLISH);
        this.nodeService.setProperty(nodeRef, BaseNodeServiceTest.PROP_QNAME_ML_TEXT_VALUE, (Serializable)((Object)"Hello"));
        I18NUtil.setContentLocale((Locale)Locale.FRENCH);
        FullNodeServiceTest.assertEquals((String)"Expected French value property", (Object)"Bonjour", (Object)this.nodeService.getProperty(nodeRef, BaseNodeServiceTest.PROP_QNAME_ML_TEXT_VALUE));
        I18NUtil.setContentLocale((Locale)Locale.ENGLISH);
        FullNodeServiceTest.assertEquals((String)"Expected English value property", (Object)"Hello", (Object)this.nodeService.getProperty(nodeRef, BaseNodeServiceTest.PROP_QNAME_ML_TEXT_VALUE));
    }

    @Test
    public void testMLValuesOnAddAspect() throws Exception {
        HashMap<QName, Serializable> properties = new HashMap<QName, Serializable>();
        this.fillProperties(BaseNodeServiceTest.TYPE_QNAME_TEST_MANY_PROPERTIES, properties);
        properties.put(BaseNodeServiceTest.PROP_QNAME_ML_TEXT_VALUE, (Serializable)((Object)"Bonjour"));
        I18NUtil.setContentLocale((Locale)Locale.FRENCH);
        NodeRef nodeRef = this.rootNodeRef;
        this.nodeService.addAspect(nodeRef, BaseNodeServiceTest.ASPECT_QNAME_TEST_TITLED, properties);
        I18NUtil.setContentLocale((Locale)Locale.ENGLISH);
        this.nodeService.setProperty(nodeRef, BaseNodeServiceTest.PROP_QNAME_ML_TEXT_VALUE, (Serializable)((Object)"Hello"));
        I18NUtil.setContentLocale((Locale)Locale.FRENCH);
        FullNodeServiceTest.assertEquals((String)"Expected French value property", (Object)"Bonjour", (Object)this.nodeService.getProperty(nodeRef, BaseNodeServiceTest.PROP_QNAME_ML_TEXT_VALUE));
        I18NUtil.setContentLocale((Locale)Locale.ENGLISH);
        FullNodeServiceTest.assertEquals((String)"Expected English value property", (Object)"Hello", (Object)this.nodeService.getProperty(nodeRef, BaseNodeServiceTest.PROP_QNAME_ML_TEXT_VALUE));
    }

    @Test
    public void testMLValuesOnAddProperties() throws Exception {
        HashMap<QName, Serializable> properties = new HashMap<QName, Serializable>();
        this.fillProperties(BaseNodeServiceTest.TYPE_QNAME_TEST_MANY_PROPERTIES, properties);
        properties.put(BaseNodeServiceTest.PROP_QNAME_ML_TEXT_VALUE, (Serializable)((Object)"Bonjour"));
        I18NUtil.setContentLocale((Locale)Locale.FRENCH);
        NodeRef nodeRef = this.rootNodeRef;
        this.nodeService.addProperties(nodeRef, properties);
        I18NUtil.setContentLocale((Locale)Locale.ENGLISH);
        this.nodeService.setProperty(nodeRef, BaseNodeServiceTest.PROP_QNAME_ML_TEXT_VALUE, (Serializable)((Object)"Hello"));
        I18NUtil.setContentLocale((Locale)Locale.FRENCH);
        FullNodeServiceTest.assertEquals((String)"Expected French value property", (Object)"Bonjour", (Object)this.nodeService.getProperty(nodeRef, BaseNodeServiceTest.PROP_QNAME_ML_TEXT_VALUE));
        I18NUtil.setContentLocale((Locale)Locale.ENGLISH);
        FullNodeServiceTest.assertEquals((String)"Expected English value property", (Object)"Hello", (Object)this.nodeService.getProperty(nodeRef, BaseNodeServiceTest.PROP_QNAME_ML_TEXT_VALUE));
    }

    @Override
    protected void getExpectedPropertyValues(Map<QName, Serializable> checkProperties) {
        MLText mlTextValue = (MLText)checkProperties.get(BaseNodeServiceTest.PROP_QNAME_ML_TEXT_VALUE);
        String strValue = mlTextValue.getDefaultValue();
        checkProperties.put(BaseNodeServiceTest.PROP_QNAME_ML_TEXT_VALUE, (Serializable)((Object)strValue));
    }

    @Override
    @Test
    public void testMultiProp() throws Exception {
        ArrayList<Object> values;
        NodeRef nodeRef;
        block8: {
            QName undeclaredPropQName = QName.createQName((String)"http://www.alfresco.org/test/BaseNodeServiceTest", (String)((Object)((Object)this)).getClass().getName());
            nodeRef = this.nodeService.createNode(this.rootNodeRef, BaseNodeServiceTest.ASSOC_TYPE_QNAME_TEST_CHILDREN, QName.createQName((String)"pathA"), BaseNodeServiceTest.TYPE_QNAME_TEST_MULTIPLE_TESTER).getChildRef();
            values = new ArrayList<Object>(1);
            values.add("ABC");
            values.add("DEF");
            this.nodeService.setProperty(nodeRef, BaseNodeServiceTest.PROP_QNAME_STRING_PROP_SINGLE, (Serializable)((Object)"ABC"));
            this.nodeService.setProperty(nodeRef, BaseNodeServiceTest.PROP_QNAME_STRING_PROP_MULTIPLE, (Serializable)((Object)"ABC"));
            this.nodeService.setProperty(nodeRef, BaseNodeServiceTest.PROP_QNAME_STRING_PROP_MULTIPLE, values);
            this.nodeService.setProperty(nodeRef, BaseNodeServiceTest.PROP_QNAME_ANY_PROP_SINGLE, (Serializable)((Object)"ABC"));
            this.nodeService.setProperty(nodeRef, BaseNodeServiceTest.PROP_QNAME_ANY_PROP_SINGLE, values);
            this.nodeService.setProperty(nodeRef, BaseNodeServiceTest.PROP_QNAME_ANY_PROP_MULTIPLE, (Serializable)((Object)"ABC"));
            this.nodeService.setProperty(nodeRef, BaseNodeServiceTest.PROP_QNAME_ANY_PROP_MULTIPLE, values);
            this.nodeService.setProperty(nodeRef, undeclaredPropQName, (Serializable)((Object)"ABC"));
            this.nodeService.setProperty(nodeRef, undeclaredPropQName, values);
            TestTransaction.flagForCommit();
            TestTransaction.end();
            TestTransaction.start();
            try {
                try {
                    this.nodeService.setProperty(nodeRef, BaseNodeServiceTest.PROP_QNAME_STRING_PROP_SINGLE, values);
                }
                catch (DictionaryException dictionaryException) {
                    TestTransaction.flagForRollback();
                    TestTransaction.end();
                    break block8;
                }
            }
            catch (Throwable throwable) {
                TestTransaction.flagForRollback();
                TestTransaction.end();
                throw throwable;
            }
            TestTransaction.flagForRollback();
            TestTransaction.end();
        }
        TestTransaction.start();
        try {
            values.clear();
            values.add(new MLText("ABC"));
            values.add(new MLText("DEF"));
            this.nodeService.setProperty(nodeRef, BaseNodeServiceTest.PROP_QNAME_MULTI_ML_VALUE, values);
            List checkValues = (List)((Object)this.nodeService.getProperty(nodeRef, BaseNodeServiceTest.PROP_QNAME_MULTI_ML_VALUE));
            FullNodeServiceTest.assertEquals((String)"Expected 2 MLText values back", (int)2, (int)checkValues.size());
            FullNodeServiceTest.assertTrue((String)"Incorrect type in collection", (boolean)(checkValues.get(0) instanceof String));
            FullNodeServiceTest.assertTrue((String)"Incorrect type in collection", (boolean)(checkValues.get(1) instanceof String));
            values.clear();
            ArrayList<String> arrayListVal = new ArrayList<String>(2);
            HashSet<String> hashSetVal = new HashSet<String>(2);
            values.add(arrayListVal);
            values.add(hashSetVal);
            this.nodeService.setProperty(nodeRef, BaseNodeServiceTest.PROP_QNAME_ANY_PROP_MULTIPLE, values);
            checkValues = (List)((Object)this.nodeService.getProperty(nodeRef, BaseNodeServiceTest.PROP_QNAME_ANY_PROP_MULTIPLE));
            FullNodeServiceTest.assertEquals((String)"Expected 2 Collection values back", (int)2, (int)checkValues.size());
            FullNodeServiceTest.assertTrue((String)"Incorrect type in collection", (boolean)(checkValues.get(0) instanceof ArrayList));
            FullNodeServiceTest.assertTrue((String)"Incorrect type in collection", (boolean)(checkValues.get(1) instanceof HashSet));
            arrayListVal.add("ONE");
            arrayListVal.add("TWO");
            hashSetVal.add("ONE");
            hashSetVal.add("TWO");
            values.clear();
            values.add(arrayListVal);
            values.add(hashSetVal);
            this.nodeService.setProperty(nodeRef, BaseNodeServiceTest.PROP_QNAME_ANY_PROP_MULTIPLE, values);
            checkValues = (List)((Object)this.nodeService.getProperty(nodeRef, BaseNodeServiceTest.PROP_QNAME_ANY_PROP_MULTIPLE));
            FullNodeServiceTest.assertEquals((String)"Expected 2 Collection values back", (int)2, (int)checkValues.size());
            FullNodeServiceTest.assertTrue((String)"Incorrect type in collection", (boolean)(checkValues.get(0) instanceof ArrayList));
            FullNodeServiceTest.assertTrue((String)"Incorrect type in collection", (boolean)(checkValues.get(1) instanceof HashSet));
            FullNodeServiceTest.assertEquals((String)"First collection incorrect", (int)2, (int)((Collection)checkValues.get(0)).size());
            FullNodeServiceTest.assertEquals((String)"Second collection incorrect", (int)2, (int)((Collection)checkValues.get(1)).size());
        }
        finally {
            TestTransaction.flagForRollback();
            TestTransaction.end();
        }
    }

    @Override
    @Test
    public void testMultiValueMLTextProperties() throws Exception {
        NodeRef nodeRef = this.nodeService.createNode(this.rootNodeRef, BaseNodeServiceTest.ASSOC_TYPE_QNAME_TEST_CHILDREN, QName.createQName((String)"pathA"), BaseNodeServiceTest.TYPE_QNAME_TEST_MANY_ML_PROPERTIES).getChildRef();
        ArrayList<MLText> mlTextCollection = new ArrayList<MLText>(2);
        MLText mlText0 = new MLText();
        mlText0.addValue(Locale.ENGLISH, "Hello");
        mlText0.addValue(Locale.FRENCH, "Bonjour");
        mlTextCollection.add(mlText0);
        MLText mlText1 = new MLText();
        mlText1.addValue(Locale.ENGLISH, "Bye bye");
        mlText1.addValue(Locale.FRENCH, "Au revoir");
        mlTextCollection.add(mlText1);
        this.nodeService.setProperty(nodeRef, BaseNodeServiceTest.PROP_QNAME_MULTI_ML_VALUE, (Serializable)mlTextCollection);
        I18NUtil.setContentLocale((Locale)Locale.ENGLISH);
        Collection mlTextCollectionCheck = (Collection)((Object)this.nodeService.getProperty(nodeRef, BaseNodeServiceTest.PROP_QNAME_MULTI_ML_VALUE));
        FullNodeServiceTest.assertEquals((String)"MLText collection didn't come back correctly.", Arrays.asList("Hello", "Bye bye"), (Object)mlTextCollectionCheck);
        I18NUtil.setContentLocale((Locale)Locale.FRENCH);
        mlTextCollectionCheck = (Collection)((Object)this.nodeService.getProperty(nodeRef, BaseNodeServiceTest.PROP_QNAME_MULTI_ML_VALUE));
        FullNodeServiceTest.assertEquals((String)"MLText collection didn't come back correctly.", Arrays.asList("Bonjour", "Au revoir"), (Object)mlTextCollectionCheck);
        I18NUtil.setContentLocale((Locale)Locale.GERMAN);
        this.nodeService.setProperty(nodeRef, BaseNodeServiceTest.PROP_QNAME_MULTI_ML_VALUE, (Serializable)((Object)Arrays.asList("eins", "zwei", "drie", "vier")));
        I18NUtil.setContentLocale((Locale)Locale.ENGLISH);
        mlTextCollectionCheck = (Collection)((Object)this.nodeService.getProperty(nodeRef, BaseNodeServiceTest.PROP_QNAME_MULTI_ML_VALUE));
        FullNodeServiceTest.assertEquals((String)"MLText collection didn't come back correctly.", Arrays.asList("Hello", "Bye bye"), (Object)mlTextCollectionCheck);
        I18NUtil.setContentLocale((Locale)Locale.FRENCH);
        mlTextCollectionCheck = (Collection)((Object)this.nodeService.getProperty(nodeRef, BaseNodeServiceTest.PROP_QNAME_MULTI_ML_VALUE));
        FullNodeServiceTest.assertEquals((String)"MLText collection didn't come back correctly.", Arrays.asList("Bonjour", "Au revoir"), (Object)mlTextCollectionCheck);
        I18NUtil.setContentLocale((Locale)Locale.GERMAN);
        mlTextCollectionCheck = (Collection)((Object)this.nodeService.getProperty(nodeRef, BaseNodeServiceTest.PROP_QNAME_MULTI_ML_VALUE));
        FullNodeServiceTest.assertEquals((String)"MLText collection didn't come back correctly.", Arrays.asList("eins", "zwei", "drie", "vier"), (Object)mlTextCollectionCheck);
        I18NUtil.setContentLocale((Locale)Locale.GERMAN);
        this.nodeService.setProperty(nodeRef, BaseNodeServiceTest.PROP_QNAME_MULTI_ML_VALUE, (Serializable)((Object)Arrays.asList("eins")));
        I18NUtil.setContentLocale((Locale)Locale.ENGLISH);
        mlTextCollectionCheck = (Collection)((Object)this.nodeService.getProperty(nodeRef, BaseNodeServiceTest.PROP_QNAME_MULTI_ML_VALUE));
        FullNodeServiceTest.assertEquals((String)"MLText collection didn't come back correctly.", Arrays.asList("Hello", "Bye bye"), (Object)mlTextCollectionCheck);
        I18NUtil.setContentLocale((Locale)Locale.FRENCH);
        mlTextCollectionCheck = (Collection)((Object)this.nodeService.getProperty(nodeRef, BaseNodeServiceTest.PROP_QNAME_MULTI_ML_VALUE));
        FullNodeServiceTest.assertEquals((String)"MLText collection didn't come back correctly.", Arrays.asList("Bonjour", "Au revoir"), (Object)mlTextCollectionCheck);
        I18NUtil.setContentLocale((Locale)Locale.GERMAN);
        mlTextCollectionCheck = (Collection)((Object)this.nodeService.getProperty(nodeRef, BaseNodeServiceTest.PROP_QNAME_MULTI_ML_VALUE));
        FullNodeServiceTest.assertEquals((String)"MLText collection didn't come back correctly.", Arrays.asList("eins"), (Object)mlTextCollectionCheck);
    }
}

