/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.messaging.camel;

import org.alfresco.messaging.camel.MockConsumer;
import org.alfresco.messaging.camel.MockExceptionProcessor;
import org.alfresco.messaging.camel.MockExceptionThrowingConsumer;
import org.alfresco.util.testing.category.NeverRunsTests;
import org.apache.camel.CamelContext;
import org.apache.camel.EndpointInject;
import org.apache.camel.Produce;
import org.apache.camel.ProducerTemplate;
import org.apache.camel.component.mock.MockEndpoint;
import org.junit.Assert;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.junit.runner.RunWith;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.test.context.ContextConfiguration;
import org.springframework.test.context.junit4.SpringJUnit4ClassRunner;

@RunWith(value=SpringJUnit4ClassRunner.class)
@Category(value={NeverRunsTests.class})
@ContextConfiguration(locations={"/test-messaging-context.xml"})
public class CamelRoutesTest {
    @EndpointInject(value="mock:result1")
    protected MockEndpoint resultEndpoint1;
    @EndpointInject(value="mock:result2")
    protected MockEndpoint resultEndpoint2;
    @EndpointInject(value="mock:dlq")
    protected MockEndpoint dlqEndpoint;
    @Autowired
    protected CamelContext camelContext;
    @Produce(value="direct:alfresco.test.1")
    protected ProducerTemplate template1;
    @Produce(value="direct:alfresco.test.2")
    protected ProducerTemplate template2;
    @Produce(value="direct:alfresco.default")
    protected ProducerTemplate template3;
    @Produce(value="direct:alfresco.test.transacted")
    protected ProducerTemplate template4;
    @Autowired
    protected MockExceptionProcessor messagingExceptionProcessor;
    @Autowired
    protected MockConsumer mockConsumer;
    @Autowired
    protected MockExceptionThrowingConsumer mockExceptionThrowingConsumer;

    @Test
    public void testMessageRouteXmlDefined() throws Exception {
        String expectedBody = "<matched.>";
        this.resultEndpoint1.expectedBodiesReceived(new Object[]{expectedBody});
        this.template1.sendBody((Object)expectedBody);
        this.resultEndpoint1.assertIsSatisfied();
    }

    @Test
    public void testMessageRoutePackageDefined() throws Exception {
        String expectedBody = "<matched.>";
        this.resultEndpoint2.expectedBodiesReceived(new Object[]{expectedBody});
        this.template2.sendBody((Object)expectedBody);
        this.resultEndpoint2.assertIsSatisfied();
    }

    @Test
    public void testMessageRouteXmlOverride() throws Exception {
        String expectedBody = "<matched.>";
        this.dlqEndpoint.expectedBodiesReceived(new Object[]{expectedBody});
        this.template3.sendBody((Object)expectedBody);
        this.dlqEndpoint.assertIsSatisfied();
    }

    @Test
    public void testTransactedRoute() throws Exception {
        String expectedBody = "<matched.>";
        this.template4.sendBody((Object)expectedBody);
        Thread.sleep(2000L);
        Assert.assertNotNull((Object)this.messagingExceptionProcessor.getLastError());
        Assert.assertTrue((boolean)this.messagingExceptionProcessor.getLastError().getClass().equals(IllegalArgumentException.class));
        Assert.assertTrue((boolean)this.mockExceptionThrowingConsumer.isErrorThrown());
        Assert.assertNull((Object)this.mockExceptionThrowingConsumer.getLastMessage());
        Assert.assertEquals((Object)expectedBody, (Object)this.mockConsumer.getLastMessage());
    }
}

