/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.virtual.ref;

import java.util.Arrays;
import java.util.List;
import junit.framework.TestCase;
import org.alfresco.repo.virtual.ref.ClasspathResource;
import org.alfresco.repo.virtual.ref.Encoding;
import org.alfresco.repo.virtual.ref.Encodings;
import org.alfresco.repo.virtual.ref.Parameter;
import org.alfresco.repo.virtual.ref.Protocols;
import org.alfresco.repo.virtual.ref.Reference;
import org.alfresco.repo.virtual.ref.ReferenceParameter;
import org.alfresco.repo.virtual.ref.RepositoryLocation;
import org.alfresco.repo.virtual.ref.RepositoryNodeRef;
import org.alfresco.repo.virtual.ref.RepositoryPath;
import org.alfresco.repo.virtual.ref.RepositoryResource;
import org.alfresco.repo.virtual.ref.Resource;
import org.alfresco.repo.virtual.ref.ResourceParameter;
import org.alfresco.repo.virtual.ref.StringParameter;
import org.alfresco.service.cmr.repository.NodeRef;
import org.junit.Test;

public abstract class AbstractReferenceParserTest
extends TestCase {
    @Test
    public void assertRecursiveReferenceParser(Encoding encoding) throws Exception {
        List<Parameter> params0 = Arrays.asList(new StringParameter("/6"), new ResourceParameter((Resource)new RepositoryResource((RepositoryLocation)new RepositoryNodeRef(new NodeRef("workspace://SpacesStore/67c8f11d-0936-4295-88a0-12b85764c76f")))));
        Reference innerRef0 = new Reference(Encodings.ZERO.encoding, Protocols.VANILLA.protocol, (Resource)new ClasspathResource("/some/cp.json"), params0);
        List<Parameter> params1 = Arrays.asList(new StringParameter("/6"), new ReferenceParameter(innerRef0));
        Reference innerRef1 = new Reference(Encodings.ZERO.encoding, Protocols.VANILLA.protocol, (Resource)new ClasspathResource("/some/cp.json"), params1);
        List<Parameter> params2 = Arrays.asList(new ReferenceParameter(innerRef1));
        Reference innerRef2 = new Reference(Encodings.ZERO.encoding, Protocols.VANILLA.protocol, (Resource)new ClasspathResource("/some/cp.json"), params2);
        List<Parameter> params = Arrays.asList(new ReferenceParameter(innerRef2), new ReferenceParameter(innerRef1), new StringParameter("AString"));
        Reference stringifiedReference = new Reference(Encodings.ZERO.encoding, Protocols.NODE.protocol, (Resource)new RepositoryResource((RepositoryLocation)new RepositoryPath("/A/repository/path/")), params);
        String refString = encoding.stringifier.stringify(stringifiedReference);
        Reference parsedReference = encoding.parser.parse(refString);
        AbstractReferenceParserTest.assertEquals((Object)stringifiedReference, (Object)parsedReference);
    }
}

