/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.security.authority;

import org.alfresco.repo.security.permissions.PermissionEntry;
import org.alfresco.repo.security.permissions.impl.AbstractPermissionTest;
import org.alfresco.repo.security.permissions.impl.SimplePermissionEntry;
import org.alfresco.service.cmr.security.AccessStatus;
import org.alfresco.service.cmr.security.AuthorityType;
import org.alfresco.test_category.OwnJVMTestsCategory;
import org.junit.experimental.categories.Category;

@Category(value={OwnJVMTestsCategory.class})
public class ExtendedPermissionServiceTest
extends AbstractPermissionTest {
    public void testGroupPermission() {
        this.authenticationComponent.setCurrentUser(this.authenticationComponent.getSystemUserName());
        this.personService.getPerson("andy");
        this.authenticationComponent.clearCurrentSecurityContext();
        this.runAs("andy");
        ExtendedPermissionServiceTest.assertFalse((this.permissionService.hasPermission(this.rootNodeRef, this.getPermission("Read")) == AccessStatus.ALLOWED ? 1 : 0) != 0);
        this.permissionService.setPermission((PermissionEntry)new SimplePermissionEntry(this.rootNodeRef, this.getPermission("Read"), "GROUP_test", AccessStatus.ALLOWED));
        ExtendedPermissionServiceTest.assertFalse((this.permissionService.hasPermission(this.rootNodeRef, this.getPermission("Read")) == AccessStatus.ALLOWED ? 1 : 0) != 0);
        this.runAs("admin");
        this.authorityService.createAuthority(AuthorityType.GROUP, "test");
        this.authorityService.addAuthority("GROUP_test", "andy");
        this.runAs("andy");
        ExtendedPermissionServiceTest.assertTrue((this.permissionService.hasPermission(this.rootNodeRef, this.getPermission("Read")) == AccessStatus.ALLOWED ? 1 : 0) != 0);
        this.runAs("admin");
        this.authorityService.removeAuthority("GROUP_test", "andy");
        this.runAs("andy");
        ExtendedPermissionServiceTest.assertFalse((this.permissionService.hasPermission(this.rootNodeRef, this.getPermission("Read")) == AccessStatus.ALLOWED ? 1 : 0) != 0);
        this.permissionService.clearPermission(this.rootNodeRef, "andy");
    }

    public void testDeletePermissions() {
        this.authenticationComponent.setCurrentUser(this.authenticationComponent.getSystemUserName());
        this.personService.getPerson("andy");
        this.authenticationComponent.clearCurrentSecurityContext();
        this.runAs("andy");
        ExtendedPermissionServiceTest.assertFalse((this.permissionService.hasPermission(this.rootNodeRef, this.getPermission("Read")) == AccessStatus.ALLOWED ? 1 : 0) != 0);
        this.permissionService.setPermission((PermissionEntry)new SimplePermissionEntry(this.rootNodeRef, this.getPermission("Read"), "GROUP_test", AccessStatus.ALLOWED));
        ExtendedPermissionServiceTest.assertFalse((this.permissionService.hasPermission(this.rootNodeRef, this.getPermission("Read")) == AccessStatus.ALLOWED ? 1 : 0) != 0);
        this.runAs("admin");
        this.authorityService.createAuthority(AuthorityType.GROUP, "test");
        this.authorityService.addAuthority("GROUP_test", "andy");
        this.runAs("andy");
        ExtendedPermissionServiceTest.assertTrue((this.permissionService.hasPermission(this.rootNodeRef, this.getPermission("Read")) == AccessStatus.ALLOWED ? 1 : 0) != 0);
        this.permissionService.deletePermissions("GROUP_test");
        ExtendedPermissionServiceTest.assertFalse((this.permissionService.hasPermission(this.rootNodeRef, this.getPermission("Read")) == AccessStatus.ALLOWED ? 1 : 0) != 0);
        this.permissionService.clearPermission(this.testStoreRef, "GROUP_test");
        this.permissionService.deletePermission(this.testStoreRef, "GROUP_test", "Read");
    }

    public void testExplainPermission() {
        ExtendedPermissionServiceTest.assertNull((String)"This method has not been implemented", (Object)this.permissionService.explainPermission(null, null));
    }
}

