/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.service.cmr.workflow;

import java.io.Serializable;
import java.util.Collection;
import java.util.Date;
import java.util.Map;
import java.util.Set;
import org.activiti.engine.history.HistoricTaskInstance;
import org.activiti.engine.task.Task;
import org.alfresco.model.ContentModel;
import org.alfresco.repo.tenant.TenantService;
import org.alfresco.repo.workflow.BPMEngineRegistry;
import org.alfresco.repo.workflow.WorkflowModel;
import org.alfresco.repo.workflow.activiti.ActivitiTypeConverter;
import org.alfresco.service.cmr.workflow.WorkflowPath;
import org.alfresco.service.cmr.workflow.WorkflowTask;
import org.alfresco.service.cmr.workflow.WorkflowTaskDefinition;
import org.alfresco.service.cmr.workflow.WorkflowTaskState;
import org.alfresco.service.namespace.QName;

public class LazyActivitiWorkflowTask
extends WorkflowTask {
    private transient ActivitiTypeConverter activitiTypeConverter;
    private transient Task task;
    private transient HistoricTaskInstance historicTask;
    private LazyPropertiesMap lazyPropertiesMap;

    public LazyActivitiWorkflowTask(Task task, ActivitiTypeConverter typeConverter, TenantService tenantService, String workflowDefinitionName) {
        super(BPMEngineRegistry.createGlobalId("activiti", task.getId()), null, null, null, null, null, null, null);
        this.task = task;
        this.activitiTypeConverter = typeConverter;
        this.lazyPropertiesMap = new LazyPropertiesMap();
        WorkflowTaskDefinition taskDefinition = this.activitiTypeConverter.getTaskDefinition(task);
        WorkflowTask partiallyInitialized = typeConverter.getWorkflowObjectFactory().createTask(task.getId(), taskDefinition, taskDefinition.getId(), task.getName(), task.getDescription(), WorkflowTaskState.IN_PROGRESS, null, workflowDefinitionName, this.lazyPropertiesMap);
        this.definition = taskDefinition;
        this.name = taskDefinition.getId();
        this.title = partiallyInitialized.getTitle();
        this.description = partiallyInitialized.getDescription();
        this.state = partiallyInitialized.getState();
    }

    public LazyActivitiWorkflowTask(HistoricTaskInstance historicTask, ActivitiTypeConverter typeConverter, TenantService tenantService) {
        super(BPMEngineRegistry.createGlobalId("activiti", historicTask.getId()), null, null, null, null, null, null, null);
        this.historicTask = historicTask;
        this.activitiTypeConverter = typeConverter;
        this.lazyPropertiesMap = new LazyPropertiesMap();
        WorkflowTaskDefinition taskDefinition = this.activitiTypeConverter.getTaskDefinition(historicTask.getTaskDefinitionKey(), historicTask.getProcessDefinitionId());
        String workflowDefinitionName = this.activitiTypeConverter.getWorkflowDefinitionName(historicTask.getProcessDefinitionId());
        workflowDefinitionName = tenantService.getBaseName(workflowDefinitionName);
        WorkflowTask partiallyInitialized = typeConverter.getWorkflowObjectFactory().createTask(historicTask.getId(), taskDefinition, taskDefinition.getId(), historicTask.getName(), historicTask.getDescription(), WorkflowTaskState.COMPLETED, null, workflowDefinitionName, this.lazyPropertiesMap);
        this.definition = taskDefinition;
        this.name = taskDefinition.getId();
        this.title = partiallyInitialized.getTitle();
        this.description = partiallyInitialized.getDescription();
        this.state = partiallyInitialized.getState();
    }

    @Override
    public WorkflowPath getPath() {
        if (this.path == null) {
            this.path = this.task != null ? this.activitiTypeConverter.getWorkflowPath(this.task.getExecutionId(), true) : this.activitiTypeConverter.getWorkflowPath(this.historicTask);
        }
        return super.getPath();
    }

    @Override
    public Map<QName, Serializable> getProperties() {
        return this.lazyPropertiesMap;
    }

    public Map<QName, Serializable> ensureProperties() {
        if (this.properties == null) {
            this.properties = this.task != null ? this.activitiTypeConverter.getTaskProperties(this.task) : this.activitiTypeConverter.getTaskProperties(this.historicTask);
        }
        return this.properties;
    }

    private class LazyPropertiesMap
    implements Map<QName, Serializable> {
        private LazyPropertiesMap() {
        }

        @Override
        public void clear() {
            LazyActivitiWorkflowTask.this.ensureProperties().clear();
        }

        @Override
        public boolean containsKey(Object key) {
            return LazyActivitiWorkflowTask.this.ensureProperties().containsKey(key);
        }

        @Override
        public boolean containsValue(Object value) {
            return LazyActivitiWorkflowTask.this.ensureProperties().containsValue(value);
        }

        @Override
        public Set<Map.Entry<QName, Serializable>> entrySet() {
            return LazyActivitiWorkflowTask.this.ensureProperties().entrySet();
        }

        @Override
        public Serializable get(Object key) {
            if (WorkflowModel.PROP_DUE_DATE.equals(key)) {
                return this.getDueDate();
            }
            if (WorkflowModel.PROP_PRIORITY.equals(key)) {
                return Integer.valueOf(this.getPriority());
            }
            if (WorkflowModel.PROP_DESCRIPTION.equals(key)) {
                if (LazyActivitiWorkflowTask.this.task != null) {
                    return LazyActivitiWorkflowTask.this.task.getDescription() != null && !LazyActivitiWorkflowTask.this.task.getDescription().isEmpty() ? LazyActivitiWorkflowTask.this.task.getDescription() : LazyActivitiWorkflowTask.this.getDescription();
                }
                return LazyActivitiWorkflowTask.this.historicTask.getDescription() != null && !LazyActivitiWorkflowTask.this.historicTask.getDescription().isEmpty() ? LazyActivitiWorkflowTask.this.historicTask.getDescription() : LazyActivitiWorkflowTask.this.getDescription();
            }
            if (ContentModel.PROP_CREATED.equals(key) || WorkflowModel.PROP_START_DATE.equals(key)) {
                return this.getCreated();
            }
            if (ContentModel.PROP_OWNER.equals(key)) {
                return this.getOwner();
            }
            if (ContentModel.PROP_NAME.equals(key)) {
                return LazyActivitiWorkflowTask.this.getName();
            }
            if (WorkflowModel.PROP_TASK_ID.equals(key)) {
                return this.getId();
            }
            return LazyActivitiWorkflowTask.this.ensureProperties().get(key);
        }

        @Override
        public boolean isEmpty() {
            return LazyActivitiWorkflowTask.this.ensureProperties().isEmpty();
        }

        @Override
        public Set<QName> keySet() {
            return LazyActivitiWorkflowTask.this.ensureProperties().keySet();
        }

        @Override
        public Serializable put(QName key, Serializable value) {
            return LazyActivitiWorkflowTask.this.ensureProperties().put(key, value);
        }

        @Override
        public void putAll(Map<? extends QName, ? extends Serializable> m) {
            LazyActivitiWorkflowTask.this.ensureProperties().putAll(m);
        }

        @Override
        public Serializable remove(Object key) {
            return LazyActivitiWorkflowTask.this.ensureProperties().remove(key);
        }

        @Override
        public int size() {
            return LazyActivitiWorkflowTask.this.ensureProperties().size();
        }

        @Override
        public Collection<Serializable> values() {
            return LazyActivitiWorkflowTask.this.ensureProperties().values();
        }

        private String getId() {
            if (LazyActivitiWorkflowTask.this.task != null) {
                return LazyActivitiWorkflowTask.this.task.getId();
            }
            return LazyActivitiWorkflowTask.this.historicTask.getExecutionId();
        }

        private Date getDueDate() {
            if (LazyActivitiWorkflowTask.this.task != null) {
                return LazyActivitiWorkflowTask.this.task.getDueDate();
            }
            return LazyActivitiWorkflowTask.this.historicTask.getDueDate();
        }

        private int getPriority() {
            if (LazyActivitiWorkflowTask.this.task != null) {
                return LazyActivitiWorkflowTask.this.task.getPriority();
            }
            return LazyActivitiWorkflowTask.this.historicTask.getPriority();
        }

        private Date getCreated() {
            if (LazyActivitiWorkflowTask.this.task != null) {
                return LazyActivitiWorkflowTask.this.task.getCreateTime();
            }
            return LazyActivitiWorkflowTask.this.historicTask.getStartTime();
        }

        private String getOwner() {
            if (LazyActivitiWorkflowTask.this.task != null) {
                return LazyActivitiWorkflowTask.this.task.getAssignee();
            }
            return LazyActivitiWorkflowTask.this.historicTask.getAssignee();
        }
    }
}

