/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.node.cleanup;

import java.util.List;
import org.alfresco.error.AlfrescoRuntimeException;
import org.alfresco.repo.node.cleanup.NodeCleanupWorker;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.quartz.Job;
import org.quartz.JobDataMap;
import org.quartz.JobExecutionContext;
import org.quartz.JobExecutionException;

public class NodeCleanupJob
implements Job {
    private static Log logger = LogFactory.getLog(NodeCleanupJob.class);

    public void execute(JobExecutionContext context) throws JobExecutionException {
        JobDataMap jobData = context.getJobDetail().getJobDataMap();
        Object nodeCleanupWorkerObj = jobData.get((Object)"nodeCleanupWorker");
        if (nodeCleanupWorkerObj == null || !(nodeCleanupWorkerObj instanceof NodeCleanupWorker)) {
            throw new AlfrescoRuntimeException("NodeCleanupJob data must contain valid 'nodeCleanupWorker' reference");
        }
        NodeCleanupWorker nodeCleanupWorker = (NodeCleanupWorker)nodeCleanupWorkerObj;
        List<String> cleanupLog = nodeCleanupWorker.doClean();
        if (logger.isDebugEnabled()) {
            logger.debug((Object)"Node cleanup log:");
            for (String log : cleanupLog) {
                logger.debug((Object)log);
            }
        }
    }
}

