/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.tenant;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.alfresco.repo.content.AbstractRoutingContentStore;
import org.alfresco.repo.content.ContentContext;
import org.alfresco.repo.content.ContentStore;
import org.alfresco.repo.domain.tenant.TenantAdminDAO;
import org.alfresco.repo.domain.tenant.TenantEntity;
import org.alfresco.repo.security.authentication.AuthenticationUtil;
import org.alfresco.repo.tenant.Tenant;
import org.alfresco.repo.tenant.TenantRoutingContentStore;
import org.alfresco.repo.tenant.TenantService;
import org.alfresco.repo.tenant.TenantUtil;
import org.alfresco.repo.transaction.RetryingTransactionHelper;
import org.alfresco.service.transaction.TransactionService;
import org.springframework.beans.BeansException;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;

public abstract class AbstractTenantRoutingContentStore
extends AbstractRoutingContentStore
implements ApplicationContextAware,
TenantRoutingContentStore {
    private String defaultRootDirectory;
    private TenantAdminDAO tenantAdminDAO;
    protected TenantService tenantService;
    private ApplicationContext applicationContext;
    private TransactionService transactionService;
    private final ReentrantReadWriteLock tenantContentStoreLock = new ReentrantReadWriteLock();
    private final ReentrantReadWriteLock.WriteLock tenantContentStoreWriteLock = this.tenantContentStoreLock.writeLock();
    private final ReentrantReadWriteLock.ReadLock tenantContentStoreReadLock = this.tenantContentStoreLock.readLock();
    private final Map<String, ContentStore> cache = new HashMap<String, ContentStore>(1024);

    protected AbstractTenantRoutingContentStore() {
    }

    public void setRootLocation(String defaultRootDirectory) {
        this.defaultRootDirectory = defaultRootDirectory;
    }

    public void setTenantService(TenantService tenantService) {
        this.tenantService = tenantService;
    }

    public void setTenantAdminDAO(TenantAdminDAO tenantAdminDAO) {
        this.tenantAdminDAO = tenantAdminDAO;
    }

    public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
        this.applicationContext = applicationContext;
    }

    public void setTransactionService(TransactionService transactionService) {
        this.transactionService = transactionService;
    }

    @Override
    public String getRootLocation() {
        return this.defaultRootDirectory;
    }

    @Override
    protected ContentStore selectWriteStore(ContentContext ctx) {
        RetryingTransactionHelper.RetryingTransactionCallback<ContentStore> callback = new RetryingTransactionHelper.RetryingTransactionCallback<ContentStore>(){

            @Override
            public ContentStore execute() throws Throwable {
                return AbstractTenantRoutingContentStore.this.getTenantContentStore();
            }
        };
        return this.transactionService.getRetryingTransactionHelper().doInTransaction(callback, true, false);
    }

    @Override
    public List<ContentStore> getAllStores() {
        RetryingTransactionHelper.RetryingTransactionCallback<List<ContentStore>> callback = new RetryingTransactionHelper.RetryingTransactionCallback<List<ContentStore>>(){

            @Override
            public List<ContentStore> execute() throws Throwable {
                return AbstractTenantRoutingContentStore.this.getAllStoresImpl();
            }
        };
        return this.transactionService.getRetryingTransactionHelper().doInTransaction(callback, true, false);
    }

    private List<ContentStore> getAllStoresImpl() {
        ContentStore cs = this.getTenantContentStore();
        if (!this.tenantService.isEnabled()) {
            return Collections.singletonList(cs);
        }
        final ArrayList<ContentStore> allEnabledStores = new ArrayList<ContentStore>();
        allEnabledStores.add(cs);
        String currentUser = AuthenticationUtil.getFullyAuthenticatedUser();
        if (currentUser == null || this.tenantService.getBaseNameUser(currentUser).equals(AuthenticationUtil.getSystemUserName())) {
            List<TenantEntity> tenants = this.tenantAdminDAO.listTenants(false);
            for (TenantEntity tenant : tenants) {
                if (!tenant.getEnabled().booleanValue()) continue;
                String tenantDomain = tenant.getTenantDomain();
                TenantUtil.runAsSystemTenant((TenantUtil.TenantRunAsWork)new TenantUtil.TenantRunAsWork<Void>(){

                    public Void doWork() throws Exception {
                        allEnabledStores.add(AbstractTenantRoutingContentStore.this.getTenantContentStore());
                        return null;
                    }
                }, (String)tenantDomain);
            }
        }
        return allEnabledStores;
    }

    private ContentStore getTenantContentStore() {
        String tenantDomain = this.tenantService.getCurrentUserDomain();
        ContentStore cs = null;
        this.tenantContentStoreReadLock.lock();
        try {
            cs = this.cache.get(tenantDomain);
            if (cs != null) {
                ContentStore contentStore = cs;
                return contentStore;
            }
        }
        finally {
            this.tenantContentStoreReadLock.unlock();
        }
        this.tenantContentStoreWriteLock.lock();
        try {
            String rootDir = this.getRootLocation();
            Tenant tenant = this.tenantService.getTenant(tenantDomain);
            if (tenant != null && tenant.getRootContentStoreDir() != null) {
                rootDir = tenant.getRootContentStoreDir();
            }
            cs = this.initContentStore(this.applicationContext, rootDir);
            this.cache.put(tenantDomain, cs);
            ContentStore contentStore = cs;
            return contentStore;
        }
        finally {
            this.tenantContentStoreWriteLock.unlock();
        }
    }

    public void init() {
        this.getTenantContentStore();
    }

    public void destroy() {
        String tenantDomain = this.tenantService.getCurrentUserDomain();
        this.tenantContentStoreWriteLock.lock();
        try {
            this.cache.remove(tenantDomain);
        }
        finally {
            this.tenantContentStoreWriteLock.unlock();
        }
    }

    public void onEnableTenant() {
        this.init();
    }

    public void onDisableTenant() {
        this.destroy();
    }

    @Override
    public long getSpaceFree() {
        ContentStore x = this.getTenantContentStore();
        if (x != null) {
            return x.getSpaceFree();
        }
        return -1L;
    }

    @Override
    public long getSpaceTotal() {
        ContentStore x = this.getTenantContentStore();
        if (x != null) {
            return x.getSpaceTotal();
        }
        return -1L;
    }

    @Override
    public Map<String, String> getStorageProperties(String contentUrl) {
        return this.getTenantContentStore().getStorageProperties(contentUrl);
    }

    @Override
    public boolean requestSendContentToArchive(String contentUrl, Map<String, Serializable> archiveParams) {
        return this.getTenantContentStore().requestSendContentToArchive(contentUrl, archiveParams);
    }

    @Override
    public boolean requestRestoreContentFromArchive(String contentUrl, Map<String, Serializable> restoreParams) {
        return this.getTenantContentStore().requestRestoreContentFromArchive(contentUrl, restoreParams);
    }

    protected abstract ContentStore initContentStore(ApplicationContext var1, String var2);
}

