/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.imap;

import jakarta.mail.MessagingException;
import jakarta.mail.util.SharedByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import org.alfresco.model.ContentModel;
import org.alfresco.repo.imap.AbstractMimeMessage;
import org.alfresco.service.ServiceRegistry;
import org.alfresco.service.cmr.model.FileInfo;
import org.alfresco.service.cmr.repository.ContentIOException;
import org.alfresco.service.cmr.repository.ContentReader;
import org.alfresco.service.cmr.repository.ContentService;

public class ImapModelMessage
extends AbstractMimeMessage {
    public ImapModelMessage(FileInfo fileInfo, ServiceRegistry serviceRegistry, boolean generateBody) throws MessagingException {
        super(fileInfo, serviceRegistry, generateBody);
    }

    @Override
    public void buildMessageInternal() throws MessagingException {
        if (this.generateBody) {
            this.setMessageHeaders();
            this.buildImapMessage();
        }
    }

    private void buildImapMessage() throws MessagingException {
        this.modified = false;
        this.saved = false;
        this.buildRFC822Message();
        this.saved = true;
    }

    private void buildRFC822Message() throws MessagingException {
        ContentService contentService = this.serviceRegistry.getContentService();
        ContentReader reader = contentService.getReader(this.messageFileInfo.getNodeRef(), ContentModel.PROP_CONTENT);
        InputStream is = null;
        try {
            try {
                is = reader.getContentInputStream();
                this.parse(is);
            }
            catch (ContentIOException e) {
                throw new MessagingException("The error occured during message creation from content stream.", (Exception)((Object)e));
            }
        }
        finally {
            if (is != null) {
                try {
                    is.close();
                }
                catch (IOException e) {
                    throw new MessagingException("The error occured during message creation from content stream.", (Exception)e);
                }
                is = null;
            }
        }
    }

    protected InputStream getContentStream() throws MessagingException {
        try {
            if (this.contentStream == null) {
                if (this.content != null) {
                    return new SharedByteArrayInputStream(this.content);
                }
                throw new MessagingException("No content");
            }
            return this.contentStream;
        }
        catch (Exception e) {
            throw new MessagingException(e.getMessage(), e);
        }
    }
}

