/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.events;

import java.io.Serializable;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.alfresco.model.ContentModel;
import org.alfresco.repo.coci.CheckOutCheckInServicePolicies;
import org.alfresco.repo.content.ContentServicePolicies;
import org.alfresco.repo.events.AbstractEventGenerationBehaviours;
import org.alfresco.repo.events.EventsService;
import org.alfresco.repo.node.NodeServicePolicies;
import org.alfresco.repo.site.SiteModel;
import org.alfresco.service.cmr.dictionary.DataTypeDefinition;
import org.alfresco.service.cmr.dictionary.DictionaryService;
import org.alfresco.service.cmr.dictionary.PropertyDefinition;
import org.alfresco.service.cmr.lock.LockType;
import org.alfresco.service.cmr.repository.ChildAssociationRef;
import org.alfresco.service.cmr.repository.ContentData;
import org.alfresco.service.cmr.repository.MLText;
import org.alfresco.service.cmr.repository.NodeRef;
import org.alfresco.service.cmr.repository.NodeService;
import org.alfresco.service.namespace.NamespacePrefixResolver;
import org.alfresco.service.namespace.NamespaceService;
import org.alfresco.service.namespace.QName;
import org.alfresco.sync.events.types.DataType;
import org.alfresco.sync.events.types.Property;
import org.alfresco.util.EqualsHelper;

public class EventGenerationBehaviours
extends AbstractEventGenerationBehaviours
implements ContentServicePolicies.OnContentPropertyUpdatePolicy,
ContentServicePolicies.OnContentReadPolicy,
NodeServicePolicies.OnCreateNodePolicy,
NodeServicePolicies.BeforeDeleteNodePolicy,
NodeServicePolicies.OnAddAspectPolicy,
NodeServicePolicies.OnUpdatePropertiesPolicy,
NodeServicePolicies.OnMoveNodePolicy,
CheckOutCheckInServicePolicies.BeforeCheckOut,
CheckOutCheckInServicePolicies.OnCheckOut,
CheckOutCheckInServicePolicies.OnCheckIn,
CheckOutCheckInServicePolicies.OnCancelCheckOut,
NodeServicePolicies.OnDeleteChildAssociationPolicy,
NodeServicePolicies.OnCreateChildAssociationPolicy {
    private static final QName POLICY_ON_GROUP_DELETED = QName.createQName((String)"http://www.alfresco.org", (String)"onGroupDeleted");
    private static final QName POLICY_ON_AUTHORITY_REMOVED_FROM_GROUP = QName.createQName((String)"http://www.alfresco.org", (String)"onAuthorityRemovedFromGroup");
    private static final QName POLICY_ON_AUTHORITY_ADDED_TO_GROUP = QName.createQName((String)"http://www.alfresco.org", (String)"onAuthorityAddedToGroup");
    private static final QName POLICY_ON_REVOKE_LOCAL_PERMISSION = QName.createQName((String)"http://www.alfresco.org", (String)"onRevokeLocalPermission");
    private static final QName POLICY_ON_GRANT_LOCAL_PERMISSION = QName.createQName((String)"http://www.alfresco.org", (String)"onGrantLocalPermission");
    private static final QName POLICY_ON_INHERIT_PERMISSIONS_DISABLED = QName.createQName((String)"http://www.alfresco.org", (String)"onInheritPermissionsDisabled");
    private static final QName POLICY_ON_INHERIT_PERMISSIONS_ENABLED = QName.createQName((String)"http://www.alfresco.org", (String)"onInheritPermissionsEnabled");
    private static final QName POLICY_ON_UPDATE_SECURITY_MARKS = QName.createQName((String)"http://www.alfresco.org", (String)"onUpdateContentSecurityMarks");
    private static final QName POLICY_ON_RECORD_DECLARATION = QName.createQName((String)"http://www.alfresco.org", (String)"onRecordDeclaration");
    private static final QName POLICY_ON_RECORD_REJECTION = QName.createQName((String)"http://www.alfresco.org", (String)"beforeRecordRejection");
    private static final QName POLICY_BEFORE_LOCK = QName.createQName((String)"http://www.alfresco.org", (String)"beforeLock");
    private static final QName POLICY_BEFORE_UNLOCK = QName.createQName((String)"http://www.alfresco.org", (String)"beforeUnlock");
    protected EventsService eventsService;
    protected DictionaryService dictionaryService;
    protected NamespaceService namespaceService;
    protected NodeService nodeService;

    public void setDictionaryService(DictionaryService dictionaryService) {
        this.dictionaryService = dictionaryService;
    }

    public void setNamespaceService(NamespaceService namespaceService) {
        this.namespaceService = namespaceService;
    }

    public void setEventsService(EventsService eventsService) {
        this.eventsService = eventsService;
    }

    public void setNodeService(NodeService nodeService) {
        this.nodeService = nodeService;
    }

    public void init() {
        this.bindClassPolicy(ContentServicePolicies.OnContentPropertyUpdatePolicy.QNAME, "CONTENTPUT");
        this.bindClassPolicy(ContentServicePolicies.OnContentReadPolicy.QNAME, "CONTENTGET");
        this.bindClassPolicy(NodeServicePolicies.OnCreateNodePolicy.QNAME, "NODEADDED");
        this.bindClassPolicy(NodeServicePolicies.BeforeDeleteNodePolicy.QNAME, "NODEREMOVED");
        this.bindClassPolicy(NodeServicePolicies.OnMoveNodePolicy.QNAME, "NODEMOVED");
        this.bindClassPolicy(CheckOutCheckInServicePolicies.BeforeCheckOut.QNAME, "NODECHECKEDOUT");
        this.bindClassPolicy(CheckOutCheckInServicePolicies.OnCheckOut.QNAME, "NODECHECKEDOUT");
        this.bindClassPolicy(CheckOutCheckInServicePolicies.OnCheckIn.QNAME, "NODECHECKEDIN");
        this.bindClassPolicy(CheckOutCheckInServicePolicies.OnCancelCheckOut.QNAME, "NODECHECKOUTCANCELLED");
        this.bindClassPolicy(NodeServicePolicies.OnUpdatePropertiesPolicy.QNAME);
        this.bindClassPolicy(POLICY_ON_INHERIT_PERMISSIONS_ENABLED, "INHERITPERMISSIONSENABLED");
        this.bindClassPolicy(POLICY_ON_INHERIT_PERMISSIONS_DISABLED, "INHERITPERMISSIONSDISABLED");
        this.bindClassPolicy(POLICY_ON_GRANT_LOCAL_PERMISSION, "LOCALPERMISSIONGRANTED");
        this.bindClassPolicy(POLICY_ON_REVOKE_LOCAL_PERMISSION, "LOCALPERMISSIONREVOKED");
        this.bindClassPolicy(POLICY_ON_AUTHORITY_ADDED_TO_GROUP, "AUTHADDEDTOGROUP");
        this.bindClassPolicy(POLICY_ON_AUTHORITY_REMOVED_FROM_GROUP, "AUTHREMOVEDFROMGROUP");
        this.bindClassPolicy(POLICY_ON_GROUP_DELETED, "GROUPDELETED");
        this.bindAssociationPolicy(NodeServicePolicies.OnDeleteChildAssociationPolicy.QNAME, "NODEREMOVED");
        this.bindAssociationPolicy(NodeServicePolicies.OnCreateChildAssociationPolicy.QNAME, "NODEADDED");
        this.bindClassPolicy(POLICY_ON_UPDATE_SECURITY_MARKS);
        this.bindClassPolicy(POLICY_ON_RECORD_DECLARATION, "RECORDCREATED");
        this.bindClassPolicy(POLICY_ON_RECORD_REJECTION, "RECORDREJECTED");
        this.bindClassPolicy(POLICY_BEFORE_LOCK, "NODELOCKED");
        this.bindClassPolicy(POLICY_BEFORE_UNLOCK, "NODEUNLOCKED");
    }

    private DataType getPropertyType(QName propertyName) {
        DataType dataType = null;
        PropertyDefinition def = this.dictionaryService.getProperty(propertyName);
        if (def != null) {
            DataTypeDefinition dataTypeDef = def.getDataType();
            String dataTypeDefStr = dataTypeDef.getName().getPrefixString().substring(2);
            StringBuilder dataTypeName = new StringBuilder(dataTypeDefStr.substring(0, 1).toUpperCase());
            dataTypeName.append(dataTypeDefStr.substring(1));
            dataType = DataType.valueOf((String)dataTypeName.toString());
        }
        return dataType;
    }

    private Set<String> getRemoves(Map<QName, Serializable> before, Map<QName, Serializable> after) {
        HashSet<QName> tmp = new HashSet<QName>(before.keySet());
        tmp.removeAll(after.keySet());
        HashSet<String> ret = new HashSet<String>();
        for (QName propQName : tmp) {
            ret.add(propQName.toPrefixString((NamespacePrefixResolver)this.namespaceService));
        }
        return ret;
    }

    private Map<String, Property> getAdds(Map<QName, Serializable> before, Map<QName, Serializable> after) {
        HashSet<QName> tmp = new HashSet<QName>(after.keySet());
        tmp.removeAll(before.keySet());
        HashMap<String, Property> ret = new HashMap<String, Property>();
        for (QName propQName : tmp) {
            Serializable value = after.get(propQName);
            DataType type = this.getPropertyType(propQName);
            String propName = propQName.toPrefixString((NamespacePrefixResolver)this.namespaceService);
            Property property = new Property(propName, value, type);
            ret.put(propName, property);
        }
        return ret;
    }

    private Map<String, Property> getChanges(Map<QName, Serializable> before, Map<QName, Serializable> after) {
        HashMap<String, Property> ret = new HashMap<String, Property>();
        HashSet<QName> intersect = new HashSet<QName>(before.keySet());
        intersect.retainAll(after.keySet());
        for (QName propQName : intersect) {
            Serializable valueBefore = before.get(propQName);
            Serializable valueAfter = after.get(propQName);
            Serializable value = null;
            if (valueBefore == null && valueAfter == null) continue;
            if (valueBefore == null && valueAfter != null) {
                value = valueAfter;
            } else if (valueBefore != null && valueAfter == null) {
                value = valueAfter;
            } else if (!valueBefore.equals(valueAfter)) {
                value = valueAfter;
            }
            DataType type = this.getPropertyType(propQName);
            String propName = propQName.toPrefixString((NamespacePrefixResolver)this.namespaceService);
            Property property = new Property(propName, value, type);
            ret.put(propName, property);
        }
        return ret;
    }

    @Override
    public void onContentRead(NodeRef nodeRef) {
        this.eventsService.contentGet(nodeRef);
    }

    @Override
    public void onCreateNode(ChildAssociationRef childAssocRef) {
        NodeRef nodeRef = childAssocRef.getChildRef();
        this.eventsService.nodeCreated(nodeRef);
    }

    private <T> boolean propertyChanged(Map<QName, Serializable> before, Map<QName, Serializable> after, QName propertyQName) {
        boolean isChanged = false;
        Serializable valueBefore = before.get(propertyQName);
        Serializable valueAfter = after.get(propertyQName);
        if (valueBefore != null && valueAfter != null) {
            isChanged = !valueBefore.equals(valueAfter);
        }
        return isChanged;
    }

    @Override
    public void onUpdateProperties(NodeRef nodeRef, Map<QName, Serializable> before, Map<QName, Serializable> after) {
        this.checkNamePropertyRenamed(nodeRef, before, after);
        this.checkSiteTitlePropertyRenamed(nodeRef, before, after);
        this.checkNodeUpdatedEventIncluded(nodeRef, before, after);
    }

    private void checkSiteTitlePropertyRenamed(NodeRef nodeRef, Map<QName, Serializable> before, Map<QName, Serializable> after) {
        QName nodeRefType = this.nodeService.getType(nodeRef);
        if (this.dictionaryService.isSubClass(nodeRefType, SiteModel.TYPE_SITE) && this.propertyChanged(before, after, ContentModel.PROP_TITLE)) {
            String oldName = ((MLText)before.get(ContentModel.PROP_TITLE)).getDefaultValue();
            String newName = ((MLText)after.get(ContentModel.PROP_TITLE)).getDefaultValue();
            this.eventsService.nodeRenamed(nodeRef, oldName, newName);
        }
    }

    private void checkNodeUpdatedEventIncluded(NodeRef nodeRef, Map<QName, Serializable> before, Map<QName, Serializable> after) {
        if (this.includeEventType("NODEUPDATED")) {
            Map<String, Property> propertiesAdded = this.getAdds(before, after);
            Set<String> propertiesRemoved = this.getRemoves(before, after);
            Map<String, Property> propertiesChanged = this.getChanges(before, after);
            this.eventsService.nodeUpdated(nodeRef, propertiesAdded, propertiesRemoved, propertiesChanged, null, null);
        }
    }

    private void checkNamePropertyRenamed(NodeRef nodeRef, Map<QName, Serializable> before, Map<QName, Serializable> after) {
        if (this.propertyChanged(before, after, ContentModel.PROP_NAME)) {
            String oldName = (String)((Object)before.get(ContentModel.PROP_NAME));
            String newName = (String)((Object)after.get(ContentModel.PROP_NAME));
            this.eventsService.nodeRenamed(nodeRef, oldName, newName);
        }
    }

    @Override
    public void onAddAspect(NodeRef nodeRef, QName aspectTypeQName) {
        this.eventsService.nodeUpdated(nodeRef, null, null, null, Collections.singleton(aspectTypeQName.toPrefixString()), null);
    }

    @Override
    public void onMoveNode(ChildAssociationRef oldChildAssocRef, ChildAssociationRef newChildAssocRef) {
        this.eventsService.nodeMoved(oldChildAssocRef, newChildAssocRef);
    }

    @Override
    public void beforeDeleteNode(NodeRef nodeRef) {
        this.eventsService.nodeDeleted(nodeRef);
    }

    @Override
    public void onContentPropertyUpdate(NodeRef nodeRef, QName propertyQName, ContentData beforeValue, ContentData afterValue) {
        boolean hasContentAfter;
        boolean hasContentBefore = ContentData.hasContent((ContentData)beforeValue) && beforeValue.getSize() > 0L;
        boolean bl = hasContentAfter = ContentData.hasContent((ContentData)afterValue) && afterValue.getSize() > 0L;
        if (!hasContentBefore && !hasContentAfter) {
            return;
        }
        if (EqualsHelper.nullSafeEquals((Object)beforeValue, (Object)afterValue)) {
            return;
        }
        this.eventsService.contentWrite(nodeRef, propertyQName, afterValue);
    }

    @Override
    public void onCheckOut(NodeRef workingCopy) {
        this.eventsService.nodeCheckedOut(workingCopy);
    }

    @Override
    public void onCancelCheckOut(NodeRef nodeRef) {
        this.eventsService.nodeCheckOutCancelled(nodeRef);
    }

    @Override
    public void onCheckIn(NodeRef nodeRef) {
        this.eventsService.nodeCheckedIn(nodeRef);
    }

    @Override
    public void beforeCheckOut(NodeRef nodeRef, NodeRef destinationParentNodeRef, QName destinationAssocTypeQName, QName destinationAssocQName) {
    }

    public void onAuthorityRemovedFromGroup(String parentGroup, String childAuthority) {
        this.eventsService.authorityRemovedFromGroup(parentGroup, childAuthority);
    }

    public void onAuthorityAddedToGroup(String parentGroup, String childAuthority) {
        this.eventsService.authorityAddedToGroup(parentGroup, childAuthority);
    }

    public void onInheritPermissionsEnabled(NodeRef nodeRef) {
        this.eventsService.inheritPermissionsEnabled(nodeRef);
    }

    public void onInheritPermissionsDisabled(NodeRef nodeRef, boolean async) {
        this.eventsService.inheritPermissionsDisabled(nodeRef, async);
    }

    public void onRevokeLocalPermission(NodeRef nodeRef, String authority, String permission) {
        this.eventsService.revokeLocalPermissions(nodeRef, authority, permission);
    }

    public void onGrantLocalPermission(NodeRef nodeRef, String authority, String permission) {
        this.eventsService.grantLocalPermission(nodeRef, authority, permission);
    }

    public void onGroupDeleted(String groupName, boolean cascade) {
        this.eventsService.groupDeleted(groupName, cascade);
    }

    @Override
    public void onCreateChildAssociation(ChildAssociationRef newChildAssocRef, boolean isNewNode) {
        if (!newChildAssocRef.isPrimary()) {
            this.eventsService.secondaryAssociationCreated(newChildAssocRef);
        }
    }

    @Override
    public void onDeleteChildAssociation(ChildAssociationRef childAssocRef) {
        if (!childAssocRef.isPrimary()) {
            this.eventsService.secondaryAssociationDeleted(childAssocRef);
        }
    }

    public void onUpdateContentSecurityMarks(NodeRef nodeRef, boolean wasMarkedBefore, boolean isMarkedAfter) {
        if (!wasMarkedBefore && isMarkedAfter && this.includeEventType("FILECLASSIFIED")) {
            this.eventsService.fileClassified(nodeRef);
        }
        if (wasMarkedBefore && !isMarkedAfter && this.includeEventType("FILEUNCLASSIFIED")) {
            this.eventsService.fileUnclassified(nodeRef);
        }
    }

    public void onRecordDeclaration(NodeRef nodeRef) {
        this.eventsService.recordCreated(nodeRef);
    }

    public void beforeRecordRejection(NodeRef nodeRef) {
        this.eventsService.recordRejected(nodeRef);
    }

    public void beforeLock(NodeRef nodeRef, LockType lockType) {
        this.eventsService.nodeLocked(nodeRef);
    }

    public void beforeUnlock(NodeRef nodeRef) {
        this.eventsService.nodeUnlocked(nodeRef);
    }
}

