/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.action.executer;

import java.util.ArrayList;
import java.util.List;
import org.alfresco.model.ContentModel;
import org.alfresco.repo.action.ParameterDefinitionImpl;
import org.alfresco.repo.action.executer.ActionExecuterAbstractBase;
import org.alfresco.repo.rule.RuntimeRuleService;
import org.alfresco.service.cmr.action.Action;
import org.alfresco.service.cmr.action.ParameterDefinition;
import org.alfresco.service.cmr.dictionary.DataTypeDefinition;
import org.alfresco.service.cmr.dictionary.DictionaryService;
import org.alfresco.service.cmr.repository.ChildAssociationRef;
import org.alfresco.service.cmr.repository.NodeRef;
import org.alfresco.service.cmr.repository.NodeService;
import org.alfresco.service.cmr.rule.Rule;
import org.alfresco.service.cmr.rule.RuleService;
import org.alfresco.service.namespace.QName;

public class ExecuteAllRulesActionExecuter
extends ActionExecuterAbstractBase {
    public static final String NAME = "execute-all-rules";
    public static final String PARAM_EXECUTE_INHERITED_RULES = "execute-inherited-rules";
    public static final String PARAM_RUN_ALL_RULES_ON_CHILDREN = "run-all-rules-on-children";
    private NodeService nodeService;
    private RuleService ruleService;
    private RuntimeRuleService runtimeRuleService;
    private DictionaryService dictionaryService;

    public void setNodeService(NodeService nodeService) {
        this.nodeService = nodeService;
    }

    public void setRuleService(RuleService ruleService) {
        this.ruleService = ruleService;
    }

    public void setRuntimeRuleService(RuntimeRuleService runtimeRuleService) {
        this.runtimeRuleService = runtimeRuleService;
    }

    @Override
    public void setDictionaryService(DictionaryService dictionaryService) {
        this.dictionaryService = dictionaryService;
    }

    @Override
    public void executeImpl(Action ruleAction, NodeRef actionedUponNodeRef) {
        this.executeImpl(ruleAction, actionedUponNodeRef, null);
    }

    private void executeImpl(Action ruleAction, NodeRef actionedUponNodeRef, List<Rule> parentRules) {
        if (!this.nodeService.exists(actionedUponNodeRef)) {
            return;
        }
        boolean includeInherited = false;
        Boolean includeInheritedValue = (Boolean)ruleAction.getParameterValue(PARAM_EXECUTE_INHERITED_RULES);
        if (includeInheritedValue != null) {
            includeInherited = includeInheritedValue;
        }
        boolean runAllChildren = false;
        Boolean runAllChildrenValue = (Boolean)ruleAction.getParameterValue(PARAM_RUN_ALL_RULES_ON_CHILDREN);
        if (runAllChildrenValue != null) {
            runAllChildren = runAllChildrenValue;
        }
        ArrayList<Rule> rules = new ArrayList<Rule>();
        List<Rule> currentNodeRules = this.ruleService.getRules(actionedUponNodeRef, includeInherited);
        if (currentNodeRules != null) {
            rules.addAll(currentNodeRules);
        }
        if (runAllChildren) {
            if (parentRules != null) {
                rules.addAll(parentRules);
            } else {
                parentRules = currentNodeRules;
            }
        }
        if (!rules.isEmpty()) {
            List children = this.nodeService.getChildAssocs(actionedUponNodeRef);
            for (ChildAssociationRef childAssoc : children) {
                NodeRef child = childAssoc.getChildRef();
                QName childType = this.nodeService.getType(child);
                if (this.dictionaryService.isSubClass(childType, ContentModel.TYPE_SYSTEM_FOLDER)) continue;
                for (Rule rule : rules) {
                    Action action;
                    if (rule.getRuleDisabled() || (action = rule.getAction()) == null) continue;
                    this.runtimeRuleService.addRulePendingExecution(actionedUponNodeRef, child, rule);
                }
                if (!runAllChildren || !this.dictionaryService.isSubClass(childType, ContentModel.TYPE_FOLDER)) continue;
                this.executeImpl(ruleAction, child, parentRules);
            }
        }
    }

    @Override
    protected void addParameterDefinitions(List<ParameterDefinition> paramList) {
        paramList.add(new ParameterDefinitionImpl(PARAM_EXECUTE_INHERITED_RULES, DataTypeDefinition.BOOLEAN, false, this.getParamDisplayLabel(PARAM_EXECUTE_INHERITED_RULES)));
        paramList.add(new ParameterDefinitionImpl(PARAM_RUN_ALL_RULES_ON_CHILDREN, DataTypeDefinition.BOOLEAN, false, this.getParamDisplayLabel(PARAM_RUN_ALL_RULES_ON_CHILDREN)));
    }
}

