/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.util.test.junitrules;

import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import org.alfresco.repo.transaction.RetryingTransactionHelper;
import org.alfresco.service.cmr.repository.NodeRef;
import org.alfresco.util.GUID;
import org.alfresco.util.test.junitrules.AbstractPersonRule;
import org.alfresco.util.test.junitrules.ApplicationContextInit;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.context.ApplicationContext;

public class AlfrescoPeople
extends AbstractPersonRule {
    private static final Log log = LogFactory.getLog(AlfrescoPeople.class);
    private final int personCount;
    Map<String, NodeRef> usersPersons = new TreeMap<String, NodeRef>();

    public AlfrescoPeople(ApplicationContext appContext, int personCount) {
        super(appContext);
        this.personCount = personCount;
    }

    public AlfrescoPeople(ApplicationContextInit appContextRule, int personCount) {
        super(appContextRule);
        this.personCount = personCount;
    }

    protected void before() throws Throwable {
        ApplicationContext ctxt = this.getApplicationContext();
        RetryingTransactionHelper transactionHelper = (RetryingTransactionHelper)ctxt.getBean("retryingTransactionHelper");
        transactionHelper.doInTransaction((RetryingTransactionHelper.RetryingTransactionCallback)new RetryingTransactionHelper.RetryingTransactionCallback<Void>(){

            public Void execute() throws Throwable {
                if (log.isDebugEnabled()) {
                    log.debug((Object)("Creating " + AlfrescoPeople.this.personCount + " users for test purposes..."));
                }
                int i = 0;
                while (i < AlfrescoPeople.this.personCount) {
                    String userName = GUID.generate();
                    NodeRef personNode = AlfrescoPeople.this.createPerson(userName);
                    AlfrescoPeople.this.usersPersons.put(userName, personNode);
                    ++i;
                }
                return null;
            }
        });
    }

    protected void after() {
        ApplicationContext ctxt = this.getApplicationContext();
        RetryingTransactionHelper transactionHelper = (RetryingTransactionHelper)ctxt.getBean("retryingTransactionHelper");
        transactionHelper.doInTransaction((RetryingTransactionHelper.RetryingTransactionCallback)new RetryingTransactionHelper.RetryingTransactionCallback<Void>(){

            public Void execute() throws Throwable {
                for (Map.Entry<String, NodeRef> entry : AlfrescoPeople.this.usersPersons.entrySet()) {
                    AlfrescoPeople.this.deletePerson(entry.getKey());
                }
                return null;
            }
        });
    }

    public Set<String> getUsernames() {
        return this.usersPersons.keySet();
    }
}

