/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.virtual.ref;

import java.util.Arrays;
import org.alfresco.repo.virtual.ref.Encoding;
import org.alfresco.repo.virtual.ref.Protocol;
import org.alfresco.repo.virtual.ref.ProtocolMethod;
import org.alfresco.repo.virtual.ref.ProtocolMethodException;
import org.alfresco.repo.virtual.ref.Protocols;
import org.alfresco.repo.virtual.ref.Reference;
import org.alfresco.repo.virtual.ref.ReferenceParameter;
import org.alfresco.repo.virtual.ref.RepositoryLocation;
import org.alfresco.repo.virtual.ref.RepositoryNodeRef;
import org.alfresco.repo.virtual.ref.RepositoryResource;
import org.alfresco.repo.virtual.ref.Resource;
import org.alfresco.service.cmr.repository.NodeRef;
import org.alfresco.service.cmr.repository.StoreRef;

public class NodeProtocol
extends Protocol {
    private static final long serialVersionUID = -6120481299842983600L;

    public static Reference newReference(NodeRef nodeRef, Reference parentReference) {
        return new Reference(Protocol.DEFAULT_ENCODING, Protocols.NODE.protocol, new RepositoryResource(new RepositoryNodeRef(nodeRef)), Arrays.asList(new ReferenceParameter(parentReference)));
    }

    public static Reference newReference(Encoding encoding, Resource actualNodeResource, Reference parentReference) {
        return new Reference(Protocol.DEFAULT_ENCODING, Protocols.NODE.protocol, actualNodeResource, Arrays.asList(new ReferenceParameter(parentReference)));
    }

    public NodeProtocol() {
        super("node");
    }

    public NodeRef getNodeRef(Reference reference) {
        RepositoryResource repositoryResource = (RepositoryResource)reference.getResource();
        RepositoryNodeRef reposioryNodeRef = (RepositoryNodeRef)repositoryResource.getLocation();
        return reposioryNodeRef.getNodeRef();
    }

    public Reference getVirtualParentReference(Reference reference) {
        return (Reference)((ReferenceParameter)reference.getParameters().get(0)).getValue();
    }

    @Override
    public <R> R dispatch(ProtocolMethod<R> method, Reference reference) throws ProtocolMethodException {
        return method.execute(this, reference);
    }

    @Override
    public Reference propagateNodeRefMutations(NodeRef mutatedNodeRef, Reference reference) {
        RepositoryResource repositoryResource;
        RepositoryLocation location;
        Resource resource;
        StoreRef storeRef = mutatedNodeRef.getStoreRef();
        String storeId = storeRef.getIdentifier();
        String protocol = storeRef.getProtocol();
        if (("version2Store".equals(storeId) || "lightWeightVersionStore".equals(storeId) || "versionStore".equals(protocol)) && (resource = reference.getResource()) instanceof RepositoryResource && (location = (repositoryResource = (RepositoryResource)resource).getLocation()) instanceof RepositoryNodeRef) {
            RepositoryNodeRef repositoryNodeRef = (RepositoryNodeRef)location;
            NodeRef nodeRef = repositoryNodeRef.getNodeRef();
            NodeRef nodeRefPropagation = new NodeRef(mutatedNodeRef.getStoreRef(), nodeRef.getId());
            RepositoryResource resourcePropagation = new RepositoryResource(new RepositoryNodeRef(nodeRefPropagation));
            return new Reference(reference.getEncoding(), reference.getProtocol(), resourcePropagation, reference.getParameters());
        }
        return reference;
    }
}

