/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.search;

import java.util.List;
import java.util.Set;
import org.alfresco.service.cmr.dictionary.DictionaryService;
import org.alfresco.service.namespace.InvalidQNameException;
import org.alfresco.service.namespace.NamespacePrefixResolver;
import org.alfresco.service.namespace.NamespaceService;
import org.alfresco.service.namespace.QName;
import org.alfresco.util.PropertyCheck;

public abstract class AbstractIndexFilter {
    protected NamespaceService namespaceService;
    protected DictionaryService dictionaryService;

    public void setNamespaceService(NamespaceService namespaceService) {
        this.namespaceService = namespaceService;
    }

    public void setDictionaryService(DictionaryService dictionaryService) {
        this.dictionaryService = dictionaryService;
    }

    public void init() {
        PropertyCheck.mandatory((Object)this, (String)"dictionaryService", (Object)this.dictionaryService);
        PropertyCheck.mandatory((Object)this, (String)"namespaceService", (Object)this.namespaceService);
    }

    protected void initIgnoringPathsByCriterion(List<String> initDataInString, Set<QName> dataForIgnoringPaths, DefinitionExistChecker dec) {
        if (initDataInString != null) {
            for (String qNameInString : initDataInString) {
                if (qNameInString == null || qNameInString.isEmpty()) continue;
                try {
                    QName qname = QName.resolveToQName((NamespacePrefixResolver)this.namespaceService, (String)qNameInString);
                    if (!dec.isDefinitionExists(qname)) continue;
                    dataForIgnoringPaths.add(qname);
                }
                catch (InvalidQNameException invalidQNameException) {}
            }
        }
    }

    protected static interface DefinitionExistChecker {
        public boolean isDefinitionExists(QName var1);
    }
}

