/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.content;

import org.alfresco.repo.transaction.RetryingTransactionHelper;
import org.alfresco.service.cmr.repository.ContentIOException;
import org.alfresco.service.cmr.repository.ContentStreamListener;

public abstract class AbstractContentStreamListener
implements ContentStreamListener {
    private RetryingTransactionHelper transactionHelper;

    public void setRetryingTransactionHelper(RetryingTransactionHelper helper) {
        this.transactionHelper = helper;
    }

    public final void contentStreamClosed() throws ContentIOException {
        RetryingTransactionHelper.RetryingTransactionCallback<Object> cb = new RetryingTransactionHelper.RetryingTransactionCallback<Object>(){

            @Override
            public Object execute() {
                AbstractContentStreamListener.this.contentStreamClosedImpl();
                return null;
            }
        };
        if (this.transactionHelper != null) {
            this.transactionHelper.doInTransaction(cb, false);
        } else {
            try {
                cb.execute();
            }
            catch (Throwable e) {
                throw new ContentIOException("Failed to executed channel close callbacks", e);
            }
        }
    }

    public abstract void contentStreamClosedImpl() throws ContentIOException;
}

