/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.action.executer;

import java.io.Serializable;
import java.util.HashMap;
import java.util.List;
import org.alfresco.model.ContentModel;
import org.alfresco.repo.action.executer.ActionExecuterAbstractBase;
import org.alfresco.service.cmr.action.Action;
import org.alfresco.service.cmr.action.ParameterDefinition;
import org.alfresco.service.cmr.repository.NodeRef;
import org.alfresco.service.cmr.repository.NodeService;
import org.alfresco.service.namespace.QName;

public class CounterIncrementActionExecuter
extends ActionExecuterAbstractBase {
    public static final String NAME = "counter";
    private NodeService nodeService;

    public void setNodeService(NodeService nodeService) {
        this.nodeService = nodeService;
    }

    @Override
    protected void executeImpl(Action action, NodeRef actionedUponNodeRef) {
        if (!this.nodeService.hasAspect(actionedUponNodeRef, ContentModel.ASPECT_COUNTABLE)) {
            HashMap<QName, Integer> props = new HashMap<QName, Integer>(1);
            props.put(ContentModel.PROP_COUNTER, 1);
            this.nodeService.addAspect(actionedUponNodeRef, ContentModel.ASPECT_COUNTABLE, props);
        } else {
            int resultValue = 1;
            Integer value = (Integer)this.nodeService.getProperty(actionedUponNodeRef, ContentModel.PROP_COUNTER);
            if (value != null) {
                resultValue = value + 1;
            }
            this.nodeService.setProperty(actionedUponNodeRef, ContentModel.PROP_COUNTER, (Serializable)Integer.valueOf(resultValue));
        }
    }

    @Override
    protected void addParameterDefinitions(List<ParameterDefinition> paramList) {
    }
}

