/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.util.schemacomp.model;

import org.alfresco.test_category.BaseSpringTestsCategory;
import org.alfresco.util.schemacomp.ComparisonUtils;
import org.alfresco.util.schemacomp.DbObjectVisitor;
import org.alfresco.util.schemacomp.DbProperty;
import org.alfresco.util.schemacomp.model.DbObject;
import org.alfresco.util.schemacomp.model.DbObjectTestBase;
import org.alfresco.util.schemacomp.model.ForeignKey;
import org.alfresco.util.schemacomp.model.Table;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.mockito.Mockito;

@Category(value={BaseSpringTestsCategory.class})
public class ForeignKeyTest
extends DbObjectTestBase<ForeignKey> {
    private ForeignKey thisFK;
    private ForeignKey thatFK;
    private Table parent;

    @Before
    public void setUp() throws Exception {
        this.parent = new Table("parent");
        this.thisFK = new ForeignKey(null, "this_fk", "local_col", "target_table", "target_col");
        this.thatFK = new ForeignKey(null, "that_fk", "local_col", "target_table", "target_col");
    }

    @Override
    protected ForeignKey getThisObject() {
        return this.thisFK;
    }

    @Override
    protected ForeignKey getThatObject() {
        return this.thatFK;
    }

    @Override
    protected void doDiffTests() {
        ((ComparisonUtils)this.inOrder.verify((Object)this.comparisonUtils)).compareSimple(new DbProperty((DbObject)this.thisFK, "localColumn"), new DbProperty((DbObject)this.thatFK, "localColumn"), this.ctx);
        ((ComparisonUtils)this.inOrder.verify((Object)this.comparisonUtils)).compareSimple(new DbProperty((DbObject)this.thisFK, "targetTable"), new DbProperty((DbObject)this.thatFK, "targetTable"), this.ctx);
        ((ComparisonUtils)this.inOrder.verify((Object)this.comparisonUtils)).compareSimple(new DbProperty((DbObject)this.thisFK, "targetColumn"), new DbProperty((DbObject)this.thatFK, "targetColumn"), this.ctx);
    }

    @Test
    public void acceptVisitor() {
        this.thisFK.accept(this.visitor);
        ((DbObjectVisitor)Mockito.verify((Object)this.visitor)).visit((DbObject)this.thisFK);
    }

    @Test
    public void sameAs() {
        this.thisFK = new ForeignKey(this.parent, "the_fk", "local_col", "target_table", "target_col");
        this.thatFK = new ForeignKey(this.parent, "the_fk", "local_col", "target_table", "target_col");
        Assert.assertTrue((String)"FKs should be considered the same", (boolean)this.thisFK.sameAs((DbObject)this.thatFK));
        this.thisFK = new ForeignKey(this.parent, "the_fk", "local_col", "target_table", "target_col");
        this.thatFK = new ForeignKey(this.parent, "different_name", "local_col", "target_table", "target_col");
        Assert.assertTrue((String)"FKs should be considered the same", (boolean)this.thisFK.sameAs((DbObject)this.thatFK));
        Assert.assertTrue((String)"FKs should be considered the same", (boolean)this.thisFK.sameAs((DbObject)this.thisFK));
        Assert.assertFalse((String)"FKs should be considered the different", (boolean)this.thisFK.sameAs(null));
        this.thisFK = new ForeignKey(this.parent, "the_fk", "local_col", "target_table", "target_col");
        this.thatFK = new ForeignKey(new Table("different_parent"), "the_fk", "local_col", "target_table", "target_col");
        Assert.assertFalse((String)"FKs should be different: parents are different.", (boolean)this.thisFK.sameAs((DbObject)this.thatFK));
        this.thisFK = new ForeignKey(this.parent, "the_fk", "local_col", "target_table", "target_col");
        this.thatFK = new ForeignKey(this.parent, "the_fk", "local_col2", "target_table", "target_col");
        Assert.assertFalse((String)"FKs have different local columns.", (boolean)this.thisFK.sameAs((DbObject)this.thatFK));
        this.thisFK = new ForeignKey(this.parent, "the_fk", "local_col", "target_table", "target_col");
        this.thatFK = new ForeignKey(this.parent, "the_fk", "local_col", "target_table2", "target_col");
        Assert.assertFalse((String)"FKs have different target table.", (boolean)this.thisFK.sameAs((DbObject)this.thatFK));
        this.thisFK = new ForeignKey(this.parent, "the_fk", "local_col", "target_table", "target_col");
        this.thatFK = new ForeignKey(this.parent, "the_fk", "local_col", "target_table", "target_col2");
        Assert.assertFalse((String)"FKs have different target column.", (boolean)this.thisFK.sameAs((DbObject)this.thatFK));
        this.thisFK = new ForeignKey(this.parent, "the_fk", "local_col", "target_table", "target_col");
        this.thatFK = new ForeignKey(this.parent, "the_fk", "local_col", "TARGET_TABLE", "target_col");
        Assert.assertTrue((String)"FKs are case sensitive to targetTable's name.", (boolean)this.thisFK.sameAs((DbObject)this.thatFK));
    }
}

