/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.transfer;

import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.InputStream;
import java.io.StringWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Properties;
import java.util.Set;
import org.alfresco.model.ContentModel;
import org.alfresco.repo.model.Repository;
import org.alfresco.repo.policy.Behaviour;
import org.alfresco.repo.policy.JavaBehaviour;
import org.alfresco.repo.policy.PolicyComponent;
import org.alfresco.repo.security.authentication.AuthenticationComponent;
import org.alfresco.repo.transaction.RetryingTransactionHelper;
import org.alfresco.repo.transfer.RepoTransferReceiverImpl;
import org.alfresco.repo.transfer.TransferModel;
import org.alfresco.repo.transfer.TransferProgressMonitor;
import org.alfresco.repo.transfer.manifest.TransferManifestDeletedNode;
import org.alfresco.repo.transfer.manifest.TransferManifestHeader;
import org.alfresco.repo.transfer.manifest.TransferManifestNode;
import org.alfresco.repo.transfer.manifest.TransferManifestNormalNode;
import org.alfresco.repo.transfer.manifest.XMLTransferManifestWriter;
import org.alfresco.service.cmr.action.ActionService;
import org.alfresco.service.cmr.model.FileFolderService;
import org.alfresco.service.cmr.model.FileInfo;
import org.alfresco.service.cmr.repository.AssociationRef;
import org.alfresco.service.cmr.repository.ChildAssociationRef;
import org.alfresco.service.cmr.repository.ContentData;
import org.alfresco.service.cmr.repository.ContentService;
import org.alfresco.service.cmr.repository.NodeRef;
import org.alfresco.service.cmr.repository.NodeService;
import org.alfresco.service.cmr.repository.Path;
import org.alfresco.service.cmr.repository.StoreRef;
import org.alfresco.service.cmr.search.SearchService;
import org.alfresco.service.cmr.security.MutableAuthenticationService;
import org.alfresco.service.cmr.transfer.TransferException;
import org.alfresco.service.cmr.transfer.TransferProgress;
import org.alfresco.service.cmr.transfer.TransferServicePolicies;
import org.alfresco.service.namespace.NamespacePrefixResolver;
import org.alfresco.service.namespace.NamespaceService;
import org.alfresco.service.namespace.QName;
import org.alfresco.service.namespace.QNamePattern;
import org.alfresco.service.transaction.TransactionService;
import org.alfresco.test_category.BaseSpringTestsCategory;
import org.alfresco.util.BaseAlfrescoSpringTest;
import org.alfresco.util.GUID;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.junit.Before;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.mockito.ArgumentCaptor;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;
import org.springframework.test.context.transaction.TestTransaction;
import org.springframework.transaction.annotation.Transactional;

@Category(value={BaseSpringTestsCategory.class})
@Transactional
public class RepoTransferReceiverImplTest
extends BaseAlfrescoSpringTest {
    private static int fileCount = 0;
    private static final Log log = LogFactory.getLog(RepoTransferReceiverImplTest.class);
    private RepoTransferReceiverImpl receiver;
    private SearchService searchService;
    private String dummyContent;
    private byte[] dummyContentBytes;
    private NodeRef guestHome;
    private PolicyComponent policyComponent;
    private Repository repositoryHelper;
    private NamespaceService namespaceService;

    @Override
    @Before
    public void before() throws Exception {
        super.before();
        System.out.println("java.io.tmpdir == " + System.getProperty("java.io.tmpdir"));
        this.nodeService = (NodeService)this.applicationContext.getBean("nodeService");
        this.contentService = (ContentService)this.applicationContext.getBean("contentService");
        this.authenticationService = (MutableAuthenticationService)this.applicationContext.getBean("authenticationService");
        this.actionService = (ActionService)this.applicationContext.getBean("actionService");
        this.transactionService = (TransactionService)this.applicationContext.getBean("transactionComponent");
        this.authenticationComponent = (AuthenticationComponent)this.applicationContext.getBean("authenticationComponent");
        this.receiver = (RepoTransferReceiverImpl)this.applicationContext.getBean("transferReceiver");
        this.policyComponent = (PolicyComponent)this.applicationContext.getBean("policyComponent");
        this.searchService = (SearchService)this.applicationContext.getBean("searchService");
        this.repositoryHelper = (Repository)this.applicationContext.getBean("repositoryHelper");
        this.namespaceService = (NamespaceService)this.applicationContext.getBean("namespaceService");
        this.dummyContent = "This is some dummy content.";
        this.dummyContentBytes = this.dummyContent.getBytes("UTF-8");
        this.authenticationComponent.setSystemUserAsCurrentUser();
        this.guestHome = this.repositoryHelper.getGuestHome();
        TestTransaction.flagForCommit();
        TestTransaction.end();
    }

    @Test
    public void testDelete() {
        log.debug((Object)"start testDelete");
        RetryingTransactionHelper tran = this.transactionService.getRetryingTransactionHelper();
        final String uuid = GUID.generate();
        class TestContext {
            ChildAssociationRef childAssoc;

            TestContext() {
            }
        }
        RetryingTransactionHelper.RetryingTransactionCallback<TestContext> setupCB = new RetryingTransactionHelper.RetryingTransactionCallback<TestContext>(){

            public TestContext execute() throws Throwable {
                TestContext tc = new TestContext();
                NodeRef companyHome = RepoTransferReceiverImplTest.this.repositoryHelper.getCompanyHome();
                HashMap<QName, String> props = new HashMap<QName, String>();
                props.put(ContentModel.PROP_NAME, uuid);
                tc.childAssoc = RepoTransferReceiverImplTest.this.nodeService.createNode(companyHome, ContentModel.ASSOC_CONTAINS, QName.createQName((String)"http://www.alfresco.org/model/application/1.0", (String)uuid), ContentModel.TYPE_CONTENT, props);
                return tc;
            }
        };
        final TestContext tc = (TestContext)tran.doInTransaction((RetryingTransactionHelper.RetryingTransactionCallback)setupCB, false, true);
        RetryingTransactionHelper.RetryingTransactionCallback<Void> deleteCB = new RetryingTransactionHelper.RetryingTransactionCallback<Void>(){
            {
            }

            public Void execute() throws Throwable {
                RepoTransferReceiverImplTest.this.nodeService.deleteNode(tc.childAssoc.getChildRef());
                return null;
            }
        };
        tran.doInTransaction((RetryingTransactionHelper.RetryingTransactionCallback)deleteCB, false, true);
        RetryingTransactionHelper.RetryingTransactionCallback<Void> validateCB = new RetryingTransactionHelper.RetryingTransactionCallback<Void>(){
            {
            }

            public Void execute() throws Throwable {
                log.debug((Object)"Test that original node no longer exists...");
                RepoTransferReceiverImplTest.assertFalse((boolean)RepoTransferReceiverImplTest.this.nodeService.exists(tc.childAssoc.getChildRef()));
                log.debug((Object)"PASS - Original node no longer exists.");
                NodeRef archiveNodeRef = new NodeRef(StoreRef.STORE_REF_ARCHIVE_SPACESSTORE, tc.childAssoc.getChildRef().getId());
                log.debug((Object)"Test that archive node exists...");
                RepoTransferReceiverImplTest.assertTrue((boolean)RepoTransferReceiverImplTest.this.nodeService.exists(archiveNodeRef));
                log.debug((Object)"PASS - Archive node exists.");
                return null;
            }
        };
        tran.doInTransaction((RetryingTransactionHelper.RetryingTransactionCallback)validateCB, false, true);
    }

    public void DISABLED_testStartAndEnd() throws Exception {
        log.debug((Object)"start testStartAndEnd");
        RetryingTransactionHelper trx = this.transactionService.getRetryingTransactionHelper();
        RetryingTransactionHelper.RetryingTransactionCallback<Void> cb = new RetryingTransactionHelper.RetryingTransactionCallback<Void>(){

            public Void execute() throws Throwable {
                log.debug((Object)"about to call start");
                String transferId = RepoTransferReceiverImplTest.this.receiver.start("1234", true, RepoTransferReceiverImplTest.this.receiver.getVersion());
                File stagingFolder = null;
                try {
                    System.out.println("TransferId == " + transferId);
                    stagingFolder = RepoTransferReceiverImplTest.this.receiver.getStagingFolder(transferId);
                    RepoTransferReceiverImplTest.assertTrue((boolean)RepoTransferReceiverImplTest.this.receiver.getStagingFolder(transferId).exists());
                    NodeRef tempFolder = RepoTransferReceiverImplTest.this.receiver.getTempFolder(transferId);
                    RepoTransferReceiverImplTest.assertNotNull((String)"tempFolder is null", (Object)tempFolder);
                    Thread.sleep(1000L);
                    try {
                        RepoTransferReceiverImplTest.this.receiver.start("1234", true, RepoTransferReceiverImplTest.this.receiver.getVersion());
                        RepoTransferReceiverImplTest.fail((String)"Successfully started twice!");
                    }
                    catch (TransferException transferException) {}
                    Thread.sleep(300L);
                    try {
                        RepoTransferReceiverImplTest.this.receiver.start("1234", true, RepoTransferReceiverImplTest.this.receiver.getVersion());
                        RepoTransferReceiverImplTest.fail((String)"Successfully started twice!");
                    }
                    catch (TransferException transferException) {}
                    try {
                        RepoTransferReceiverImplTest.this.receiver.end(new NodeRef(StoreRef.STORE_REF_WORKSPACE_SPACESSTORE, GUID.generate()).toString());
                    }
                    catch (TransferException transferException) {}
                }
                finally {
                    log.debug((Object)"about to call end");
                    RepoTransferReceiverImplTest.this.receiver.end(transferId);
                    if (stagingFolder != null) {
                        RepoTransferReceiverImplTest.assertFalse((boolean)stagingFolder.exists());
                    }
                }
                return null;
            }
        };
        long oldRefreshTime = this.receiver.getLockRefreshTime();
        try {
            this.receiver.setLockRefreshTime(500L);
            int i = 0;
            while (i < 5) {
                log.info((Object)("test iteration:" + i));
                trx.doInTransaction((RetryingTransactionHelper.RetryingTransactionCallback)cb, false, true);
                ++i;
            }
        }
        finally {
            this.receiver.setLockRefreshTime(oldRefreshTime);
        }
    }

    public void DISABLED_testLockTimeout() throws Exception {
        log.info((Object)"start testLockTimeout");
        RetryingTransactionHelper trx = this.transactionService.getRetryingTransactionHelper();
        RetryingTransactionHelper.RetryingTransactionCallback<Void> startWithoutAnythingElse = new RetryingTransactionHelper.RetryingTransactionCallback<Void>(){

            public Void execute() throws Throwable {
                log.debug((Object)"about to call start");
                RepoTransferReceiverImplTest.this.receiver.start("1234", true, RepoTransferReceiverImplTest.this.receiver.getVersion());
                return null;
            }
        };
        RetryingTransactionHelper.RetryingTransactionCallback<Void> slowTransfer = new RetryingTransactionHelper.RetryingTransactionCallback<Void>(){

            public Void execute() throws Throwable {
                log.debug((Object)"about to call start");
                String transferId = RepoTransferReceiverImplTest.this.receiver.start("1234", true, RepoTransferReceiverImplTest.this.receiver.getVersion());
                Thread.sleep(1000L);
                RepoTransferReceiverImplTest.this.receiver.saveSnapshot(transferId, null);
                RepoTransferReceiverImplTest.fail((String)"did not timeout");
                return null;
            }
        };
        long lockRefreshTime = this.receiver.getLockRefreshTime();
        long lockTimeOut = this.receiver.getLockTimeOut();
        try {
            this.receiver.setLockRefreshTime(500L);
            this.receiver.setLockTimeOut(200L);
            int i = 0;
            while (i < 3) {
                log.info((Object)("test iteration:" + i));
                trx.doInTransaction((RetryingTransactionHelper.RetryingTransactionCallback)startWithoutAnythingElse, false, true);
                Thread.sleep(1000L);
                ++i;
            }
            try {
                trx.doInTransaction((RetryingTransactionHelper.RetryingTransactionCallback)slowTransfer, false, true);
            }
            catch (Exception exception) {}
        }
        finally {
            this.receiver.setLockRefreshTime(lockRefreshTime);
            this.receiver.setLockTimeOut(lockTimeOut);
        }
        log.info((Object)"end testLockTimeout");
    }

    @Test
    public void testSaveContent() throws Exception {
        log.info((Object)"start testSaveContent");
        String transferId = this.receiver.start("1234", true, this.receiver.getVersion());
        try {
            String contentId = "mytestcontent";
            this.receiver.saveContent(transferId, contentId, (InputStream)new ByteArrayInputStream(this.dummyContentBytes));
            File contentFile = new File(this.receiver.getStagingFolder(transferId), contentId);
            RepoTransferReceiverImplTest.assertTrue((boolean)contentFile.exists());
            RepoTransferReceiverImplTest.assertEquals((long)this.dummyContentBytes.length, (long)contentFile.length());
        }
        finally {
            this.receiver.end(transferId);
        }
    }

    @Test
    public void testSaveSnapshot() throws Exception {
        log.info((Object)"start testSaveSnapshot");
        String transferId = this.receiver.start("1234", true, this.receiver.getVersion());
        File snapshotFile = null;
        try {
            TransferManifestNormalNode node = this.createContentNode();
            ArrayList<TransferManifestNode> nodes = new ArrayList<TransferManifestNode>();
            nodes.add((TransferManifestNode)node);
            String snapshot = this.createSnapshot(nodes);
            this.receiver.saveSnapshot(transferId, (InputStream)new ByteArrayInputStream(snapshot.getBytes("UTF-8")));
            File stagingFolder = this.receiver.getStagingFolder(transferId);
            snapshotFile = new File(stagingFolder, "snapshot.xml");
            RepoTransferReceiverImplTest.assertTrue((boolean)snapshotFile.exists());
            RepoTransferReceiverImplTest.assertEquals((long)snapshot.getBytes("UTF-8").length, (long)snapshotFile.length());
        }
        finally {
            this.receiver.end(transferId);
            if (snapshotFile != null) {
                RepoTransferReceiverImplTest.assertFalse((boolean)snapshotFile.exists());
            }
        }
    }

    @Test
    public void testBasicCommit() throws Exception {
        log.info((Object)"start testBasicCommit");
        RetryingTransactionHelper tran = this.transactionService.getRetryingTransactionHelper();
        class TestContext {
            TransferManifestNode node = null;
            String transferId = null;

            TestContext() {
            }
        }
        RetryingTransactionHelper.RetryingTransactionCallback<TestContext> setupCB = new RetryingTransactionHelper.RetryingTransactionCallback<TestContext>(){

            public TestContext execute() throws Throwable {
                TestContext tc = new TestContext();
                tc.node = RepoTransferReceiverImplTest.this.createContentNode();
                return tc;
            }
        };
        final TestContext tc = (TestContext)tran.doInTransaction((RetryingTransactionHelper.RetryingTransactionCallback)setupCB, false, true);
        RetryingTransactionHelper.RetryingTransactionCallback<Void> doPrepareCB = new RetryingTransactionHelper.RetryingTransactionCallback<Void>(){
            {
            }

            public Void execute() throws Throwable {
                tc.transferId = RepoTransferReceiverImplTest.this.receiver.start("1234", true, RepoTransferReceiverImplTest.this.receiver.getVersion());
                ArrayList<TransferManifestNode> nodes = new ArrayList<TransferManifestNode>();
                nodes.add(tc.node);
                String snapshot = RepoTransferReceiverImplTest.this.createSnapshot(nodes);
                RepoTransferReceiverImplTest.this.receiver.saveSnapshot(tc.transferId, (InputStream)new ByteArrayInputStream(snapshot.getBytes("UTF-8")));
                RepoTransferReceiverImplTest.this.receiver.saveContent(tc.transferId, tc.node.getUuid(), (InputStream)new ByteArrayInputStream(RepoTransferReceiverImplTest.this.dummyContentBytes));
                return null;
            }
        };
        RetryingTransactionHelper.RetryingTransactionCallback<Void> doCommitCB = new RetryingTransactionHelper.RetryingTransactionCallback<Void>(){
            {
            }

            public Void execute() throws Throwable {
                RepoTransferReceiverImplTest.this.receiver.commit(tc.transferId);
                return null;
            }
        };
        RetryingTransactionHelper.RetryingTransactionCallback<Void> doEndCB = new RetryingTransactionHelper.RetryingTransactionCallback<Void>(){
            {
            }

            public Void execute() throws Throwable {
                RepoTransferReceiverImplTest.this.receiver.end(tc.transferId);
                return null;
            }
        };
        try {
            tran.doInTransaction((RetryingTransactionHelper.RetryingTransactionCallback)doPrepareCB, false, true);
            tran.doInTransaction((RetryingTransactionHelper.RetryingTransactionCallback)doCommitCB, false, true);
        }
        finally {
            if (tc.transferId != null) {
                tran.doInTransaction((RetryingTransactionHelper.RetryingTransactionCallback)doEndCB, false, true);
            }
        }
        RetryingTransactionHelper.RetryingTransactionCallback<Void> doValidateCB = new RetryingTransactionHelper.RetryingTransactionCallback<Void>(){
            {
            }

            public Void execute() throws Throwable {
                RepoTransferReceiverImplTest.assertTrue((boolean)RepoTransferReceiverImplTest.this.nodeService.exists(tc.node.getNodeRef()));
                RepoTransferReceiverImplTest.this.nodeService.deleteNode(tc.node.getNodeRef());
                return null;
            }
        };
        tran.doInTransaction((RetryingTransactionHelper.RetryingTransactionCallback)doValidateCB, false, true);
    }

    @Test
    public void testMoreComplexCommit() throws Exception {
        log.info((Object)"start testMoreComplexCommit");
        RetryingTransactionHelper tran = this.transactionService.getRetryingTransactionHelper();
        class TestContext {
            List<TransferManifestNode> nodes = new ArrayList<TransferManifestNode>();
            TransferManifestNormalNode node1 = null;
            TransferManifestNormalNode node2 = null;
            TransferManifestNode node3 = null;
            TransferManifestNode node4 = null;
            TransferManifestNode node5 = null;
            TransferManifestNode node6 = null;
            TransferManifestNode node7 = null;
            TransferManifestNode node8 = null;
            TransferManifestNode node9 = null;
            TransferManifestNode node10 = null;
            TransferManifestNormalNode node11 = null;
            TransferManifestNode node12 = null;
            String transferId = null;

            TestContext() {
            }
        }
        RetryingTransactionHelper.RetryingTransactionCallback<TestContext> setupCB = new RetryingTransactionHelper.RetryingTransactionCallback<TestContext>(){

            public TestContext execute() throws Throwable {
                TestContext tc = new TestContext();
                tc.node1 = RepoTransferReceiverImplTest.this.createContentNode();
                tc.nodes.add((TransferManifestNode)tc.node1);
                tc.node2 = RepoTransferReceiverImplTest.this.createContentNode();
                tc.nodes.add((TransferManifestNode)tc.node2);
                tc.node3 = RepoTransferReceiverImplTest.this.createContentNode();
                tc.nodes.add(tc.node3);
                tc.node4 = RepoTransferReceiverImplTest.this.createContentNode();
                tc.nodes.add(tc.node4);
                tc.node5 = RepoTransferReceiverImplTest.this.createContentNode();
                tc.nodes.add(tc.node5);
                tc.node6 = RepoTransferReceiverImplTest.this.createContentNode();
                tc.nodes.add(tc.node6);
                tc.node7 = RepoTransferReceiverImplTest.this.createContentNode();
                tc.nodes.add(tc.node7);
                tc.node8 = RepoTransferReceiverImplTest.this.createFolderNode();
                tc.nodes.add(tc.node8);
                tc.node9 = RepoTransferReceiverImplTest.this.createFolderNode();
                tc.nodes.add(tc.node9);
                tc.node10 = RepoTransferReceiverImplTest.this.createFolderNode();
                tc.nodes.add(tc.node10);
                tc.node11 = RepoTransferReceiverImplTest.this.createFolderNode();
                tc.nodes.add((TransferManifestNode)tc.node11);
                tc.node12 = RepoTransferReceiverImplTest.this.createFolderNode();
                tc.nodes.add(tc.node12);
                RepoTransferReceiverImplTest.this.associatePeers(tc.node1, tc.node2);
                RepoTransferReceiverImplTest.this.moveNode(tc.node2, tc.node11);
                return tc;
            }
        };
        final TestContext tc = (TestContext)tran.doInTransaction((RetryingTransactionHelper.RetryingTransactionCallback)setupCB, false, true);
        RetryingTransactionHelper.RetryingTransactionCallback<Void> doPrepareCB = new RetryingTransactionHelper.RetryingTransactionCallback<Void>(){
            {
            }

            public Void execute() throws Throwable {
                tc.transferId = RepoTransferReceiverImplTest.this.receiver.start("1234", true, RepoTransferReceiverImplTest.this.receiver.getVersion());
                String snapshot = RepoTransferReceiverImplTest.this.createSnapshot(tc.nodes);
                RepoTransferReceiverImplTest.this.receiver.saveSnapshot(tc.transferId, (InputStream)new ByteArrayInputStream(snapshot.getBytes("UTF-8")));
                for (TransferManifestNode node : tc.nodes) {
                    RepoTransferReceiverImplTest.this.receiver.saveContent(tc.transferId, node.getUuid(), (InputStream)new ByteArrayInputStream(RepoTransferReceiverImplTest.this.dummyContentBytes));
                }
                return null;
            }
        };
        RetryingTransactionHelper.RetryingTransactionCallback<Void> doCommitCB = new RetryingTransactionHelper.RetryingTransactionCallback<Void>(){
            {
            }

            public Void execute() throws Throwable {
                log.info((Object)"testMoreComplexCommit - commit");
                RepoTransferReceiverImplTest.this.receiver.commit(tc.transferId);
                log.info((Object)"testMoreComplexCommit - commited");
                return null;
            }
        };
        RetryingTransactionHelper.RetryingTransactionCallback<Void> doEndCB = new RetryingTransactionHelper.RetryingTransactionCallback<Void>(){
            {
            }

            public Void execute() throws Throwable {
                RepoTransferReceiverImplTest.this.receiver.end(tc.transferId);
                return null;
            }
        };
        try {
            tran.doInTransaction((RetryingTransactionHelper.RetryingTransactionCallback)doPrepareCB, false, true);
            tran.doInTransaction((RetryingTransactionHelper.RetryingTransactionCallback)doCommitCB, false, true);
        }
        finally {
            if (tc.transferId != null) {
                tran.doInTransaction((RetryingTransactionHelper.RetryingTransactionCallback)doEndCB, false, true);
            }
        }
        RetryingTransactionHelper.RetryingTransactionCallback<Void> validateCB = new RetryingTransactionHelper.RetryingTransactionCallback<Void>(){
            {
            }

            public Void execute() throws Throwable {
                log.info((Object)"testMoreComplexCommit - validate nodes");
                RepoTransferReceiverImplTest.assertTrue((boolean)RepoTransferReceiverImplTest.this.nodeService.getAspects(tc.node1.getNodeRef()).contains(ContentModel.ASPECT_ATTACHABLE));
                RepoTransferReceiverImplTest.assertFalse((boolean)RepoTransferReceiverImplTest.this.nodeService.getSourceAssocs(tc.node2.getNodeRef(), (QNamePattern)ContentModel.ASSOC_ATTACHMENTS).isEmpty());
                for (TransferManifestNode node : tc.nodes) {
                    RepoTransferReceiverImplTest.assertTrue((boolean)RepoTransferReceiverImplTest.this.nodeService.exists(node.getNodeRef()));
                }
                return null;
            }
        };
        tran.doInTransaction((RetryingTransactionHelper.RetryingTransactionCallback)validateCB, false, true);
    }

    @Test
    public void testNodeDeleteAndRestore() throws Exception {
        log.info((Object)"start testNodeDeleteAndRestore");
        RetryingTransactionHelper tran = this.transactionService.getRetryingTransactionHelper();
        final TransferServicePolicies.OnEndInboundTransferPolicy mockedPolicyHandler = (TransferServicePolicies.OnEndInboundTransferPolicy)Mockito.mock(TransferServicePolicies.OnEndInboundTransferPolicy.class);
        this.policyComponent.bindClassBehaviour(TransferServicePolicies.OnEndInboundTransferPolicy.QNAME, TransferModel.TYPE_TRANSFER_RECORD, (Behaviour)new JavaBehaviour((Object)mockedPolicyHandler, "onEndInboundTransfer", Behaviour.NotificationFrequency.EVERY_EVENT));
        class TestContext {
            String transferId;
            TransferManifestNormalNode node1;
            TransferManifestNormalNode node2;
            TransferManifestNode node3;
            TransferManifestNode node4;
            TransferManifestNode node5;
            TransferManifestNode node6;
            TransferManifestNode node7;
            TransferManifestNode node8;
            TransferManifestNode node9;
            TransferManifestNode node10;
            TransferManifestNormalNode node11;
            TransferManifestNode node12;
            TransferManifestDeletedNode deletedNode8;
            TransferManifestDeletedNode deletedNode2;
            TransferManifestDeletedNode deletedNode11;
            List<TransferManifestNode> nodes;
            String errorMsgId;

            TestContext() {
            }
        }
        RetryingTransactionHelper.RetryingTransactionCallback<TestContext> setupCB = new RetryingTransactionHelper.RetryingTransactionCallback<TestContext>(){

            public TestContext execute() throws Throwable {
                TestContext tc = new TestContext();
                tc.nodes = new ArrayList<TransferManifestNode>();
                tc.node1 = RepoTransferReceiverImplTest.this.createContentNode();
                tc.nodes.add((TransferManifestNode)tc.node1);
                tc.node2 = RepoTransferReceiverImplTest.this.createContentNode();
                tc.nodes.add((TransferManifestNode)tc.node2);
                tc.node3 = RepoTransferReceiverImplTest.this.createContentNode();
                tc.nodes.add(tc.node3);
                tc.node4 = RepoTransferReceiverImplTest.this.createContentNode();
                tc.nodes.add(tc.node4);
                tc.node5 = RepoTransferReceiverImplTest.this.createContentNode();
                tc.nodes.add(tc.node5);
                tc.node6 = RepoTransferReceiverImplTest.this.createContentNode();
                tc.nodes.add(tc.node6);
                tc.node7 = RepoTransferReceiverImplTest.this.createContentNode();
                tc.nodes.add(tc.node7);
                tc.node8 = RepoTransferReceiverImplTest.this.createFolderNode();
                tc.nodes.add(tc.node8);
                tc.node9 = RepoTransferReceiverImplTest.this.createFolderNode();
                tc.nodes.add(tc.node9);
                tc.node10 = RepoTransferReceiverImplTest.this.createFolderNode();
                tc.nodes.add(tc.node10);
                tc.node11 = RepoTransferReceiverImplTest.this.createFolderNode();
                tc.nodes.add((TransferManifestNode)tc.node11);
                tc.node12 = RepoTransferReceiverImplTest.this.createFolderNode();
                tc.nodes.add(tc.node12);
                RepoTransferReceiverImplTest.this.associatePeers(tc.node1, tc.node2);
                RepoTransferReceiverImplTest.this.moveNode(tc.node2, tc.node11);
                tc.deletedNode8 = RepoTransferReceiverImplTest.this.createDeletedNode(tc.node8);
                tc.deletedNode2 = RepoTransferReceiverImplTest.this.createDeletedNode((TransferManifestNode)tc.node2);
                tc.deletedNode11 = RepoTransferReceiverImplTest.this.createDeletedNode((TransferManifestNode)tc.node11);
                return tc;
            }
        };
        final TestContext tc = (TestContext)tran.doInTransaction((RetryingTransactionHelper.RetryingTransactionCallback)setupCB, false, true);
        RetryingTransactionHelper.RetryingTransactionCallback<Void> doFirstPrepareCB = new RetryingTransactionHelper.RetryingTransactionCallback<Void>(){
            {
            }

            public Void execute() throws Throwable {
                tc.transferId = RepoTransferReceiverImplTest.this.receiver.start("1234", true, RepoTransferReceiverImplTest.this.receiver.getVersion());
                String snapshot = RepoTransferReceiverImplTest.this.createSnapshot(tc.nodes);
                log.debug((Object)snapshot);
                RepoTransferReceiverImplTest.this.receiver.saveSnapshot(tc.transferId, (InputStream)new ByteArrayInputStream(snapshot.getBytes("UTF-8")));
                for (TransferManifestNode node : tc.nodes) {
                    RepoTransferReceiverImplTest.this.receiver.saveContent(tc.transferId, node.getUuid(), (InputStream)new ByteArrayInputStream(RepoTransferReceiverImplTest.this.dummyContentBytes));
                }
                return null;
            }
        };
        RetryingTransactionHelper.RetryingTransactionCallback<Void> doCommitCB = new RetryingTransactionHelper.RetryingTransactionCallback<Void>(){
            {
            }

            public Void execute() throws Throwable {
                RepoTransferReceiverImplTest.this.receiver.commit(tc.transferId);
                return null;
            }
        };
        RetryingTransactionHelper.RetryingTransactionCallback<Void> doEndCB = new RetryingTransactionHelper.RetryingTransactionCallback<Void>(){
            {
            }

            public Void execute() throws Throwable {
                RepoTransferReceiverImplTest.this.receiver.end(tc.transferId);
                return null;
            }
        };
        RetryingTransactionHelper.RetryingTransactionCallback<Void> validateFirstCB = new RetryingTransactionHelper.RetryingTransactionCallback<Void>(){
            {
            }

            public Void execute() throws Throwable {
                RepoTransferReceiverImplTest.assertTrue((boolean)RepoTransferReceiverImplTest.this.nodeService.getAspects(tc.node1.getNodeRef()).contains(ContentModel.ASPECT_ATTACHABLE));
                RepoTransferReceiverImplTest.assertFalse((boolean)RepoTransferReceiverImplTest.this.nodeService.getSourceAssocs(tc.node2.getNodeRef(), (QNamePattern)ContentModel.ASSOC_ATTACHMENTS).isEmpty());
                ArgumentCaptor transferIdCaptor = ArgumentCaptor.forClass(String.class);
                ArgumentCaptor createdNodesCaptor = ArgumentCaptor.forClass(Set.class);
                ArgumentCaptor updatedNodesCaptor = ArgumentCaptor.forClass(Set.class);
                ArgumentCaptor deletedNodesCaptor = ArgumentCaptor.forClass(Set.class);
                ((TransferServicePolicies.OnEndInboundTransferPolicy)Mockito.verify((Object)mockedPolicyHandler, (VerificationMode)Mockito.times((int)1))).onEndInboundTransfer((String)transferIdCaptor.capture(), (Set)createdNodesCaptor.capture(), (Set)updatedNodesCaptor.capture(), (Set)deletedNodesCaptor.capture());
                RepoTransferReceiverImplTest.assertEquals((String)tc.transferId, (String)((String)transferIdCaptor.getValue()));
                Set capturedCreatedNodes = (Set)createdNodesCaptor.getValue();
                RepoTransferReceiverImplTest.assertEquals((int)tc.nodes.size(), (int)capturedCreatedNodes.size());
                for (TransferManifestNode node : tc.nodes) {
                    RepoTransferReceiverImplTest.assertTrue((boolean)RepoTransferReceiverImplTest.this.nodeService.exists(node.getNodeRef()));
                    RepoTransferReceiverImplTest.assertTrue((boolean)capturedCreatedNodes.contains(node.getNodeRef()));
                }
                return null;
            }
        };
        try {
            tran.doInTransaction((RetryingTransactionHelper.RetryingTransactionCallback)doFirstPrepareCB, false, true);
            Mockito.reset((Object[])new TransferServicePolicies.OnEndInboundTransferPolicy[]{mockedPolicyHandler});
            tran.doInTransaction((RetryingTransactionHelper.RetryingTransactionCallback)doCommitCB, false, true);
            tran.doInTransaction((RetryingTransactionHelper.RetryingTransactionCallback)validateFirstCB, false, true);
        }
        finally {
            if (tc.transferId != null) {
                tran.doInTransaction((RetryingTransactionHelper.RetryingTransactionCallback)doEndCB, false, true);
            }
        }
        Mockito.reset((Object[])new TransferServicePolicies.OnEndInboundTransferPolicy[]{mockedPolicyHandler});
        this.logger.debug((Object)"part 2 - transfer some deleted nodes");
        RetryingTransactionHelper.RetryingTransactionCallback<Void> doSecondPrepareCB = new RetryingTransactionHelper.RetryingTransactionCallback<Void>(){
            {
            }

            public Void execute() throws Throwable {
                tc.transferId = RepoTransferReceiverImplTest.this.receiver.start("1234", true, RepoTransferReceiverImplTest.this.receiver.getVersion());
                String snapshot = RepoTransferReceiverImplTest.this.createSnapshot(Arrays.asList(tc.deletedNode8, tc.deletedNode2, tc.deletedNode11));
                log.debug((Object)snapshot);
                RepoTransferReceiverImplTest.this.receiver.saveSnapshot(tc.transferId, (InputStream)new ByteArrayInputStream(snapshot.getBytes("UTF-8")));
                return null;
            }
        };
        RetryingTransactionHelper.RetryingTransactionCallback<Void> validateSecondCB = new RetryingTransactionHelper.RetryingTransactionCallback<Void>(){
            {
            }

            public Void execute() throws Throwable {
                ArgumentCaptor transferIdCaptor = ArgumentCaptor.forClass(String.class);
                ArgumentCaptor createdNodesCaptor = ArgumentCaptor.forClass(Set.class);
                ArgumentCaptor updatedNodesCaptor = ArgumentCaptor.forClass(Set.class);
                ArgumentCaptor deletedNodesCaptor = ArgumentCaptor.forClass(Set.class);
                ((TransferServicePolicies.OnEndInboundTransferPolicy)Mockito.verify((Object)mockedPolicyHandler, (VerificationMode)Mockito.times((int)1))).onEndInboundTransfer((String)transferIdCaptor.capture(), (Set)createdNodesCaptor.capture(), (Set)updatedNodesCaptor.capture(), (Set)deletedNodesCaptor.capture());
                RepoTransferReceiverImplTest.assertEquals((String)tc.transferId, (String)((String)transferIdCaptor.getValue()));
                Set capturedDeletedNodes = (Set)deletedNodesCaptor.getValue();
                RepoTransferReceiverImplTest.assertEquals((int)3, (int)capturedDeletedNodes.size());
                RepoTransferReceiverImplTest.assertTrue((boolean)capturedDeletedNodes.contains(tc.deletedNode8.getNodeRef()));
                RepoTransferReceiverImplTest.assertTrue((boolean)capturedDeletedNodes.contains(tc.deletedNode2.getNodeRef()));
                RepoTransferReceiverImplTest.assertTrue((boolean)capturedDeletedNodes.contains(tc.deletedNode11.getNodeRef()));
                log.debug((Object)"Test success of transfer...");
                TransferProgress progress = RepoTransferReceiverImplTest.this.receiver.getProgressMonitor().getProgress(tc.transferId);
                RepoTransferReceiverImplTest.assertEquals((Object)TransferProgress.Status.COMPLETE, (Object)progress.getStatus());
                NodeRef archiveNode8 = new NodeRef(StoreRef.STORE_REF_ARCHIVE_SPACESSTORE, tc.node8.getNodeRef().getId());
                NodeRef archiveNode2 = new NodeRef(StoreRef.STORE_REF_ARCHIVE_SPACESSTORE, tc.node2.getNodeRef().getId());
                NodeRef archiveNode11 = new NodeRef(StoreRef.STORE_REF_ARCHIVE_SPACESSTORE, tc.node11.getNodeRef().getId());
                RepoTransferReceiverImplTest.assertTrue((boolean)RepoTransferReceiverImplTest.this.nodeService.exists(archiveNode8));
                RepoTransferReceiverImplTest.assertTrue((boolean)RepoTransferReceiverImplTest.this.nodeService.hasAspect(archiveNode8, ContentModel.ASPECT_ARCHIVED));
                log.debug((Object)("Successfully tested existence of archive node: " + String.valueOf(archiveNode8)));
                RepoTransferReceiverImplTest.assertTrue((boolean)RepoTransferReceiverImplTest.this.nodeService.exists(archiveNode2));
                RepoTransferReceiverImplTest.assertTrue((boolean)RepoTransferReceiverImplTest.this.nodeService.hasAspect(archiveNode2, ContentModel.ASPECT_ARCHIVED));
                log.debug((Object)("Successfully tested existence of archive node: " + String.valueOf(archiveNode2)));
                RepoTransferReceiverImplTest.assertTrue((boolean)RepoTransferReceiverImplTest.this.nodeService.exists(archiveNode11));
                RepoTransferReceiverImplTest.assertTrue((boolean)RepoTransferReceiverImplTest.this.nodeService.hasAspect(archiveNode11, ContentModel.ASPECT_ARCHIVED));
                log.debug((Object)("Successfully tested existence of archive node: " + String.valueOf(archiveNode11)));
                log.debug((Object)"Successfully tested existence of all archive nodes");
                log.debug((Object)("Testing existence of original node: " + String.valueOf(tc.node8.getNodeRef())));
                RepoTransferReceiverImplTest.assertFalse((boolean)RepoTransferReceiverImplTest.this.nodeService.exists(tc.node8.getNodeRef()));
                log.debug((Object)("Testing existence of original node: " + String.valueOf(tc.node2.getNodeRef())));
                RepoTransferReceiverImplTest.assertFalse((boolean)RepoTransferReceiverImplTest.this.nodeService.exists(tc.node2.getNodeRef()));
                log.debug((Object)("Testing existence of original node: " + String.valueOf(tc.node11.getNodeRef())));
                RepoTransferReceiverImplTest.assertFalse((boolean)RepoTransferReceiverImplTest.this.nodeService.exists(tc.node11.getNodeRef()));
                log.debug((Object)"Successfully tested non-existence of all original nodes");
                log.debug((Object)("Progress indication: " + progress.getCurrentPosition() + "/" + progress.getEndPosition()));
                return null;
            }
        };
        try {
            tran.doInTransaction((RetryingTransactionHelper.RetryingTransactionCallback)doSecondPrepareCB, false, true);
            tran.doInTransaction((RetryingTransactionHelper.RetryingTransactionCallback)doCommitCB, false, true);
            tran.doInTransaction((RetryingTransactionHelper.RetryingTransactionCallback)validateSecondCB, false, true);
        }
        finally {
            if (tc.transferId != null) {
                tran.doInTransaction((RetryingTransactionHelper.RetryingTransactionCallback)doEndCB, false, true);
            }
        }
        this.logger.debug((Object)"part 3 - restore orphan node which should fail");
        System.out.println("Now try to restore orphan node 2.");
        Mockito.reset((Object[])new TransferServicePolicies.OnEndInboundTransferPolicy[]{mockedPolicyHandler});
        RetryingTransactionHelper.RetryingTransactionCallback<Void> doThirdPrepareCB = new RetryingTransactionHelper.RetryingTransactionCallback<Void>(){
            {
            }

            public Void execute() throws Throwable {
                tc.transferId = RepoTransferReceiverImplTest.this.receiver.start("1234", true, RepoTransferReceiverImplTest.this.receiver.getVersion());
                String snapshot = RepoTransferReceiverImplTest.this.createSnapshot(Arrays.asList(tc.node2));
                log.debug((Object)snapshot);
                RepoTransferReceiverImplTest.this.receiver.saveSnapshot(tc.transferId, (InputStream)new ByteArrayInputStream(snapshot.getBytes("UTF-8")));
                RepoTransferReceiverImplTest.this.receiver.saveContent(tc.transferId, tc.node2.getUuid(), (InputStream)new ByteArrayInputStream(RepoTransferReceiverImplTest.this.dummyContentBytes));
                return null;
            }
        };
        RetryingTransactionHelper.RetryingTransactionCallback<Void> doCommitExpectingFailCB = new RetryingTransactionHelper.RetryingTransactionCallback<Void>(){
            {
            }

            public Void execute() throws Throwable {
                try {
                    RepoTransferReceiverImplTest.this.receiver.commit(tc.transferId);
                    RepoTransferReceiverImplTest.fail((String)"Expected an exception");
                }
                catch (TransferException ex) {
                    tc.errorMsgId = ex.getMsgId();
                    ArgumentCaptor transferIdCaptor = ArgumentCaptor.forClass(String.class);
                    ArgumentCaptor createdNodesCaptor = ArgumentCaptor.forClass(Set.class);
                    ArgumentCaptor updatedNodesCaptor = ArgumentCaptor.forClass(Set.class);
                    ArgumentCaptor deletedNodesCaptor = ArgumentCaptor.forClass(Set.class);
                    ((TransferServicePolicies.OnEndInboundTransferPolicy)Mockito.verify((Object)mockedPolicyHandler, (VerificationMode)Mockito.times((int)1))).onEndInboundTransfer((String)transferIdCaptor.capture(), (Set)createdNodesCaptor.capture(), (Set)updatedNodesCaptor.capture(), (Set)deletedNodesCaptor.capture());
                    RepoTransferReceiverImplTest.assertEquals((String)tc.transferId, (String)((String)transferIdCaptor.getValue()));
                    RepoTransferReceiverImplTest.assertTrue((boolean)((Set)createdNodesCaptor.getValue()).isEmpty());
                    RepoTransferReceiverImplTest.assertTrue((boolean)((Set)updatedNodesCaptor.getValue()).isEmpty());
                    RepoTransferReceiverImplTest.assertTrue((boolean)((Set)deletedNodesCaptor.getValue()).isEmpty());
                }
                return null;
            }
        };
        RetryingTransactionHelper.RetryingTransactionCallback<Void> validateThirdCB = new RetryingTransactionHelper.RetryingTransactionCallback<Void>(){
            {
            }

            public Void execute() throws Throwable {
                TransferProgress progress = RepoTransferReceiverImplTest.this.receiver.getProgressMonitor().getProgress(tc.transferId);
                RepoTransferReceiverImplTest.assertEquals((Object)TransferProgress.Status.ERROR, (Object)progress.getStatus());
                log.debug((Object)("Progress indication: " + progress.getCurrentPosition() + "/" + progress.getEndPosition()));
                RepoTransferReceiverImplTest.assertNotNull((String)"Progress error", (Object)progress.getError());
                RepoTransferReceiverImplTest.assertTrue((boolean)(progress.getError() instanceof Exception));
                RepoTransferReceiverImplTest.assertTrue((String)tc.errorMsgId, (boolean)tc.errorMsgId.contains("orphan"));
                return null;
            }
        };
        try {
            tran.doInTransaction((RetryingTransactionHelper.RetryingTransactionCallback)doThirdPrepareCB, false, true);
            tran.doInTransaction((RetryingTransactionHelper.RetryingTransactionCallback)doCommitExpectingFailCB, false, true);
        }
        finally {
            if (tc.transferId != null) {
                tran.doInTransaction((RetryingTransactionHelper.RetryingTransactionCallback)doEndCB, false, true);
            }
        }
        tran.doInTransaction((RetryingTransactionHelper.RetryingTransactionCallback)validateThirdCB, false, true);
        log.debug((Object)"start testNodeDeleteAndRestore");
    }

    @Test
    public void testJira_ALF_2772() throws Exception {
        log.debug((Object)"start testJira_ALF_2772");
        RetryingTransactionHelper tran = this.transactionService.getRetryingTransactionHelper();
        class TestContext {
            TransferManifestNormalNode node1 = null;
            TransferManifestNormalNode node2 = null;
            TransferManifestNormalNode node11 = null;
            TransferManifestDeletedNode deletedNode11 = null;
            String transferId = null;

            TestContext() {
            }
        }
        RetryingTransactionHelper.RetryingTransactionCallback<TestContext> setupCB = new RetryingTransactionHelper.RetryingTransactionCallback<TestContext>(){

            public TestContext execute() throws Throwable {
                TestContext tc = new TestContext();
                tc.node1 = RepoTransferReceiverImplTest.this.createContentNode();
                tc.node2 = RepoTransferReceiverImplTest.this.createContentNode();
                tc.node11 = RepoTransferReceiverImplTest.this.createFolderNode();
                RepoTransferReceiverImplTest.this.associatePeers(tc.node1, tc.node2);
                RepoTransferReceiverImplTest.this.moveNode(tc.node2, tc.node11);
                tc.deletedNode11 = RepoTransferReceiverImplTest.this.createDeletedNode((TransferManifestNode)tc.node11);
                return tc;
            }
        };
        final TestContext tc = (TestContext)tran.doInTransaction((RetryingTransactionHelper.RetryingTransactionCallback)setupCB, false, true);
        RetryingTransactionHelper.RetryingTransactionCallback<Void> doEndCB = new RetryingTransactionHelper.RetryingTransactionCallback<Void>(){
            {
            }

            public Void execute() throws Throwable {
                RepoTransferReceiverImplTest.this.receiver.end(tc.transferId);
                return null;
            }
        };
        RetryingTransactionHelper.RetryingTransactionCallback<Void> doFirstCB = new RetryingTransactionHelper.RetryingTransactionCallback<Void>(){
            {
            }

            public Void execute() throws Throwable {
                tc.transferId = RepoTransferReceiverImplTest.this.receiver.start("1234", true, RepoTransferReceiverImplTest.this.receiver.getVersion());
                ArrayList<TransferManifestNode> nodes = new ArrayList<TransferManifestNode>();
                nodes.add((TransferManifestNode)tc.node11);
                String snapshot = RepoTransferReceiverImplTest.this.createSnapshot(nodes);
                log.debug((Object)snapshot);
                RepoTransferReceiverImplTest.this.receiver.saveSnapshot(tc.transferId, (InputStream)new ByteArrayInputStream(snapshot.getBytes("UTF-8")));
                for (TransferManifestNode node : nodes) {
                    RepoTransferReceiverImplTest.this.receiver.saveContent(tc.transferId, node.getUuid(), (InputStream)new ByteArrayInputStream(RepoTransferReceiverImplTest.this.dummyContentBytes));
                }
                RepoTransferReceiverImplTest.this.receiver.commit(tc.transferId);
                for (TransferManifestNode node : nodes) {
                    RepoTransferReceiverImplTest.assertTrue((boolean)RepoTransferReceiverImplTest.this.nodeService.exists(node.getNodeRef()));
                }
                return null;
            }
        };
        try {
            tran.doInTransaction((RetryingTransactionHelper.RetryingTransactionCallback)doFirstCB, false, true);
        }
        finally {
            if (tc.transferId != null) {
                tran.doInTransaction((RetryingTransactionHelper.RetryingTransactionCallback)doEndCB, false, true);
            }
        }
        RetryingTransactionHelper.RetryingTransactionCallback<Void> doSecondCB = new RetryingTransactionHelper.RetryingTransactionCallback<Void>(){
            {
            }

            public Void execute() throws Throwable {
                tc.transferId = RepoTransferReceiverImplTest.this.receiver.start("1234", true, RepoTransferReceiverImplTest.this.receiver.getVersion());
                String snapshot = RepoTransferReceiverImplTest.this.createSnapshot(Arrays.asList(tc.deletedNode11));
                log.debug((Object)snapshot);
                RepoTransferReceiverImplTest.this.receiver.saveSnapshot(tc.transferId, (InputStream)new ByteArrayInputStream(snapshot.getBytes("UTF-8")));
                RepoTransferReceiverImplTest.this.receiver.commit(tc.transferId);
                return null;
            }
        };
        RetryingTransactionHelper.RetryingTransactionCallback<Void> doValidateSecondCB = new RetryingTransactionHelper.RetryingTransactionCallback<Void>(){
            {
            }

            public Void execute() throws Throwable {
                TransferProgress progress = RepoTransferReceiverImplTest.this.receiver.getProgressMonitor().getProgress(tc.transferId);
                RepoTransferReceiverImplTest.assertEquals((Object)TransferProgress.Status.COMPLETE, (Object)progress.getStatus());
                NodeRef archivedNodeRef = new NodeRef(StoreRef.STORE_REF_ARCHIVE_SPACESSTORE, tc.deletedNode11.getNodeRef().getId());
                RepoTransferReceiverImplTest.assertTrue((boolean)RepoTransferReceiverImplTest.this.nodeService.exists(archivedNodeRef));
                RepoTransferReceiverImplTest.assertTrue((boolean)RepoTransferReceiverImplTest.this.nodeService.hasAspect(archivedNodeRef, ContentModel.ASPECT_ARCHIVED));
                log.debug((Object)("Successfully tested existence of archive node: " + String.valueOf(tc.deletedNode11.getNodeRef())));
                log.debug((Object)"Successfully tested existence of all archive nodes");
                log.debug((Object)("Testing existence of original node: " + String.valueOf(tc.node11.getNodeRef())));
                RepoTransferReceiverImplTest.assertFalse((boolean)RepoTransferReceiverImplTest.this.nodeService.exists(tc.node11.getNodeRef()));
                log.debug((Object)"Successfully tested non-existence of all original nodes");
                log.debug((Object)("Progress indication: " + progress.getCurrentPosition() + "/" + progress.getEndPosition()));
                return null;
            }
        };
        try {
            tran.doInTransaction((RetryingTransactionHelper.RetryingTransactionCallback)doSecondCB, false, true);
            tran.doInTransaction((RetryingTransactionHelper.RetryingTransactionCallback)doValidateSecondCB, false, true);
        }
        finally {
            if (tc.transferId != null) {
                tran.doInTransaction((RetryingTransactionHelper.RetryingTransactionCallback)doEndCB, false, true);
            }
        }
        RetryingTransactionHelper.RetryingTransactionCallback<Void> doThirdCB = new RetryingTransactionHelper.RetryingTransactionCallback<Void>(){
            {
            }

            public Void execute() throws Throwable {
                tc.transferId = RepoTransferReceiverImplTest.this.receiver.start("1234", true, RepoTransferReceiverImplTest.this.receiver.getVersion());
                String snapshot = RepoTransferReceiverImplTest.this.createSnapshot(Arrays.asList(tc.node2, tc.node11));
                log.debug((Object)snapshot);
                RepoTransferReceiverImplTest.this.receiver.saveSnapshot(tc.transferId, (InputStream)new ByteArrayInputStream(snapshot.getBytes("UTF-8")));
                RepoTransferReceiverImplTest.this.receiver.saveContent(tc.transferId, tc.node2.getUuid(), (InputStream)new ByteArrayInputStream(RepoTransferReceiverImplTest.this.dummyContentBytes));
                RepoTransferReceiverImplTest.this.receiver.commit(tc.transferId);
                return null;
            }
        };
        RetryingTransactionHelper.RetryingTransactionCallback<Void> doValidateThirdCB = new RetryingTransactionHelper.RetryingTransactionCallback<Void>(){

            public Void execute() throws Throwable {
                return null;
            }
        };
        try {
            tran.doInTransaction((RetryingTransactionHelper.RetryingTransactionCallback)doThirdCB, false, true);
            tran.doInTransaction((RetryingTransactionHelper.RetryingTransactionCallback)doValidateThirdCB, false, true);
        }
        finally {
            if (tc.transferId != null) {
                tran.doInTransaction((RetryingTransactionHelper.RetryingTransactionCallback)doEndCB, false, true);
            }
        }
    }

    @Test
    public void testMNT11057() throws Exception {
        String folder1Name = "H1";
        String folder2Name = "H2";
        String folder3Name = "H3";
        TestTransaction.start();
        String transferIdA1 = this.receiver.start("transferFromRepoA1", true, this.receiver.getVersion());
        TransferManifestNormalNode folder1A1 = this.createFolderNode(folder1Name);
        TransferManifestNormalNode folder2A1 = this.createFolderNode(folder2Name);
        TransferManifestNormalNode folder3A1 = this.createFolderNode(folder3Name);
        this.moveNode(folder2A1, folder1A1);
        ArrayList<Object> nodesA1 = new ArrayList<TransferManifestNode>();
        nodesA1.add(folder1A1);
        nodesA1.add(folder2A1);
        TestTransaction.flagForCommit();
        TestTransaction.end();
        TestTransaction.start();
        try {
            String snapshot = this.createSnapshot(nodesA1, "repo A");
            log.debug((Object)snapshot);
            this.receiver.saveSnapshot(transferIdA1, (InputStream)new ByteArrayInputStream(snapshot.getBytes("UTF-8")));
            for (TransferManifestNode transferManifestNode : nodesA1) {
                this.receiver.saveContent(transferIdA1, transferManifestNode.getUuid(), (InputStream)new ByteArrayInputStream(this.dummyContentBytes));
            }
            this.receiver.commit(transferIdA1);
            for (TransferManifestNode transferManifestNode : nodesA1) {
                RepoTransferReceiverImplTest.assertTrue((boolean)this.nodeService.exists(transferManifestNode.getNodeRef()));
            }
        }
        finally {
            this.receiver.end(transferIdA1);
            TestTransaction.flagForCommit();
            TestTransaction.end();
        }
        TestTransaction.start();
        String transferIdB1 = this.receiver.start("transferFromRepoB1", true, this.receiver.getVersion());
        TransferManifestNormalNode transferManifestNormalNode = this.createFolderNode(folder1Name);
        TransferManifestNormalNode folder3B1 = this.createFolderNode(folder3Name);
        this.moveNode(folder3B1, transferManifestNormalNode);
        ArrayList<TransferManifestNode> nodesB1 = new ArrayList<TransferManifestNode>();
        nodesB1.add((TransferManifestNode)transferManifestNormalNode);
        nodesB1.add((TransferManifestNode)folder3B1);
        TestTransaction.flagForCommit();
        TestTransaction.end();
        TestTransaction.start();
        try {
            String snapshot = this.createSnapshot(nodesB1, "repo B");
            log.debug((Object)snapshot);
            this.receiver.saveSnapshot(transferIdB1, (InputStream)new ByteArrayInputStream(snapshot.getBytes("UTF-8")));
            for (TransferManifestNode node : nodesB1) {
                this.receiver.saveContent(transferIdB1, node.getUuid(), (InputStream)new ByteArrayInputStream(this.dummyContentBytes));
            }
            this.receiver.commit(transferIdB1);
        }
        finally {
            this.receiver.end(transferIdB1);
            TestTransaction.flagForCommit();
            TestTransaction.end();
        }
        RepoTransferReceiverImplTest.assertTrue((boolean)this.nodeService.exists(folder1A1.getNodeRef()));
        log.info((Object)"has Alien");
        log.info((Object)this.nodeService.hasAspect(folder1A1.getNodeRef(), TransferModel.ASPECT_ALIEN));
        RepoTransferReceiverImplTest.assertTrue((boolean)this.nodeService.exists(folder2A1.getNodeRef()));
        log.info((Object)"has Alien");
        RepoTransferReceiverImplTest.assertFalse((boolean)this.nodeService.hasAspect(folder2A1.getNodeRef(), TransferModel.ASPECT_ALIEN));
        RepoTransferReceiverImplTest.assertFalse((boolean)this.nodeService.exists(transferManifestNormalNode.getNodeRef()));
        RepoTransferReceiverImplTest.assertTrue((boolean)this.nodeService.exists(folder3B1.getNodeRef()));
        log.info((Object)"has Alien");
        RepoTransferReceiverImplTest.assertTrue((boolean)this.nodeService.hasAspect(folder3B1.getNodeRef(), TransferModel.ASPECT_ALIEN));
        TestTransaction.start();
        this.moveNode(folder3A1, folder1A1);
        this.moveNode(folder2A1, folder3A1);
        nodesA1 = new ArrayList();
        nodesA1.add((TransferManifestNode)folder1A1);
        nodesA1.add(folder3A1);
        nodesA1.add(folder2A1);
        TestTransaction.flagForCommit();
        TestTransaction.end();
        TestTransaction.start();
        try {
            try {
                String transferId = this.receiver.start("transferFromRepoA1Again", true, this.receiver.getVersion());
                String snapshot = this.createSnapshot(nodesA1, "repo A");
                log.debug((Object)snapshot);
                this.receiver.saveSnapshot(transferId, (InputStream)new ByteArrayInputStream(snapshot.getBytes("UTF-8")));
                this.receiver.commit(transferId);
            }
            catch (Exception ex) {
                if (ex instanceof NullPointerException) {
                    RepoTransferReceiverImplTest.fail((String)("Test of MNT-11057 failed: " + ex.getMessage()));
                }
                TestTransaction.flagForCommit();
                TestTransaction.end();
            }
        }
        finally {
            TestTransaction.flagForCommit();
            TestTransaction.end();
        }
    }

    @Test
    public void testAsyncCommit() throws Exception {
        log.info((Object)"start testAsyncCommit");
        this.localTestAsyncCommit();
    }

    private String localTestAsyncCommit() throws Exception, InterruptedException {
        String transferId = this.receiver.start("1234", true, this.receiver.getVersion());
        TestTransaction.start();
        ArrayList<TransferManifestNode> nodes = new ArrayList<TransferManifestNode>();
        TransferManifestNormalNode node1 = this.createContentNode();
        nodes.add((TransferManifestNode)node1);
        TransferManifestNormalNode node2 = this.createContentNode();
        nodes.add((TransferManifestNode)node2);
        TransferManifestNormalNode node3 = this.createContentNode();
        nodes.add((TransferManifestNode)node3);
        TransferManifestNormalNode node4 = this.createContentNode();
        nodes.add((TransferManifestNode)node4);
        TransferManifestNormalNode node5 = this.createContentNode();
        nodes.add((TransferManifestNode)node5);
        TransferManifestNormalNode node6 = this.createContentNode();
        nodes.add((TransferManifestNode)node6);
        TransferManifestNormalNode node7 = this.createContentNode();
        nodes.add((TransferManifestNode)node7);
        TransferManifestNormalNode node8 = this.createFolderNode();
        nodes.add((TransferManifestNode)node8);
        TransferManifestNormalNode node9 = this.createFolderNode();
        nodes.add((TransferManifestNode)node9);
        TransferManifestNormalNode node10 = this.createFolderNode();
        nodes.add((TransferManifestNode)node10);
        TransferManifestNormalNode node11 = this.createFolderNode();
        nodes.add((TransferManifestNode)node11);
        TransferManifestNormalNode node12 = this.createFolderNode();
        nodes.add((TransferManifestNode)node12);
        this.associatePeers(node1, node2);
        this.moveNode(node2, node11);
        TestTransaction.flagForCommit();
        TestTransaction.end();
        String snapshot = this.createSnapshot(nodes);
        TestTransaction.start();
        this.receiver.saveSnapshot(transferId, (InputStream)new ByteArrayInputStream(snapshot.getBytes("UTF-8")));
        TestTransaction.flagForCommit();
        TestTransaction.end();
        for (TransferManifestNode node : nodes) {
            TestTransaction.start();
            this.receiver.saveContent(transferId, node.getUuid(), (InputStream)new ByteArrayInputStream(this.dummyContentBytes));
            TestTransaction.flagForCommit();
            TestTransaction.end();
        }
        TestTransaction.start();
        this.receiver.commitAsync(transferId);
        TestTransaction.flagForCommit();
        TestTransaction.end();
        log.debug((Object)"Posted request for commit");
        TransferProgressMonitor progressMonitor = this.receiver.getProgressMonitor();
        TransferProgress progress = null;
        while (progress == null || !TransferProgress.getTerminalStatuses().contains(progress.getStatus())) {
            Thread.sleep(500L);
            TestTransaction.start();
            progress = progressMonitor.getProgress(transferId);
            TestTransaction.flagForCommit();
            TestTransaction.end();
            log.debug((Object)("Progress indication: " + String.valueOf(progress.getStatus()) + ": " + progress.getCurrentPosition() + "/" + progress.getEndPosition()));
        }
        RepoTransferReceiverImplTest.assertEquals((Object)TransferProgress.Status.COMPLETE, (Object)progress.getStatus());
        TestTransaction.start();
        try {
            RepoTransferReceiverImplTest.assertTrue((boolean)this.nodeService.getAspects(node1.getNodeRef()).contains(ContentModel.ASPECT_ATTACHABLE));
            RepoTransferReceiverImplTest.assertFalse((boolean)this.nodeService.getSourceAssocs(node2.getNodeRef(), (QNamePattern)ContentModel.ASSOC_ATTACHMENTS).isEmpty());
            for (TransferManifestNode node : nodes) {
                RepoTransferReceiverImplTest.assertTrue((boolean)this.nodeService.exists(node.getNodeRef()));
            }
        }
        finally {
            TestTransaction.end();
        }
        return transferId;
    }

    @Test
    public void testAsyncCommitWithSummaryReport() throws Exception {
        log.info((Object)"start testAsyncCommitWithSummaryReport");
        Properties properties = (Properties)this.applicationContext.getBean("global-properties");
        String prevValue = properties.getProperty("transferservice.simple-report");
        try {
            properties.put("transferservice.simple-report", Boolean.TRUE.toString());
            RepoTransferReceiverImplTest.assertTrue((boolean)Boolean.parseBoolean(properties.getProperty("transferservice.simple-report")));
            this.localTestDestinationReports(true);
        }
        finally {
            if (prevValue == null) {
                properties.remove("transferservice.simple-report");
            } else {
                properties.put("transferservice.simple-report", prevValue);
            }
        }
    }

    @Test
    public void testAsyncCommitWithOutSummaryReport() throws Exception {
        log.info((Object)"start testAsyncCommitWithOutSummaryReport");
        Properties properties = (Properties)this.applicationContext.getBean("global-properties");
        String prevValue = properties.getProperty("transferservice.simple-report");
        try {
            properties.put("transferservice.simple-report", Boolean.FALSE.toString());
            RepoTransferReceiverImplTest.assertFalse((boolean)Boolean.parseBoolean(properties.getProperty("transferservice.simple-report")));
            this.localTestDestinationReports(false);
        }
        finally {
            if (prevValue == null) {
                properties.remove("transferservice.simple-report");
            } else {
                properties.put("transferservice.simple-report", prevValue);
            }
        }
    }

    private void localTestDestinationReports(boolean testAlsoForSummaryReport) throws Exception, InterruptedException {
        String transferId = this.localTestAsyncCommit();
        FileFolderService fileFolderService = (FileFolderService)this.applicationContext.getBean("fileFolderService");
        NodeRef destinationReportNodeRef = new NodeRef(transferId);
        RepoTransferReceiverImplTest.assertTrue((boolean)this.nodeService.exists(destinationReportNodeRef));
        RepoTransferReceiverImplTest.assertTrue((boolean)this.nodeService.getType(destinationReportNodeRef).equals((Object)TransferModel.TYPE_TRANSFER_RECORD));
        String destinationReportName = (String)this.nodeService.getProperties(destinationReportNodeRef).get(ContentModel.PROP_NAME);
        String destinationReportWithoutExtension = destinationReportName.substring(0, destinationReportName.lastIndexOf("."));
        NodeRef summaryReportsParentFolder = null;
        String summaryReportsLocation = "/app:company_home/app:dictionary/app:transfers/app:inbound_transfer_records";
        summaryReportsParentFolder = this.getSummaryReportsParentFolder(summaryReportsLocation);
        RepoTransferReceiverImplTest.assertTrue((boolean)fileFolderService.getFileInfo(summaryReportsParentFolder).isFolder());
        FileInfo simplifiedReportFile = null;
        for (FileInfo fi : fileFolderService.list(summaryReportsParentFolder)) {
            if (!fi.getName().startsWith(destinationReportWithoutExtension) || !fi.getName().contains("_simple_report")) continue;
            simplifiedReportFile = fi;
        }
        if (testAlsoForSummaryReport) {
            RepoTransferReceiverImplTest.assertNotNull(simplifiedReportFile);
        } else {
            RepoTransferReceiverImplTest.assertNull(simplifiedReportFile);
        }
    }

    private NodeRef getSummaryReportsParentFolder(String transferSummaryReportLocation) {
        NodeRef reportParentFolder = null;
        log.debug((Object)("Trying to find transfer summary report records folder: " + transferSummaryReportLocation));
        List refs = this.searchService.selectNodes(this.nodeService.getRootNode(StoreRef.STORE_REF_WORKSPACE_SPACESSTORE), transferSummaryReportLocation, null, (NamespacePrefixResolver)this.namespaceService, false);
        if (refs.size() > 0) {
            reportParentFolder = (NodeRef)refs.get(0);
            log.debug((Object)("Found transfer summary report records folder: " + String.valueOf(reportParentFolder)));
        }
        return reportParentFolder;
    }

    private TransferManifestDeletedNode createDeletedNode(TransferManifestNode nodeToDelete) {
        TransferManifestDeletedNode deletedNode = new TransferManifestDeletedNode();
        deletedNode.setNodeRef(nodeToDelete.getNodeRef());
        deletedNode.setParentPath(nodeToDelete.getParentPath());
        deletedNode.setPrimaryParentAssoc(nodeToDelete.getPrimaryParentAssoc());
        deletedNode.setUuid(nodeToDelete.getUuid());
        return deletedNode;
    }

    private void moveNode(TransferManifestNormalNode childNode, TransferManifestNormalNode newParent) {
        List currentParents = childNode.getParentAssocs();
        ArrayList<ChildAssociationRef> newParents = new ArrayList<ChildAssociationRef>();
        for (ChildAssociationRef parent : currentParents) {
            if (!parent.isPrimary()) {
                newParents.add(parent);
                continue;
            }
            ChildAssociationRef newPrimaryAssoc = new ChildAssociationRef(ContentModel.ASSOC_CONTAINS, newParent.getNodeRef(), parent.getQName(), parent.getChildRef(), true, -1);
            newParents.add(newPrimaryAssoc);
            childNode.setPrimaryParentAssoc(newPrimaryAssoc);
            Path newParentPath = new Path();
            newParentPath.append(newParent.getParentPath());
            newParentPath.append((Path.Element)new Path.ChildAssocElement(newParent.getPrimaryParentAssoc()));
            childNode.setParentPath(newParentPath);
        }
        childNode.setParentAssocs(newParents);
    }

    private void associatePeers(TransferManifestNormalNode source, TransferManifestNormalNode target) {
        HashSet<QName> aspects;
        ArrayList<AssociationRef> currentRefereePeers;
        ArrayList<AssociationRef> currentReferencedPeers = source.getTargetAssocs();
        if (currentReferencedPeers == null) {
            currentReferencedPeers = new ArrayList<AssociationRef>();
            source.setTargetAssocs(currentReferencedPeers);
        }
        if ((currentRefereePeers = target.getSourceAssocs()) == null) {
            currentRefereePeers = new ArrayList<AssociationRef>();
            target.setSourceAssocs(currentRefereePeers);
        }
        if ((aspects = source.getAspects()) == null) {
            aspects = new HashSet<QName>();
            source.setAspects(aspects);
        }
        aspects.add(ContentModel.ASPECT_ATTACHABLE);
        AssociationRef newAssoc = new AssociationRef(null, source.getNodeRef(), ContentModel.ASSOC_ATTACHMENTS, target.getNodeRef());
        currentRefereePeers.add(newAssoc);
        currentReferencedPeers.add(newAssoc);
    }

    private String createSnapshot(List<TransferManifestNode> nodes) throws Exception {
        return this.createSnapshot(nodes, "repo 1");
    }

    private String createSnapshot(List<TransferManifestNode> nodes, String repoID) throws Exception {
        XMLTransferManifestWriter manifestWriter = new XMLTransferManifestWriter();
        StringWriter output = new StringWriter();
        manifestWriter.startTransferManifest((Writer)output);
        TransferManifestHeader header = new TransferManifestHeader();
        header.setCreatedDate(new Date());
        header.setNodeCount(nodes.size());
        header.setRepositoryId(repoID);
        manifestWriter.writeTransferManifestHeader(header);
        for (TransferManifestNode node : nodes) {
            manifestWriter.writeTransferManifestNode(node);
        }
        manifestWriter.endTransferManifest();
        return output.toString();
    }

    private TransferManifestNormalNode createContentNode() throws Exception {
        TransferManifestNormalNode node = new TransferManifestNormalNode();
        String uuid = GUID.generate();
        NodeRef nodeRef = new NodeRef(StoreRef.STORE_REF_WORKSPACE_SPACESSTORE, uuid);
        node.setNodeRef(nodeRef);
        node.setUuid(uuid);
        byte[] dummyContent = "This is some dummy content.".getBytes("UTF-8");
        node.setType(ContentModel.TYPE_CONTENT);
        NodeRef parentFolder = this.guestHome;
        String nodeName = uuid + ".testnode" + this.getNameSuffix();
        ArrayList<ChildAssociationRef> parents = new ArrayList<ChildAssociationRef>();
        ChildAssociationRef primaryAssoc = new ChildAssociationRef(ContentModel.ASSOC_CONTAINS, parentFolder, QName.createQName((String)"http://www.alfresco.org/model/content/1.0", (String)nodeName), node.getNodeRef(), true, -1);
        parents.add(primaryAssoc);
        node.setParentAssocs(parents);
        node.setParentPath(this.nodeService.getPath(parentFolder));
        node.setPrimaryParentAssoc(primaryAssoc);
        HashMap<QName, Object> props = new HashMap<QName, Object>();
        props.put(ContentModel.PROP_NODE_UUID, uuid);
        props.put(ContentModel.PROP_NAME, nodeName);
        ContentData contentData = new ContentData("/" + uuid, "text/plain", (long)dummyContent.length, "UTF-8");
        props.put(ContentModel.PROP_CONTENT, contentData);
        node.setProperties(props);
        return node;
    }

    private TransferManifestNormalNode createFolderNode() throws Exception {
        return this.createFolderNode(null);
    }

    private TransferManifestNormalNode createFolderNode(String folderName) throws Exception {
        TransferManifestNormalNode node = new TransferManifestNormalNode();
        String uuid = GUID.generate();
        NodeRef nodeRef = new NodeRef(StoreRef.STORE_REF_WORKSPACE_SPACESSTORE, uuid);
        node.setNodeRef(nodeRef);
        node.setUuid(uuid);
        node.setType(ContentModel.TYPE_FOLDER);
        NodeRef parentFolder = this.repositoryHelper.getGuestHome();
        String nodeName = folderName == null ? uuid + ".folder" + this.getNameSuffix() : folderName;
        ArrayList<ChildAssociationRef> parents = new ArrayList<ChildAssociationRef>();
        ChildAssociationRef primaryAssoc = new ChildAssociationRef(ContentModel.ASSOC_CONTAINS, parentFolder, QName.createQName((String)"http://www.alfresco.org/model/content/1.0", (String)nodeName), node.getNodeRef(), true, -1);
        parents.add(primaryAssoc);
        node.setParentAssocs(parents);
        node.setParentPath(this.nodeService.getPath(parentFolder));
        node.setPrimaryParentAssoc(primaryAssoc);
        HashMap<QName, String> props = new HashMap<QName, String>();
        props.put(ContentModel.PROP_NODE_UUID, uuid);
        props.put(ContentModel.PROP_NAME, nodeName);
        node.setProperties(props);
        return node;
    }

    private String getNameSuffix() {
        return "" + fileCount++;
    }
}

